<?php
// Test script to validate quiz category points system

// Set up CodeIgniter environment
require_once 'index.php';

echo "=== QUIZ CATEGORY POINTS SYSTEM VALIDATION ===\n\n";

// Test 1: Check database structure
echo "1. Database Structure Check:\n";
$ci =& get_instance();
$ci->load->database();

// Check if qcc_points_per_question exists
try {
    $result = $ci->db->query("DESCRIBE tn_quiz_category_config qcc_points_per_question");
    if ($result->num_rows() > 0) {
        echo "   ✅ qcc_points_per_question field exists\n";
    } else {
        echo "   ❌ qcc_points_per_question field missing\n";
    }
} catch (Exception $e) {
    echo "   ❌ Error checking qcc_points_per_question: " . $e->getMessage() . "\n";
}

// Test 2: Check qb_gain_point in question bank
try {
    $result = $ci->db->query("DESCRIBE tn_question_bank qb_gain_point");
    if ($result->num_rows() > 0) {
        echo "   ✅ qb_gain_point field exists\n";
    } else {
        echo "   ❌ qb_gain_point field missing\n";
    }
} catch (Exception $e) {
    echo "   ❌ Error checking qb_gain_point: " . $e->getMessage() . "\n";
}

// Test 3: Check qq_points in quiz_questions
try {
    $result = $ci->db->query("DESCRIBE tn_quiz_questions qq_points");
    if ($result->num_rows() > 0) {
        echo "   ✅ qq_points field exists\n";
    } else {
        echo "   ❌ qq_points field missing\n";
    }
} catch (Exception $e) {
    echo "   ❌ Error checking qq_points: " . $e->getMessage() . "\n";
}

// Test 4: Test points calculation logic
echo "\n2. Points Calculation Logic Test:\n";

$ci->load->model('model_quiz_questions');
$ci->load->model('model_quiz_category_config');

// Create test data
$test_quiz_id = 1;
$test_question_id = 1;

// Test case 1: qq_points (manual assignment)
$test_case_1 = [
    'qq_points' => 5.5,
    'qb_gain_point' => 2.0,
    'qcc_points_per_question' => 3.0,
    'expected' => 5.5
];

// Test case 2: qb_gain_point (bank points)
$test_case_2 = [
    'qq_points' => null,
    'qb_gain_point' => 2.0,
    'qcc_points_per_question' => 3.0,
    'expected' => 2.0
];

// Test case 3: category points
$test_case_3 = [
    'qq_points' => null,
    'qb_gain_point' => null,
    'qcc_points_per_question' => 3.0,
    'expected' => 3.0
];

// Test case 4: default fallback
$test_case_4 = [
    'qq_points' => null,
    'qb_gain_point' => null,
    'qcc_points_per_question' => null,
    'expected' => 1.0
];

$test_cases = [$test_case_1, $test_case_2, $test_case_3, $test_case_4];

foreach ($test_cases as $i => $case) {
    $effective_points = 1.0;
    
    if (isset($case['qq_points']) && $case['qq_points'] !== null) {
        $effective_points = floatval($case['qq_points']);
    } elseif (isset($case['qb_gain_point']) && $case['qb_gain_point'] !== null && floatval($case['qb_gain_point']) > 0) {
        $effective_points = floatval($case['qb_gain_point']);
    } elseif (isset($case['qcc_points_per_question']) && $case['qcc_points_per_question'] !== null && floatval($case['qcc_points_per_question']) > 0) {
        $effective_points = floatval($case['qcc_points_per_question']);
    }
    
    $result = ($effective_points == $case['expected']) ? "✅ PASS" : "❌ FAIL";
    echo "   Test case " . ($i + 1) . ": $result (got: $effective_points, expected: {$case['expected']})\n";
}

// Test 5: Check if models are loading correctly
echo "\n3. Model Loading Test:\n";
try {
    $ci->load->model('model_quiz_questions');
    echo "   ✅ Model_quiz_questions loaded successfully\n";
} catch (Exception $e) {
    echo "   ❌ Error loading Model_quiz_questions: " . $e->getMessage() . "\n";
}

try {
    $ci->load->model('model_quiz_category_config');
    echo "   ✅ Model_quiz_category_config loaded successfully\n";
} catch (Exception $e) {
    echo "   ❌ Error loading Model_quiz_category_config: " . $e->getMessage() . "\n";
}

// Test 6: Check database connection
echo "\n4. Database Connection Test:\n";
try {
    $ci->db->query("SELECT 1");
    echo "   ✅ Database connection successful\n";
} catch (Exception $e) {
    echo "   ❌ Database connection failed: " . $e->getMessage() . "\n";
}

echo "\n=== VALIDATION COMPLETE ===\n";
?>
