<?php
// Simple database connection test

$host = 'localhost';
$username = 'root';
$password = 'root'; // Updated password
$database = 'creactivityhub';

try {
    $mysqli = new mysqli($host, $username, $password, $database);
    
    if ($mysqli->connect_error) {
        echo "❌ Connection failed: " . $mysqli->connect_error . "\n";
    } else {
        echo "✅ Database connection successful!\n";
        
        // Test if tables exist
        $tables_to_check = [
            'tn_quiz_category_config',
            'tn_question_bank', 
            'tn_quiz_questions',
            'tn_result_quiz',
            'tn_result'
        ];
        
        foreach ($tables_to_check as $table) {
            $result = $mysqli->query("SHOW TABLES LIKE '$table'");
            if ($result->num_rows > 0) {
                echo "✅ Table $table exists\n";
                
                // Check specific fields
                $fields_result = $mysqli->query("DESCRIBE $table");
                if ($fields_result) {
                    $fields = [];
                    while ($field = $fields_result->fetch_assoc()) {
                        $fields[] = $field['Field'];
                    }
                    
                    // Check for points-related fields
                    $points_fields = [];
                    if ($table == 'tn_quiz_category_config') {
                        $points_fields = ['qcc_points_per_question'];
                    } elseif ($table == 'tn_question_bank') {
                        $points_fields = ['qb_gain_point'];
                    } elseif ($table == 'tn_quiz_questions') {
                        $points_fields = ['qq_points'];
                    } elseif ($table == 'tn_result_quiz') {
                        $points_fields = ['rq_points_possible', 'rq_points_earned'];
                    }
                    
                    foreach ($points_fields as $field) {
                        if (in_array($field, $fields)) {
                            echo "   ✅ Field $field exists in $table\n";
                        } else {
                            echo "   ❌ Field $field missing in $table\n";
                        }
                    }
                }
            } else {
                echo "❌ Table $table does not exist\n";
            }
        }
        
        $mysqli->close();
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
