<?php
// router.php
$uri = $_SERVER["REQUEST_URI"];

// Remove /creactivityhub/ prefix if it exists
$uri = preg_replace('#^/creactivityhub/#', '/', $uri);

// Check if it's a static file request
if (preg_match('/\.(?:png|jpg|jpeg|gif|css|js|ico)$/', $uri)) {
    // Get the file path relative to the document root
    $file = __DIR__ . $uri;
    
    // Check if file exists
    if (file_exists($file)) {
        // Get the file extension
        $ext = pathinfo($file, PATHINFO_EXTENSION);
        
        // Set the appropriate content type
        $content_types = [
            'png' => 'image/png',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'gif' => 'image/gif',
            'css' => 'text/css',
            'js' => 'application/javascript',
            'ico' => 'image/x-icon'
        ];
        
        if (isset($content_types[$ext])) {
            header('Content-Type: ' . $content_types[$ext]);
        }
        
        // Serve the file
        readfile($file);
        return true;
    }
}
