-- SQL para crear tabla de asignaciones de quices a usuarios específicos
CREATE TABLE IF NOT EXISTS `tn_quiz_user_assignment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `due_date` date NOT NULL,
  `penalty_rate` decimal(5,2) DEFAULT NULL COMMENT 'Penalty rate percentage per day',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_quiz_user_assignment_quiz` (`quiz_id`),
  KEY `fk_quiz_user_assignment_user` (`user_id`),
  CONSTRAINT `fk_quiz_user_assignment_quiz` FOREIGN KEY (`quiz_id`) REFERENCES `tn_quiz` (`quiz_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_quiz_user_assignment_user` FOREIGN KEY (`user_id`) REFERENCES `tn_user` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Añadir campos necesarios a la tabla de resultados para manejar penalizaciones
-- Nota: Hay que ejecutar cada ALTER TABLE por separado para evitar errores si alguna columna ya existe

-- Verificar y añadir columna is_late_submission
SET @s = (SELECT IF(
  EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'is_late_submission'),
  'SELECT "Columna is_late_submission ya existe."',
  'ALTER TABLE `tn_result` ADD COLUMN `is_late_submission` tinyint(1) NOT NULL DEFAULT 0 COMMENT "Indicates if submission was late"'
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Verificar y añadir columna days_late
SET @s = (SELECT IF(
  EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'days_late'),
  'SELECT "Columna days_late ya existe."',
  'ALTER TABLE `tn_result` ADD COLUMN `days_late` int(11) DEFAULT NULL COMMENT "Number of days late"'
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Verificar y añadir columna penalty_applied
SET @s = (SELECT IF(
  EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'penalty_applied'),
  'SELECT "Columna penalty_applied ya existe."',
  'ALTER TABLE `tn_result` ADD COLUMN `penalty_applied` decimal(5,2) DEFAULT NULL COMMENT "Percentage of penalty applied"'
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Verificar y añadir columna original_score
SET @s = (SELECT IF(
  EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'original_score'),
  'SELECT "Columna original_score ya existe."',
  'ALTER TABLE `tn_result` ADD COLUMN `original_score` decimal(10,2) DEFAULT NULL COMMENT "Score before penalty"'
));
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
