-- Script de migraciu00f3n del Banco de Preguntas Centralizado
-- Ejecutar este script directamente en MySQL

-- Tabla question_bank
CREATE TABLE IF NOT EXISTS `question_bank` (
    `qb_id` int(11) NOT NULL AUTO_INCREMENT,
    `qb_text` text NOT NULL,
    `qb_explanation` text,
    `qb_type` int(2) NOT NULL COMMENT '1: Multiple Choice, 2: True/False, 3: Essay, etc.',
    `qb_difficulty` int(1) DEFAULT '1' COMMENT '1-5 escala de dificultad',
    `qb_is_bonus` tinyint(1) DEFAULT '0',
    `qb_gain_point` int(11) DEFAULT '0',
    `qb_bonus_points` float DEFAULT '0',
    `qb_course_id` int(11) DEFAULT NULL,
    `qb_subject_id` int(11) DEFAULT NULL,
    `qb_created_by` int(11) NOT NULL,
    `qb_created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `qb_modified_on` datetime DEFAULT NULL,
    `qb_status` tinyint(1) DEFAULT '1',
    `qb_tags` varchar(255) DEFAULT NULL,
    `qb_options` text COMMENT 'JSON encoded options',
    `qb_correct_answer` varchar(255) DEFAULT NULL,
    PRIMARY KEY (`qb_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabla quiz_questions
CREATE TABLE IF NOT EXISTS `quiz_questions` (
    `qq_id` int(11) NOT NULL AUTO_INCREMENT,
    `qq_quiz_id` int(11) NOT NULL,
    `qq_question_id` int(11) NOT NULL,
    `qq_order` int(3) DEFAULT '0',
    `qq_points` float DEFAULT '1',
    `qq_is_bonus_override` tinyint(1) DEFAULT NULL,
    `qq_created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `qq_status` tinyint(1) DEFAULT '1',
    PRIMARY KEY (`qq_id`),
    KEY `qq_quiz_id` (`qq_quiz_id`),
    KEY `qq_question_id` (`qq_question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- u00cdndices adicionales
ALTER TABLE `question_bank` ADD INDEX `idx_qb_course_subject` (`qb_course_id`, `qb_subject_id`);
ALTER TABLE `question_bank` ADD INDEX `idx_qb_type` (`qb_type`);
ALTER TABLE `question_bank` ADD INDEX `idx_qb_status` (`qb_status`);
ALTER TABLE `quiz_questions` ADD INDEX `idx_qq_quiz_question` (`qq_quiz_id`, `qq_question_id`);

-- Script para migrar datos (solo a modo de referencia)
-- Migrar preguntas de course_quiz a question_bank
--
-- INSERT INTO question_bank (
--     qb_text, qb_type, qb_is_bonus, qb_bonus_points, qb_course_id, 
--     qb_subject_id, qb_created_by, qb_created_on, qb_status, qb_options
-- )
-- SELECT 
--     cq_question, cq_type, 
--     COALESCE(cq_is_bonus, 0), COALESCE(cq_bonus_points, 0),
--     cq_course_id, cq_subject_id, 
--     COALESCE(cq_created_by, 1), COALESCE(cq_createdon, NOW()), 
--     cq_status, cq_options
-- FROM course_quiz;
--
-- -- Crear relaciones quiz-pregunta
-- -- Requiere asignar IDs correctamente basado en la migraciu00f3n previa
