-- Script para migrar preguntas del sistema antiguo al banco centralizado
-- Adaptado para trabajar con prefijo de tablas 'tn_'

-- Migrar preguntas de tn_course_quiz a question_bank
INSERT INTO question_bank (
    qb_text, qb_type, qb_is_bonus, qb_bonus_points, qb_course_id, 
    qb_subject_id, qb_created_by, qb_created_on, qb_status, qb_options
)
SELECT 
    cq_question, cq_type, 
    COALESCE(cq_is_bonus, 0), COALESCE(cq_bonus_points, 0),
    cq_course_id, cq_subject_id, 
    1, -- Valor predeterminado para usuario administrador (1)
    cq_createdon, 
    cq_status,
    -- Convertir las opciones a formato JSON
    CONCAT('{"options":[',
        IF(cq_option_1 IS NOT NULL AND cq_option_1 != '', CONCAT('"',REPLACE(cq_option_1,'"','\"'),'"'), 'null'),',',
        IF(cq_option_2 IS NOT NULL AND cq_option_2 != '', CONCAT('"',REPLACE(cq_option_2,'"','\"'),'"'), 'null'),',',
        IF(cq_option_3 IS NOT NULL AND cq_option_3 != '', CONCAT('"',REPLACE(cq_option_3,'"','\"'),'"'), 'null'),',',
        IF(cq_option_4 IS NOT NULL AND cq_option_4 != '', CONCAT('"',REPLACE(cq_option_4,'"','\"'),'"'), 'null'),',',
        IF(cq_option_5 IS NOT NULL AND cq_option_5 != '', CONCAT('"',REPLACE(cq_option_5,'"','\"'),'"'), 'null'),',',
        IF(cq_option_6 IS NOT NULL AND cq_option_6 != '', CONCAT('"',REPLACE(cq_option_6,'"','\"'),'"'), 'null'),
    '],"correct":"',COALESCE(cq_correct_answer,''),'"}')
FROM tn_course_quiz;

-- Crear relaciones quiz-pregunta para preguntas asignadas a quizzes
INSERT INTO quiz_questions (
    qq_quiz_id, qq_question_id, qq_points, qq_created_on
)
SELECT 
    cq_quiz_id,
    (SELECT qb_id FROM question_bank WHERE qb_text = cq_question LIMIT 1),
    COALESCE(cq_gain_point, 1), -- Usando el campo correcto cq_gain_point para los puntos
    NOW()
FROM tn_course_quiz
WHERE cq_quiz_id > 0;
