<?php
/**
 * Script para ejecutar la migraciu00f3n del banco de preguntas
 * Este script carga directamente el framework de CodeIgniter sin restricciones
 */

// Definir constantes necesarias para CodeIgniter
define('BASEPATH', 'system');
define('ENVIRONMENT', 'development');
define('VIEWPATH', 'My_application/views/');
define('SCRIPTPATH', __FILE__);
define('APPPATH', 'My_application/');

// Iniciar output buffering para controlar la salida
ob_start();

// Incluir archivo index de CodeIgniter para inicializar el sistema
include_once('index.php');

// Obtener la conexiu00f3n a la base de datos de CodeIgniter
$CI = &get_instance();

// Verificar si las tablas ya existen
$tablesExist = $CI->db->table_exists('question_bank') && $CI->db->table_exists('quiz_questions');

// Mensaje de cabecera
echo '<!DOCTYPE html><html><head><title>Migraciu00f3n Banco de Preguntas</title>';
echo '<style>body{font-family:Arial;margin:20px;line-height:1.6}h1,h2{color:#2980b9}'
    . '.success{color:green;font-weight:bold}.error{color:red;font-weight:bold}'
    . '.box{border:1px solid #ddd;padding:15px;margin:15px 0;border-radius:4px}'
    . '.button{display:inline-block;padding:10px 15px;background:#3498db;color:white;'
    . 'text-decoration:none;border-radius:4px;margin-right:10px}</style></head><body>';

echo '<h1>Herramienta de Migraciu00f3n del Banco de Preguntas</h1>';

if (!$tablesExist) {
    echo '<div class="box error"><h2>Las tablas no existen</h2>';
    echo '<p>Primero necesitas crear las tablas en la base de datos.</p>';
    
    // Crear las tablas con las definiciones del archivo SQL
    $sqlFile = file_get_contents('question_bank_migration.sql');
    $sqlStatements = explode(';', $sqlFile);
    
    echo '<h3>Ejecutando migraciu00f3n de esquema...</h3>';
    $success = true;
    
    foreach ($sqlStatements as $sql) {
        if (trim($sql) == '') continue;
        
        // Ignorar comentarios
        if (strpos(trim($sql), '--') === 0) continue;
        
        try {
            $CI->db->query($sql);
            echo '<p><span class="success">u2714 Ejecutado:</span> ' . substr(htmlspecialchars(trim($sql)), 0, 50) . '...</p>';
        } catch (Exception $e) {
            echo '<p><span class="error">u2718 Error:</span> ' . $e->getMessage() . '</p>';
            $success = false;
        }
    }
    
    if ($success) {
        echo '<p class="success">Tablas creadas correctamente.</p>';
    } else {
        echo '<p class="error">Hubo errores al crear las tablas.</p>';
    }
    
    echo '</div>';
} else {
    echo '<div class="box success"><p>Las tablas ya existen en la base de datos.</p></div>';
}

// Verificar si se solicitou00f3 la migraciu00f3n de datos
if (isset($_GET['migrate_data']) || isset($_POST['migrate_data'])) {
    echo '<div class="box"><h2>Migraciu00f3n de Datos</h2>';
    
    // Cargar modelos necesarios
    $CI->load->model('model_question_bank');
    $CI->load->model('model_quiz_questions');
    
    // Contadores para estadisticas
    $stats = [
        'total_questions' => 0,
        'migrated_questions' => 0,
        'failed_questions' => 0,
        'total_relations' => 0,
        'migrated_relations' => 0,
        'failed_relations' => 0,
        'unassigned_questions' => 0,
        'assigned_questions' => 0
    ];
    
    // Obtener todas las preguntas existentes de course_quiz
    $CI->db->select('*');
    $existing_questions = $CI->db->get('course_quiz')->result_array();
    $stats['total_questions'] = count($existing_questions);
    
    echo '<p>Iniciando migraciu00f3n de ' . $stats['total_questions'] . ' preguntas...</p>';
    
    // Mapeo de IDs antiguos a nuevos para mantener relaciones
    $id_mapping = [];
    
    // Iniciar transacciu00f3n
    $CI->db->trans_start();
    
    // Procesar cada pregunta
    foreach ($existing_questions as $question) {
        try {
            // Preparar datos para el nuevo formato
            $new_question = [
                'qb_text' => $question['cq_question'],
                'qb_type' => $question['cq_type'],
                'qb_is_bonus' => isset($question['cq_is_bonus']) ? $question['cq_is_bonus'] : 0,
                'qb_bonus_points' => isset($question['cq_bonus_points']) ? $question['cq_bonus_points'] : 0,
                'qb_difficulty' => 3, // Dificultad media por defecto
                'qb_course_id' => $question['cq_course_id'],
                'qb_subject_id' => isset($question['cq_subject_id']) ? $question['cq_subject_id'] : null,
                'qb_created_by' => $question['cq_created_by'] ?? 1,
                'qb_created_on' => $question['cq_createdon'] ?? date('Y-m-d H:i:s'),
                'qb_status' => $question['cq_status'],
            ];
            
            // Si hay opciones, convertirlas al nuevo formato
            if (isset($question['cq_options']) && !empty($question['cq_options'])) {
                $new_question['qb_options'] = $question['cq_options'];
            }
            
            // Guardar la pregunta en el nuevo banco
            $CI->db->insert('question_bank', $new_question);
            $new_question_id = $CI->db->insert_id();
            
            if ($new_question_id) {
                // Guardar mapeo de ID antiguo a nuevo
                $id_mapping[$question['cq_id']] = $new_question_id;
                $stats['migrated_questions']++;
                
                // Verificar si la pregunta estaba asignada a un quiz
                if (isset($question['cq_quiz_id']) && $question['cq_quiz_id'] > 0) {
                    $stats['assigned_questions']++;
                    
                    // Crear relaciu00f3n en la nueva tabla
                    $relation_data = [
                        'qq_quiz_id' => $question['cq_quiz_id'],
                        'qq_question_id' => $new_question_id,
                        'qq_order' => 0, // Orden por defecto
                        'qq_points' => $question['cq_points'] ?? 1,
                        'qq_created_on' => date('Y-m-d H:i:s')
                    ];
                    
                    $CI->db->insert('quiz_questions', $relation_data);
                    $relation_id = $CI->db->insert_id();
                    
                    if ($relation_id) {
                        $stats['migrated_relations']++;
                    } else {
                        $stats['failed_relations']++;
                    }
                    
                    $stats['total_relations']++;
                } else {
                    $stats['unassigned_questions']++;
                }
            } else {
                $stats['failed_questions']++;
            }
        } catch (Exception $e) {
            $stats['failed_questions']++;
            echo '<p class="error">Error migrando pregunta ID ' . $question['cq_id'] . ': ' . $e->getMessage() . '</p>';
        }
    }
    
    // Completar transacciu00f3n
    $CI->db->trans_complete();
    
    if ($CI->db->trans_status() === FALSE) {
        echo '<p class="error">Error en la transacciu00f3n. Algunas operaciones pueden no haberse completado.</p>';
    }
    
    // Mostrar resultados
    echo '<h3>Resultados de la Migraciu00f3n</h3>';
    echo '<ul>';
    echo '<li><strong>Preguntas totales:</strong> ' . $stats['total_questions'] . '</li>';
    echo '<li><strong>Preguntas migradas:</strong> ' . $stats['migrated_questions'] . '</li>';
    echo '<li><strong>Preguntas fallidas:</strong> ' . $stats['failed_questions'] . '</li>';
    echo '<li><strong>Preguntas sin asignar:</strong> ' . $stats['unassigned_questions'] . '</li>';
    echo '<li><strong>Preguntas asignadas a quizzes:</strong> ' . $stats['assigned_questions'] . '</li>';
    echo '<li><strong>Relaciones creadas:</strong> ' . $stats['migrated_relations'] . '</li>';
    echo '<li><strong>Relaciones fallidas:</strong> ' . $stats['failed_relations'] . '</li>';
    echo '</ul>';
    
    if ($stats['migrated_questions'] == $stats['total_questions']) {
        echo '<p class="success"><strong>Migraciu00f3n completada con u00e9xito!</strong></p>';
    } else {
        echo '<p class="error"><strong>Migraciu00f3n parcial - Revise los errores</strong></p>';
    }
    
    echo '</div>';
} else {
    echo '<div class="box">';
    echo '<h2>Iniciar Migraciu00f3n de Datos</h2>';
    echo '<p>Haz clic en el botu00f3n para iniciar la migraciu00f3n de datos:</p>';
    echo '<form method="post"><input type="hidden" name="migrate_data" value="1">';
    echo '<button type="submit" class="button">Iniciar Migraciu00f3n de Datos</button></form>';
    echo '</div>';
}

echo '<div style="margin-top:20px">';
echo '<a href="admin/question_bank" class="button">Ir al Banco de Preguntas</a>';
echo '<a href="admin" class="button" style="background:#27ae60">Volver al Dashboard</a>';
echo '</div>';

echo '</body></html>';

// Limpiar buffer de salida anterior
ob_end_flush();

// Terminar ejecuciu00f3n
exit;
