<?php
/**
 * Script directo para migrar datos al Banco de Preguntas Centralizado
 * Este script es independiente de CodeIgniter y no requiere iniciar sesiu00f3n
 */

// Configurar tiempo de ejecuciu00f3n (algunos servidores pueden limitar la ejecuciu00f3n)
set_time_limit(300); // 5 minutos
ini_set('memory_limit', '256M');

// Obtener configuraciu00f3n de base de datos
$config_file = './My_application/config/database.php';
if (!file_exists($config_file)) {
    die('Error: No se pudo encontrar el archivo de configuraciu00f3n de la base de datos');
}

require_once($config_file);

// Establecer conexiu00f3n a la base de datos
$db_config = $db['default'];

try {
    $mysqli = new mysqli(
        $db_config['hostname'],
        $db_config['username'],
        $db_config['password'],
        $db_config['database']
    );

    if ($mysqli->connect_error) {
        die('Error de conexiu00f3n: ' . $mysqli->connect_error);
    }
} catch (Exception $e) {
    die('Error de conexiu00f3n: ' . $e->getMessage());
}

// Verificar si las tablas existen
$result = $mysqli->query("SHOW TABLES LIKE 'question_bank'");
if ($result->num_rows == 0) {
    die('Error: La tabla question_bank no existe. Ejecute la migraciu00f3n de esquema primero.');
}

$result = $mysqli->query("SHOW TABLES LIKE 'quiz_questions'");
if ($result->num_rows == 0) {
    die('Error: La tabla quiz_questions no existe. Ejecute la migraciu00f3n de esquema primero.');
}

// Funciones auxiliares
function sanitize_string($value) {
    global $mysqli;
    return $mysqli->real_escape_string($value);
}

// Iniciar salida HTML
echo '<!DOCTYPE html>
<html>
<head>
    <title>Migraciu00f3n de Datos - Banco de Preguntas</title>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
        h1, h2 { color: #2980b9; }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        .warning { color: orange; font-weight: bold; }
        .stats { background: #f8f9fa; padding: 15px; margin: 15px 0; border-left: 4px solid #2980b9; }
        .progress { margin: 10px 0; }
    </style>
</head>
<body>
<h1>Migraciu00f3n de Datos - Banco de Preguntas Centralizado</h1>
';

// Iniciar contador de tiempo para mediciu00f3n de rendimiento
$start_time = microtime(true);

// Contadores para estadu00edsticas
$stats = [
    'total_questions' => 0,
    'migrated_questions' => 0,
    'failed_questions' => 0,
    'total_relations' => 0,
    'migrated_relations' => 0,
    'failed_relations' => 0,
    'unassigned_questions' => 0,
    'assigned_questions' => 0
];

// 1. Verificar si ya hay datos en las tablas nuevas
$result = $mysqli->query("SELECT COUNT(*) as count FROM question_bank");
$row = $result->fetch_assoc();
if ($row['count'] > 0) {
    echo '<div class="warning">Advertencia: Ya existen ' . $row['count'] . ' preguntas en el banco centralizado.</div>';
    echo '<p>Si continu00faa, podru00edan crearse duplicados. u00bfDesea continuar?</p>';
    echo '<form method="POST"><input type="hidden" name="confirm" value="1"><button type="submit">Su00ed, continuar</button></form>';
    
    if (!isset($_POST['confirm'])) {
        echo '</body></html>';
        exit;
    }
}

echo '<h2>Obteniendo datos de preguntas existentes...</h2>';

// 2. Obtener todas las preguntas existentes
$result = $mysqli->query("SELECT * FROM course_quiz");
if (!$result) {
    die('<div class="error">Error obteniendo preguntas: ' . $mysqli->error . '</div>');
}

$existing_questions = [];
while ($row = $result->fetch_assoc()) {
    $existing_questions[] = $row;
}

$stats['total_questions'] = count($existing_questions);

echo '<p>Se encontraron ' . $stats['total_questions'] . ' preguntas para migrar.</p>';

// Iniciar transacciu00f3n
$mysqli->begin_transaction();

try {
    // Mapeo de IDs antiguos a nuevos
    $id_mapping = [];
    
    echo '<div class="progress">Procesando preguntas...</div>';
    
    // Procesar cada pregunta
    foreach ($existing_questions as $question) {
        // Valores por defecto para campos que podru00edan faltar
        $is_bonus = isset($question['cq_is_bonus']) ? (int)$question['cq_is_bonus'] : 0;
        $bonus_points = isset($question['cq_bonus_points']) ? (float)$question['cq_bonus_points'] : 0;
        $subject_id = isset($question['cq_subject_id']) ? $question['cq_subject_id'] : 'NULL';
        $created_by = isset($question['cq_created_by']) ? (int)$question['cq_created_by'] : 1;
        $created_on = isset($question['cq_createdon']) ? "'" . sanitize_string($question['cq_createdon']) . "'" : 'NOW()';
        $options = isset($question['cq_options']) ? "'" . sanitize_string($question['cq_options']) . "'" : 'NULL';
        
        // Insertar en question_bank
        $query = "INSERT INTO question_bank (
            qb_text, qb_type, qb_is_bonus, qb_bonus_points, qb_course_id, 
            qb_subject_id, qb_created_by, qb_created_on, qb_status, qb_options
        ) VALUES (
            '" . sanitize_string($question['cq_question']) . "',
            " . (int)$question['cq_type'] . ",
            " . $is_bonus . ",
            " . $bonus_points . ",
            " . (int)$question['cq_course_id'] . ",
            " . $subject_id . ",
            " . $created_by . ",
            " . $created_on . ",
            " . (int)$question['cq_status'] . ",
            " . $options . "
        )";
        
        if (!$mysqli->query($query)) {
            throw new Exception('Error insertando pregunta ID ' . $question['cq_id'] . ': ' . $mysqli->error);
        }
        
        $new_question_id = $mysqli->insert_id;
        $id_mapping[$question['cq_id']] = $new_question_id;
        $stats['migrated_questions']++;
        
        // Verificar si estu00e1 asignada a un quiz
        if (isset($question['cq_quiz_id']) && $question['cq_quiz_id'] > 0) {
            $stats['assigned_questions']++;
            $stats['total_relations']++;
            
            // Crear relaciu00f3n en quiz_questions
            $points = isset($question['cq_points']) ? (float)$question['cq_points'] : 1;
            
            $query = "INSERT INTO quiz_questions (
                qq_quiz_id, qq_question_id, qq_order, qq_points, qq_created_on
            ) VALUES (
                " . (int)$question['cq_quiz_id'] . ",
                " . $new_question_id . ",
                0,
                " . $points . ",
                NOW()
            )";
            
            if (!$mysqli->query($query)) {
                // No detener el proceso por fallos en relaciones
                echo '<p class="error">Error creando relaciu00f3n para pregunta ID ' . $question['cq_id'] . ': ' . $mysqli->error . '</p>';
                $stats['failed_relations']++;
            } else {
                $stats['migrated_relations']++;
            }
        } else {
            $stats['unassigned_questions']++;
        }
        
        // Actualizar progreso cada 10 preguntas
        if ($stats['migrated_questions'] % 10 == 0) {
            echo '<script>document.querySelector(".progress").innerHTML = "Procesando preguntas: ' . $stats['migrated_questions'] . ' de ' . $stats['total_questions'] . '";</script>';
            flush();
        }
    }
    
    // Confirmar transacciu00f3n
    $mysqli->commit();
    
    echo '<div class="success">Migraciu00f3n completada con u00e9xito.</div>';
} catch (Exception $e) {
    // Revertir transacciu00f3n en caso de error
    $mysqli->rollback();
    echo '<div class="error">Error durante la migraciu00f3n: ' . $e->getMessage() . '</div>';
}

// Calcular tiempo total
$end_time = microtime(true);
$execution_time = ($end_time - $start_time);

// Mostrar estadu00edsticas
echo '<div class="stats">';
echo '<h2>Resumen de la Migraciu00f3n</h2>';
echo '<ul>';
echo '<li><strong>Tiempo total:</strong> ' . number_format($execution_time, 2) . ' segundos</li>';
echo '<li><strong>Preguntas totales:</strong> ' . $stats['total_questions'] . '</li>';
echo '<li><strong>Preguntas migradas:</strong> ' . $stats['migrated_questions'] . '</li>';
echo '<li><strong>Preguntas fallidas:</strong> ' . ($stats['total_questions'] - $stats['migrated_questions']) . '</li>';
echo '<li><strong>Preguntas sin asignar:</strong> ' . $stats['unassigned_questions'] . '</li>';
echo '<li><strong>Preguntas asignadas a quizzes:</strong> ' . $stats['assigned_questions'] . '</li>';
echo '<li><strong>Relaciones creadas:</strong> ' . $stats['migrated_relations'] . '</li>';
echo '<li><strong>Relaciones fallidas:</strong> ' . $stats['failed_relations'] . '</li>';
echo '</ul>';
echo '</div>';

// Cerrar conexiu00f3n
$mysqli->close();

// Enlaces de navegaciu00f3n
echo '<div style="margin-top:20px">';
echo '<a href="index.php/admin/question_bank" style="padding:10px 15px;background:#27ae60;color:white;text-decoration:none;border-radius:4px;margin-right:10px;">Ir al Banco de Preguntas</a>';
echo '<a href="index.php/admin" style="padding:10px 15px;background:#2980b9;color:white;text-decoration:none;border-radius:4px;">Volver al Dashboard</a>';
echo '</div>';

echo '</body></html>';
