<?php
/**
 * Script directo para ejecutar migraciones sin redirecciones
 * Coloque este archivo en la raíz del proyecto y acceda a él directamente
 */

// Definir constantes necesarias para CodeIgniter
define('BASEPATH', 'system/');
define('ENVIRONMENT', 'development');

// Cargar el archivo de configuración principal
require_once('./My_application/config/config.php');

// Cargar la conexión a la base de datos
require_once('./My_application/config/database.php');

// Establecer la conexión a la base de datos
$db = mysqli_connect(
    $db['default']['hostname'],
    $db['default']['username'],
    $db['default']['password'],
    $db['default']['database']
);

if (!$db) {
    die('Error de conexión a la base de datos: ' . mysqli_connect_error());
}

echo '<html><head><title>Migración del Banco de Preguntas</title>';
echo '<style>body{font-family:Arial,sans-serif;margin:20px;line-height:1.6}h1{color:#2980b9}';
echo '.success{color:green;font-weight:bold}.error{color:red;font-weight:bold}';
echo '.query{background:#f8f9fa;padding:10px;font-family:monospace;margin:5px 0;border-left:4px solid #2980b9}</style>';
echo '</head><body>';

echo '<h1>Migración del Banco de Preguntas Centralizado</h1>';

// 1. Crear tabla question_bank
echo '<h2>Paso 1: Creando tabla question_bank</h2>';

$query = "CREATE TABLE IF NOT EXISTS `question_bank` (
    `qb_id` int(11) NOT NULL AUTO_INCREMENT,
    `qb_text` text NOT NULL,
    `qb_explanation` text,
    `qb_type` int(2) NOT NULL COMMENT '1: Multiple Choice, 2: True/False, 3: Essay, etc.',
    `qb_difficulty` int(1) DEFAULT '1' COMMENT '1-5 escala de dificultad',
    `qb_is_bonus` tinyint(1) DEFAULT '0',
    `qb_bonus_points` float DEFAULT '0',
    `qb_course_id` int(11) DEFAULT NULL,
    `qb_subject_id` int(11) DEFAULT NULL,
    `qb_created_by` int(11) NOT NULL,
    `qb_created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `qb_modified_on` datetime DEFAULT NULL,
    `qb_status` tinyint(1) DEFAULT '1',
    `qb_tags` varchar(255) DEFAULT NULL,
    `qb_options` text COMMENT 'JSON encoded options',
    PRIMARY KEY (`qb_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

echo '<div class="query">' . $query . '</div>';

if (mysqli_query($db, $query)) {
    echo '<p class="success">Tabla question_bank creada con éxito.</p>';
} else {
    echo '<p class="error">Error creando tabla question_bank: ' . mysqli_error($db) . '</p>';
}

// 2. Crear tabla quiz_questions
echo '<h2>Paso 2: Creando tabla quiz_questions</h2>';

$query = "CREATE TABLE IF NOT EXISTS `quiz_questions` (
    `qq_id` int(11) NOT NULL AUTO_INCREMENT,
    `qq_quiz_id` int(11) NOT NULL,
    `qq_question_id` int(11) NOT NULL,
    `qq_order` int(3) DEFAULT '0',
    `qq_points` float DEFAULT '1',
    `qq_is_bonus_override` tinyint(1) DEFAULT NULL,
    `qq_created_on` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`qq_id`),
    KEY `qq_quiz_id` (`qq_quiz_id`),
    KEY `qq_question_id` (`qq_question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

echo '<div class="query">' . $query . '</div>';

if (mysqli_query($db, $query)) {
    echo '<p class="success">Tabla quiz_questions creada con éxito.</p>';
} else {
    echo '<p class="error">Error creando tabla quiz_questions: ' . mysqli_error($db) . '</p>';
}

// 3. Añadir índices
echo '<h2>Paso 3: Creando índices adicionales</h2>';

$indexes = [
    "ALTER TABLE `question_bank` ADD INDEX `idx_qb_course_subject` (`qb_course_id`, `qb_subject_id`)",
    "ALTER TABLE `question_bank` ADD INDEX `idx_qb_type` (`qb_type`)",
    "ALTER TABLE `question_bank` ADD INDEX `idx_qb_status` (`qb_status`)",
    "ALTER TABLE `quiz_questions` ADD INDEX `idx_qq_quiz_question` (`qq_quiz_id`, `qq_question_id`)"
];

$success = true;
foreach ($indexes as $query) {
    echo '<div class="query">' . $query . '</div>';
    
    if (!mysqli_query($db, $query)) {
        echo '<p class="error">Error creando índice: ' . mysqli_error($db) . '</p>';
        $success = false;
    }
}

if ($success) {
    echo '<p class="success">Todos los índices creados con éxito.</p>';
}

echo '<h2>Resumen de la Migración</h2>';
echo '<p>La migración se ha completado. Ahora puedes proceder a la migración de datos desde el sistema antiguo.</p>';

echo '<div style="margin-top:20px">';
echo '<a href="' . rtrim($config['base_url'], '/') . '/admin/migrate_questions" style="padding:10px 15px;background:#2980b9;color:white;text-decoration:none;border-radius:4px;margin-right:10px;">Migrar Datos</a>';
echo '<a href="' . rtrim($config['base_url'], '/') . '/admin/question_bank" style="padding:10px 15px;background:#27ae60;color:white;text-decoration:none;border-radius:4px;">Ir al Banco de Preguntas</a>';
echo '</div>';

echo '</body></html>';

// Cerrar conexión
mysqli_close($db);
