-- MySQL Script generated by MySQL Workbench
-- Wed May 14 10:49:37 2025
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema mydb
-- -----------------------------------------------------
-- -----------------------------------------------------
-- Schema creactivityhub
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema creactivityhub
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `creactivityhub` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci ;
-- -----------------------------------------------------
-- Schema creactivityhub_original
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema creactivityhub_original
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `creactivityhub_original` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci ;
USE `creactivityhub` ;

-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_announcements`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_announcements` (
  `announcements_id` INT NOT NULL AUTO_INCREMENT,
  `announcements_course_id` INT NULL DEFAULT NULL,
  `announcements_title` VARCHAR(100) NULL DEFAULT NULL,
  `announcements_description` TEXT NULL DEFAULT NULL,
  `announcements_status` TINYINT NOT NULL DEFAULT '1',
  `announcements_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`announcements_id`),
  INDEX `announcements_status` USING BTREE (`announcements_status`) VISIBLE,
  INDEX `announcements_course_id` USING BTREE (`announcements_course_id`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 7
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_course`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_course` (
  `course_id` INT NOT NULL AUTO_INCREMENT,
  `course_category_id` INT NOT NULL DEFAULT '0',
  `course_user_id` INT NOT NULL DEFAULT '2',
  `course_name` VARCHAR(512) NOT NULL,
  `course_title` VARCHAR(512) NOT NULL,
  `course_slug` VARCHAR(512) NOT NULL,
  `course_hours` VARCHAR(100) NOT NULL,
  `course_type` VARCHAR(100) NOT NULL,
  `course_total_enrolled` VARCHAR(100) NOT NULL,
  `course_duration` VARCHAR(100) NOT NULL,
  `course_short_description` TEXT NOT NULL,
  `course_description` TEXT NULL DEFAULT NULL,
  `course_package_detail` TEXT NULL DEFAULT NULL,
  `course_faqs` TEXT NULL DEFAULT NULL,
  `course_information` TEXT NULL DEFAULT NULL,
  `course_regulatory_information` TEXT NULL DEFAULT NULL,
  `course_price` FLOAT NOT NULL DEFAULT '0',
  `course_image` VARCHAR(255) NULL DEFAULT NULL,
  `course_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `course_status` TINYINT NOT NULL DEFAULT '1',
  `course_is_featured` TINYINT NOT NULL DEFAULT '1',
  `course_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `course_is_adsense` TINYINT NOT NULL DEFAULT '0',
  `course_professor` VARCHAR(50) NOT NULL,
  `course_professor_image` VARCHAR(150) NOT NULL,
  PRIMARY KEY USING BTREE (`course_id`),
  INDEX `course_stauts` USING BTREE (`course_status`) VISIBLE,
  INDEX `course_category_id` (`course_category_id` ASC) VISIBLE,
  INDEX `course_user_id` (`course_user_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 37
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_assignment_group`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_assignment_group` (
  `assignment_group_id` INT NOT NULL AUTO_INCREMENT,
  `assignment_group_name` VARCHAR(255) NOT NULL,
  `assignment_group_percentage` INT NOT NULL,
  `assignment_group_course_id` INT NOT NULL,
  `assignment_group_status` TINYINT NOT NULL DEFAULT '1',
  `assignment_group_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`assignment_group_id`),
  INDEX `assignment_group_course_id` (`assignment_group_course_id` ASC) VISIBLE,
  CONSTRAINT `tn_assignment_group_ibfk_1`
    FOREIGN KEY (`assignment_group_course_id`)
    REFERENCES `creactivityhub`.`tn_course` (`course_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 59
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_assignment`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_assignment` (
  `assignment_id` INT NOT NULL AUTO_INCREMENT,
  `assignment_subject_id` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_course_id` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_title` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_number` FLOAT NOT NULL DEFAULT '0',
  `assignment` INT NOT NULL,
  `assignment_description` TEXT NULL DEFAULT NULL,
  `assignment_feedback` TEXT NULL DEFAULT NULL,
  `assignment_file` TEXT NULL DEFAULT NULL,
  `assignment_file_path` TEXT NULL DEFAULT NULL,
  `assignment_startdate` DATE NULL DEFAULT NULL,
  `assignment_enddate` DATE NULL DEFAULT NULL,
  `assignment_untildate` DATE NULL DEFAULT NULL,
  `assignment_status` TINYINT NOT NULL DEFAULT '1',
  `assignment_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`assignment_id`),
  INDEX `assignment_status` USING BTREE (`assignment_status`) VISIBLE,
  INDEX `assignment_subject_id` USING BTREE (`assignment_subject_id`) VISIBLE,
  INDEX `assignment_course_id` USING BTREE (`assignment_course_id`) VISIBLE,
  INDEX `assignment` (`assignment` ASC) VISIBLE,
  CONSTRAINT `tn_assignment_ibfk_1`
    FOREIGN KEY (`assignment`)
    REFERENCES `creactivityhub`.`tn_assignment_group` (`assignment_group_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 11
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_assignment_submit`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_assignment_submit` (
  `assignment_submit_id` INT NOT NULL AUTO_INCREMENT,
  `assignment_submit_assignment_id` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_submit_user_id` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_submit_title` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_submit_feedback` TEXT NULL DEFAULT NULL,
  `assignment_submit_points` FLOAT NOT NULL DEFAULT '0',
  `assignment_submit_file` TEXT NULL DEFAULT NULL,
  `assignment_submit_file_path` TEXT NULL DEFAULT NULL,
  `assignment_submit_status` TINYINT NOT NULL DEFAULT '1',
  `assignment_submit_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`assignment_submit_id`),
  INDEX `assignment_submit_status` USING BTREE (`assignment_submit_status`) VISIBLE,
  INDEX `assignment_submit_assignment_id` USING BTREE (`assignment_submit_assignment_id`) VISIBLE,
  INDEX `assignment_submit_user_id` USING BTREE (`assignment_submit_user_id`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 36
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_banner`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_banner` (
  `banner_id` INT NOT NULL AUTO_INCREMENT,
  `banner_page_id` INT NOT NULL DEFAULT '0',
  `banner_layout1` TEXT NULL DEFAULT NULL,
  `banner_layout2` VARCHAR(255) NULL DEFAULT NULL,
  `banner_layout3` VARCHAR(512) NULL DEFAULT NULL,
  `banner_layout4` VARCHAR(512) NULL DEFAULT NULL,
  `banner_layout5` VARCHAR(512) NULL DEFAULT NULL,
  `banner_readmore_btn` VARCHAR(512) NULL DEFAULT NULL,
  `banner_video_link` VARCHAR(512) NULL DEFAULT NULL,
  `banner_image_path` TINYTEXT NOT NULL,
  `banner_image1` VARCHAR(255) NOT NULL,
  `banner_image1_thumb` VARCHAR(255) NOT NULL,
  `banner_image2` VARCHAR(255) NOT NULL,
  `banner_image2_thumb` VARCHAR(255) NOT NULL,
  `banner_image3` VARCHAR(255) NOT NULL,
  `banner_image3_thumb` VARCHAR(255) NOT NULL,
  `banner_position` TINYINT NOT NULL DEFAULT '0',
  `banner_status` TINYINT NOT NULL DEFAULT '1' COMMENT '1=Active 0=In-Active',
  `banner_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`banner_id`),
  INDEX `banner_status` (`banner_status` ASC) VISIBLE,
  INDEX `banner_position` (`banner_position` ASC) VISIBLE,
  INDEX `banner_page_id` (`banner_page_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 2
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_blog`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_blog` (
  `blog_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `blog_name` VARCHAR(100) NULL DEFAULT NULL,
  `blog_status` TINYINT NOT NULL DEFAULT '1',
  `blog_createdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`blog_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_blog_comment`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_blog_comment` (
  `bc_id` INT NOT NULL AUTO_INCREMENT,
  `bc_post_id` INT NOT NULL DEFAULT '0',
  `bc_name` VARCHAR(100) NULL DEFAULT NULL,
  `bc_email` VARCHAR(100) NULL DEFAULT NULL,
  `bc_comment` TEXT NULL DEFAULT NULL,
  `bc_status` TINYINT NOT NULL DEFAULT '0',
  `bc_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`bc_id`),
  INDEX `bc_post_id` (`bc_post_id` ASC) VISIBLE,
  INDEX `bc_status` (`bc_status` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_brand`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_brand` (
  `brand_id` INT NOT NULL AUTO_INCREMENT,
  `brand_name` VARCHAR(255) NULL DEFAULT NULL,
  `brand_image` VARCHAR(255) NULL DEFAULT NULL,
  `brand_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `brand_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `brand_status` TINYINT(1) NULL DEFAULT '1' COMMENT '1=Active; 0= Inactive',
  PRIMARY KEY USING BTREE (`brand_id`),
  INDEX `brand_status` (`brand_status` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_category`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_category` (
  `category_id` INT NOT NULL AUTO_INCREMENT,
  `category_parent_id` INT NOT NULL DEFAULT '1',
  `category_name` VARCHAR(100) NULL DEFAULT NULL,
  `category_slug` VARCHAR(100) NULL DEFAULT NULL,
  `category_image` VARCHAR(255) NULL DEFAULT NULL,
  `category_image_thumb` VARCHAR(255) NULL DEFAULT NULL,
  `category_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `category_status` TINYINT NOT NULL DEFAULT '1',
  `category_is_feaured` TINYINT NOT NULL DEFAULT '1',
  `category_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`category_id`),
  INDEX `category_parent_id` (`category_parent_id` ASC) VISIBLE,
  INDEX `category_status` (`category_status` ASC) VISIBLE,
  INDEX `category_is_feaured` (`category_is_feaured` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 65
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_ci_sessions`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_ci_sessions` (
  `id` VARCHAR(128) NOT NULL,
  `ip_address` VARCHAR(45) NOT NULL,
  `timestamp` INT UNSIGNED NOT NULL DEFAULT '0',
  `data` BLOB NOT NULL,
  PRIMARY KEY (`id`, `ip_address`),
  INDEX `ci_sessions_timestamp` (`timestamp` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_cms_page`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_cms_page` (
  `cms_page_id` INT NOT NULL AUTO_INCREMENT,
  `cms_page_status` TINYINT NOT NULL DEFAULT '1',
  `cms_page_page` INT NOT NULL DEFAULT '0',
  `cms_page_is_image` TINYINT NOT NULL DEFAULT '0',
  `cms_page_name` VARCHAR(255) NULL DEFAULT NULL,
  `cms_page_title` VARCHAR(255) NULL DEFAULT NULL,
  `cms_page_content` TEXT NULL DEFAULT NULL,
  `cms_page_image` VARCHAR(255) NULL DEFAULT NULL,
  `cms_page_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `cms_page_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `cms_page_meta_title` VARCHAR(100) NULL DEFAULT NULL,
  `cms_page_meta_keywords` VARCHAR(255) NULL DEFAULT NULL,
  `cms_page_meta_description` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`cms_page_id`),
  INDEX `cms_page_status` (`cms_page_status` ASC) VISIBLE,
  INDEX `cms_page_page` (`cms_page_page` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 50
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_color`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_color` (
  `color_id` INT NOT NULL AUTO_INCREMENT,
  `color_name` VARCHAR(255) NOT NULL,
  `color_image` VARCHAR(255) NOT NULL,
  `color_image_path` VARCHAR(512) NOT NULL,
  `color_status` INT NOT NULL,
  `color_created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`color_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_config`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_config` (
  `config_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `config_variable` VARCHAR(50) NULL DEFAULT NULL,
  `config_value` VARCHAR(100) NULL DEFAULT NULL,
  `config_position` INT NOT NULL DEFAULT '0',
  `config_type` ENUM('admin', 'system') NULL DEFAULT 'system' COMMENT '1-Admin; 2-System',
  `config_status` INT NOT NULL DEFAULT '1',
  PRIMARY KEY (`config_id`),
  INDEX `config_type` (`config_type` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 30
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_country`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_country` (
  `country` VARCHAR(255) CHARACTER SET 'latin1' NOT NULL DEFAULT '',
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `sb_countrycode` INT NOT NULL DEFAULT '0',
  `sb_faxprice` DOUBLE NOT NULL DEFAULT '0',
  `sb_country_alias` CHAR(2) CHARACTER SET 'latin1' NULL DEFAULT NULL,
  `sb_in_countrysearch` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `sb_synonyms` VARCHAR(255) CHARACTER SET 'latin1' NULL DEFAULT NULL,
  `country_ar` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `country_cn` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `country_es` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `country_jp` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `country_fr` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `sb_continent` VARCHAR(30) CHARACTER SET 'latin1' NULL DEFAULT NULL COMMENT 'Country\'s Continent name',
  `sb_iso_code` CHAR(2) CHARACTER SET 'latin1' NULL DEFAULT NULL COMMENT 'Country\'s ISO Code',
  `sb_country_name_native_lang` VARCHAR(255) NOT NULL DEFAULT '' COMMENT 'Country name in it\'s native language',
  PRIMARY KEY (`id`),
  UNIQUE INDEX `country` (`country` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 240
DEFAULT CHARACTER SET = utf8mb3
ROW_FORMAT = DYNAMIC;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_coupon`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_coupon` (
  `coupon_id` INT NOT NULL AUTO_INCREMENT,
  `coupon_course_id` INT NOT NULL DEFAULT '0',
  `coupon_type` TINYINT NOT NULL COMMENT '1=>%, 2=>price',
  `coupon_code` VARCHAR(50) NOT NULL,
  `coupon_comments` VARCHAR(255) NULL DEFAULT NULL,
  `coupon_rate` FLOAT NOT NULL DEFAULT '0',
  `coupon_status` TINYINT NOT NULL DEFAULT '1',
  `coupon_createdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `coupon_expire_date` DATE NULL DEFAULT NULL,
  `coupon_start_date` DATE NULL DEFAULT NULL,
  PRIMARY KEY (`coupon_id`),
  INDEX `coupon_type` (`coupon_type` ASC) VISIBLE,
  INDEX `coupon_status` (`coupon_status` ASC) VISIBLE,
  INDEX `coupon_course_id` (`coupon_course_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 2005
DEFAULT CHARACTER SET = latin1
COMMENT = 'Coupon';


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_course_quiz`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_course_quiz` (
  `cq_id` INT NOT NULL AUTO_INCREMENT,
  `cq_type` INT NOT NULL DEFAULT '0',
  `cq_quiz_id` INT NOT NULL DEFAULT '0',
  `cq_course_id` INT NOT NULL DEFAULT '0',
  `cq_subject_id` INT NOT NULL DEFAULT '0',
  `cq_question` MEDIUMTEXT NOT NULL,
  `cq_option_1` VARCHAR(255) NOT NULL,
  `cq_option_2` VARCHAR(255) NOT NULL,
  `cq_option_3` VARCHAR(255) NULL DEFAULT NULL,
  `cq_option_4` VARCHAR(255) NULL DEFAULT NULL,
  `cq_option_5` VARCHAR(255) NULL DEFAULT NULL,
  `cq_option_6` VARCHAR(255) NULL DEFAULT NULL,
  `cq_correct_answer` VARCHAR(50) NULL DEFAULT NULL,
  `cq_gain_point` FLOAT NOT NULL DEFAULT '0',
  `cq_order` INT NOT NULL DEFAULT '0' COMMENT 'Order of questions in quiz',
  `cq_is_bonus` TINYINT(1) NULL DEFAULT '0',
  `cq_bonus_points` FLOAT NULL DEFAULT '0',
  `cq_status` TINYINT NOT NULL DEFAULT '1',
  `cq_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`cq_id`),
  INDEX `cq_status` USING BTREE (`cq_status`) VISIBLE,
  INDEX `cq_course_id` USING BTREE (`cq_course_id`) VISIBLE,
  INDEX `cq_subject_id` USING BTREE (`cq_subject_id`) VISIBLE,
  INDEX `cq_type` (`cq_type` ASC) VISIBLE,
  INDEX `cq_quiz_id` (`cq_quiz_id` ASC) VISIBLE,
  INDEX `idx_course_quiz_order` (`cq_quiz_id` ASC, `cq_order` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 117
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_course_subject`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_course_subject` (
  `course_subject_id` INT NOT NULL AUTO_INCREMENT,
  `course_subject_course_id` INT NOT NULL DEFAULT '0',
  `course_subject_position` INT NOT NULL,
  `course_subject_name` VARCHAR(512) NULL DEFAULT NULL,
  `course_subject_credit` FLOAT NULL DEFAULT '0',
  `course_subject_status` TINYINT NOT NULL DEFAULT '1',
  `course_subject_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`course_subject_id`),
  INDEX `subject_status` USING BTREE (`course_subject_status`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 130
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_faq`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_faq` (
  `faq_id` INT NOT NULL AUTO_INCREMENT,
  `faq_question` TEXT NULL DEFAULT NULL,
  `faq_answer` TEXT NULL DEFAULT NULL,
  `faq_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `faq_status` TINYINT(1) NULL DEFAULT '1' COMMENT '1=Active; 0= Inactive',
  PRIMARY KEY USING BTREE (`faq_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 5
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_grade`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_grade` (
  `grade_id` INT NOT NULL AUTO_INCREMENT,
  `grade_user_id` INT NULL DEFAULT NULL,
  `grade_course_id` INT NULL DEFAULT NULL,
  `grade_subject_id` INT NULL DEFAULT NULL,
  `grade_related_id` INT NULL DEFAULT NULL,
  `grade_type` VARCHAR(50) NULL DEFAULT NULL,
  `grade_assignment_id` INT NULL DEFAULT NULL,
  `grade_quiz_id` INT NULL DEFAULT NULL,
  `grade_marks` FLOAT NULL DEFAULT '0',
  `grade_total_marks` FLOAT NULL DEFAULT '0',
  `grade_percentage` DECIMAL(10,2) NOT NULL,
  `grade_status` TINYINT NULL DEFAULT '1',
  `grade_oncreated` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`grade_id`),
  INDEX `grade_user_id` USING BTREE (`grade_user_id`) VISIBLE,
  INDEX `grade_course_id` USING BTREE (`grade_course_id`) VISIBLE,
  INDEX `grade_subject_id` USING BTREE (`grade_subject_id`) VISIBLE,
  INDEX `grade_related_id` USING BTREE (`grade_related_id`) VISIBLE,
  INDEX `grade_status` USING BTREE (`grade_status`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 1955
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_grade_setting`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_grade_setting` (
  `grade_setting_id` INT NOT NULL AUTO_INCREMENT,
  `course_id` INT NOT NULL,
  `missing_percentage` INT NULL DEFAULT NULL,
  `missing_percentage_status` INT NOT NULL,
  `late_percentage_status` INT NOT NULL,
  `late_percentage` INT NULL DEFAULT NULL,
  `grade_setting_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`grade_setting_id`),
  INDEX `grade_course_foreign_id` (`course_id` ASC) VISIBLE,
  CONSTRAINT `tn_grade_setting_ibfk_1`
    FOREIGN KEY (`course_id`)
    REFERENCES `creactivityhub`.`tn_course` (`course_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 4
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_grading_settings`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_grading_settings` (
  `grading_setting_id` INT NOT NULL AUTO_INCREMENT,
  `course_id` INT NOT NULL,
  `grading_system` ENUM('pass_fail', 'letter_grade', 'gpa', 'custom') NOT NULL,
  `pass_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_a_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_b_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_c_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_d_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_f_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `gpa_1_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `gpa_2_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `gpa_3_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `gpa_4_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `custom_grades` LONGTEXT CHARACTER SET 'utf8mb4' COLLATE 'utf8mb4_bin' NULL DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`grading_setting_id`),
  INDEX `course_id` (`course_id` ASC) VISIBLE,
  CONSTRAINT `tn_grading_settings_ibfk_1`
    FOREIGN KEY (`course_id`)
    REFERENCES `creactivityhub`.`tn_course` (`course_id`)
    ON DELETE CASCADE)
ENGINE = InnoDB
AUTO_INCREMENT = 4
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_inquiry`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_inquiry` (
  `inquiry_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `inquiry_user_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `inquiry_heading` VARCHAR(100) NULL DEFAULT NULL,
  `inquiry_type` VARCHAR(100) NULL DEFAULT NULL COMMENT 'Identifies from where inquiry comes from . eg. contactus',
  `inquiry_name` VARCHAR(100) NULL DEFAULT NULL,
  `inquiry_email` VARCHAR(100) NULL DEFAULT NULL,
  `inquiry_phone` VARCHAR(100) NULL DEFAULT NULL,
  `inquiry_message` TEXT NULL DEFAULT NULL,
  `inquiry_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `inquiry_status` TINYINT NOT NULL DEFAULT '1' COMMENT '1-Unread ; 2-Read',
  PRIMARY KEY (`inquiry_id`),
  INDEX `inquiry_status` (`inquiry_status` ASC) VISIBLE,
  INDEX `inquiry_user_id` (`inquiry_user_id` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 29
DEFAULT CHARACTER SET = utf8mb3
COMMENT = 'INquiry';


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_logo`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_logo` (
  `logo_id` INT NOT NULL AUTO_INCREMENT,
  `logo_name` VARCHAR(50) COLLATE 'utf8mb3_bin' NULL DEFAULT '0',
  `logo_image` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `logo_footer_image` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `logo_favicon` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `logo_image_path` VARCHAR(512) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `logo_status` TINYINT NOT NULL DEFAULT '1',
  `ondate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`logo_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 2;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_newsletter`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_newsletter` (
  `newsletter_id` INT NOT NULL AUTO_INCREMENT,
  `newsletter_email` VARCHAR(100) NOT NULL,
  `newsletter_name` VARCHAR(100) NOT NULL,
  `newsletter_status` TINYINT NOT NULL DEFAULT '1' COMMENT '0 = Inactive, 1 = Active',
  `newsletter_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`newsletter_id`),
  INDEX `newsletter_status` (`newsletter_status` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 2
DEFAULT CHARACTER SET = utf8mb3
COMMENT = 'Newsletter';


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_post`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_post` (
  `post_id` INT NOT NULL AUTO_INCREMENT,
  `post_user_id` INT NOT NULL,
  `post_page_type` INT NOT NULL DEFAULT '1' COMMENT '1: General (timeline and profile) , 2: Groups',
  `post_page_id` INT NULL DEFAULT NULL COMMENT 'Group ID etc',
  `post_type` INT NOT NULL COMMENT '1 = text , 2 = image , 3 = video , 4 = like , 5 = update profile image',
  `post_other_action_id` INT NULL DEFAULT NULL,
  `post_description` MEDIUMTEXT NULL DEFAULT NULL,
  `post_file` MEDIUMTEXT NULL DEFAULT NULL,
  `post_file_path` MEDIUMTEXT NULL DEFAULT NULL,
  `post_visibility` INT NOT NULL DEFAULT '1',
  `post_status` INT NOT NULL DEFAULT '1',
  `post_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_post_comment`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_post_comment` (
  `post_comment_id` INT NOT NULL AUTO_INCREMENT,
  `post_comment_post_id` INT NULL DEFAULT NULL,
  `post_comment_post_type` VARCHAR(255) NULL DEFAULT NULL,
  `post_comment_user_id` INT NULL DEFAULT NULL,
  `post_comment_user_comment` MEDIUMTEXT NULL DEFAULT NULL,
  `post_comment_status` INT NULL DEFAULT NULL,
  `post_comment_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_comment_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_post_like`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_post_like` (
  `post_like_id` INT NOT NULL AUTO_INCREMENT,
  `post_like_post_id` INT NULL DEFAULT NULL,
  `post_like_post_type` VARCHAR(255) NULL DEFAULT NULL,
  `post_like_user_id` INT NOT NULL,
  `post_like_status` INT NOT NULL,
  `post_like_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_like_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_product`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_product` (
  `product_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_category_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_parent_category_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_type_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_user_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_brand_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_name` VARCHAR(100) NULL DEFAULT NULL,
  `product_slogan` VARCHAR(100) NULL DEFAULT NULL,
  `product_slug` VARCHAR(100) NULL DEFAULT NULL,
  `product_sku` VARCHAR(100) NULL DEFAULT NULL,
  `product_selling_price` FLOAT NULL DEFAULT '0',
  `product_deal_contdown` DATE NULL DEFAULT '2023-04-03',
  `product_price` FLOAT NULL DEFAULT '0',
  `product_price_wholesaler` FLOAT NULL DEFAULT '0',
  `product_price_retailers` FLOAT NULL DEFAULT '0',
  `product_short_desc` TEXT NULL DEFAULT NULL,
  `product_specification` TEXT NULL DEFAULT NULL,
  `product_desc` TEXT NULL DEFAULT NULL,
  `product_qty` FLOAT NULL DEFAULT '100',
  `product_packupsize` INT NULL DEFAULT NULL,
  `product_packup_desc` TEXT NULL DEFAULT NULL,
  `product_meta_title` VARCHAR(50) NULL DEFAULT NULL,
  `product_meta_description` VARCHAR(120) NULL DEFAULT NULL,
  `product_meta_keywords` VARCHAR(120) NULL DEFAULT NULL,
  `product_image` VARCHAR(255) NULL DEFAULT NULL,
  `product_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `product_is_featured` TINYINT(1) NULL DEFAULT '0',
  `product_is_availability` TINYINT(1) NULL DEFAULT '0',
  `product_is_hotdeal` TINYINT(1) NULL DEFAULT '0',
  `product_status` INT NOT NULL DEFAULT '1',
  `product_createdon` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`product_id`),
  INDEX `product_is_featured` (`product_is_featured` ASC) VISIBLE,
  INDEX `product_slug` (`product_slug` ASC) VISIBLE,
  INDEX `product_category_id` (`product_category_id` ASC) VISIBLE,
  INDEX `product_status` (`product_status` ASC) VISIBLE,
  INDEX `product_brand_id` (`product_brand_id` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_product_color`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_product_color` (
  `pc_color_id` INT NULL DEFAULT NULL,
  `pc_product_id` INT NULL DEFAULT NULL,
  INDEX `pc_color_id_pc_product_id` (`pc_color_id` ASC, `pc_product_id` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_product_image`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_product_image` (
  `pi_id` INT NOT NULL AUTO_INCREMENT,
  `pi_product_id` INT NOT NULL,
  `pi_image` VARCHAR(50) NOT NULL,
  `pi_image_thumb` VARCHAR(50) NOT NULL,
  `pi_image_path` TINYTEXT NOT NULL,
  `pi_createdon` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `pi_visibility` INT NOT NULL DEFAULT '1',
  `pi_is_featured` TINYINT(1) NULL DEFAULT '0',
  PRIMARY KEY (`pi_id`),
  INDEX `pi_createdon` (`pi_createdon` ASC) VISIBLE,
  INDEX `pi_product_id` (`pi_product_id` ASC) VISIBLE,
  INDEX `pi_tn_featured` (`pi_is_featured` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 657
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_product_rating`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_product_rating` (
  `pr_id` INT NOT NULL AUTO_INCREMENT,
  `pr_product_id` INT NULL DEFAULT '0',
  `pr_vendor_id` INT NULL DEFAULT '0',
  `pr_user_id` INT NULL DEFAULT '0',
  `pr_name` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `pr_email` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `pr_description` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `pr_rating` INT NULL DEFAULT NULL,
  `pr_status` TINYINT NOT NULL DEFAULT '1',
  `pr_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pr_id`),
  INDEX `pr_product_id` (`pr_product_id` ASC) VISIBLE,
  INDEX `pr_status` (`pr_status` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 4;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_question_bank`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_question_bank` (
  `qb_id` INT NOT NULL AUTO_INCREMENT,
  `qb_text` TEXT NOT NULL,
  `qb_explanation` TEXT NULL DEFAULT NULL,
  `qb_type` INT NOT NULL COMMENT '1: Multiple Choice, 2: True/False, 3: Essay, etc.',
  `qb_difficulty` INT NULL DEFAULT '1' COMMENT '1-5 escala de dificultad',
  `qb_is_bonus` TINYINT(1) NULL DEFAULT '0',
  `qb_bonus_points` FLOAT NULL DEFAULT '0',
  `qb_course_id` INT NULL DEFAULT NULL,
  `qb_subject_id` INT NULL DEFAULT NULL,
  `qb_created_by` INT NOT NULL,
  `qb_created_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `qb_modified_on` DATETIME NULL DEFAULT NULL,
  `qb_status` TINYINT(1) NULL DEFAULT '1',
  `qb_tags` VARCHAR(255) NULL DEFAULT NULL,
  `qb_options` TEXT NULL DEFAULT NULL COMMENT 'JSON encoded options',
  `qb_gain_point` INT NULL DEFAULT '0',
  `qb_correct_answer` VARCHAR(255) NULL DEFAULT NULL,
  PRIMARY KEY (`qb_id`),
  INDEX `idx_qb_course_subject` (`qb_course_id` ASC, `qb_subject_id` ASC) VISIBLE,
  INDEX `idx_qb_type` (`qb_type` ASC) VISIBLE,
  INDEX `idx_qb_status` (`qb_status` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 274
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_quiz`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_quiz` (
  `quiz_id` INT NOT NULL AUTO_INCREMENT,
  `quiz_course_id` INT NOT NULL DEFAULT '0',
  `quiz_subject_id` INT NOT NULL DEFAULT '0',
  `quiz_name` MEDIUMTEXT NOT NULL,
  `quiz_startdate` DATE NULL DEFAULT NULL,
  `quiz_enddate` DATE NULL DEFAULT NULL,
  `quiz_untildate` DATE NULL DEFAULT NULL,
  `quiz_type` TINYINT NOT NULL,
  `assignment` INT NULL DEFAULT NULL,
  `quiz_shuffle_answers` TINYINT NOT NULL DEFAULT '0',
  `quiz_time_limit` TINYINT NOT NULL DEFAULT '0',
  `quiz_time_limit_minutes` FLOAT NULL DEFAULT NULL,
  `quiz_multiple_attempts` TINYINT NULL DEFAULT '0',
  `quiz_attempt_count` INT NULL DEFAULT '1',
  `quiz_daily_penalty` FLOAT NULL DEFAULT '0',
  `quiz_max_attempts` INT NOT NULL DEFAULT '1' COMMENT 'Maximum attempts allowed (0 for unlimited)',
  `quiz_unlimited_attempts` TINYINT(1) NOT NULL DEFAULT '0' COMMENT 'Flag for unlimited attempts',
  `quiz_require_access_code` TINYINT NOT NULL DEFAULT '0',
  `quiz_access_code` VARCHAR(255) NULL DEFAULT NULL,
  `quiz_filter_ip_address` TINYINT NOT NULL DEFAULT '0',
  `score` INT NULL DEFAULT NULL COMMENT '1: Highest , 2: Latest, 3: Average',
  `quiz_status` TINYINT NOT NULL DEFAULT '1',
  `quiz_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`quiz_id`),
  INDEX `quiz_status` USING BTREE (`quiz_status`) VISIBLE,
  INDEX `quiz_course_id` USING BTREE (`quiz_course_id`) VISIBLE,
  INDEX `quiz_subject_id` USING BTREE (`quiz_subject_id`) VISIBLE,
  INDEX `assignment` (`assignment` ASC) VISIBLE,
  CONSTRAINT `tn_quiz_ibfk_1`
    FOREIGN KEY (`assignment`)
    REFERENCES `creactivityhub`.`tn_assignment_group` (`assignment_group_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 33
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_quiz_questions`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_quiz_questions` (
  `qq_id` INT NOT NULL AUTO_INCREMENT,
  `qq_quiz_id` INT NOT NULL,
  `qq_question_id` INT NOT NULL,
  `qq_order` INT NULL DEFAULT '0',
  `qq_points` FLOAT NULL DEFAULT '1',
  `qq_is_bonus_override` TINYINT(1) NULL DEFAULT NULL,
  `qq_created_on` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `qq_status` TINYINT(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`qq_id`),
  INDEX `qq_quiz_id` (`qq_quiz_id` ASC) VISIBLE,
  INDEX `qq_question_id` (`qq_question_id` ASC) VISIBLE,
  INDEX `idx_qq_quiz_question` (`qq_quiz_id` ASC, `qq_question_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 135
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_quiz_user_assignment`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_quiz_user_assignment` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `quiz_id` INT NULL DEFAULT NULL,
  `user_id` INT UNSIGNED NULL DEFAULT NULL,
  `group_id` INT NULL DEFAULT NULL,
  `due_date` DATE NULL DEFAULT NULL,
  `penalty_rate` FLOAT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  INDEX `quiz_id` (`quiz_id` ASC) VISIBLE,
  CONSTRAINT `tn_quiz_user_assignment_ibfk_1`
    FOREIGN KEY (`quiz_id`)
    REFERENCES `creactivityhub`.`tn_quiz` (`quiz_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_0900_ai_ci;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_result`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_result` (
  `r_id` INT NOT NULL AUTO_INCREMENT,
  `r_user_id` INT NULL DEFAULT '0',
  `r_course_id` INT NULL DEFAULT '0',
  `r_quiz_id` INT NULL DEFAULT '0',
  `r_start_date` DATE NULL DEFAULT NULL,
  `r_end_date` DATE NULL DEFAULT NULL,
  `r_total_quiz` FLOAT NOT NULL DEFAULT '0',
  `r_correct` FLOAT NOT NULL DEFAULT '0',
  `r_wrong` FLOAT NOT NULL DEFAULT '0',
  `r_avg` FLOAT NOT NULL DEFAULT '0',
  `r_points` FLOAT NOT NULL DEFAULT '0',
  `r_time_spent` FLOAT NOT NULL DEFAULT '0',
  `r_is_pass` TINYINT NOT NULL DEFAULT '0' COMMENT '1=PASS , 0=FAIL',
  `r_status` TINYINT NOT NULL DEFAULT '1' COMMENT '1=Active,0=In-Active',
  `r_createdon` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_late_submission` TINYINT(1) NOT NULL DEFAULT '0' COMMENT 'Indicates if submission was late',
  `days_late` INT NULL DEFAULT NULL COMMENT 'Number of days late',
  `penalty_applied` DECIMAL(5,2) NULL DEFAULT NULL COMMENT 'Percentage of penalty applied',
  `original_score` DECIMAL(10,2) NULL DEFAULT NULL COMMENT 'Score before penalty',
  `r_bonus_points` FLOAT NOT NULL DEFAULT '0' COMMENT 'Bonus points earned',
  PRIMARY KEY USING BTREE (`r_id`),
  INDEX `r_user_id` USING BTREE (`r_user_id`) VISIBLE,
  INDEX `r_status` USING BTREE (`r_status`) VISIBLE,
  INDEX `r_course_id` USING BTREE (`r_course_id`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 27
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_result_quiz`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_result_quiz` (
  `rq_id` INT NOT NULL AUTO_INCREMENT,
  `rq_result_id` INT NOT NULL DEFAULT '0',
  `rq_course_id` INT NOT NULL DEFAULT '0',
  `rq_subject_id` INT NOT NULL DEFAULT '0',
  `rq_question_id` INT NOT NULL DEFAULT '0',
  `rq_answer` TEXT NULL DEFAULT NULL,
  `rq_is_correct_asnwer` TINYINT NOT NULL DEFAULT '0' COMMENT '1=YES , 0=NO',
  `rq_feedback` TEXT NULL DEFAULT NULL,
  `rq_points` FLOAT NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`rq_id`),
  INDEX `rq_result_id` USING BTREE (`rq_result_id`) VISIBLE,
  INDEX `rq_course_id_rq_subject_id_rq_question_id` USING BTREE (`rq_course_id`, `rq_subject_id`, `rq_question_id`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 213
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_shop_item`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_shop_item` (
  `item_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_order_id` INT UNSIGNED NOT NULL,
  `item_product_id` INT UNSIGNED NOT NULL,
  `item_product_name` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_product_img` VARCHAR(512) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_qty` INT UNSIGNED NOT NULL,
  `item_rate` FLOAT UNSIGNED NOT NULL,
  `item_price` FLOAT UNSIGNED NOT NULL,
  `item_type` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_serialize` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_stripe_data` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_stripe_id` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  PRIMARY KEY (`item_id`),
  INDEX `item_order_id` (`item_order_id` ASC) VISIBLE,
  INDEX `item_product_id` (`item_product_id` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 1512
COMMENT = 'Shopping Item in order';


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_shop_order`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_shop_order` (
  `order_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_user_id` INT UNSIGNED NOT NULL,
  `order_payment_type` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT 'Paypal',
  `order_is_sandbox` TINYINT NOT NULL DEFAULT '1' COMMENT '1=sandbox , 0=live',
  `order_agreed_terms_status` INT NOT NULL DEFAULT '0' COMMENT '1=approve , 0=notapprove',
  `order_payment_status` TINYINT UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 - Not approved,1-Approved ,2-Declined ,3-Error ,4-Held for Review,11-fruad cause',
  `order_delivery_status` TINYINT UNSIGNED NOT NULL DEFAULT '1' COMMENT '0 =  In process , 1 = new order ,  shipped , 3= on hold , 4= denied , 5= reject',
  `order_status` TINYINT UNSIGNED NOT NULL DEFAULT '1' COMMENT '1=Active , 0= Disable',
  `order_ondate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `order_shipping_amount` FLOAT NOT NULL DEFAULT '0',
  `order_shipping_type` INT NOT NULL DEFAULT '0' COMMENT '0=no delivery charges , 1=free,2=pick store,3=cash on delivery',
  `order_tax_percentage` FLOAT NOT NULL DEFAULT '0',
  `order_tax_amount` FLOAT NOT NULL DEFAULT '0',
  `order_redeem_points` FLOAT NOT NULL DEFAULT '0',
  `order_redeem_points_amount` FLOAT NOT NULL DEFAULT '0',
  `order_discount_amount` FLOAT NULL DEFAULT '0',
  `order_billing_fname` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_lname` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_phone` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_email` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_address` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_address2` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_city` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_state` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_country` INT UNSIGNED NULL DEFAULT NULL,
  `order_billing_zip_code` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_fname` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_lname` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_phone` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_email` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_address` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_address2` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_city` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_state` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_country` INT NULL DEFAULT NULL,
  `order_shipping_zip_code` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_order_description` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_notes` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_mc_gross` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_date` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_payment_status` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_pending_reason` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_ReasonCode` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_verify_sign` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_txn_id` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_payer_email` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_ipn_track_id` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_payment_post` LONGTEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_coupon` VARCHAR(25) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  PRIMARY KEY (`order_id`),
  INDEX `user_id` (`order_user_id` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 1515
COMMENT = 'Shopping order data';


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_team_member`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_team_member` (
  `team_member_id` INT NOT NULL AUTO_INCREMENT,
  `team_member_name` VARCHAR(255) NULL DEFAULT NULL,
  `team_member_designation` VARCHAR(255) NULL DEFAULT NULL,
  `team_member_description` TEXT NULL DEFAULT NULL,
  `team_member_image` VARCHAR(255) NULL DEFAULT NULL,
  `team_member_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `team_member_status` TINYINT NOT NULL DEFAULT '1',
  `team_member_createdon` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY USING BTREE (`team_member_id`),
  INDEX `team_member_status` USING BTREE (`team_member_status`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 4
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_testimonial`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_testimonial` (
  `testimonial_id` INT NOT NULL AUTO_INCREMENT,
  `testimonial_name` VARCHAR(100) NULL DEFAULT NULL,
  `testimonial_designation` VARCHAR(255) NOT NULL,
  `testimonial_description` TEXT NOT NULL,
  `testimonial_rating` VARCHAR(100) NULL DEFAULT NULL,
  `testimonial_video_url` VARCHAR(512) NULL DEFAULT NULL,
  `testimonial_image` VARCHAR(255) NULL DEFAULT NULL,
  `testimonial_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `testimonial_status` TINYINT NOT NULL DEFAULT '1',
  `testimonial_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`testimonial_id`),
  INDEX `testimonial_status` USING BTREE (`testimonial_status`) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 7
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_university`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_university` (
  `university_id` INT NOT NULL AUTO_INCREMENT,
  `university_name` VARCHAR(100) NULL DEFAULT NULL,
  `university_image` VARCHAR(255) NULL DEFAULT NULL,
  `university_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `university_status` TINYINT NOT NULL DEFAULT '1',
  `university_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`university_id`),
  INDEX `university_status` USING BTREE (`university_status`) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 7
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_user`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_user` (
  `user_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_type` TINYINT NULL DEFAULT '0' COMMENT '0=End User, 1=Advisor',
  `user_parent_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_package_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_stripe_customer_id` VARCHAR(100) NULL DEFAULT NULL,
  `user_package_price` FLOAT NOT NULL DEFAULT '0',
  `user_package_startdate` DATE NULL DEFAULT '2021-12-01',
  `user_package_enddate` DATE NULL DEFAULT '2021-12-01',
  `user_package_status` TINYINT NOT NULL DEFAULT '0',
  `user_reviews_total` FLOAT UNSIGNED NOT NULL DEFAULT '0',
  `user_reviews_avail` FLOAT UNSIGNED NOT NULL DEFAULT '0',
  `user_reviews_balance` FLOAT UNSIGNED NOT NULL DEFAULT '0',
  `user_createdon` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `user_status` TINYINT UNSIGNED NULL DEFAULT '1',
  `user_is_online` TINYINT UNSIGNED NULL DEFAULT '0',
  `user_points` FLOAT UNSIGNED NULL DEFAULT '0',
  `user_email` VARCHAR(100) NULL DEFAULT NULL,
  `user_username` VARCHAR(100) NULL DEFAULT NULL,
  `user_password` VARCHAR(64) NULL DEFAULT NULL,
  `user_firstname` VARCHAR(100) NULL DEFAULT NULL,
  `user_lastname` VARCHAR(100) NULL DEFAULT NULL,
  `user_is_admin` TINYINT NULL DEFAULT '0',
  `user_term_agreed` TINYINT NULL DEFAULT '0',
  `user_email_verified_status` TINYINT NULL DEFAULT '0',
  `user_social` TINYINT NULL DEFAULT '0',
  `user_last_login_time` DATETIME NULL DEFAULT NULL,
  `user_account_activate_token` VARCHAR(50) NULL DEFAULT NULL,
  `user_server_ip` VARCHAR(50) NULL DEFAULT NULL,
  `user_connected_payment` VARCHAR(50) NULL DEFAULT NULL,
  `user_connected_id` VARCHAR(255) NULL DEFAULT NULL,
  `user_connected_status` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE INDEX `user_email` (`user_email` ASC) VISIBLE,
  UNIQUE INDEX `user_username` (`user_username` ASC) VISIBLE,
  INDEX `email_verified_status` (`user_email_verified_status` ASC) VISIBLE,
  INDEX `user_type` (`user_type` ASC) VISIBLE,
  INDEX `user_idx_admin` (`user_is_admin` ASC) VISIBLE,
  INDEX `user_status` (`user_status` ASC) VISIBLE,
  INDEX `user_parent_id` (`user_parent_id` ASC) VISIBLE,
  INDEX `user_server_ip` (`user_server_ip` ASC) VISIBLE,
  INDEX `user_package_status` (`user_package_status` ASC) VISIBLE,
  INDEX `user_package_enddate` (`user_package_enddate` ASC) VISIBLE,
  INDEX `user_package_startdate` (`user_package_startdate` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 1080
DEFAULT CHARACTER SET = latin1
COMMENT = 'Registration USER DATA';


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_user_info`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_user_info` (
  `ui_id` INT NOT NULL AUTO_INCREMENT,
  `ui_user_id` INT NOT NULL,
  `ui_industry_id` INT NOT NULL,
  `ui_phone` VARCHAR(50) NULL DEFAULT NULL,
  `ui_mobile` VARCHAR(50) NULL DEFAULT NULL,
  `ui_website` VARCHAR(100) NULL DEFAULT NULL,
  `ui_contact_person` VARCHAR(100) NULL DEFAULT NULL,
  `ui_contact_person_title` VARCHAR(100) NULL DEFAULT NULL,
  `ui_description` TEXT NULL DEFAULT NULL,
  `ui_address_primary` VARCHAR(512) NULL DEFAULT NULL,
  `ui_longitude` VARCHAR(100) NULL DEFAULT NULL,
  `ui_latitude` VARCHAR(100) NULL DEFAULT NULL,
  `ui_address_secondary` VARCHAR(512) NULL DEFAULT NULL,
  `ui_city` VARCHAR(50) NULL DEFAULT NULL,
  `ui_town` VARCHAR(50) NULL DEFAULT NULL,
  `ui_state` VARCHAR(50) NULL DEFAULT NULL,
  `ui_zip` VARCHAR(50) NULL DEFAULT NULL,
  `ui_country_id` INT NULL DEFAULT NULL,
  `ui_dob` DATE NULL DEFAULT NULL,
  `ui_profile_image` VARCHAR(255) NULL DEFAULT 'profile.png',
  `ui_image` VARCHAR(255) NULL DEFAULT NULL,
  `ui_profile_image_path` VARCHAR(512) NULL DEFAULT 'assets/uploads/user/',
  `ui_social_twitter` VARCHAR(100) NULL DEFAULT NULL,
  `ui_social_facebook` VARCHAR(100) NULL DEFAULT NULL,
  `ui_social_google_plus` VARCHAR(100) NULL DEFAULT NULL,
  `ui_social_linkedin` VARCHAR(100) NULL DEFAULT NULL,
  `ui_social_skype` VARCHAR(100) NULL DEFAULT NULL,
  `ui_fee_range` VARCHAR(255) NULL DEFAULT NULL,
  `ui_languages` VARCHAR(512) NULL DEFAULT NULL,
  `ui_total_monthly_event` INT NOT NULL DEFAULT '0',
  `ui_consume_monthly_event` INT NOT NULL DEFAULT '0',
  `ui_balance_monthly_event` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`ui_id`),
  UNIQUE INDEX `ui_user_id` (`ui_user_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 862
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub`.`tn_user_login_history`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub`.`tn_user_login_history` (
  `ulh_id` INT NOT NULL AUTO_INCREMENT,
  `ulh_user_id` INT NULL DEFAULT NULL,
  `ulh_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ulh_id`),
  INDEX `ulh_user_id` (`ulh_user_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 12794
DEFAULT CHARACTER SET = latin1;

USE `creactivityhub_original` ;

-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_announcements`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_announcements` (
  `announcements_id` INT NOT NULL AUTO_INCREMENT,
  `announcements_course_id` INT NULL DEFAULT NULL,
  `announcements_title` VARCHAR(100) NULL DEFAULT NULL,
  `announcements_description` TEXT NULL DEFAULT NULL,
  `announcements_status` TINYINT NOT NULL DEFAULT '1',
  `announcements_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`announcements_id`),
  INDEX `announcements_status` USING BTREE (`announcements_status`) VISIBLE,
  INDEX `announcements_course_id` USING BTREE (`announcements_course_id`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 7
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_course`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_course` (
  `course_id` INT NOT NULL AUTO_INCREMENT,
  `course_category_id` INT NOT NULL DEFAULT '0',
  `course_user_id` INT NOT NULL DEFAULT '2',
  `course_name` VARCHAR(512) NOT NULL,
  `course_title` VARCHAR(512) NOT NULL,
  `course_slug` VARCHAR(512) NOT NULL,
  `course_hours` VARCHAR(100) NOT NULL,
  `course_type` VARCHAR(100) NOT NULL,
  `course_total_enrolled` VARCHAR(100) NOT NULL,
  `course_duration` VARCHAR(100) NOT NULL,
  `course_short_description` TEXT NOT NULL,
  `course_description` TEXT NULL DEFAULT NULL,
  `course_package_detail` TEXT NULL DEFAULT NULL,
  `course_faqs` TEXT NULL DEFAULT NULL,
  `course_information` TEXT NULL DEFAULT NULL,
  `course_regulatory_information` TEXT NULL DEFAULT NULL,
  `course_price` FLOAT NOT NULL DEFAULT '0',
  `course_image` VARCHAR(255) NULL DEFAULT NULL,
  `course_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `course_status` TINYINT NOT NULL DEFAULT '1',
  `course_is_featured` TINYINT NOT NULL DEFAULT '1',
  `course_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `course_is_adsense` TINYINT NOT NULL DEFAULT '0',
  `course_professor` VARCHAR(50) NOT NULL,
  `course_professor_image` VARCHAR(150) NOT NULL,
  PRIMARY KEY USING BTREE (`course_id`),
  INDEX `course_stauts` USING BTREE (`course_status`) VISIBLE,
  INDEX `course_category_id` (`course_category_id` ASC) VISIBLE,
  INDEX `course_user_id` (`course_user_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 37
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_assignment_group`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_assignment_group` (
  `assignment_group_id` INT NOT NULL AUTO_INCREMENT,
  `assignment_group_name` VARCHAR(255) NOT NULL,
  `assignment_group_percentage` INT NOT NULL,
  `assignment_group_course_id` INT NOT NULL,
  `assignment_group_status` TINYINT NOT NULL DEFAULT '1',
  `assignment_group_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`assignment_group_id`),
  INDEX `assignment_group_course_id` (`assignment_group_course_id` ASC) VISIBLE,
  CONSTRAINT `tn_assignment_group_ibfk_1`
    FOREIGN KEY (`assignment_group_course_id`)
    REFERENCES `creactivityhub_original`.`tn_course` (`course_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 59
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_assignment`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_assignment` (
  `assignment_id` INT NOT NULL AUTO_INCREMENT,
  `assignment_subject_id` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_course_id` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_title` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_number` FLOAT NOT NULL DEFAULT '0',
  `assignment` INT NOT NULL,
  `assignment_description` TEXT NULL DEFAULT NULL,
  `assignment_feedback` TEXT NULL DEFAULT NULL,
  `assignment_file` TEXT NULL DEFAULT NULL,
  `assignment_file_path` TEXT NULL DEFAULT NULL,
  `assignment_startdate` DATE NULL DEFAULT NULL,
  `assignment_enddate` DATE NULL DEFAULT NULL,
  `assignment_untildate` DATE NULL DEFAULT NULL,
  `assignment_status` TINYINT NOT NULL DEFAULT '1',
  `assignment_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`assignment_id`),
  INDEX `assignment_status` USING BTREE (`assignment_status`) VISIBLE,
  INDEX `assignment_subject_id` USING BTREE (`assignment_subject_id`) VISIBLE,
  INDEX `assignment_course_id` USING BTREE (`assignment_course_id`) VISIBLE,
  INDEX `assignment` (`assignment` ASC) VISIBLE,
  CONSTRAINT `tn_assignment_ibfk_1`
    FOREIGN KEY (`assignment`)
    REFERENCES `creactivityhub_original`.`tn_assignment_group` (`assignment_group_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 11
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_assignment_submit`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_assignment_submit` (
  `assignment_submit_id` INT NOT NULL AUTO_INCREMENT,
  `assignment_submit_assignment_id` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_submit_user_id` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_submit_title` VARCHAR(255) NULL DEFAULT NULL,
  `assignment_submit_feedback` TEXT NULL DEFAULT NULL,
  `assignment_submit_points` FLOAT NOT NULL DEFAULT '0',
  `assignment_submit_file` TEXT NULL DEFAULT NULL,
  `assignment_submit_file_path` TEXT NULL DEFAULT NULL,
  `assignment_submit_status` TINYINT NOT NULL DEFAULT '1',
  `assignment_submit_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`assignment_submit_id`),
  INDEX `assignment_submit_status` USING BTREE (`assignment_submit_status`) VISIBLE,
  INDEX `assignment_submit_assignment_id` USING BTREE (`assignment_submit_assignment_id`) VISIBLE,
  INDEX `assignment_submit_user_id` USING BTREE (`assignment_submit_user_id`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 36
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_banner`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_banner` (
  `banner_id` INT NOT NULL AUTO_INCREMENT,
  `banner_page_id` INT NOT NULL DEFAULT '0',
  `banner_layout1` TEXT NULL DEFAULT NULL,
  `banner_layout2` VARCHAR(255) NULL DEFAULT NULL,
  `banner_layout3` VARCHAR(512) NULL DEFAULT NULL,
  `banner_layout4` VARCHAR(512) NULL DEFAULT NULL,
  `banner_layout5` VARCHAR(512) NULL DEFAULT NULL,
  `banner_readmore_btn` VARCHAR(512) NULL DEFAULT NULL,
  `banner_video_link` VARCHAR(512) NULL DEFAULT NULL,
  `banner_image_path` TINYTEXT NOT NULL,
  `banner_image1` VARCHAR(255) NOT NULL,
  `banner_image1_thumb` VARCHAR(255) NOT NULL,
  `banner_image2` VARCHAR(255) NOT NULL,
  `banner_image2_thumb` VARCHAR(255) NOT NULL,
  `banner_image3` VARCHAR(255) NOT NULL,
  `banner_image3_thumb` VARCHAR(255) NOT NULL,
  `banner_position` TINYINT NOT NULL DEFAULT '0',
  `banner_status` TINYINT NOT NULL DEFAULT '1' COMMENT '1=Active 0=In-Active',
  `banner_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`banner_id`),
  INDEX `banner_status` (`banner_status` ASC) VISIBLE,
  INDEX `banner_position` (`banner_position` ASC) VISIBLE,
  INDEX `banner_page_id` (`banner_page_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 2
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_blog`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_blog` (
  `blog_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `blog_name` VARCHAR(100) NULL DEFAULT NULL,
  `blog_status` TINYINT NOT NULL DEFAULT '1',
  `blog_createdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`blog_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_blog_comment`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_blog_comment` (
  `bc_id` INT NOT NULL AUTO_INCREMENT,
  `bc_post_id` INT NOT NULL DEFAULT '0',
  `bc_name` VARCHAR(100) NULL DEFAULT NULL,
  `bc_email` VARCHAR(100) NULL DEFAULT NULL,
  `bc_comment` TEXT NULL DEFAULT NULL,
  `bc_status` TINYINT NOT NULL DEFAULT '0',
  `bc_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`bc_id`),
  INDEX `bc_post_id` (`bc_post_id` ASC) VISIBLE,
  INDEX `bc_status` (`bc_status` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_brand`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_brand` (
  `brand_id` INT NOT NULL AUTO_INCREMENT,
  `brand_name` VARCHAR(255) NULL DEFAULT NULL,
  `brand_image` VARCHAR(255) NULL DEFAULT NULL,
  `brand_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `brand_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `brand_status` TINYINT(1) NULL DEFAULT '1' COMMENT '1=Active; 0= Inactive',
  PRIMARY KEY USING BTREE (`brand_id`),
  INDEX `brand_status` (`brand_status` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_category`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_category` (
  `category_id` INT NOT NULL AUTO_INCREMENT,
  `category_parent_id` INT NOT NULL DEFAULT '1',
  `category_name` VARCHAR(100) NULL DEFAULT NULL,
  `category_slug` VARCHAR(100) NULL DEFAULT NULL,
  `category_image` VARCHAR(255) NULL DEFAULT NULL,
  `category_image_thumb` VARCHAR(255) NULL DEFAULT NULL,
  `category_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `category_status` TINYINT NOT NULL DEFAULT '1',
  `category_is_feaured` TINYINT NOT NULL DEFAULT '1',
  `category_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`category_id`),
  INDEX `category_parent_id` (`category_parent_id` ASC) VISIBLE,
  INDEX `category_status` (`category_status` ASC) VISIBLE,
  INDEX `category_is_feaured` (`category_is_feaured` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 65
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_ci_sessions`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_ci_sessions` (
  `id` VARCHAR(128) NOT NULL,
  `ip_address` VARCHAR(45) NOT NULL,
  `timestamp` INT UNSIGNED NOT NULL DEFAULT '0',
  `data` BLOB NOT NULL,
  PRIMARY KEY (`id`, `ip_address`),
  INDEX `ci_sessions_timestamp` (`timestamp` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_cms_page`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_cms_page` (
  `cms_page_id` INT NOT NULL AUTO_INCREMENT,
  `cms_page_status` TINYINT NOT NULL DEFAULT '1',
  `cms_page_page` INT NOT NULL DEFAULT '0',
  `cms_page_is_image` TINYINT NOT NULL DEFAULT '0',
  `cms_page_name` VARCHAR(255) NULL DEFAULT NULL,
  `cms_page_title` VARCHAR(255) NULL DEFAULT NULL,
  `cms_page_content` TEXT NULL DEFAULT NULL,
  `cms_page_image` VARCHAR(255) NULL DEFAULT NULL,
  `cms_page_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `cms_page_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `cms_page_meta_title` VARCHAR(100) NULL DEFAULT NULL,
  `cms_page_meta_keywords` VARCHAR(255) NULL DEFAULT NULL,
  `cms_page_meta_description` TEXT NULL DEFAULT NULL,
  PRIMARY KEY (`cms_page_id`),
  INDEX `cms_page_status` (`cms_page_status` ASC) VISIBLE,
  INDEX `cms_page_page` (`cms_page_page` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 50
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_color`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_color` (
  `color_id` INT NOT NULL AUTO_INCREMENT,
  `color_name` VARCHAR(255) NOT NULL,
  `color_image` VARCHAR(255) NOT NULL,
  `color_image_path` VARCHAR(512) NOT NULL,
  `color_status` INT NOT NULL,
  `color_created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`color_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_config`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_config` (
  `config_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `config_variable` VARCHAR(50) NULL DEFAULT NULL,
  `config_value` VARCHAR(100) NULL DEFAULT NULL,
  `config_position` INT NOT NULL DEFAULT '0',
  `config_type` ENUM('admin', 'system') NULL DEFAULT 'system' COMMENT '1-Admin; 2-System',
  `config_status` INT NOT NULL DEFAULT '1',
  PRIMARY KEY (`config_id`),
  INDEX `config_type` (`config_type` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 30
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_country`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_country` (
  `country` VARCHAR(255) CHARACTER SET 'latin1' NOT NULL DEFAULT '',
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `sb_countrycode` INT NOT NULL DEFAULT '0',
  `sb_faxprice` DOUBLE NOT NULL DEFAULT '0',
  `sb_country_alias` CHAR(2) CHARACTER SET 'latin1' NULL DEFAULT NULL,
  `sb_in_countrysearch` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `sb_synonyms` VARCHAR(255) CHARACTER SET 'latin1' NULL DEFAULT NULL,
  `country_ar` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `country_cn` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `country_es` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `country_jp` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `country_fr` VARCHAR(255) CHARACTER SET 'utf8mb3' NULL DEFAULT NULL,
  `sb_continent` VARCHAR(30) CHARACTER SET 'latin1' NULL DEFAULT NULL COMMENT 'Country\'s Continent name',
  `sb_iso_code` CHAR(2) CHARACTER SET 'latin1' NULL DEFAULT NULL COMMENT 'Country\'s ISO Code',
  `sb_country_name_native_lang` VARCHAR(255) NOT NULL DEFAULT '' COMMENT 'Country name in it\'s native language',
  PRIMARY KEY (`id`),
  UNIQUE INDEX `country` (`country` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 240
DEFAULT CHARACTER SET = utf8mb3
ROW_FORMAT = DYNAMIC;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_coupon`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_coupon` (
  `coupon_id` INT NOT NULL AUTO_INCREMENT,
  `coupon_course_id` INT NOT NULL DEFAULT '0',
  `coupon_type` TINYINT NOT NULL COMMENT '1=>%, 2=>price',
  `coupon_code` VARCHAR(50) NOT NULL,
  `coupon_comments` VARCHAR(255) NULL DEFAULT NULL,
  `coupon_rate` FLOAT NOT NULL DEFAULT '0',
  `coupon_status` TINYINT NOT NULL DEFAULT '1',
  `coupon_createdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `coupon_expire_date` DATE NULL DEFAULT NULL,
  `coupon_start_date` DATE NULL DEFAULT NULL,
  PRIMARY KEY (`coupon_id`),
  INDEX `coupon_type` (`coupon_type` ASC) VISIBLE,
  INDEX `coupon_status` (`coupon_status` ASC) VISIBLE,
  INDEX `coupon_course_id` (`coupon_course_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 2005
DEFAULT CHARACTER SET = latin1
COMMENT = 'Coupon';


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_course_quiz`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_course_quiz` (
  `cq_id` INT NOT NULL AUTO_INCREMENT,
  `cq_type` INT NOT NULL DEFAULT '0',
  `cq_quiz_id` INT NOT NULL DEFAULT '0',
  `cq_course_id` INT NOT NULL DEFAULT '0',
  `cq_subject_id` INT NOT NULL DEFAULT '0',
  `cq_question` MEDIUMTEXT NOT NULL,
  `cq_option_1` VARCHAR(255) NOT NULL,
  `cq_option_2` VARCHAR(255) NOT NULL,
  `cq_option_3` VARCHAR(255) NULL DEFAULT NULL,
  `cq_option_4` VARCHAR(255) NULL DEFAULT NULL,
  `cq_option_5` VARCHAR(255) NULL DEFAULT NULL,
  `cq_option_6` VARCHAR(255) NULL DEFAULT NULL,
  `cq_correct_answer` VARCHAR(50) NULL DEFAULT NULL,
  `cq_gain_point` FLOAT NOT NULL DEFAULT '0',
  `cq_status` TINYINT NOT NULL DEFAULT '1',
  `cq_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`cq_id`),
  INDEX `cq_status` USING BTREE (`cq_status`) VISIBLE,
  INDEX `cq_course_id` USING BTREE (`cq_course_id`) VISIBLE,
  INDEX `cq_subject_id` USING BTREE (`cq_subject_id`) VISIBLE,
  INDEX `cq_type` (`cq_type` ASC) VISIBLE,
  INDEX `cq_quiz_id` (`cq_quiz_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 101
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_course_subject`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_course_subject` (
  `course_subject_id` INT NOT NULL AUTO_INCREMENT,
  `course_subject_course_id` INT NOT NULL DEFAULT '0',
  `course_subject_position` INT NOT NULL,
  `course_subject_name` VARCHAR(512) NULL DEFAULT NULL,
  `course_subject_credit` FLOAT NULL DEFAULT '0',
  `course_subject_status` TINYINT NOT NULL DEFAULT '1',
  `course_subject_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`course_subject_id`),
  INDEX `subject_status` USING BTREE (`course_subject_status`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 130
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_faq`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_faq` (
  `faq_id` INT NOT NULL AUTO_INCREMENT,
  `faq_question` TEXT NULL DEFAULT NULL,
  `faq_answer` TEXT NULL DEFAULT NULL,
  `faq_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `faq_status` TINYINT(1) NULL DEFAULT '1' COMMENT '1=Active; 0= Inactive',
  PRIMARY KEY USING BTREE (`faq_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 5
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_grade`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_grade` (
  `grade_id` INT NOT NULL AUTO_INCREMENT,
  `grade_user_id` INT NULL DEFAULT NULL,
  `grade_course_id` INT NULL DEFAULT NULL,
  `grade_subject_id` INT NULL DEFAULT NULL,
  `grade_related_id` INT NULL DEFAULT NULL,
  `grade_type` VARCHAR(50) NULL DEFAULT NULL,
  `grade_assignment_id` INT NULL DEFAULT NULL,
  `grade_quiz_id` INT NULL DEFAULT NULL,
  `grade_marks` FLOAT NULL DEFAULT '0',
  `grade_total_marks` FLOAT NULL DEFAULT '0',
  `grade_percentage` DECIMAL(10,2) NOT NULL,
  `grade_status` TINYINT NULL DEFAULT '1',
  `grade_oncreated` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`grade_id`),
  INDEX `grade_user_id` USING BTREE (`grade_user_id`) VISIBLE,
  INDEX `grade_course_id` USING BTREE (`grade_course_id`) VISIBLE,
  INDEX `grade_subject_id` USING BTREE (`grade_subject_id`) VISIBLE,
  INDEX `grade_related_id` USING BTREE (`grade_related_id`) VISIBLE,
  INDEX `grade_status` USING BTREE (`grade_status`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 1955
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_grade_setting`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_grade_setting` (
  `grade_setting_id` INT NOT NULL AUTO_INCREMENT,
  `course_id` INT NOT NULL,
  `missing_percentage` INT NULL DEFAULT NULL,
  `missing_percentage_status` INT NOT NULL,
  `late_percentage_status` INT NOT NULL,
  `late_percentage` INT NULL DEFAULT NULL,
  `grade_setting_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`grade_setting_id`),
  INDEX `grade_course_foreign_id` (`course_id` ASC) VISIBLE,
  CONSTRAINT `tn_grade_setting_ibfk_1`
    FOREIGN KEY (`course_id`)
    REFERENCES `creactivityhub_original`.`tn_course` (`course_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 4
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_grading_settings`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_grading_settings` (
  `grading_setting_id` INT NOT NULL AUTO_INCREMENT,
  `course_id` INT NOT NULL,
  `grading_system` ENUM('pass_fail', 'letter_grade', 'gpa', 'custom') NOT NULL,
  `pass_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_a_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_b_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_c_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_d_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `grade_f_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `gpa_1_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `gpa_2_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `gpa_3_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `gpa_4_percentage` DECIMAL(5,2) NULL DEFAULT NULL,
  `custom_grades` LONGTEXT CHARACTER SET 'utf8mb4' COLLATE 'utf8mb4_bin' NULL DEFAULT NULL,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`grading_setting_id`),
  INDEX `course_id` (`course_id` ASC) VISIBLE,
  CONSTRAINT `tn_grading_settings_ibfk_1`
    FOREIGN KEY (`course_id`)
    REFERENCES `creactivityhub_original`.`tn_course` (`course_id`)
    ON DELETE CASCADE)
ENGINE = InnoDB
AUTO_INCREMENT = 4
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_inquiry`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_inquiry` (
  `inquiry_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `inquiry_user_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `inquiry_heading` VARCHAR(100) NULL DEFAULT NULL,
  `inquiry_type` VARCHAR(100) NULL DEFAULT NULL COMMENT 'Identifies from where inquiry comes from . eg. contactus',
  `inquiry_name` VARCHAR(100) NULL DEFAULT NULL,
  `inquiry_email` VARCHAR(100) NULL DEFAULT NULL,
  `inquiry_phone` VARCHAR(100) NULL DEFAULT NULL,
  `inquiry_message` TEXT NULL DEFAULT NULL,
  `inquiry_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `inquiry_status` TINYINT NOT NULL DEFAULT '1' COMMENT '1-Unread ; 2-Read',
  PRIMARY KEY (`inquiry_id`),
  INDEX `inquiry_status` (`inquiry_status` ASC) VISIBLE,
  INDEX `inquiry_user_id` (`inquiry_user_id` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 29
DEFAULT CHARACTER SET = utf8mb3
COMMENT = 'INquiry';


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_logo`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_logo` (
  `logo_id` INT NOT NULL AUTO_INCREMENT,
  `logo_name` VARCHAR(50) COLLATE 'utf8mb3_bin' NULL DEFAULT '0',
  `logo_image` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `logo_footer_image` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `logo_favicon` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `logo_image_path` VARCHAR(512) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `logo_status` TINYINT NOT NULL DEFAULT '1',
  `ondate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`logo_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 2;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_newsletter`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_newsletter` (
  `newsletter_id` INT NOT NULL AUTO_INCREMENT,
  `newsletter_email` VARCHAR(100) NOT NULL,
  `newsletter_name` VARCHAR(100) NOT NULL,
  `newsletter_status` TINYINT NOT NULL DEFAULT '1' COMMENT '0 = Inactive, 1 = Active',
  `newsletter_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`newsletter_id`),
  INDEX `newsletter_status` (`newsletter_status` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 2
DEFAULT CHARACTER SET = utf8mb3
COMMENT = 'Newsletter';


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_post`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_post` (
  `post_id` INT NOT NULL AUTO_INCREMENT,
  `post_user_id` INT NOT NULL,
  `post_page_type` INT NOT NULL DEFAULT '1' COMMENT '1: General (timeline and profile) , 2: Groups',
  `post_page_id` INT NULL DEFAULT NULL COMMENT 'Group ID etc',
  `post_type` INT NOT NULL COMMENT '1 = text , 2 = image , 3 = video , 4 = like , 5 = update profile image',
  `post_other_action_id` INT NULL DEFAULT NULL,
  `post_description` MEDIUMTEXT NULL DEFAULT NULL,
  `post_file` MEDIUMTEXT NULL DEFAULT NULL,
  `post_file_path` MEDIUMTEXT NULL DEFAULT NULL,
  `post_visibility` INT NOT NULL DEFAULT '1',
  `post_status` INT NOT NULL DEFAULT '1',
  `post_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_post_comment`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_post_comment` (
  `post_comment_id` INT NOT NULL AUTO_INCREMENT,
  `post_comment_post_id` INT NULL DEFAULT NULL,
  `post_comment_post_type` VARCHAR(255) NULL DEFAULT NULL,
  `post_comment_user_id` INT NULL DEFAULT NULL,
  `post_comment_user_comment` MEDIUMTEXT NULL DEFAULT NULL,
  `post_comment_status` INT NULL DEFAULT NULL,
  `post_comment_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_comment_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_post_like`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_post_like` (
  `post_like_id` INT NOT NULL AUTO_INCREMENT,
  `post_like_post_id` INT NULL DEFAULT NULL,
  `post_like_post_type` VARCHAR(255) NULL DEFAULT NULL,
  `post_like_user_id` INT NOT NULL,
  `post_like_status` INT NOT NULL,
  `post_like_createdon` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_like_id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_product`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_product` (
  `product_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_category_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_parent_category_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_type_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_user_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_brand_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `product_name` VARCHAR(100) NULL DEFAULT NULL,
  `product_slogan` VARCHAR(100) NULL DEFAULT NULL,
  `product_slug` VARCHAR(100) NULL DEFAULT NULL,
  `product_sku` VARCHAR(100) NULL DEFAULT NULL,
  `product_selling_price` FLOAT NULL DEFAULT '0',
  `product_deal_contdown` DATE NULL DEFAULT '2023-04-03',
  `product_price` FLOAT NULL DEFAULT '0',
  `product_price_wholesaler` FLOAT NULL DEFAULT '0',
  `product_price_retailers` FLOAT NULL DEFAULT '0',
  `product_short_desc` TEXT NULL DEFAULT NULL,
  `product_specification` TEXT NULL DEFAULT NULL,
  `product_desc` TEXT NULL DEFAULT NULL,
  `product_qty` FLOAT NULL DEFAULT '100',
  `product_packupsize` INT NULL DEFAULT NULL,
  `product_packup_desc` TEXT NULL DEFAULT NULL,
  `product_meta_title` VARCHAR(50) NULL DEFAULT NULL,
  `product_meta_description` VARCHAR(120) NULL DEFAULT NULL,
  `product_meta_keywords` VARCHAR(120) NULL DEFAULT NULL,
  `product_image` VARCHAR(255) NULL DEFAULT NULL,
  `product_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `product_is_featured` TINYINT(1) NULL DEFAULT '0',
  `product_is_availability` TINYINT(1) NULL DEFAULT '0',
  `product_is_hotdeal` TINYINT(1) NULL DEFAULT '0',
  `product_status` INT NOT NULL DEFAULT '1',
  `product_createdon` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`product_id`),
  INDEX `product_is_featured` (`product_is_featured` ASC) VISIBLE,
  INDEX `product_slug` (`product_slug` ASC) VISIBLE,
  INDEX `product_category_id` (`product_category_id` ASC) VISIBLE,
  INDEX `product_status` (`product_status` ASC) VISIBLE,
  INDEX `product_brand_id` (`product_brand_id` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_product_color`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_product_color` (
  `pc_color_id` INT NULL DEFAULT NULL,
  `pc_product_id` INT NULL DEFAULT NULL,
  INDEX `pc_color_id_pc_product_id` (`pc_color_id` ASC, `pc_product_id` ASC) VISIBLE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_product_image`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_product_image` (
  `pi_id` INT NOT NULL AUTO_INCREMENT,
  `pi_product_id` INT NOT NULL,
  `pi_image` VARCHAR(50) NOT NULL,
  `pi_image_thumb` VARCHAR(50) NOT NULL,
  `pi_image_path` TINYTEXT NOT NULL,
  `pi_createdon` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `pi_visibility` INT NOT NULL DEFAULT '1',
  `pi_is_featured` TINYINT(1) NULL DEFAULT '0',
  PRIMARY KEY (`pi_id`),
  INDEX `pi_createdon` (`pi_createdon` ASC) VISIBLE,
  INDEX `pi_product_id` (`pi_product_id` ASC) VISIBLE,
  INDEX `pi_tn_featured` (`pi_is_featured` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 657
DEFAULT CHARACTER SET = utf8mb3;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_product_rating`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_product_rating` (
  `pr_id` INT NOT NULL AUTO_INCREMENT,
  `pr_product_id` INT NULL DEFAULT '0',
  `pr_vendor_id` INT NULL DEFAULT '0',
  `pr_user_id` INT NULL DEFAULT '0',
  `pr_name` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `pr_email` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `pr_description` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `pr_rating` INT NULL DEFAULT NULL,
  `pr_status` TINYINT NOT NULL DEFAULT '1',
  `pr_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pr_id`),
  INDEX `pr_product_id` (`pr_product_id` ASC) VISIBLE,
  INDEX `pr_status` (`pr_status` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 4;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_quiz`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_quiz` (
  `quiz_id` INT NOT NULL AUTO_INCREMENT,
  `quiz_course_id` INT NOT NULL DEFAULT '0',
  `quiz_subject_id` INT NOT NULL DEFAULT '0',
  `quiz_name` MEDIUMTEXT NOT NULL,
  `quiz_startdate` DATE NULL DEFAULT NULL,
  `quiz_enddate` DATE NULL DEFAULT NULL,
  `quiz_untildate` DATE NULL DEFAULT NULL,
  `quiz_type` TINYINT NOT NULL,
  `assignment` INT NULL DEFAULT NULL,
  `quiz_shuffle_answers` TINYINT NOT NULL DEFAULT '0',
  `quiz_time_limit` TINYINT NOT NULL DEFAULT '0',
  `quiz_time_limit_minutes` FLOAT NULL DEFAULT NULL,
  `quiz_multiple_attempts` TINYINT NULL DEFAULT '0',
  `quiz_attempt_count` INT NULL DEFAULT '1',
  `quiz_require_access_code` TINYINT NOT NULL DEFAULT '0',
  `quiz_access_code` VARCHAR(255) NULL DEFAULT NULL,
  `quiz_filter_ip_address` TINYINT NOT NULL DEFAULT '0',
  `score` INT NULL DEFAULT NULL COMMENT '1: Highest , 2: Latest, 3: Average',
  `quiz_status` TINYINT NOT NULL DEFAULT '1',
  `quiz_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`quiz_id`),
  INDEX `quiz_status` USING BTREE (`quiz_status`) VISIBLE,
  INDEX `quiz_course_id` USING BTREE (`quiz_course_id`) VISIBLE,
  INDEX `quiz_subject_id` USING BTREE (`quiz_subject_id`) VISIBLE,
  INDEX `assignment` (`assignment` ASC) VISIBLE,
  CONSTRAINT `tn_quiz_ibfk_1`
    FOREIGN KEY (`assignment`)
    REFERENCES `creactivityhub_original`.`tn_assignment_group` (`assignment_group_id`))
ENGINE = InnoDB
AUTO_INCREMENT = 33
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_result`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_result` (
  `r_id` INT NOT NULL AUTO_INCREMENT,
  `r_user_id` INT NULL DEFAULT '0',
  `r_course_id` INT NULL DEFAULT '0',
  `r_quiz_id` INT NULL DEFAULT '0',
  `r_start_date` DATE NULL DEFAULT NULL,
  `r_end_date` DATE NULL DEFAULT NULL,
  `r_total_quiz` FLOAT NOT NULL DEFAULT '0',
  `r_correct` FLOAT NOT NULL DEFAULT '0',
  `r_wrong` FLOAT NOT NULL DEFAULT '0',
  `r_avg` FLOAT NOT NULL DEFAULT '0',
  `r_points` FLOAT NOT NULL DEFAULT '0',
  `r_time_spent` FLOAT NOT NULL DEFAULT '0',
  `r_is_pass` TINYINT NOT NULL DEFAULT '0' COMMENT '1=PASS , 0=FAIL',
  `r_status` TINYINT NOT NULL DEFAULT '1' COMMENT '1=Active,0=In-Active',
  `r_createdon` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`r_id`),
  INDEX `r_user_id` USING BTREE (`r_user_id`) VISIBLE,
  INDEX `r_status` USING BTREE (`r_status`) VISIBLE,
  INDEX `r_course_id` USING BTREE (`r_course_id`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 27
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_result_quiz`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_result_quiz` (
  `rq_id` INT NOT NULL AUTO_INCREMENT,
  `rq_result_id` INT NOT NULL DEFAULT '0',
  `rq_course_id` INT NOT NULL DEFAULT '0',
  `rq_subject_id` INT NOT NULL DEFAULT '0',
  `rq_question_id` INT NOT NULL DEFAULT '0',
  `rq_answer` TEXT NULL DEFAULT NULL,
  `rq_is_correct_asnwer` TINYINT NOT NULL DEFAULT '0' COMMENT '1=YES , 0=NO',
  `rq_feedback` TEXT NULL DEFAULT NULL,
  `rq_points` FLOAT NOT NULL DEFAULT '0',
  PRIMARY KEY USING BTREE (`rq_id`),
  INDEX `rq_result_id` USING BTREE (`rq_result_id`) VISIBLE,
  INDEX `rq_course_id_rq_subject_id_rq_question_id` USING BTREE (`rq_course_id`, `rq_subject_id`, `rq_question_id`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 213
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_shop_item`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_shop_item` (
  `item_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_order_id` INT UNSIGNED NOT NULL,
  `item_product_id` INT UNSIGNED NOT NULL,
  `item_product_name` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_product_img` VARCHAR(512) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_qty` INT UNSIGNED NOT NULL,
  `item_rate` FLOAT UNSIGNED NOT NULL,
  `item_price` FLOAT UNSIGNED NOT NULL,
  `item_type` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_serialize` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_stripe_data` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `item_stripe_id` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  PRIMARY KEY (`item_id`),
  INDEX `item_order_id` (`item_order_id` ASC) VISIBLE,
  INDEX `item_product_id` (`item_product_id` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 1511
COMMENT = 'Shopping Item in order';


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_shop_order`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_shop_order` (
  `order_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_user_id` INT UNSIGNED NOT NULL,
  `order_payment_type` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT 'Paypal',
  `order_is_sandbox` TINYINT NOT NULL DEFAULT '1' COMMENT '1=sandbox , 0=live',
  `order_agreed_terms_status` INT NOT NULL DEFAULT '0' COMMENT '1=approve , 0=notapprove',
  `order_payment_status` TINYINT UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 - Not approved,1-Approved ,2-Declined ,3-Error ,4-Held for Review,11-fruad cause',
  `order_delivery_status` TINYINT UNSIGNED NOT NULL DEFAULT '1' COMMENT '0 =  In process , 1 = new order ,  shipped , 3= on hold , 4= denied , 5= reject',
  `order_status` TINYINT UNSIGNED NOT NULL DEFAULT '1' COMMENT '1=Active , 0= Disable',
  `order_ondate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `order_shipping_amount` FLOAT NOT NULL DEFAULT '0',
  `order_shipping_type` INT NOT NULL DEFAULT '0' COMMENT '0=no delivery charges , 1=free,2=pick store,3=cash on delivery',
  `order_tax_percentage` FLOAT NOT NULL DEFAULT '0',
  `order_tax_amount` FLOAT NOT NULL DEFAULT '0',
  `order_redeem_points` FLOAT NOT NULL DEFAULT '0',
  `order_redeem_points_amount` FLOAT NOT NULL DEFAULT '0',
  `order_discount_amount` FLOAT NULL DEFAULT '0',
  `order_billing_fname` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_lname` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_phone` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_email` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_address` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_address2` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_city` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_state` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_billing_country` INT UNSIGNED NULL DEFAULT NULL,
  `order_billing_zip_code` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_fname` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_lname` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_phone` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_email` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_address` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_address2` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_city` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_state` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_country` INT NULL DEFAULT NULL,
  `order_shipping_zip_code` VARCHAR(100) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_shipping_order_description` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_notes` TEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_mc_gross` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_date` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_payment_status` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_pending_reason` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_ReasonCode` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_verify_sign` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_txn_id` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_payer_email` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_paypal_ipn_track_id` VARCHAR(255) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_payment_post` LONGTEXT COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  `order_coupon` VARCHAR(25) COLLATE 'utf8mb3_bin' NULL DEFAULT NULL,
  PRIMARY KEY (`order_id`),
  INDEX `user_id` (`order_user_id` ASC) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 1514
COMMENT = 'Shopping order data';


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_team_member`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_team_member` (
  `team_member_id` INT NOT NULL AUTO_INCREMENT,
  `team_member_name` VARCHAR(255) NULL DEFAULT NULL,
  `team_member_designation` VARCHAR(255) NULL DEFAULT NULL,
  `team_member_description` TEXT NULL DEFAULT NULL,
  `team_member_image` VARCHAR(255) NULL DEFAULT NULL,
  `team_member_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `team_member_status` TINYINT NOT NULL DEFAULT '1',
  `team_member_createdon` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY USING BTREE (`team_member_id`),
  INDEX `team_member_status` USING BTREE (`team_member_status`) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 4
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_testimonial`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_testimonial` (
  `testimonial_id` INT NOT NULL AUTO_INCREMENT,
  `testimonial_name` VARCHAR(100) NULL DEFAULT NULL,
  `testimonial_designation` VARCHAR(255) NOT NULL,
  `testimonial_description` TEXT NOT NULL,
  `testimonial_rating` VARCHAR(100) NULL DEFAULT NULL,
  `testimonial_video_url` VARCHAR(512) NULL DEFAULT NULL,
  `testimonial_image` VARCHAR(255) NULL DEFAULT NULL,
  `testimonial_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `testimonial_status` TINYINT NOT NULL DEFAULT '1',
  `testimonial_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`testimonial_id`),
  INDEX `testimonial_status` USING BTREE (`testimonial_status`) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 7
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_university`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_university` (
  `university_id` INT NOT NULL AUTO_INCREMENT,
  `university_name` VARCHAR(100) NULL DEFAULT NULL,
  `university_image` VARCHAR(255) NULL DEFAULT NULL,
  `university_image_path` VARCHAR(512) NULL DEFAULT NULL,
  `university_status` TINYINT NOT NULL DEFAULT '1',
  `university_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY USING BTREE (`university_id`),
  INDEX `university_status` USING BTREE (`university_status`) VISIBLE)
ENGINE = MyISAM
AUTO_INCREMENT = 7
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_user`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_user` (
  `user_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_type` TINYINT NULL DEFAULT '0' COMMENT '0=End User, 1=Advisor',
  `user_parent_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_package_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_stripe_customer_id` VARCHAR(100) NULL DEFAULT NULL,
  `user_package_price` FLOAT NOT NULL DEFAULT '0',
  `user_package_startdate` DATE NULL DEFAULT '2021-12-01',
  `user_package_enddate` DATE NULL DEFAULT '2021-12-01',
  `user_package_status` TINYINT NOT NULL DEFAULT '0',
  `user_reviews_total` FLOAT UNSIGNED NOT NULL DEFAULT '0',
  `user_reviews_avail` FLOAT UNSIGNED NOT NULL DEFAULT '0',
  `user_reviews_balance` FLOAT UNSIGNED NOT NULL DEFAULT '0',
  `user_createdon` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `user_status` TINYINT UNSIGNED NULL DEFAULT '1',
  `user_is_online` TINYINT UNSIGNED NULL DEFAULT '0',
  `user_points` FLOAT UNSIGNED NULL DEFAULT '0',
  `user_email` VARCHAR(100) NULL DEFAULT NULL,
  `user_username` VARCHAR(100) NULL DEFAULT NULL,
  `user_password` VARCHAR(64) NULL DEFAULT NULL,
  `user_firstname` VARCHAR(100) NULL DEFAULT NULL,
  `user_lastname` VARCHAR(100) NULL DEFAULT NULL,
  `user_is_admin` TINYINT NULL DEFAULT '0',
  `user_term_agreed` TINYINT NULL DEFAULT '0',
  `user_email_verified_status` TINYINT NULL DEFAULT '0',
  `user_social` TINYINT NULL DEFAULT '0',
  `user_last_login_time` DATETIME NULL DEFAULT NULL,
  `user_account_activate_token` VARCHAR(50) NULL DEFAULT NULL,
  `user_server_ip` VARCHAR(50) NULL DEFAULT NULL,
  `user_connected_payment` VARCHAR(50) NULL DEFAULT NULL,
  `user_connected_id` VARCHAR(255) NULL DEFAULT NULL,
  `user_connected_status` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE INDEX `user_email` (`user_email` ASC) VISIBLE,
  UNIQUE INDEX `user_username` (`user_username` ASC) VISIBLE,
  INDEX `email_verified_status` (`user_email_verified_status` ASC) VISIBLE,
  INDEX `user_type` (`user_type` ASC) VISIBLE,
  INDEX `user_idx_admin` (`user_is_admin` ASC) VISIBLE,
  INDEX `user_status` (`user_status` ASC) VISIBLE,
  INDEX `user_parent_id` (`user_parent_id` ASC) VISIBLE,
  INDEX `user_server_ip` (`user_server_ip` ASC) VISIBLE,
  INDEX `user_package_status` (`user_package_status` ASC) VISIBLE,
  INDEX `user_package_enddate` (`user_package_enddate` ASC) VISIBLE,
  INDEX `user_package_startdate` (`user_package_startdate` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 1080
DEFAULT CHARACTER SET = latin1
COMMENT = 'Registration USER DATA';


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_user_info`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_user_info` (
  `ui_id` INT NOT NULL AUTO_INCREMENT,
  `ui_user_id` INT NOT NULL,
  `ui_industry_id` INT NOT NULL,
  `ui_phone` VARCHAR(50) NULL DEFAULT NULL,
  `ui_mobile` VARCHAR(50) NULL DEFAULT NULL,
  `ui_website` VARCHAR(100) NULL DEFAULT NULL,
  `ui_contact_person` VARCHAR(100) NULL DEFAULT NULL,
  `ui_contact_person_title` VARCHAR(100) NULL DEFAULT NULL,
  `ui_description` TEXT NULL DEFAULT NULL,
  `ui_address_primary` VARCHAR(512) NULL DEFAULT NULL,
  `ui_longitude` VARCHAR(100) NULL DEFAULT NULL,
  `ui_latitude` VARCHAR(100) NULL DEFAULT NULL,
  `ui_address_secondary` VARCHAR(512) NULL DEFAULT NULL,
  `ui_city` VARCHAR(50) NULL DEFAULT NULL,
  `ui_town` VARCHAR(50) NULL DEFAULT NULL,
  `ui_state` VARCHAR(50) NULL DEFAULT NULL,
  `ui_zip` VARCHAR(50) NULL DEFAULT NULL,
  `ui_country_id` INT NULL DEFAULT NULL,
  `ui_dob` DATE NULL DEFAULT NULL,
  `ui_profile_image` VARCHAR(255) NULL DEFAULT 'profile.png',
  `ui_image` VARCHAR(255) NULL DEFAULT NULL,
  `ui_profile_image_path` VARCHAR(512) NULL DEFAULT 'assets/uploads/user/',
  `ui_social_twitter` VARCHAR(100) NULL DEFAULT NULL,
  `ui_social_facebook` VARCHAR(100) NULL DEFAULT NULL,
  `ui_social_google_plus` VARCHAR(100) NULL DEFAULT NULL,
  `ui_social_linkedin` VARCHAR(100) NULL DEFAULT NULL,
  `ui_social_skype` VARCHAR(100) NULL DEFAULT NULL,
  `ui_fee_range` VARCHAR(255) NULL DEFAULT NULL,
  `ui_languages` VARCHAR(512) NULL DEFAULT NULL,
  `ui_total_monthly_event` INT NOT NULL DEFAULT '0',
  `ui_consume_monthly_event` INT NOT NULL DEFAULT '0',
  `ui_balance_monthly_event` INT NOT NULL DEFAULT '0',
  PRIMARY KEY (`ui_id`),
  UNIQUE INDEX `ui_user_id` (`ui_user_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 862
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `creactivityhub_original`.`tn_user_login_history`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `creactivityhub_original`.`tn_user_login_history` (
  `ulh_id` INT NOT NULL AUTO_INCREMENT,
  `ulh_user_id` INT NULL DEFAULT NULL,
  `ulh_createdon` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ulh_id`),
  INDEX `ulh_user_id` (`ulh_user_id` ASC) VISIBLE)
ENGINE = InnoDB
AUTO_INCREMENT = 12792
DEFAULT CHARACTER SET = latin1;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
