Country flags in single CSS sprite
==================================

CSS Sprites - a method to optimize page loads by combining a large number of small images into one. 

## Usage

Include CSS file in your HTML code then insert a transparent 1x1 pixel image with classes `flag` and `flag-{country code}`. The country code is in the format ISO 3166-1 alpha-2:

```html
<html>
    <head>
        <link href="flags.css" rel=stylesheet type="text/css">
    </head>
    <body>
        <img src="blank.gif" class="flag flag-cz" alt="Czech Republic" />
    </body>
</html>
```

## Included flags


* Afghanistan (af)
* Aland Islands (ax)
* Albania (al)
* Algeria (dz)
* American Samoa (as)
* Andorra (ad)
* Angola (ao)
* Anguilla (ai)
* Antigua and Barbuda (ag)
* Argentina (ar)
* Armenia (am)
* Aruba (aw)
* Australia (au)
* Austria (at)
* Azerbaijan (az)
* Bahamas (bs)
* Bahrain (bh)
* Bangladesh (bd)
* Barbados (bb)
* Belarus (by)
* Belgium (be)
* Belize (bz)
* Benin (bj)
* Bermuda (bm)
* Bhutan (bt)
* Bolivia, Plurinational State of (bo)
* Bosnia and Herzegovina (ba)
* Botswana (bw)
* Brazil (br)
* Brunei Darussalam (bn)
* Bulgaria (bg)
* Burkina Faso (bf)
* Burundi (bi)
* Cambodia (kh)
* Cameroon (cm)
* Canada (ca)
* Canary Islands (ic)
* Cape Verde (cv)
* Cayman Islands (ky)
* Central African Republic (cf)
* Chad (td)
* Chile (cl)
* China (cn)
* Colombia (co)
* Comoros (km)
* Congo (cg)
* Congo, The Democratic Republic of the (cd)
* Cook Islands (ck)
* Costa Rica (cr)
* Cote d&#39;Ivoire (ci)
* Croatia (hr)
* Cuba (cu)
* Curacao (cw)
* Cyprus (cy)
* Czech Republic (cz)
* Denmark (dk)
* Djibouti (dj)
* Dominica (dm)
* Dominican Republic (do)
* Ecuador (ec)
* Egypt (eg)
* El Salvador (sv)
* Equatorial Guinea (gq)
* Eritrea (er)
* Estonia (ee)
* Ethiopia (et)
* European Union (eu)
* Falkland Islands (Malvinas) (fk)
* Faroe Islands (fo)
* Fiji (fj)
* Finland (fi)
* France (fr)
* French Polynesia (pf)
* French Southern Territories (tf)
* Gabon (ga)
* Gambia (gm)
* Georgia (ge)
* Germany (de)
* Ghana (gh)
* Gibraltar (gi)
* Greece (gr)
* Greenland (gl)
* Grenada (gd)
* Guam (gu)
* Guatemala (gt)
* Guernsey (gg)
* Guinea (gn)
* Guinea-Bissau (gw)
* Guyana (gy)
* Haiti (ht)
* Holy See (Vatican City State) (va)
* Honduras (hn)
* Hong Kong (hk)
* Hungary (hu)
* Iceland (is)
* India (in)
* Indonesia (id)
* Iran, Islamic Republic of (ir)
* Iraq (iq)
* Ireland (ie)
* Isle of Man (im)
* Israel (il)
* Italy (it)
* Jamaica (jm)
* Japan (jp)
* Jersey (je)
* Jordan (jo)
* Kazakhstan (kz)
* Kenya (ke)
* Kiribati (ki)
* Korea, Democratic People&#39;s Republic of (kp)
* Korea, Republic of (kr)
* Kuwait (kw)
* Kyrgyzstan (kg)
* Lao People&#39;s Democratic Republic (la)
* Latvia (lv)
* Lebanon (lb)
* Lesotho (ls)
* Liberia (lr)
* Libya (ly)
* Liechtenstein (li)
* Lithuania (lt)
* Luxembourg (lu)
* Macao (mo)
* Macedonia, The Former Yugoslav Republic of (mk)
* Madagascar (mg)
* Malawi (mw)
* Malaysia (my)
* Maldives (mv)
* Mali (ml)
* Malta (mt)
* Marshall Islands (mh)
* Martinique (mq)
* Mauritania (mr)
* Mauritius (mu)
* Mayotte (yt)
* Mexico (mx)
* Micronesia, Federated States of (fm)
* Moldova, Republic of (md)
* Monaco (mc)
* Mongolia (mn)
* Montenegro (me)
* Montserrat (ms)
* Morocco (ma)
* Mozambique (mz)
* Myanmar (mm)
* Namibia (na)
* Nauru (nr)
* Nepal (np)
* Netherlands (nl)
* Netherlands Antilles (an)
* New Caledonia (nc)
* New Zealand (nz)
* Nicaragua (ni)
* Niger (ne)
* Nigeria (ng)
* Niue (nu)
* Norfolk Island (nf)
* Northern Mariana Islands (mp)
* Norway (no)
* Oman (om)
* Pakistan (pk)
* Palau (pw)
* Palestinian Territory, Occupied (ps)
* Panama (pa)
* Papua New Guinea (pg)
* Paraguay (py)
* Peru (pe)
* Philippines (ph)
* Pitcairn (pn)
* Poland (pl)
* Portugal (pt)
* Puerto Rico (pr)
* Qatar (qa)
* Romania (ro)
* Russian Federation (ru)
* Rwanda (rw)
* Saint Barthelemy (bl)
* Saint Helena (sh)
* Saint Kitts and Nevis (kn)
* Saint Lucia (lc)
* Saint Martin (mf)
* Saint Vincent and the Grenadines (vc)
* Samoa (ws)
* San Marino (sm)
* Sao Tome and Principe (st)
* Saudi Arabia (sa)
* Senegal (sn)
* Serbia (rs)
* Seychelles (sc)
* Sierra Leone (sl)
* Singapore (sg)
* Slovakia (sk)
* Slovenia (si)
* Solomon Islands (sb)
* Somalia (so)
* South Africa (za)
* South Georgia and the South Sandwich Islands (gs)
* South Sudan (ss)
* Spain (es)
* Sri Lanka (lk)
* Sudan (sd)
* Suriname (sr)
* Swaziland (sz)
* Sweden (se)
* Switzerland (ch)
* Syrian Arab Republic (sy)
* Taiwan, Province of China (tw)
* Tajikistan (tj)
* Tanzania (tz)
* Thailand (th)
* Timor-Leste (tl)
* Togo (tg)
* Tokelau (tk)
* Tonga (to)
* Trinidad and Tobago (tt)
* Tunisia (tn)
* Turkey (tr)
* Turkmenistan (tm)
* Turks and Caicos Islands (tc)
* Tuvalu (tv)
* Uganda (ug)
* Ukraine (ua)
* United Arab Emirates (ae)
* United Kingdom (gb)
* United States (us)
* Uruguay (uy)
* Uzbekistan (uz)
* Vanuatu (vu)
* Venezuela, Bolivarian Republic of (ve)
* Viet Nam (vn)
* Virgin Islands, British (vg)
* Virgin Islands, U.S. (vi)
* Wallis and Futuna (wf)
* Western Sahara (eh)
* Yemen (ye)
* Zambia (zm)
* Zimbabwe (zw)

## Links

* [CSS Flag Sprites generator](https://www.flag-sprites.com/ "Country flags in single CSS sprite")
* [ISO 3166-1](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)