// Script in this form
//- Contact us Ajax Script
//- Newsletter Ajax Script
//- Signup Ajax Script
//- Signin Ajax Script
//- Advisor Signin Ajax Script
//- Forgot Password Ajax Script
//- Reset Password Ajax Script
//- Update User Information Ajax 
//- Update About Ajax Script
//- Change Password Ajax Script
//- Update address Ajax Script
//- Update Contact Info Ajax Script
//- Security Setting Script
//- Account Activate Script
//- Customer Review Script


var Form = function () {
    //var baseUrl = base_url;


    var urls = {
        // General Method
        newsletter : base_url + "newsletter",
        contact_us : base_url + "contact-us/ajax_send",
        
        // Account Script
        signup : base_url + "ajax-save-signup",
        signin : base_url + "signin",
        forgot_password : base_url + "account/forgot_password",
        reset_password : base_url + "account/reset_password/process",
        update_profile : base_url + "account/profile/update",
        update_about : base_url + "account/profile/ajax-update-about",
        update_contact_info : base_url + "account/profile/ajax-contact-info-save",
        update_address : base_url + "account/profile/ajax-update-address-save",
        change_password : base_url + "account/profile/ajax-change-password",
        //account_activate_process : base_url + "account/active_account/process",
        //review : base_url + "customer_review",
    };
	
	var value;

    return {
        
        //main function to initiate the module
        init: function () {
            // call instance variable
            //this.value = $("#order_id").val();
            
            // call default function
            //this.method();
        },

        faq_contact_us : function(form) {
            
            // Disable the submit button to prevent repeated clicks:
            $('#forms-faq_contact_us-btn').prop('disabled', true);

            var data = form.serialize();

            response = AjaxRequest.fire(urls.contact_us, data) ;
            
            $('#forms-faq_contact_us-btn').prop('disabled', false);
            if(response.status == 0){
                Toastr.error(response.msg.desc,'Error');
                return false;
            }
            else if(response.status == 1){

                Toastr.success(response.msg.desc,'');  
                $("#form-faq_contact_us").find('input[type=text],input[type=email],textarea,select').val('');
                //FOR GOOGLE CAPTCHA RESET:
                //grecaptcha.reset();

                return false;
            }
            else{
                Toastr.error('Error Found please try again','Error');
                return false;
            }
        },
        

        footer_contact_us : function(form) {
            
            // Disable the submit button to prevent repeated clicks:
            $('#forms-footer_contact_us-btn').prop('disabled', true);

            var data = form.serialize();

            response = AjaxRequest.fire(urls.contact_us, data) ;
            
            $('#forms-footer_contact_us-btn').prop('disabled', false);
            if(response.status == 0){
                Toastr.error(response.msg.desc,'Error');
                return false;
            }
            else if(response.status == 1){

                Toastr.success(response.msg.desc,'');  
                $("#form-footer_contact_us").find('input[type=text],input[type=email],textarea,select').val('');
                //FOR GOOGLE CAPTCHA RESET:
                //grecaptcha.reset();

                return false;
            }
            else{
                Toastr.error('Error Found please try again','Error');
                return false;
            }
        },

        contact_us : function(form) {
        	
            // Disable the submit button to prevent repeated clicks:
            $('#forms-contact_us-btn').prop('disabled', true);

            var data = form.serialize();

            response = AjaxRequest.fire(urls.contact_us, data) ;
            
            $('#forms-contact_us-btn').prop('disabled', false);
            if(response.status == 0){
                Toastr.error(response.msg.desc,'Error');
                return false;
            }
            else if(response.status == 1){

                Toastr.success(response.msg.desc,'');  
                $("#form-contact_us").find('input[type=text],input[type=email],textarea,select').val('');
                //FOR GOOGLE CAPTCHA RESET:
                //grecaptcha.reset();

                return false;
            }
            else{
                Toastr.error('Error Found please try again','Error');
                return false;
            }
        },

       
        newsletter : function(form)
        {
            // Disable the submit button to prevent repeated clicks:
            form.find('#forms-newsletter-btn').prop('disabled', true);

            var data = form.serialize();

            response = AjaxRequest.fire(urls.newsletter, data) ;

            // BTN Disabled
            form.find('#forms-newsletter-btn').prop('disabled', false);

            if(response.status == 0){
                Toastr.error(response.txt,'Error');
                return false;
            }
            else if(response.status == 1){
                form.find('input[type=email]').val('');
                Toastr.success(response.txt,'');
                return false;
            }
            else{
                Toastr.error('Error Found please try again','Error');
                return false;
            }
        },

        signup : function(form)
        {
            form.find('#signup-btn').prop('disabled', true);

            var data = form.serialize();
            var s = AjaxRequest.fire(urls.signup,data); 
            
            if(s.status) {
                form.find('#signup-btn').prop('disabled', false);

                form[0].reset();

                Toastr.success(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );

                if(s.redirect.status) {
                    setTimeout(function(){
                        window.location.href = s.redirect.link;
                    },4000);
                }
                
            }
            else
            {
                //$("#signup-form_loading").show();
                form.find('#signup-btn').prop('disabled', false);

                Toastr.error(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );
            }
            return false;
        },

        

        forgot_password:function(form)
        {
            // Disable the submit button to prevent repeated clicks:
            form.find('#forgot_password-btn').prop('disabled', true);
            var data = form.serialize();
            var s = AjaxRequest.fire(urls.forgot_password,data); 
            //console.log(data);

            if(s.status) {
                
                form.find('#forgot_password-btn').prop('disabled', false);
                form[0].reset();
                Toastr.success(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );
                //$('#myModal-forgot_password .close').trigger('click');
                
            }
            else
            {
                form.find('#forgot_password-btn').prop('disabled', false);
                Toastr.error(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );
                //Toastr.error(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );
            }
            //return false;
        },

        reset_password:function(form)
        {
             // Disable the submit button to prevent repeated clicks:
            form.find('#reset_password-btn').prop('disabled', true);
            var data = form.serialize();
            var s = AjaxRequest.fire(urls.reset_password,data); 

            if(s.status) {
                
                form.find('#reset_password-btn').prop('disabled', false);
                form[0].reset();
                Toastr.success(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );

                // Location Redirection {START}
                window.location.href = base_url+"account/dashboard?msgtype=success&msg="+s.msg.desc;
            }
            else
            {
                form.find('#reset_password-btn').prop('disabled', false);
                Toastr.error(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );
            }
        },


        signin: function(form)
        {
            // Disable the submit button to prevent repeated clicks:
            form.find('#signin-btn').prop('disabled', true);

            var data = form.serialize();
            var s = AjaxRequest.fire(urls.signin,data); 
            
            if(s.status) {
                
                form.find('#signin-btn').prop('disabled', false);
                form[0].reset();

                Toastr.success(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );
                
                
                if(s.redirect.status)
                    window.location.href = s.redirect.link+"?msgtype=success&msg="+s.msg.desc;
                else
                    window.location.href = "<?=l('account/dashboard')?>?msgtype=success&msg="+s.msg.desc;
                
            }
            else
            {
                form.find('#signin-btn').prop('disabled', false);
                Toastr.error(s.msg.desc, s.msg.title , {positionClass:"toast-bottom-right"} );
            }

            return false;
        },


        

        update_profile: function(form){
            
            var data = new FormData(document.getElementById('forms-update_profile'));
            
            // Submit action
            var response =FileUploadScript.fire(urls.update_profile, data, 'json') ;
            
            if( response.status ) {
                Toastr.success(response.msg.desc ,response.msg.title, 'toast-bottom-left');

                //location.reload();
                window.location.href = response.msg.url+'?msg='+response.msg.desc+'&msgtype=success';
                return false;
            }
            else {
               Toastr.error(response.msg.desc ,response.msg.title, 'toast-bottom-left');
               return false;
            }
        },


        update_about: function(form){
            
            var data = new FormData(document.getElementById('update-about-form'));
            
            // Submit action
            var response =FileUploadScript.fire(urls.update_about, data, 'json') ;
                     
            if( response.status ) {
                Toastr.success(response.msg.desc ,response.msg.title, 'toast-bottom-left');

                // Reload After 3sec
                setTimeout(function(){ location.reload(); }, 3000);
                
                return false;
            }
            else {
               Toastr.error(response.msg.desc ,response.msg.title, 'toast-bottom-left');
               return false;
            }
        },

        update_address: function(form){
            
            // Disable the submit button to prevent repeated clicks:
            form.find('#update-address_info-btn').prop('disabled', true);
            var data = form.serialize();
            var response = AjaxRequest.fire(urls.update_address,data); 

            if( response.status ) {
                Toastr.success(response.msg.desc ,response.msg.title, 'toast-bottom-left');

                return false;
            }
            else {
               Toastr.error(response.msg.desc ,response.msg.title, 'toast-bottom-left');
               return false;
            }
        },


        update_contact_info: function(form){
            
            // Disable the submit button to prevent repeated clicks:
            form.find('#update-contact_info-btn').prop('disabled', true);
            var data = form.serialize();
            var response = AjaxRequest.fire(urls.update_contact_info,data); 
            
            if( response.status ) {
                form.find('#update-contact_info-btn').prop('disabled', false);
                Toastr.success(response.msg.desc ,response.msg.title, 'toast-bottom-left');
                return false;
            }
            else {
                form.find('#update-contact_info-btn').prop('disabled', false);
                Toastr.error(response.msg.desc ,response.msg.title, 'toast-bottom-left');
                return false;
            }
        },


        change_password : function(form){
            
            // Disable the submit button to prevent repeated clicks:
            form.find('#update-change_password-btn').prop('disabled', true);

            var data = form.serialize();
            var response = AjaxRequest.fire(urls.change_password,data); 

            if( response.status ) {
                form.find('#update-change_password-btn').prop('disabled', false);
                
                Toastr.success(response.msg.desc ,response.msg.title, 'toast-bottom-left');
                
                $("#update-change_password-form .form-control").val('');

                return false;
            }
            else {
                form.find('#update-change_password-btn').prop('disabled', false);
               Toastr.error(response.msg.desc ,response.msg.title, 'toast-bottom-left');
               return false;
            }
        },

        

    }; // End of class return

}(); // End of Script



$(document).ready(function () {
    Form.init();
});



/*###########
Contact us Ajax Script Start
###########*/
$(function() {
    var $form = $('#form-contact_us');
    $form.submit(function(event) {
      Form.contact_us($form);
      return false;
    });
  });

/*###########
Contact us Ajax Script END
###########*/




/*###########
Newsletter Ajax Script Start
###########*/
$(function() {
    var $form = $('#forms-newsletter');
    $form.submit(function(event) {
      Form.newsletter($form);
      return false;
    });
  });

/*###########
Newsletter Ajax Script END
###########*/




/*###########
Signup Ajax Script Start
###########*/
$(function() {
    var $form = $('#forms-signup');
    $form.submit(function(event) {
        event.preventDefault();
        Form.signup($form);
        return false;
    });
  });

if($("#user_password").length > 0)
{
    var password = document.getElementById("user_password")
    , confirm_password = document.getElementById("user_confirm_password");

    function validatePassword(){

        if(password.value != confirm_password.value) {
            confirm_password.setCustomValidity("Passwords Don't Match");
        }
        else {
            confirm_password.setCustomValidity('');
        }
    }

    password.onchange = validatePassword;
    confirm_password.onkeyup = validatePassword;
}

/*###########
Signup Ajax Script END
###########*/



/*###########
Signin Ajax Script START
###########*/
$(function() {
    var $form = $('#forms-signin');
    $form.submit(function(event) {
      Form.signin($form);
      return false;
    });
});


$(function() {
    var $form = $('#forms-signin-advisor');
    $form.submit(function(event) {
        Form.signin_advisor($form);
        return false;
    });
});

/*###########
Signin Ajax Script END
###########*/


/*###########
Forgot Password Ajax Script START
###########*/
$(function() {
    var $form = $('#forms-forgot_password');
    $form.submit(function(event) {
      Form.forgot_password($form);
      return false;
    });
});

$("body").on('click','#forgot_password-callmodal',function(){
    $("#loginsec2").modal('toggle');

     setTimeout(function(){
        $("#myModal-forgot_password").modal();
    },500);
});
//$("#forgot_password").click(function(){
// $(".forgot_password").click(function(){
//     $("#myModal .close").trigger('click');
    

//     setTimeout(function(){
//         $("#myModal-forgot_password").modal();
//     },500);
// });

/*###########
Forgot Password Ajax Script END
###########*/


/*###########
Reset Password Ajax Script START
###########*/
jQuery(document).ready(function () {
    jQuery("#reset_password-btn").click(function(event){
        event.preventDefault();
        var $form = $('#forms-reset_password');
        Form.reset_password($form);
    });

});

/*###########
Reset Password Ajax Script END
###########*/



/*###########
Update User Information Ajax Script START
###########*/
$(function() {
    var $form = $('#forms-update_profile');
    $form.submit(function(event) {
      Form.update_profile($form);
      return false;
    });
});

/*###########
Update User Information Ajax Script END
###########*/


/*###########
Update About Ajax Script START
###########*/
$(function() {
    var $form = $('#update-about-form');
    $form.submit(function(event) {
      Form.update_about($form);
      return false;
    });
});

/*###########
Update About Ajax Script END
###########*/


/*###########
Change Password Ajax Script START
###########*/
$(function() {
    var $form = $('#update-change_password-form');
    $form.submit(function(event) {
      Form.change_password($form);
      return false;
    });
});

/*###########
Change Password Ajax Script END
###########*/


/*###########
Update address Ajax Script START
###########*/
$(function() {
    var $form = $('#update-address_info-form');
    $form.submit(function(event) {
      Form.update_address($form);
      return false;
    });
});

/*###########
Update address Ajax Script END
###########*/


/*###########
Update Contact Info Ajax Script START
###########*/
$(function() {
    var $form = $('#update-contact_info-form');
    $form.submit(function(event) {
      Form.update_contact_info($form);
      return false;
    });
});

/*###########
Update Contact Info Ajax Script END
###########*/


// function playVid() { 
//     var vid = document.getElementById("video_preview"); 
//     vid.play(); 
// }

// function pauseVid() { 
//     var vid = document.getElementById("video_preview"); 
//     vid.pause(); 
// }

// $("body").on('click','.view_this_speaker_video',function(){
//     var src = $(this).attr("data-url");
//     var title = $(this).attr("data-title");

//     //var html = '<video width="100%" controls>';
//     var html = '<video id="video_preview" width="100%" controls>';
//     html += '<source src="'+src+'" type="video/mp4">';
//     //html += '<source src="mov_bbb.ogg" type="video/ogg">';
//     html += 'Your browser does not support HTML5 video.';
//     html += '</video>';
    
//     Modal.load(title,html);
//     playVid();
// });


/**
    Image Change Function for about us START
*/
function readURL(input){
    var filename = input.files[0]['name'];
    
    if(input.files&&input.files[0]){
        var reader=new FileReader();
        reader.onload=function(e){
            $('#profile-img-tag').attr('src',e.target.result);
        }
        reader.readAsDataURL(input.files[0]);
    }
}

$("#profile-img").change(function(){
    readURL(this);
});

//***Image Change Function for about us END*/






/*###########
WEBSITE APP SCRIPT START
###########*/

$(function() {
    var $form = $('#form-footer_contact_us');
    $form.submit(function(event) {
      Form.footer_contact_us($form);
      return false;
    });
  });


$(function() {
    var $form = $('#form-faq_contact_us');
    $form.submit(function(event) {
      Form.faq_contact_us($form);
      return false;
    });
  });

// Shop/Detail page
$("body").on('change','#product_pack',function(){
    var element = $(this).find('option:selected'); 
    var ps_id = element.attr("data-ps_id");
    var size_id = element.attr("data-size_id");
    var qty = element.attr("data-qty");
    var name = element.attr("data-name");
    var price = $(this).val();

    $("#ps_id").val(ps_id);
    $("#pc_size_id").val(size_id);
    $("#size_name").val(name);
    $("#pc_price").val(price);
    $("#product_price").val(price);
    $("#leftqty").val(qty);
    $("#product_qty").attr('max',qty);
});


// Cart stepone Page
$("body").on('click','#minus-btn',function(){
    var obj = $(this).closest('td');
    var qty_input = obj.find('input');
    var value = qty_input.val();
    value--;
    if(value == 0)
      value = 1;
  
    qty_input.val(value);
});

$("body").on('click','#plus-btn',function(){
    var obj = $(this).closest('td');
    var qty_input = obj.find('input');
    var value = qty_input.val();
    if(qty_input.attr('max') > value)
        value++;
    obj.find('input').val(value);
});


// Product Detail page for Pack Size Choosing Start
function pack_size_function(total_pack)
{
    if($(".pack_size_checkbox:checked").length >= total_pack){
        $(".pack_size_checkbox:checkbox:not(:checked)").closest('div.pack_size').addClass('disabled');
        $(".pack_size_checkbox:checkbox:not(:checked)").attr('disabled','disabled');
    }
    else{
        $(".pack_size_checkbox:checkbox:not(:checked)").closest('div.pack_size').removeClass('disabled').find('.pack_size_checkbox').removeAttr('disabled');
        $(".pack_size_checkbox:checkbox:not(:checked)").removeAttr('disabled');    
    }

}

$("body").on('click','.pack_size_checkbox',function(){
  var pack_size = $("#pack_size").val();
  pack_size_function(pack_size);
});
// Product Detail page for Pack Size Choosing End


$("body").on('click','.view_order_more',function(){
  var id = $(this).attr('data-id');
  var html = $("#"+id).html();
  Modal.load("Order Detail",html);
  
});



$(function() {
    var $form = $('#inquiry-threading-form');
    $form.submit(function(event) {
      $.ajax({ 
        url: $form.attr('action'),
        type: 'POST',
        data: $form.serialize(),
        dataType: "json",

        success: function (response)
        {
            $("inquiry-threading-form-btn").text("Reply");
            if(response.status)
            {
                //Toastr.success("response.txt");
                setTimeout(function(){
                   location.reload(); 
                },1000);
            }
            else {
                Toastr.error(response.msg);
            }
        },
        beforeSend: function(response)
        {
            $("inquiry-threading-form-btn").text('Loading....');
        }
       
      });    
      
      return false;

    });
  });



$("body").on('click','#redeem_points',function(){
    var url = base_url+"cart/redeem-points"
    response = AjaxRequest.fire(url, {});   
    
    if( response.status ) {
        Toastr.success(response.desc);
        setInterval(function(){ location.reload(); }, 2000);
        
    }
    else {
        Toastr.error(response.desc);
    }
});



$("body").on('click','#show_number',function(){
    var phone = $(this).attr("data-p");
    $(".show_number").text(phone);
    $(this).hide();
});



$("body").on('change','#customer_zip_code',function(){
    var name = $(this).val();
    var data = {name:name}
    var url = base_url+"location/ajax_get_lat_lng";
    response = AjaxRequest.fire(url, data) ;  
    $("#preloader").hide();
    if(response.status) {
        $("#user_longitude").val(response.long);
        $("#user_latitude").val(response.lat);
        
        $("#paddress").val(response.data.address);
        $("#city").val(response.data.city);
        $("#state").val(response.data.state);
        $("#ui_country_id:eq(0)").val(response.data.country);

        view_google_map(response.lat,response.long);
    }
    else{
        Toastr.error("Error found please try again");
    }
});


function view_google_map(lat,lng) {
    //var latlon = lat+","+long;
    // The location of Uluru
    var uluru = {lat: lat, lng: lng};
    // The map, centered at Uluru
    var map = new google.maps.Map(
    document.getElementById('map_2'), {zoom: 15, center: uluru});
    // The marker, positioned at Uluru
    var marker = new google.maps.Marker({position: uluru, map: map});

}



$("body").on('click','.like_post' , function(){
    var id = $(this).attr('data-post_id');
    var data = {id:id}
    var url = base_url+"chatroom/ajax_post_like";
    response = AjaxRequest.fire(url, data) ; 
    if(response.status) {
        $(this).addClass("like_post_fill");
        Toastr.success(response.txt);
    }
    else{
        //$(this).removeClass("like_post_fill");
        Toastr.error(response.txt);
    }
});

$("body").on('click','.post_comment' , function(){
    var data = $(this).closest('form').serialize();
    var url = base_url+"chatroom/ajax_save_comment";
    response = AjaxRequest.fire(url, data) ; 
    if(response.status) {
        $("#add-comm-"+response.post_id).html(response.new_comment);
        Toastr.success(response.txt);
    }
    else{
        Toastr.error(response.txt);
    }
});

$(function() {
    var $form = $('#form-post-status');
    $form.submit(function(event) {
      event.preventDefault();
      $.ajax({ 
        url: $form.attr('action'),
        type: 'POST',
        data: $form.serialize(),
        dataType: "json",

        success: function (response)
        {
            $("form-post-status-btn").text("Public");
            if(response.status)
            {
                Toastr.success(response.txt);
                setTimeout(function(){
                   location.reload(); 
                },1000);
            }
            else {
                Toastr.error(response.txt);
            }
        },
        beforeSend: function(response)
        {
            $("form-post-status-btn").text('Loading....');
        }
       
      });   


      return false;
    });
});





$(function() {
    var $form = $('#form-img-post-status');
    $form.submit(function(event) {
        event.preventDefault();

        var data = new FormData(document.getElementById('form-img-post-status'));

        // Submit action
        var response =FileUploadScript.fire($form.attr('action'), data, 'json') ;

        if(response.status)
        {
            Toastr.success(response.txt);
            setTimeout(function(){
                location.reload(); 
            },1000);
        }
        else {
            Toastr.error(response.txt);
        }

      return false;
    });
});


$(function() {
    var $form = $('#form-audio-post-status');
    $form.submit(function(event) {
        event.preventDefault();

        var data = new FormData(document.getElementById('form-audio-post-status'));

        // Submit action
        var response =FileUploadScript.fire($form.attr('action'), data, 'json') ;

        if(response.status)
        {
            Toastr.success(response.txt);
            setTimeout(function(){
                location.reload(); 
            },1000);
        }
        else {
            Toastr.error(response.txt);
        }

      return false;
    });
});



$(function() {
    var $form = $('#form-video-post-status');
    $form.submit(function(event) {
        event.preventDefault();

        var data = new FormData(document.getElementById('form-video-post-status'));

        // Submit action
        var response =FileUploadScript.fire($form.attr('action'), data, 'json') ;

        if(response.status)
        {
            Toastr.success(response.txt);
            setTimeout(function(){
                location.reload(); 
            },1000);
        }
        else {
            Toastr.error(response.txt);
        }

      return false;
    });
});
/*###########
WEBSITE APP SCRIPT END
###########*/



$("body").on("focusout",'#form-control-yt',function(){

  var url = $(this).val();
  var urlNoProtocol = url.replace(/^https?\:\/\//i, "");
  $(this).val(urlNoProtocol);
});






function playVid() { 
    var vid = document.getElementById("video_preview"); 
    vid.play(); 
}

function pauseVid() { 
    var vid = document.getElementById("video_preview"); 
    vid.pause(); 
}


$("body").on('click','.view_this_video',function(){
    var src = $(this).attr("data-video_src");
    var title = $(this).attr("title");

    //var html = '<video width="100%" controls>';
    var html = '<video id="video_preview" width="100%" controls>';
    html += '<source src="'+src+'" type="video/mp4">';
    //html += '<source src="mov_bbb.ogg" type="video/ogg">';
    html += 'Your browser does not support HTML5 video.';
    html += '</video>';
    
    Modal.load(title,html);
    playVid();
});




$('#myModal-custom').on('hidden.bs.modal', function () {
  if($('#video_preview').length > 0)
    pauseVid();  
});


$("body").on('click','.action-upload_media',function(){
    var data = {media_type:$(this).attr('data-media_type')};
    var url = base_url+"expose/ajax_get_upload_media";
    response = AjaxRequest.fire(url, data) ; 
    if(response.status) {
        $("#Perform-myModal").find('div.modal-body').html(response.html);
    }
    else{
        Toastr.error("Error found please try again");
    }
});


$("body").on('click','#action-upload_media_challenge',function(){
    var media_type = $(this).attr('data-media_type');
    var parent_id = $(this).attr('data-parent_id');
    var data = {media_type:media_type,parent_id:parent_id};
    var url = base_url+"expose/ajax_get_upload_media";
    response = AjaxRequest.fire(url, data) ; 
    if(response.status) {
        $("#Perform-myModal").modal();
        $("#Perform-myModal").find('h4.modal-title').html("Challenge Now");
        $("#Perform-myModal").find('div.modal-body').html(response.html);
    }
    else{
        Toastr.error("Error found please try again");
    }
});


if($("#views_count").length > 0) {
    var total = convert(Math.floor(Math.random() * 10000) + 1);    
    $("#views_count").text(total);
}

function convert(value)
{
    if(value>=1000000)
    {
        value=(value/1000000).toFixed(1)+"M"
    }
    else if(value>=1000)
    {
        value=(value/1000).toFixed(1)+"K";
    }
    return value;
}




$("body").on('change','#ordering_paging',function(){
    var val = $(this).val();
    setGetParameter('paging',val);
});
$("body").on('change','#ordering_sorting',function(){
    var val = $(this).val();
    setGetParameter('sorting',val);
});


$("body").on('click','.category_id',function(){
    var val = $(this).data('id');
    setGetParameter('category_id',val);
});

$("body").on('click','.brand_id',function(){
    var val = $(this).data('id');
    setGetParameter('brand_id',val);
});


function setGetParameter(paramName, paramValue)
{
    var url = window.location.href;
    var hash = location.hash;
    url = url.replace(hash, '');
    if (url.indexOf(paramName + "=") >= 0)
    {
        var prefix = url.substring(0, url.indexOf(paramName));
        var suffix = url.substring(url.indexOf(paramName));
        suffix = suffix.substring(suffix.indexOf("=") + 1);
        suffix = (suffix.indexOf("&") >= 0) ? suffix.substring(suffix.indexOf("&")) : "";
        url = prefix + paramName + "=" + paramValue + suffix;
    }
    else
    {
    if (url.indexOf("?") < 0)
        url += "?" + paramName + "=" + paramValue;
    else
        url += "&" + paramName + "=" + paramValue;
    }
    window.location.href = url + hash;
}


// Contact Form Submit Start
$('.btn-send').on('click', function () {
    var obj = $(".pro_rating-form");
    // Get form data
    var data = obj.serialize();
    // Get post url
    var url = obj.attr('action');
    // Submit action
    var response = AjaxRequest.fire(url, data);

    if(response.status == 1) {
      $(".pro_rating-form")[0].reset();
      Toastr.success(response.txt,'');
    }
    else {
        Toastr.error(response.txt,'');
    }
    // Add return
    return false;
});
// Login Form Submit End






$("body").on("click",'#quiz_btn',function(){
    var url = $("#quiz_form").attr("action");
    var data = $("#quiz_form").serialize();

    $.ajax({ 
        url: url,
        type: 'POST',
        data: data,
        dataType: "json",

        success: function (response)
        {
            $("#quiz_loading").hide();
            $("#quiz_btn").show();
            //console.log(response);return false;
            if(response.status)
            {
                window.location.href = response.url;
                // Redirect URL
                // setTimeout(function(){
                //     window.location.href = base_url+'account/client_dashbaord';
                // }, 1000);
            }
            else
            {
                Toastr.error(response.txt,'');
            }
        },
        beforeSend: function(response)
        {
            $("#quiz_btn").hide();
            $("#quiz_loading").show();
        }
       
      
    });
});




$("body").on('click','.form-subject_data-btn',function(){
    var $form = $(this).closest("form");
    var data = $form.serialize();
    var url = $form.attr('action');
    var response = AjaxRequest.fire(url, data);
    if(response.status) {
        Toastr.success(response.msg);
        setTimeout(function(){
            location.reload(); 
        },1000);
    }
    else {
        Toastr.error(response.msg);
    }
    return false;
});


$("body").on('click','.add_subject',function(){
    var related_modal = $(this).data('related_modal');

    var obj = $("#"+related_modal);
    obj.find('form input.course_subject_id').remove();
    obj.find('form input.course_subject_name').val("");
    obj.modal("show");
    return false;
});


$("body").on('click','.edit_course_subject',function(){
    var course_subject_id = $(this).data('course_subject_id');
    var course_subject_name = $(this).data('course_subject_name');
    var course_subject_position = $(this).data('course_subject_position');
    var modal_id = $(this).data('modal_id');

    var obj = $("#"+modal_id);
    obj.find('form input.course_subject_name').val(course_subject_name);
    obj.find('form input.course_subject_position').val(course_subject_position);
    obj.find('form input.course_subject_id').val(course_subject_id);

    //obj.find('form').append("<input type='hidden' name='course_subject[course_subject_course_id]' value='"+course_subject_course_id+"'>");


    obj.modal("show");

    return false;
});


/*
$(function() {
    var $form = $('#form-subject_data');
    $form.submit(function(event) {
        event.preventDefault();
        var data = $form.serialize();
        var url = $form.attr('action');
        var response = AjaxRequest.fire(url, data);
        if(response.status)
        {
            Toastr.success(response.msg);
            setTimeout(function(){
                location.reload(); 
            },1000);
        }
        else {
            Toastr.error(response.msg);
        }
        return false;
    });
});
*/


function readURL2(input,this_obj) {
  var file = input.files[0].name;
  var data = file.split(".");
  var last_index = data.length-1;
  var ext = data[last_index].toLowerCase();
  var allow_exts = "jpg|jpeg|png|pdf|doc|docx|xls|xlsx|zip";
  var allow_ext = allow_exts.split('|')
  
  if ($.inArray(ext, allow_ext) == -1) {
    // Set error message
    Toastr.error('Just allow jpg and png files');
    this_obj.val('');
    /*
    if(this_obj.closest('div.upload-images').find('img.profile-img-tag').length > 0) {
        this_obj.closest('div.upload-images').find('img.profile-img-tag').attr('src', base_url+"assets/front_assets/images/240_400.png");
    }

    if(this_obj.closest('div.upload-images').find('span.bgclr_blc').length > 0) {
        this_obj.closest('div.upload-images').find('span.bgclr_blc').text('Browser......');
    }
    */
  }
  else{
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function (e) {

            this_obj.val(file);
            /*
            if(this_obj.closest('div.upload-images').find('img.profile-img-tag').length > 0) {
                this_obj.closest('div.upload-images').find('img.profile-img-tag').attr('src', e.target.result);
            }

            if(this_obj.closest('div.upload-images').find('span.bgclr_blc').length > 0) {
                this_obj.closest('div.upload-images').find('span.bgclr_blc').text(file);
            }
            */
        }
        reader.readAsDataURL(input.files[0]);
    }
  }
}

$(".formFile").change(function(){
    readURL2(this,$(this));
});




$(function() {
    var $form = $('#form-assignment_submit');
    $form.submit(function(event) {
        event.preventDefault();

        var data = new FormData(document.getElementById('form-assignment_submit'));

        // Submit action
        var response =FileUploadScript.fire($form.attr('action'), data, 'json') ;
        //console.log(response);return false;
        if(response.status)
        {
            Toastr.success(response.txt);
            setTimeout(function(){
                location.reload(); 
            },1000);
        }
        else {
            Toastr.error(response.txt);
        }

      return false;
    });
});