﻿// (c) ammap.com | SVG (in JSON format) map of Hong Kong - Low
// areas: {id:"HK-KI"},{id:"HK-WT"},{id:"HK-TW"},{id:"HK-SS"},{id:"HK-KC"},{id:"HK-TM"},{id:"HK-KU"},{id:"HK-YT"},{id:"HK-IS"},{id:"HK-NO"},{id:"HK-YL"},{id:"HK-TP"},{id:"HK-ST"},{id:"HK-EA"},{id:"HK-CW"},{id:"HK-WC"},{id:"HK-SK"},{id:"HK-SO"}
AmCharts.maps.hongKongLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"113.834541",
				"topLatitude":"22.562136",
				"rightLongitude":"114.441034",
				"bottomLatitude":"22.153123"
			}
		},
		"g":{
			"path":[
				{
					"id":"HK-KI",
					"title":"Kwai Tsing",
					"d":"M315.55,235.42l-0.63,1.79l1.05,0.95l-2.55,2.28l-2.13,-1.37l-2.55,1.37l-5.52,-1.83l-1.7,2.28h-2.55l0.86,1.83l3.82,0.91l0.19,3.52l4.48,1.05l0.22,3.34l-1.14,2.69l-8.59,7.44l2.06,3.72l0,0l-4.54,0.9l-6.73,-5.12l1.13,-3.62l1.96,0.6l10.1,-3.61l-0.28,-1.81l-6.73,1.51l-1.96,-0.9l-1.68,-7.84l4.77,-1.2l-0.29,-1.51l-5.33,1.21l-3.64,-11.15l-2.24,0.9l-3.09,-2.71l0.29,-7.23l-1.69,-3.32l-1.4,0.6v-3.48l0,0l0.38,-0.11l0,0l0.2,0.02l0,0l7.85,-4.03l4.25,-6.85l12.15,-0.91l-0.26,-5.03l1.28,-2.74l-0.42,-1.37l-1.7,-0.46v-1.37l8.93,-2.28l0.85,0.91l-1.22,2.12l0.38,2.9l2.97,0.46l2.13,-1.37l0,0v2.74l-1.28,1.37l-2.55,0.46l-0.85,2.29l2.55,3.2l-2.13,1.37l-0.85,2.28l1.7,4.11l-0.43,1.37l-4.24,4.56l0.85,9.14l2.97,1.37v1.37L315.55,235.42zM268.29,215.08l4.2,0.6l3.93,2.41l-0.29,6.03l1.96,3.01l-0.28,1.81l2.8,2.71l-1.12,4.82l2.24,2.71l-0.55,2.41l1.4,2.71l-1.69,2.71l0.56,2.11l-1.13,0.3l-0.84,3.31l-1.96,1.21l-0.84,3.32h-1.68l-2.25,-3.01l-3.92,1.2l-1.96,-0.9l-0.84,-2.11l-3.09,0.9l0.28,3.01l-3.36,0.3l-3.65,-5.12l2.53,-6.33l-0.56,-1.51l-1.4,0.6l1.12,-1.2l-1.12,-0.3v-3.92l1.68,-0.3l-5.61,-1.51l-1.12,-4.52h-2.25l-0.84,-2.41l0.84,-3.62l-2.52,-4.82l0.28,-1.21l4.49,-2.71l2.52,-0.3l0.85,-2.11l1.96,0.3l0.56,2.11l1.69,0.3l3.08,-2.11L268.29,215.08z"
				},
				{
					"id":"HK-WT",
					"title":"Wong Tai Sin",
					"d":"M392.03,247.75L383.11,249.12L380.14,246.38L378.01,247.3L373.76,246.84L373.76,246.84L370.36,245.47L363.56,250.04L358.89,247.3L357.61,248.67L355.91,248.67L355.91,246.38L354.64,245.93L354.64,242.27L352.09,240.9L352.94,236.79L349.97,235.42L349.97,233.59L348.27,231.31L348.27,231.31L352.09,229.48L355.07,230.4L360.08,229.48L359.74,226.74L360.59,225.83L362.29,225.83L363.56,227.65L366.11,227.2L368.24,223.54L369.51,224.46L369.51,224.46L376.31,224L376.31,224L381.84,223.08L382.26,221.26L386.51,219.89L390.33,219.89L390.33,219.89L390.04,228.27L392.39,243.61z"
				},
				{
					"id":"HK-TW",
					"title":"Tsuen Wan",
					"d":"M280.08,217.53l-0.58,-3.96l-2.8,-3.61l-3.93,-2.71h-1.68l-4.2,3.01l-9.82,2.11l-0.84,1.21l-5.61,-3.32l-4.77,-0.6l-5.04,2.71l-1.96,3.32l-3.09,0.6l-3.37,-0.6l-1.69,-2.11l-5.32,-0.3l-4.77,3.62l-3.08,0.6l-1.12,2.12l-5.88,-0.91l-3.93,2.71l-0.56,1.5l-3.64,-0.3l-4.48,2.42l-3.33,-0.62l0,0l-1.15,-0.82l0.15,-3.7l3.83,-2.74l3.82,-5.02l3.4,-0.46l1.7,-2.29l-0.43,-1.37l-3.82,0.92l-1.28,-0.92l-1.27,-4.11l-2.13,-0.46v-3.66l1.7,-0.91l2.97,0.46l3.4,-4.11l5.1,2.74h2.56l-0.85,-4.57l1.7,-2.74l6.8,2.28l1.7,-1.83h8.07l1.28,-5.03l0,0l4.67,-3.2l1.69,-0.46l1.28,0.91l2.55,-4.57h4.67l5.94,-5.48l7.22,2.29l5.11,-4.11l2.55,-3.65l3.82,-0.46l1.7,2.28h1.28l5.52,-1.37l4.25,-4.57l5.52,0.91v-1.37l2.55,-2.74l0.42,-2.74l0,0l-0.07,1.71l4.37,-1.55l16.86,0.71l0.52,4.15l11.23,0.74l3.41,-1.53l5.74,0.6l0,0l-0.42,3.84l1.7,1.83l0.42,3.2v3.2l-1.7,0.92l0.86,5.94l-11.47,12.34l-4.67,1.37l-2.13,2.29l0,0l-2.13,1.37l-2.97,-0.46l-0.38,-2.9l1.22,-2.12l-0.85,-0.91l-8.93,2.28v1.37l1.7,0.46l0.42,1.37l-1.28,2.74l0.26,5.03l-12.15,0.91l-4.25,6.85L280.08,217.53zM203.53,269.31l-42.05,-0.45l0,0l4.2,-7.08l2.53,0.6l7.28,-4.52l2.81,-0.3l-0.28,-3.01l3.36,-2.11h3.09l1.96,-3.61l0.85,1.81l3.37,-1.21l-1.4,-4.22l2.52,1.21v2.11l-2.24,3.01v2.11l-1.96,1.51v1.51l3.93,-1.51l5.33,-7.23l8.97,-5.42l1.68,-3.32l1.69,-0.6l0.28,1.51l1.68,0.3l-0.55,-2.71l1.12,-0.6l0.29,-3.62l4.48,0.91l5.89,4.82l0.28,2.41l2.8,4.52l-3.37,1.51l0.56,3.32l1.69,2.11l-1.69,1.51l-1.68,4.82l2.24,2.71l-2.24,-0.9l-2.8,3.61l-4.21,-0.3l-0.28,2.11l-1.4,0.6l-1.96,-0.9l-4.77,-8.74l-4.2,-0.3l2.53,8.14L203.53,269.31zM227.92,223.21l0.56,1.81l4.21,-0.91l-0.29,1.2H231v2.71l-1.68,2.11l0.84,1.51l1.69,-0.3l1.68,3.92l-7.01,3.32l-2.24,-4.82l-2.8,-3.01l3.08,-0.91l0.28,-3.01l-1.68,-0.6l0.84,-2.11L227.92,223.21z"
				},
				{
					"id":"HK-SS",
					"title":"Sham Shui Po",
					"d":"M315.55,235.42L318.1,235.42L319.38,233.13L321.08,234.05L323.19,233.13L327.02,234.96L331.27,231.31L333.82,233.59L341.47,233.59L341.47,233.59L341.89,235.42L340.62,238.62L343.17,240.44L344.87,244.55L344.87,249.58L342.75,255.06L342.75,255.06L341.47,254.15L329.99,254.15L329.15,255.06L330.37,256.44L325.28,259.66L322.35,255.97L320.64,257.8L320.61,259.62L320.61,259.62L314.55,255.16L312.58,255.16L311.18,257.56L315.11,261.18L311.75,264.5L312.31,266.31L311.47,267.81L310.34,267.81L308.1,265.1L300.87,265.4L300.87,265.4L298.82,261.68L307.41,254.24L308.55,251.55L308.32,248.21L303.84,247.16L303.65,243.64L299.83,242.73L298.98,240.9L301.52,240.9L303.23,238.62L308.75,240.44L311.3,239.07L313.42,240.44L315.97,238.16L314.92,237.21z"
				},
				{
					"id":"HK-KC",
					"title":"Kowloon City",
					"d":"M373.76,246.84L373.76,256.43L371.63,258.71L378.43,265.56L379.28,267.39L378.19,267.69L378.19,267.69L373.71,265.1L369.78,261.18L369.22,263.29L376.22,270.22L380.15,273.84L383.52,274.14L384.35,277.45L385.99,278.96L384.63,281.37L364.73,262.69L360.52,269.92L362.77,274.74L361.92,281.97L358,284.68L354.64,284.98L353.49,286.8L353.49,286.8L353.36,281.55L351.24,280.18L351.24,278.35L344.45,269.22L341.89,262.37L341.04,259.17L342.75,255.06L342.75,255.06L344.87,249.58L344.87,244.55L343.17,240.44L340.62,238.62L341.89,235.42L341.47,233.59L341.47,233.59L342.75,231.31L348.27,231.31L348.27,231.31L349.97,233.59L349.97,235.42L352.94,236.79L352.09,240.9L354.64,242.27L354.64,245.93L355.91,246.38L355.91,248.67L357.61,248.67L358.89,247.3L363.56,250.04L370.36,245.47z"
				},
				{
					"id":"HK-TM",
					"title":"Tuen Mun",
					"d":"M231.85,186.08l-1.28,5.03h-8.07l-1.7,1.83l-6.8,-2.28l-1.7,2.74l0.85,4.57h-2.56l-5.1,-2.74l-3.4,4.11l-2.97,-0.46l-1.7,0.91v3.66l2.13,0.46l1.27,4.11l1.28,0.92l3.82,-0.92l0.43,1.37l-1.7,2.29l-3.4,0.46l-3.82,5.02l-3.83,2.74l-0.15,3.7l1.15,0.82l0,0l-7.05,-0.3l-6.17,-7.84l-3.36,1.21l-1.12,-3.92l-6.17,3.31l-4.49,0.61l-3.64,-3.01l-3.09,-0.3l-0.84,-3.31h-1.13l-0.56,-2.11h-0.84v2.41l-2.52,3.62l-5.05,1.51l-2.52,-2.71l1.12,3.62l-0.56,1.51h-2.8l-0.84,-3.92l-2.24,-2.41l-2.53,-0.3l-1.68,-2.11h-1.96l0.56,4.81l-1.4,0.91l-4.49,0.91l-3.08,-3.32l-0.56,0.91l1.68,5.73l1.4,-0.3l1.13,1.81l-1.96,1.81l-1.68,-2.71l-3.65,-1.2l1.12,5.43l-1.12,0.6l-1.12,-1.2l0.84,-1.51h-1.13l-0.28,1.51l-2.53,-0.3l-3.93,-4.22l-1.96,1.21l-1.12,-1.81l-3.09,-1.21l-0.84,-4.52h-1.12l-1.12,-2.41l-1.13,0.3l-2.52,6.93h-1.13l-0.56,-2.11l1.4,-3.92l-0.91,-1.81l-2.46,-0.3l-1.12,1.81l-3.93,1.2l-6.17,-3.31l0.56,-1.81l-1.4,-3.31l-1.96,2.41l-2.8,-4.82L81.3,200l4.49,-2.71l1.4,-6.94l-0.85,-3.32l-5.32,-2.71l-1.12,-3.62l1.4,-2.11l-0.28,-3.62l-1.96,-1.81l-2.24,0.3l-1.69,-1.81l-6.73,-0.91l-0.84,-1.51l5.61,-7.84h1.12l0.56,-1.51l4.48,-3.32l1.13,-4.22h2.8l5.33,-2.41l6.45,0.9l5.04,-3.01l4.55,-0.92l0,0l0,0l0,0l-0.26,5.8l0.85,1.83l6.38,-7.77l3.4,-7.31l20.82,0.46l1.27,2.28h14.02l1.28,0.92l9.77,-2.74l-1.7,6.85l2.97,4.11h9.35l0.42,6.86l4.67,1.83l0.43,9.6h39.09l0.85,-3.65h7.65l0.85,0.91l-0.43,2.74l-2.55,0.46l-0.42,1.37v6.85h7.65l1.28,0.92L231.85,186.08zM45.69,195.48l1.4,1.5l3.09,0l1.12,1.21l-1.68,4.52l0.84,2.41l-1.96,3.92l-2.52,-0.91l0.84,-4.22l1.12,-0.3l-0.28,-3.01l-4.77,-2.41v-2.71L45.69,195.48zM132.6,247.32l0.28,1.81l2.79,0.9l-1.67,3.32l-2.79,-0.6l0.26,-4.52L132.6,247.32zM54.1,232.86l1.4,1.51l1.69,-1.2l0.56,1.81l-1.4,3.92H55.5l-1.4,-4.82l-1.96,-0.6l0.55,-1.2L54.1,232.86zM149.14,239.79l1.13,2.41l-3.09,5.42L149.14,239.79zM52.14,229.54v-2.71l1.68,-0.6l0.84,1.81L52.14,229.54zM104.63,146.92L104.63,146.92l0.21,-0.28L104.63,146.92z"
				},
				{
					"id":"HK-KU",
					"title":"Kwun Tong",
					"d":"M392.03,247.75L397.98,247.3L403.51,260.08L405.2,260.08L408.6,262.37L410.3,262.37L411.15,261L412.43,261.45L411.58,265.11L409.45,267.39L412.43,267.85L414.12,269.67L410.73,275.15L408.6,276.52L409.45,279.26L412.85,281.55L412.85,284.29L414.12,285.66L414.55,289.77L411.15,288.85L410.3,290.22L411.58,294.79L409.87,297.07L411.58,299.81L412.95,299.44L412.95,299.44L410.99,300.35L406.79,299.15L406.22,295.23L401.18,290.71L398.66,286.19L393.33,281.97L390.8,278.06L386.6,274.44L386.04,272.03L382.68,270.22L379.03,270.22L378.19,267.69L378.19,267.69L379.28,267.39L378.43,265.56L371.63,258.71L373.76,256.43L373.76,246.84L373.76,246.84L378.01,247.3L380.14,246.38L383.11,249.12z"
				},
				{
					"id":"HK-YT",
					"title":"Yau Tsim Mong",
					"d":"M353.49,286.8L351.84,288.6L350.15,286.79L348.19,286.49L342.58,292.82L339.5,291.92L337.82,292.52L335.58,290.71L333.61,290.71L336.14,289.51L335.85,287.4L333.89,287.4L333.89,284.98L335.29,284.68L334.74,279.86L324.36,285.29L323.24,268.41L326.32,267.21L323.8,262.69L320.61,259.62L320.61,259.62L320.64,257.8L322.35,255.97L325.28,259.66L330.37,256.44L329.15,255.06L329.99,254.15L341.47,254.15L342.75,255.06L342.75,255.06L341.04,259.17L341.89,262.37L344.45,269.22L351.24,278.35L351.24,280.18L353.36,281.55z"
				},
				{
					"id":"HK-IS",
					"title":"Islands",
					"d":"M178.02,356.97l4.49,1.21l0.84,1.51l1.4,-1.21l1.96,1.5l-2.23,1.5l0.84,1.81l-0.84,1.5l-5.89,2.41l-1.96,2.41l0.56,1.8l-4.49,1.21l-1.68,4.21h-3.09l-0.84,-2.41l-3.08,-1.2l-2.53,1.5l-0.56,1.51l-3.93,1.2l-0.55,2.71l-3.09,0l-0.28,-3.61l-2.53,0.3l-3.37,-2.41l3.64,-6.62l-4.2,-4.82l-1.96,-0.3l-0.55,-1.5l4.21,-8.43l-3.09,-2.41l-5.32,-1.21l-3.65,1.81l-0.56,1.5l-4.21,0.9l-2.52,1.81l-0.56,2.71l-1.96,-0.3l-2.24,1.81l-1.13,-0.9l0.28,-1.81l-5.32,-0.6l-9.82,3.31l-2.8,3.01l-2.8,-0.3l-3.08,3.61l-4.77,1.81l-1.69,-0.6l-1.12,-2.11l-2.53,0.6l-1.69,4.22l-2.8,0.9v2.41l5.33,1.5l2.24,-2.41l4.49,2.1v6.63l1.68,1.81l-5.88,0.3l-5.61,2.41l-1.13,-2.11h-1.4l-0.84,-2.41l-2.53,-0.3l-0.84,0.3l-0.84,4.82l-1.96,0.9l-3.93,-2.1l-2.8,-3.01l-1.4,0.61l-0.56,-2.41l-1.68,-1.51l-2.8,-0.6l-1.69,-4.21l1.69,-2.41l-0.29,-1.51l-4.21,0.6l-0.56,-1.81l-1.68,-0.3v2.71l-2.25,1.51l-1.4,-0.61v-1.5l-2.8,0.3l-3.92,3.31l-0.85,2.71l-2.24,1.2l1.12,3.91l-1.69,0.61l-0.84,-1.21h-1.96l-2.8,1.81l-5.61,8.73h-2.8l0.28,-2.41l-1.96,-0.3l-2.52,1.5l-2.53,-0.3l-0.28,0.9l-3.37,0.6l-1.13,2.4l1.69,0.91v1.21h-1.12l-0.56,1.5l-4.77,-1.2l-1.12,1.2l0.29,1.5l-1.13,0.3l-1.68,-2.71l2.52,-1.5l0.01,-3.91h2.24l0.28,-2.41l-0.84,-0.9l-2.24,0.9l-4.77,-3.92l-0.29,-3.31l0.85,-2.11h1.12l0.29,-3.61l-3.93,-3.31l0.56,-7.53l-1.12,-0.3v-1.81l1.69,-1.81l1.12,-5.72l3.93,-0.9l5.04,5.12l2.24,-3.91l-0.84,-6.02l-1.4,-0.9l1.13,-3.31l3.64,-1.81h4.2l3.37,-2.71l-0.28,-4.22l-2.53,-0.61l0.56,-1.5l-3.09,-0.6l-1.96,2.11H18.5l-1.12,-4.21l2.79,-1.81l0.57,-2.11l4.2,-1.51l2.53,0.3l1.12,2.41h1.69l4.48,-6.33l0.56,-3.31l1.96,-1.21l4.21,0.3l1.96,-1.51l2.8,-0.3l1.68,-2.41l2.25,0.9l1.4,3.61l1.96,-0.9v-3.31l-1.96,-2.41l0.28,-3.61l6.17,-2.71l1.96,-2.11v-6.32l0.56,-1.2l1.68,-0.3l0.29,-2.41l0.56,0.9l2.52,-0.61l0.29,2.11h2.24l1.68,-3.62l3.09,0.3l2.24,2.41h1.96v-1.21l4.77,-2.11l3.64,2.41l2.8,-0.3l1.96,1.51l0.84,4.82l2.8,2.41l-0.28,1.2l1.69,2.11l2.52,-0.9l1.96,0.6l-0.84,-2.11l5.88,-11.45h1.96l0.85,-1.51h1.68l0.84,1.51h2.8l0.85,-1.51l7.57,-0.9l4.21,-2.71l11.49,-2.71l6.97,-3.92l5.09,-5.72l4.77,-2.41l5.33,-0.9l2.24,-2.26l0,0l42.05,0.45l0,0l0.85,3.63l-2.53,1.51h-1.69l-1.4,-2.71l-3.08,-1.22l-3.94,3.33l-6.15,-0.61l-1.12,3.02l-1.69,0.3l0.84,2.11l-0.84,2.41h3.37l0.84,2.41l-4.77,1.51l-0.56,2.41l1.41,0.9l1.96,-0.9l1.4,1.51l0.85,-2.11l1.12,-0.3l1.12,1.2l1.96,-2.11l1.12,3.92l2.25,3.01v1.51H194l-0.28,-0.9l-3.64,0.6l-2.25,-2.41l-1.68,0.9l1.96,2.11l-2.24,1.81l0.84,3.92l3.37,2.11l-1.12,3.31l1.4,2.71l-1.96,0.6l0.29,1.81l-0.85,0.6l1.96,1.81l-1.12,3.01l0.84,2.11l-1.12,1.5l0.29,1.81l-2.25,-0.6l-2.52,1.81l-6.45,-1.5l-0.84,-2.71l-3.08,-0.3l-0.85,-1.81l-2.52,-1.51h-2.25l-2.24,3.01l0.56,2.41l3.37,1.81l-0.29,2.41l3.09,0.9l1.96,2.41l2.53,5.72l1.96,1.2v2.11l-2.24,0.3l-4.48,3.01l-4.21,0.6l-1.4,3.31l-5.88,2.71v1.81l2.52,1.5l2.53,-1.2l0.56,2.11l3.08,2.11l2.25,3.91l2.8,0.3l1.68,-2.41L178.02,356.97zM292.96,416.88l-0.29,-2.11l-1.68,-1.5l-1.69,2.11l-2.8,-0.3l-3.92,-2.41l-0.85,-2.41l1.4,-4.52l1.96,0.3l1.4,-2.41l1.69,-0.3v-5.12l1.4,-2.41l-0.29,-6.62h1.12l0.29,-1.2l-3.06,-2.11l0.25,-1.21l1.4,-0.3l-0.28,-2.41l0.84,-0.61l-1.4,-2.41l0.56,-1.5l-1.13,-4.52l-3.64,-1.81h-2.53l-0.84,4.21h-10.37v-2.41l1.69,-3.01l3.08,-3.31l3.36,-1.5l-0.27,-0.9h-1.69l-0.28,-1.2l1.62,-3.61l-3.58,-1.5l-0.84,-1.81l3.6,-1.51l0.89,-1.5l6.45,-1.81l1.12,-3.01l1.13,1.81l2.8,0.3l1.4,1.81l-0.28,3.92l-2.25,0.6l-0.28,1.81l0.84,3.6l4.71,2.72l-0.51,3.31l3.37,3.61l3.09,0.6l0.28,-1.5l2.8,-0.9l2.52,2.41l-0.28,3.01l-1.96,-0.3l0.84,2.71l-3.93,0.6l-4.77,5.12l-0.56,3.01l2.8,3.31l1.12,-0.6v-2.71l5.04,-3.31l5.33,-0.3l4.77,1.81l1.4,-3.91l1.96,0.3l1.68,-1.5h1.4l1.13,2.71l6.17,-0.3l1.4,2.1l-3.08,4.82l-3.09,0.3l-1.96,-2.71l-1.4,-0.3l-2.24,1.2l0.28,2.11l-3.08,0.9l-0.28,3.31l-1.68,0.3l-0.56,1.21l-3.37,-0.6l-0.28,3.01l2.53,-0.3l0.84,1.21l0.28,3.01l5.05,8.73l0.28,3.31l-1.4,-2.11l-3.09,-0.6l-2.24,-3.01l-3.93,-2.41l-1.4,-3.01l-2.24,1.81v1.2l3.09,6.32l-0.29,5.42l-2.8,-1.2l-2.53,-4.82l-3.92,3.92v1.51l-2.25,0.89L292.96,416.88zM80.46,264.8l18.78,-6.63l5.05,0.9l-2.53,0.9v1.51l5.89,-1.2l1.68,0.6l0.56,-1.51l1.4,0.6l1.12,-0.9v3.61l-1.96,2.71l0.28,1.2l-5.04,7.83l-0.56,3.92l1.12,2.11l-2.24,2.41l-1.12,-0.61l0.28,4.22l1.68,4.22l-5.32,4.82l-1.69,-1.5l-5.04,-0.3l-10.66,-3.92l-1.96,0.6l-5.04,-0.9l-10.09,2.41h-4.2l-0.56,-1.21l-3.36,0.9l7.57,-9.04l-2.53,-3.31v-2.41l-2.8,-1.21l-3.37,0.6l-0.28,-1.21l2.53,-0.6l0.84,-2.41L80.46,264.8zM421.08,434.95l2.52,-3.91l-3.37,0.9l-1.12,-2.41l1.96,-2.41l0.84,-3.31l4.48,-4.82l6.73,-1.5l0.29,-2.71l2.24,-0.9l1.68,2.41l3.93,2.11l1.4,3.61l-1.12,4.52l2.52,3.91v3.31h-8.41l-0.28,-1.81l-1.12,-0.3l-3.37,3.91v2.41l-5.04,3.61l-1.13,-0.9l2.53,-4.21L421.08,434.95zM418.28,436.75l2.52,-0.3l0.29,-1.51l-1.4,-0.3L418.28,436.75zM185.31,391.3h2.8l2.24,-4.52h2.53l2.24,-1.81l-1.68,-3.61l-3.37,-0.6l-0.84,-2.11v-0.9l2.8,-0.3l0.28,-2.11l1.12,-0.3l-0.29,-1.5l-1.4,-0.6l0.84,-2.11l2.25,-2.11l4.48,0.6l2.8,-2.41l1.4,3.01l-3.64,3.31h3.37l0.28,1.5l-5.32,1.51l-1.69,1.5l0.28,2.71l1.68,3.01l2.53,1.81l1.68,0.3l1.13,-1.51h1.68l2.24,2.71l-1.4,1.21v1.81l-2.8,1.21l-0.28,2.11l-2.53,-3.31l-3.08,0.9l-2.53,2.11v1.2l-3.08,0.9v1.81l-1.4,0.3h-1.96l-0.29,-1.5l-2.8,0.3l-1.12,-3.01L185.31,391.3zM197.08,328.97v0.9l12.06,-0.3l2.24,0.9l1.4,2.11l-1.4,6.02l3.08,4.52l-0.56,3.31l-1.4,1.5l-1.68,0.6l-3.09,-2.11l-2.24,-4.52v-2.71l-3.64,-0.9l-1.69,-3.62l-5.32,-0.3l-1.4,-3.01h1.68l-0.28,-2.11L197.08,328.97zM78.22,424.41l0.55,2.11l2.53,-0.3l1.4,0.9l-0.28,2.11l-3.36,0.6l0.28,3.01l1.69,0.3l1.4,3.61h-3.93l-0.56,1.81l-1.96,-0.9l-3.64,0.6l-0.56,1.5l-3.08,0.9l-3.91,-3.31l0.82,-3.31l3.37,-1.81h1.96l0.56,1.5h1.12l0.56,-1.81l0.84,0.6l1.69,-1.5v-1.5l-1.1,-0.6l0.54,-3.31L78.22,424.41zM154.75,404.24l-0.56,-1.51h-1.96l-3.37,-3.01l0.84,-5.12l4.21,-4.22l2.53,0.3l2.52,2.71l0.56,2.71l-1.12,0.6v1.81l3.08,-0.6l-0.28,5.72l-3.37,1.21l-0.56,1.5L154.75,404.24zM424.73,403.94l1.68,1.81l-0.55,6.02l-5.05,3.61l-1.68,-1.51l-1.96,0.3l-1.96,-1.21v2.71l-1.13,0.3l-1.4,-3.01v-7.22L424.73,403.94zM211.38,292.82l0.84,2.71l-3.93,2.41l-0.56,1.81l1.12,0.9l0.84,-1.81h3.93l1.13,3.31l-2.53,3.92l-5.04,1.51l-2.81,-3.92l0.28,-1.8l-1.96,-2.11l-0.57,-3.92L211.38,292.82zM73.17,406.05l3.09,1.81l1.12,2.71l2.25,0.6l1.68,-0.9l1.69,2.41l2.8,-0.6l1.68,2.41l-0.56,2.41h-1.12l-2.25,-2.71l-0.84,0.3l0.84,1.81l-0.55,1.51l-1.41,-0.3l-0.55,-2.41l-0.56,1.2h-1.4l-0.56,-3.91l-3.37,0.6v1.81l-1.4,0.3v1.2l-2.53,-0.6l1.13,-3.61l-0.84,-3.01l0.56,-2.71L73.17,406.05zM222.03,322.64l1.69,1.81l-0.84,3.31l-4.77,3.62l-3.09,-0.9l-1.13,-1.5l0.85,-3.62l1.4,-0.3l0.84,-1.81L222.03,322.64zM460.05,403.64l0.85,1.5l-1.96,3.92v4.22l-1.13,0.9l-3.64,-0.6l-1.13,-1.2l-0.56,-4.51l1.4,-0.9l1.41,0.6l0.84,-3.31l2.8,0.6L460.05,403.64zM246.7,298.84v5.12h-4.2l-1.12,-2.41l1.96,-1.81L246.7,298.84zM473.79,412.97l-1.41,0.9l-0.84,-1.8l2.8,-2.71l0.56,-3.92l1.69,-0.6l-0.29,3.91L473.79,412.97zM1.96,373.53l2.25,0.9l-1.96,3.01L0,375.04l0.28,-1.5H1.96zM304.17,364.8v2.41l-1.68,0.9l-1.96,-0.6l1.12,-2.41l1.41,-0.9L304.17,364.8zM90.27,439.46l0.28,2.71l-2.25,1.5l-0.56,-2.1L90.27,439.46zM226.52,295.23l1.13,2.71l-2.25,0.6l-1.68,-2.11L226.52,295.23zM67.84,421.7v2.41l-1.96,-0.61l-0.29,1.21h-1.4l-0.84,-0.9L67.84,421.7zM89.99,414.18l2.52,2.41l-0.28,1.2l-2.53,-1.2l-0.55,-2.11L89.99,414.18zM71.49,419.3l0.56,2.98l-0.85,0.33l-1.4,-2.11L71.49,419.3z"
				},
				{
					"id":"HK-NO",
					"title":"North",
					"d":"M386.88,40.45l3.64,-6.34l4.2,1.51l3.37,-2.41l0.29,-2.41l3.64,1.81l2.8,-1.21l1.96,-2.72l0.84,-5.73l2.24,-2.72l1.4,-6.34l1.96,0.6l1.13,-1.21l1.68,0.3l0.56,3.62l1.4,1.51l1.69,-1.21l-0.29,-1.81h2.53l1.96,1.51l0.28,-3.62l2.8,0.3l0.84,1.21h1.96l-3.37,3.32l0.29,0.9l3.64,-2.11l1.4,0.3l-0.84,1.51l-2.8,0.6l-2.53,6.03l1.69,0.61l2.52,-2.72l2.25,0.3l1.12,1.51l-1.96,5.13l2.25,-3.02l2.8,0.3l0.84,1.81l-0.56,2.11l-2.53,0.3l-1.4,1.81l-0.84,2.41l0.84,3.62h2.53l0.84,-1.51l6.45,1.21l1.68,-2.11l-1.12,-1.21l0.55,-1.21l1.96,1.81l5.33,-0.9l-2.8,5.13l0.84,1.81l1.96,-0.6l1.68,-2.11l3.09,-0.6L455,43.17l-3.08,1.81l-0.56,2.72L449.4,48l-1.13,5.13l-3.92,-3.62l-2.25,-0.3v1.21h0.85l-0.85,2.11l2.25,0.3l-1.13,3.92l1.4,1.51l0.56,-1.51l1.96,-0.6l7.01,-0.61l-0.84,2.72h4.2l1.4,2.41v-2.11l2.8,-0.61l2.24,3.92l2.24,0.3l1.41,-1.51l-1.13,-1.51l1.4,-1.51l-3.64,-3.62l7.01,-0.9l2.8,3.02l0.84,-2.72l2.24,-1.21l0.56,-2.71l1.96,-1.81l-1.13,-8.75l6.73,2.72l1.96,3.62l-0.56,1.51h2.53l1.96,2.11l-0.29,1.21h-1.12l-3.37,4.53l-4.49,1.21l-1.68,2.72l-3.09,-1.51l-2.24,0.6l-1.68,3.02h-1.69l-4.21,2.72l0.84,1.51h1.96l4.21,3.32l4.77,-3.62l17.66,-3.92l2.53,-3.02l4.72,-2.11l0,0l0.61,1.64l-2.13,1.37l-1.28,2.74l-3.82,2.74l-4.25,0.46l-7.22,5.03l-1.7,2.29l-11.9,7.32l-5.52,-2.29h-2.55l-1.28,-1.83l-8.92,-5.03l-6.37,-0.46l-2.98,1.83l-4.24,-0.92l-1.7,1.37h-2.55l-0.42,2.29l-2.56,0.46l-12.32,-0.46l-6.38,-7.77l-2.97,-1.83l-0.42,-2.28l-2.97,1.37l0.42,2.74l-0.85,0.91l-1.28,-0.46l-5.1,3.2l-3.4,5.49L395,76.38l-1.7,5.03l-4.24,-3.2l-6.8,-1.37l-5.53,0.92l-6.8,-2.75l-5.1,-0.46l-1.69,-1.83l-2.56,0.46l-5.1,-1.83l-4.67,0.46l-3.4,1.37l-4.25,3.66l-2.55,7.32h-1.28l-2.55,-2.74l-3.82,0.92l-0.43,-4.57l-11.46,1.37l-1.28,2.74l2.55,4.12v2.74l-2.97,-0.91l-4.25,5.94l-5.1,1.83l-7.22,5.49h-3.83l-3.4,2.28l0,0l-5.95,0.92l-2.55,-3.2l-5.1,-3.2l-6.37,2.28l-4.67,-0.46l-2.97,2.29l-3.4,0.91l-7.65,0.46V88.27l2.97,-7.31l0.86,-5.49l-2.97,-5.94l1.69,-2.29l-2.13,-9.6l0.86,-0.92l1.27,0.46l1.28,-1.83l-1.7,-1.83l-0.85,-3.2l1.27,-5.94l-3.4,-1.83l-2.13,2.74l-1.7,0.46l0,0l2.54,-4.6l-0.42,-1.81l-5.94,-5.95l7.22,-2.74l3.4,-4.12h2.97l3.78,3.18l5.14,-0.89l-0.42,3.2l1.28,0.46l5.95,-5.03l1.7,6.4l2.55,0.91l3.4,-3.2v-2.29h4.25l0.85,-1.83h1.27l-0.42,-1.83l3.83,-2.74l2.12,0.91l2.12,-2.29l10.2,-2.29l4.25,2.74l3.82,-0.91l0.85,-1.37l-0.85,-0.92l4.25,-3.2l-0.42,-1.83l-2.13,-0.91l2.13,-2.75V7.78l2.13,-0.46l1.27,0.91l1.28,-0.91l0.85,-4.57L329.99,0l2.98,2.29l2.97,-1.83l5.1,1.37l4.67,-0.91l1.7,1.83l0.43,3.2l1.7,0.91l5.52,-0.46l5.52,1.37l10.2,-3.2l2.97,1.83l1.28,-0.91l11.47,1.83l5.52,4.12l2.13,0.46l3.39,3.66l-1.7,2.74v2.24l-1.96,0.91l-1.13,-1.51l-5.32,0.6l-2.53,2.71l-0.84,4.53l-1.69,2.11l-0.84,0.91l-3.37,-0.6l-0.56,1.21l0.85,1.81l-1.13,3.02l0.56,4.22h1.12l0.29,-1.21l3.64,0.3l1.96,-2.11l0.56,2.41L386.88,40.45zM462.86,7.56l0.84,0.6l-0.84,2.42l0.84,1.21h13.18l9.81,1.21l-1.68,0.3l-3.64,3.32L478,14.8l-0.29,1.81l-2.52,-0.3l-1.69,3.02l-5.61,-4.83l-1.4,0.91l-0.84,-0.6l-1.4,1.51l-0.56,3.32l3.08,0.91l1.69,4.23l4.2,3.32l2.53,-0.6l0.55,1.81l-1.96,3.62l-4.49,-0.6l-0.28,-3.62l-2.25,0.3l-2.24,2.11L455,31.4v-1.51l2.24,-1.81v-2.42h2.53l1.12,-1.51h0.84l-0.56,1.51l2.53,-0.9l-3.37,-4.83l-4.49,-3.32V15.4l3.36,-0.91l-1.96,-2.41l0.29,-2.72l1.96,-1.81H462.86zM490.05,26.87l1.4,3.92l-1.4,7.24l1.69,3.02l-3.09,1.51l-0.56,-1.81h-2.8l-2.24,-2.41L478,36.23l-0.29,-4.83l1.69,-2.11l3.08,1.81l1.96,4.52l1.96,0.3l1.68,-3.02l-0.55,-5.13L490.05,26.87zM478.55,21.74l1.96,2.11l-3.92,3.32l-1.69,-0.3l-0.28,-3.32l2.24,-1.81H478.55zM395.29,23.86l0.84,1.21l-0.84,2.41l-3.36,0.91l-1.41,-2.72L395.29,23.86zM456.13,44.38l2.24,0.91l-0.28,1.51l-3.37,-0.6l-0.29,-1.51L456.13,44.38zM500.7,21.14l1.12,1.81l-1.68,1.81l-1.13,-3.02L500.7,21.14z"
				},
				{
					"id":"HK-YL",
					"title":"Yuen Long",
					"d":"M295.58,103.36L294.3,107.47L280.25,126.11L279.43,128.96L283.66,138.06L284.4,143.95L292.09,153.6L292.6,157.75L292.6,157.75L292.18,160.49L289.63,163.23L289.63,164.6L284.11,163.69L279.86,168.26L274.34,169.63L273.06,169.63L271.36,167.35L267.54,167.8L264.99,171.46L259.88,175.57L252.66,173.29L246.72,178.77L242.04,178.77L239.49,183.34L238.22,182.43L236.52,182.88L231.85,186.08L231.85,186.08L232.27,179.23L230.99,178.31L223.35,178.31L223.35,171.46L223.77,170.09L226.32,169.63L226.74,166.89L225.9,165.98L218.25,165.98L217.4,169.63L178.31,169.63L177.88,160.03L173.2,158.21L172.78,151.35L163.43,151.35L160.46,147.24L162.16,140.38L152.39,143.13L151.11,142.21L137.09,142.21L135.82,139.93L115,139.47L111.6,146.78L105.22,154.55L104.37,152.72L104.63,146.92L104.63,146.92L104.84,146.64L104.84,146.64L112.13,141.81L113.26,135.18L116.06,130.95L119.7,128.54L119.99,124.32L121.67,122.51L124.75,122.51L131.76,117.69L137.08,117.08L143.54,113.46L145.5,110.75L146.34,105.92L148.58,101.4L152.51,98.38L153.63,96.27L155.31,95.97L156.15,93.55L157.55,93.55L159.24,91.75L162.6,82.09L166.52,78.17L170.73,78.47L172.41,80.28L178.86,81.79L178.02,90.84L175.78,90.84L175.49,96.27L174.37,98.08L176.34,97.17L176.61,99.29L181.66,104.41L184.75,102.3L186.99,102.91L188.11,101.4L185.02,98.68L187.55,95.67L192.59,94.46L195.96,97.48L195.4,106.22L196.52,105.62L196.8,101.4L199.61,100.79L204.37,102.6L211.66,107.43L211.1,104.72L200.45,99.29L197.92,95.67L195.68,95.36L190.64,89.33L189.51,89.63L189.51,91.14L186.71,91.44L183.62,93.55L181.94,96.57L181.66,102.3L181.1,96.87L176.61,93.25L178.02,92.95L178.86,94.16L181.1,93.55L182.51,92.05L182.51,90.23L192.32,85.41L191.75,80.58L193.72,78.77L194.28,74.55L205.92,62.66L207.62,63.12L209.32,61.29L215.7,63.12L222.92,62.66L225.9,59.46L227.17,52.6L231.42,48.95L241.2,46.66L245.86,49.86L252.24,45.74L252.24,45.74L253.94,45.29L256.07,42.54L259.46,44.37L258.19,50.32L259.04,53.52L260.74,55.35L259.46,57.18L258.19,56.72L257.33,57.64L259.46,67.24L257.77,69.52L260.74,75.47L259.88,80.95L256.91,88.27L256.91,103.36L264.56,102.9L267.96,101.99L270.93,99.7L275.61,100.16L281.98,97.87L287.08,101.07L289.63,104.27z"
				},
				{
					"id":"HK-TP",
					"title":"Tai Po",
					"d":"M379.59,101.4l-1.4,2.41l-0.28,7.85l3.08,1.51l6.73,0.6l3.37,3.02l2.24,-0.3v1.51l-4.21,0.6l-1.4,-0.6l-0.28,-2.41l-1.13,-0.3l-2.24,2.11l1.4,1.75l5.04,1.87l0.56,1.21l-1.13,1.21l-3.92,-0.91l0.56,1.81l-1.4,0.91l-1.4,-2.11l-4.77,-0.3l-0.55,-1.21l1.4,-0.61l0.28,-1.81l-5.33,0.6l-0.84,-1.81l0.56,-1.81l2.52,-0.9l-2.8,-0.6l-4.21,-3.01l-2.52,2.71l0.28,3.02l-1.68,1.81l-3.93,1.81l-10.93,-2.11l-1.4,0.91l-0.29,2.41l-2.24,0.6l-0.84,1.51l1.68,3.55l2.25,1.57h2.24v1.51l2.24,1.51l2.53,0.61l2.24,-1.21l4.2,0.3l1.69,0.6l1.68,3.01l3.93,0.91l0.84,3.02l-1.13,1.81l1.69,0.6l0.84,2.71l3.8,1.51l0,0l-1.02,1.5l-3.33,-0.38l-0.9,3.5l-1.7,-2.88h-0.95l-2.28,8.33l-12.94,0.04l-0.99,3.13l-9.74,-0.3l-2.29,2.69l-6.43,0.62l0,0l-5.74,-0.6l-3.41,1.53l-11.23,-0.74l-0.52,-4.15l-16.86,-0.71l-4.37,1.55l0.07,-1.71l0,0l-0.51,-4.15l-7.69,-9.65l-0.74,-5.89l-4.23,-9.1l0.82,-2.84l14.05,-18.64l1.28,-4.12l0,0l3.4,-2.28h3.83l7.22,-5.49l5.1,-1.83l4.25,-5.94l2.97,0.91v-2.74l-2.55,-4.12l1.28,-2.74l11.46,-1.37l0.43,4.57l3.82,-0.92l2.55,2.74h1.28l2.55,-7.32l4.25,-3.66l3.4,-1.37l4.67,-0.46l5.1,1.83l2.56,-0.46l1.69,1.83l5.1,0.46l6.8,2.75l5.53,-0.92l6.8,1.37l4.24,3.2l1.7,-5.03l2.97,-0.91l3.4,-5.49l5.1,-3.2l1.28,0.46l0.85,-0.91l-0.42,-2.74l2.97,-1.37l0.42,2.28l2.97,1.83l6.38,7.77l12.32,0.46l2.56,-0.46l0.42,-2.29h2.55l1.7,-1.37l4.24,0.92l2.98,-1.83l6.37,0.46l8.92,5.03l1.28,1.83h2.55l5.52,2.29l11.9,-7.32l1.7,-2.29l7.22,-5.03l4.25,-0.46l3.82,-2.74l1.28,-2.74l2.13,-1.37l-0.61,-1.64l0,0l2.56,1.21l0.28,2.41l-9.82,8.15l-1.68,0.3L485,79.68l-1.96,1.21l-4.21,-0.6l-1.12,2.11l1.4,1.81l-1.68,1.51l-3.93,1.21l-3.93,3.02l-4.48,0.6l-1.96,3.01l-8.41,2.72l-5.05,3.32l-3.92,-0.91l-2.8,0.61l-1.4,1.81l2.24,0.3l-0.84,1.81l-10.94,6.03l-3.93,6.03l-4.2,3.62l-0.84,-1.21l-2.81,0.3l-3.92,3.92l-0.56,-4.83l0.84,-0.91l-13.17,-13.57l-1.96,-0.6v-2.11l-1.4,-1.81l-5.04,1.21l-2.25,2.71l-5.04,0.91l-1.68,-0.3l-1.4,-4.83h-1.96l-0.85,2.11L379.59,101.4zM414.92,142.11l0.84,-1.2l4.48,-0.9l2.81,-2.11l1.96,3.32l11.5,-1.81l1.39,-1.21l2.5,4.22l0.59,7.54l-3.37,5.43h1.96l0.28,2.41l2.8,1.81l2.23,4.52l-0.55,-4.52l1.12,-4.22l1.4,-1.51l5.05,-1.81l5.32,-5.13l-0.28,-2.11l-2.53,0.3l0.29,-2.41l-1.69,-1.51l-0.28,-3.32l-2.24,-4.22v-1.51l2.24,-2.71l-3.93,-0.6l-1.4,0.91l-0.84,-3.02l1.96,-0.6l3.08,-5.43l2.53,-0.91l1.68,-2.41l2.79,1.21l0.85,2.71l1.4,0l0.28,-8.44l0.84,-0.6l3.09,3.02l4.2,-0.6l0.28,2.11h1.96l1.41,-2.71l-1.12,-6.34l2.52,-0.91l1.12,-4.83l3.08,-3.62l4.49,-1.51l2.24,-3.92l4.77,-0.6l1.13,-3.62h1.12l2.53,3.92l-1.4,2.71l0.84,2.11l2.8,0.6l1.96,-1.81h2.25l0.28,3.31l-1.68,-0.29l-0.56,0.9l-0.56,4.83l-1.4,2.11l0.56,1.81h1.68l1.96,-2.71l3.37,1.21l1.68,-0.6l-0.55,-2.72l1.96,-1.21l1.4,-3.92l-1.96,-4.22l2.23,-0.3l0.28,-2.71l1.69,-1.81l1.4,0.91l1.68,5.43l-0.28,3.32l3.64,8.45l-3.37,2.41l-2.24,-0.3l-3.64,-2.71l-0.85,0.6l1.12,2.71l-1.96,6.03l1.69,3.02l-0.29,3.92l3.09,1.21l0.28,2.41l-2.8,5.12l-4.77,-0.3v1.51l3.37,4.83l-0.56,3.62l-2.24,3.32l1.4,0.3l1.96,-1.51l0.28,-2.71h3.37v-4.22l2.24,-3.32l2.25,-0.61l1.37,1.21l-0.25,3.02l3.35,7.84l-0.26,2.11l-2.8,0.9l0.28,1.81l1.4,1.51h6.17l-1.96,-3.02l1.69,-0.3l-1.4,-2.71v-5.43l0.28,-4.82l1.69,-2.41l-1.69,-1.21l0.29,2.41h-1.41l-0.84,-3.62l1.69,-5.73l-1.4,-3.02l1.68,-1.21l3.09,0.3l1.68,-2.41l3.09,0.91l-1.69,-4.52l0.56,-5.43l3.37,2.11l3.64,0.6v1.81l3.06,2.71l-0.54,4.52l-3.09,3.62l1.4,5.62l0,0l-1.05,-1.13l-2.55,0.91l-0.42,1.37l0.85,3.66l-1.27,2.74l2.97,3.2l-0.85,4.57l2.55,2.74l-2.98,8.23v2.74l-2.97,1.83l-1.27,2.74l-5.53,5.03l-2.97,0.46l-1.28,-0.91v-2.74l-2.55,-1.37h-3.4l-7.22,-8.68l-1.28,-0.46l-2.99,4.12l-4.24,0.45l-6.8,-4.11l-1.7,-2.29l2.56,-2.29l-1.28,-0.91l-2.55,-0.46l-2.12,-2.74l-9.35,-1.83l-2.97,2.29l0.85,4.57l-2.13,3.2l1.28,1.83l-2.55,1.83l-4.67,-0.92l-2.55,0.92l-3.4,-1.37l-5.1,1.37l-1.7,7.31l-3.82,3.66l-1.28,2.74l-3.83,-0.91l-5.52,5.48h-14.87l-5.53,4.57l0,0v-4.57l1.7,-3.66l-0.85,-3.66l-1.7,-1.83v-5.48l-3.83,-2.29l1.7,-13.71l-2.13,-0.91l1.28,-4.11L414.92,142.11zM530.14,82.09l4.2,1.51l1.12,2.41l-1.12,3.92l3.93,4.52l-1.4,3.32l-2.53,0.91v4.53l-1.4,0.3l-1.13,2.11l-3.37,-0.91l0.56,-6.33h-1.13l0.29,-3.62l-1.13,-1.21l-1.96,0.3l-1.68,-4.83l0.28,-1.51l3.37,-1.81l0.84,-2.11L530.14,82.09zM601.06,9.97l0.56,8.15l5.33,4.53l1.68,-0.91l3.37,0.91l-1.96,3.62l-5.04,0.6l-4.77,-3.62l-1.96,0.3l-1.4,-1.81l-1.13,-2.72l0.56,-1.81l-1.4,-2.41l1.69,-3.32L601.06,9.97zM401.46,112.26l1.4,0.6l0.84,2.11l-2.8,4.53l-6.17,3.62l-1.96,-0.61l-0.55,-1.51l3.36,-2.11l0.85,-3.62l3.36,-3.02H401.46zM529.58,61.88l3.37,1.21l2.24,-0.91l0.28,1.51l-2.8,1.51l-1.68,6.64h-3.09v-1.81l-2.52,-3.02l1.96,-0.61l-0.85,-3.02L529.58,61.88zM390.8,107.13l1.96,3.62h-3.37l-0.55,-2.11L390.8,107.13zM501.26,88.13l0.84,0.6v3.02l-1.4,1.21l-0.29,-3.92L501.26,88.13zM391.65,131.86l0.56,1.81l-1.69,1.21v-3.02l1.69,-0.6L391.65,131.86zM541.91,84.81l1.13,1.81l-2.52,-0.6l-0.29,-1.21H541.91z"
				},
				{
					"id":"HK-ST",
					"title":"Sha Tin",
					"d":"M390.33,219.89L386.51,219.89L382.26,221.26L381.84,223.08L376.31,224L376.31,224L369.51,224.46L369.51,224.46L368.24,223.54L366.11,227.2L363.56,227.65L362.29,225.83L360.59,225.83L359.74,226.74L360.08,229.48L355.07,230.4L352.09,229.48L348.27,231.31L348.27,231.31L342.75,231.31L341.47,233.59L341.47,233.59L333.82,233.59L331.27,231.31L327.02,234.96L323.19,233.13L321.08,234.05L319.38,233.13L318.1,235.42L315.55,235.42L315.55,235.42L315.55,235.42L315.55,235.42L313,233.13L313,231.76L310.03,230.4L309.18,221.26L313.42,216.69L313.85,215.32L312.15,211.21L313,208.93L315.12,207.56L312.58,204.36L313.42,202.07L315.97,201.62L317.25,200.25L317.25,197.51L317.25,197.51L319.38,195.22L324.05,193.85L335.52,181.51L334.67,175.57L336.37,174.66L336.37,171.46L335.95,168.26L334.24,166.43L334.67,162.59L334.67,162.59L341.1,161.97L343.38,159.28L353.12,159.58L354.12,156.44L367.05,156.4L369.33,148.08L370.28,148.08L371.98,150.95L372.88,147.46L376.21,147.84L377.23,146.34L377.23,146.34L380.99,150.26L384.35,150.26L383.79,158.7L382.39,163.22L384.92,165.03L386.32,168.04L375.66,178.9L374.55,181.61L372.86,181.92L368.94,187.64L365.85,189.75L361.92,196.09L357.16,201.21L361.92,198.5L363.61,195.18L374.26,184.93L375.66,181.92L382.39,175.58L387.72,168.65L390.52,168.35L389.68,165.03L391.92,155.08L392.76,155.08L393.05,152.06L396.13,146.34L399.78,145.13L402.86,146.34L403.42,144.53L407.9,141.81L407.9,139.1L406.22,137.89L406.22,136.69L408.19,136.99L409.3,135.18L412.11,135.48L414.07,137.89L415.75,136.99L417.16,137.59L413.51,140.31L413.51,141.81L414.92,142.11L414.92,142.11L417.53,141.75L416.25,145.87L418.38,146.78L416.67,160.49L420.5,162.78L420.5,168.26L422.2,170.09L423.05,173.74L421.35,177.4L421.35,181.97L421.35,181.97L421.35,186.08L423.05,189.28L415.4,189.28L416.25,192.02L413.28,196.59L411.15,197.05L408.6,201.62L402.23,205.73L396.71,206.18L395,207.56L391.61,214.41L392.03,219.89z"
				},
				{
					"id":"HK-EA",
					"title":"Eastern",
					"d":"M346.51,302.46L346.79,301.25L351.28,300.95L354.08,298.84L356.6,299.45L357.16,297.34L359.97,295.83L362.21,292.82L367.82,290.41L371.18,290.71L371.46,289.8L374.82,291.31L377.35,291.01L378.47,292.52L382.11,292.52L385.48,295.23L390.52,296.74L395.01,299.75L395.57,302.46L397.25,303.66L404.55,301.56L410.99,307.58L411.83,311.5L414.07,313L411.83,317.22L412.11,319.03L414.63,317.22L415.19,314.21L416.59,317.22L421.64,319.93L421.92,321.44L426.69,325.65L424.73,333.78L426.13,336.19L423.05,341.01L421.08,340.11L419.73,341.88L419.73,341.88L416.25,334.96L413.28,334.5L410.73,332.22L407.32,331.31L400.1,333.59L397.55,330.85L389.48,330.4L385.23,329.03L383.53,326.74L378.86,327.2L375.04,329.03L372.91,328.11L369.51,329.48L367.03,329.23L367.03,329.23L367.99,322.53L375.33,316.7L375.27,313.43L370.36,308.94L369.51,311.21L366.66,312.96L364.1,309.99L361.02,303L356.13,305.45L354.04,303.18z"
				},
				{
					"id":"HK-CW",
					"title":"Central and Western",
					"d":"M335.47,304.57l1.36,3.12l-0.03,3.99l-1.66,1.79l-0.86,10.04l-2.13,3.65l0,0l-1.72,1.41l-3.4,0.46l-5.52,-2.28l-1.7,3.65l-5.52,3.19l-1.28,-0.91l0.42,-2.74l-2.97,-2.74l0.42,-1.37l-2.13,-4.11l-6.37,-8.22l-2.98,-1.83h-4.67l-3.4,1.83l-5.1,0.08l0,0l-2.24,-2.09l0.56,-4.52l1.68,-2.41l7.01,-2.41l0.56,-2.41l5.89,-1.81l1.96,-2.41l3.09,0.3l3.08,-1.51l7.02,0.3l3.37,1.51l2.52,-1.21l1.4,2.11h7.57l-0.28,4.82l5.04,1.51L335.47,304.57zM281.75,300.05l1.4,2.11l-3.92,1.21l-0.29,-2.11L281.75,300.05z"
				},
				{
					"id":"HK-WC",
					"title":"Wan Chai",
					"d":"M367.03,329.23L354.67,333.1L349.57,332.19L347.87,330.36L346.17,330.36L344.48,332.19L338.95,330.81L332.15,327.16L332.15,327.16L334.27,323.51L335.13,313.47L336.79,311.68L336.82,307.68L335.47,304.57L335.47,304.57L339.78,304.27L340.06,300.95L343.15,300.95L343.98,303.36L346.51,302.46L346.51,302.46L354.04,303.18L356.13,305.45L361.02,303L364.1,309.99L366.66,312.96L369.51,311.21L370.36,308.94L375.27,313.43L375.33,316.7L367.99,322.53z"
				},
				{
					"id":"HK-SK",
					"title":"Sai Kung",
					"d":"M444.91,216.88l2.8,1.81l0.56,2.41l-1.12,1.51l0.28,2.71l-1.96,1.51l-0.28,3.01h-0.84l-1.69,-1.21l-1.68,-3.62l-1.96,0.3l1.4,-2.71l-6.17,0.3l0.56,-3.31l3.37,-1.81l1.12,-3.92l-0.56,-1.51l-3.64,-0.3l0.56,-3.62l-2.24,-1.51l-0.85,4.83l-2.24,-0.9l-0.56,6.33h-2.8l-0.28,0.9l2.24,4.22l-6.73,3.31h6.17l1.12,-2.71l0.84,1.81l2.24,0.6l3.09,3.02l2.8,0.6l-0.56,3.01l-2.24,3.31l0.28,4.82l0.85,2.71l2.23,0.6l1.41,3.32l-0.29,3.31l1.66,2.41l-0.25,6.63l4.48,1.2l1.96,2.71l5.89,-2.11l3.36,1.81l1.69,-1.51l1.12,8.14l2.25,0.9v3.32l-1.69,3.01h1.96l0.29,3.01l2.24,-0.3l-0.29,-2.71l2.81,-2.71l1.96,0.6l0.56,-0.9l1.39,0.6l0.29,-0.9h1.68l1.12,1.51l-0.28,1.81l7.57,7.23v3.31l-1.68,0.3l0.56,4.52l-1.4,1.5h-3.37l-2.8,2.11l-1.4,3.31l-7.29,-1.2l-1.4,-0.9v-2.11h-2.8l-2.24,2.41l0.28,2.71l2.24,-0.6l-0.56,2.41l-2.52,1.21l1.4,3.61l6.17,0.3l0.84,0.6l-0.56,2.4l0.84,0.01l3.09,-3.61l3.64,0.3l-2.52,1.81l0.28,3.01l1.4,4.22l1.96,0.9v2.11l1.4,-0.9l1.96,0.9l-0.83,3.61l-3.09,1.21l-2.8,-2.11v5.42l-1.96,1.2l-2.21,-1.81l-1.43,-3.61l-5.33,-2.41l-0.56,-2.71l-7.57,-1.5l0.56,2.71l-2.8,1.51v3.01l-3.37,3.31l-1.13,-1.2l-2.52,0.3l0.28,-1.81l-3.93,-6.02l2.53,-2.71l3.37,0.3v-1.21l-3.37,-1.2l1.4,-2.71l-5.04,3.31l-2.8,-0.6l-1.12,-1.51l0.56,-2.71l2.24,-2.41l-0.56,-3.01l2.25,-4.52l-0.29,-4.52l-2.52,-2.11l0.28,-2.11l-2.24,-3.31l-0.29,-2.71l-6.17,-0.9l0.29,-2.11l-0.85,-0.6l-1.68,0.3l0.84,5.42l-3.37,1.81l-6.17,7.23l0.56,1.21l-3.64,3.31l0,0l-1.38,0.37l-1.7,-2.74l1.7,-2.28l-1.27,-4.57l0.85,-1.37l3.39,0.91l-0.42,-4.11l-1.27,-1.37v-2.74l-3.4,-2.28l-0.85,-2.74l2.13,-1.37l3.4,-5.48l-1.7,-1.83l-2.98,-0.45l2.13,-2.28l0.85,-3.65l-1.28,-0.46l-0.85,1.37h-1.7l-3.4,-2.28h-1.69l-5.53,-12.79l-5.94,0.46l0,0l0,0l0,0l0.36,-4.14l-2.35,-15.34l0.29,-8.39l0,0h1.7l-0.42,-5.48l3.39,-6.85l1.7,-1.37l5.52,-0.46l6.38,-4.11l2.55,-4.57l2.13,-0.46l2.97,-4.57l-0.85,-2.74h7.65l-1.7,-3.2v-4.11l0,0l5.53,-4.57h14.87l5.52,-5.48l3.83,0.91l1.28,-2.74l3.82,-3.66l1.7,-7.31l5.1,-1.37l3.4,1.37l2.55,-0.92l4.67,0.92l2.55,-1.83l-1.28,-1.83l2.13,-3.2l-0.85,-4.57l2.97,-2.29l9.35,1.83l2.12,2.74l2.55,0.46l1.28,0.91l-2.56,2.29l1.7,2.29l6.8,4.11l4.24,-0.45l2.99,-4.12l1.28,0.46l7.22,8.68h3.4l2.55,1.37v2.74l1.28,0.91l2.97,-0.46l5.53,-5.03l1.27,-2.74l2.97,-1.83v-2.74l2.98,-8.23l-2.55,-2.74l0.85,-4.57l-2.97,-3.2l1.27,-2.74l-0.85,-3.66l0.42,-1.37l2.55,-0.91l1.05,1.13l0,0l1.4,4.03l1.69,0.91l3.08,-0.3l2.25,-1.81l0.84,2.11l3.93,0.9l5.32,-2.71l3.93,0.3l1.68,-3.02l0.29,4.83l2.53,-1.51l1.4,3.62h3.36l0.55,-1.51l1.96,0.6l-3.37,3.02v2.41l-3.08,2.11l2.24,2.71l-0.28,4.52l1.68,0.91l0.28,1.51l3.64,0.6l2.24,7.54l-1.96,1.21l-4.77,0.3l-1.4,-2.72l-3.08,-1.51l-1.96,-5.43l-3.64,0.91l-3.65,-1.81l-3.08,4.82l-1.96,-0.6l-2.24,3.32l1.12,5.13l-1.12,0.3l-1.96,-2.11l-1.69,1.81l0.85,1.81l-0.56,5.73l-5.33,3.32l2.24,1.51l0.29,1.81h1.39l0.85,-1.51l1.39,0.6l0.29,-1.51h1.13l1.4,2.71l1.96,-0.3l1.68,3.01v2.71l1.96,-0.3l0.85,2.41l2.52,-2.11v1.8l1.69,-0.29l1.96,1.21v7.84l1.4,4.22l-4.49,1.81l3.64,5.42l0.56,2.71l-1.68,3.31l-3.37,-0.3l-4.49,-8.44v-2.41l-2.52,2.11l-3.37,-2.11l-1.4,2.11l0.84,3.92l5.04,3.02l0.28,2.71l-1.69,2.11l-2.8,-0.3l-1.96,3.62l3.37,0.6l1.12,1.51l-4.2,0.3l0.28,1.51l-1.4,0.91l-0.28,2.1l-2.25,0.01l-0.28,1.51l-6.17,-3.02l-1.12,2.41l2.8,0.61l0.85,1.2l-0.28,1.51l-1.4,-0.6l-0.56,1.51l-4.48,-3.62l-1.4,0.6v7.23l1.12,0.6l0.56,3.31l-1.68,0.61l-1.13,4.82l-2.53,0.91l-1.4,-1.51l-0.28,-5.42l-1.69,-1.2l-0.55,-4.22l-1.13,-0.6l0.84,-1.2l-0.56,-2.11l1.12,-0.91l-0.56,-3.62l-1.12,0.3v1.21h-1.4v3.31l-1.4,0.6l-0.85,-1.2l-1.68,0.3l-2.24,3.92l-4.49,-5.12l-1.11,-3.01l-0.01,-0.9l3.65,0.3l-0.56,-2.11l-1.96,-0.3l-1.96,-2.41h-2.8l-3.08,-3.62l-0.28,-1.81l1.69,-0.91v-2.71l1.12,-0.3l-0.56,-1.81l1.12,-1.51l0.56,-7.54l-2.53,1.81l-2.24,-1.81l-3.37,-0.6l-3.93,-3.02l-0.55,-2.71l-3.93,2.11l-0.56,-2.11l1.12,-3.02l-2.25,3.02l-2.24,-1.2l1.69,-4.22h1.12v-4.22l1.4,-0.3l-1.12,-0.91l-7.01,1.21l-0.28,2.71l-1.69,2.11l1.96,2.41l-0.28,1.21l-3.09,-0.6l-2.8,1.51l-0.55,-1.81h-1.69l-3.64,1.81l-0.29,-2.71l-1.96,-3.02l-2.24,1.21l-3.36,-0.6l-3.08,-6.33l-3.93,-0.91l-1.96,2.71l-3.64,-1.5l-1.96,5.13l1.13,5.4l-5.89,6.06l0.29,0.91l1.96,-0.3l1.36,2.71l-3.04,5.12l-0.28,2.71l1.12,3.92L444.91,216.88zM469.58,203.02l0.56,-5.73l1.69,-0.6l3.92,1.51l0.56,5.12l1.69,-2.41l-0.85,-4.22l1.96,1.51l4.49,-0.6l0.28,1.51l-1.4,2.41l1.96,-1.81l2.8,-0.3l1.12,2.41l-1.4,2.41l0.28,2.11l2.24,2.71l1.12,3.92l-1.12,5.12l8.42,4.82l-1.69,9.35l-2.24,0.9l0.84,2.11l-0.56,3.62l1.96,1.2l4.49,7.53v3.02l-0.29,3.92h-1.96l-1.69,2.41l-2.24,-1.51l-5.05,0.6l-2.52,-9.94l-1.69,-2.71l1.13,-4.52h1.68l0.29,-1.21h-1.96l-1.4,-2.41l-1.4,-0.3l-0.84,2.41l-1.4,0.6l-6.45,-5.43l-1.96,-4.82l0.56,-2.71l1.4,-0.6l0.84,-2.11l-0.84,-3.32l1.13,-1.51l-1.96,-4.82l-3.64,-2.11L469.58,203.02zM466.21,331.68l1.68,0.6l-1.39,3.92l1.96,2.11l0.28,2.11l-2.24,2.11l-0.84,5.42l-5.05,-0.6l-0.56,3.91l-2.52,1.2l-1.4,-1.2l1.4,-2.41l-0.84,-1.21l-2.53,-0.3l-4.49,-2.71l0.56,-3.31l-0.84,-2.11l5.89,-5.72l0.84,1.2h2.24v-1.5l3.93,-2.11l0.28,-1.2l3.63,-0.9V331.68zM536.87,260.28l-0.29,2.71l2.24,1.51l1.13,2.71l-0.56,2.71l2.8,1.51l-1.12,2.11l-2.8,0.61v3.61l-3.65,-1.2l0.84,-3.31l-2.8,-1.81l-1.68,-3.92l0.56,-4.52l2.24,-0.3L536.87,260.28zM464.26,203.92l1.68,1.21h-3.64l1.4,2.41l-0.29,2.11l1.96,1.51v1.51l1.96,0.3v2.11l-1.96,1.51l1.69,7.23l-1.13,3.62l-1.4,-0.6l1.13,-3.62l-1.69,-1.2l-1.4,0.3l-0.56,-6.03l-5.32,-4.52l3.08,-2.41l0.28,-3.31l1.41,-2.11l3.08,-1.2L464.26,203.92zM527.05,256.36l0.29,1.19l-3.37,4.23l-0.29,4.52l-1.68,0.3l-0.29,1.2h-2.24l-0.56,-0.9l-0.28,3.62h-1.39l-1.13,-1.81v-3.01l1.69,-1.81l0.84,-4.52l1.68,-1.81h1.96l1.13,1.21l1.68,-2.41H527.05zM535.46,243.71l0.28,-1.81l3.08,1.21l-1.12,4.22l-1.13,0.6l1.13,3.32l-1.13,2.41l-3.08,-1.81h-3.09l1.13,-2.71l-0.84,-0.6l0.55,-5.42l2.53,-0.9L535.46,243.71zM464.81,250.03l7.29,6.63l0.28,3.31l-0.84,0.91l-5.61,-0.91l-1.96,-1.51l-1.68,-4.52l0.56,-3.31L464.81,250.03zM492.85,201.21l6.45,3.32l0.56,2.41l-0.29,1.51h-1.12l0.28,4.22l-1.69,1.2l-0.55,-3.92l-0.85,-0.3l0.56,-4.22l-1.96,-1.2v2.11l-1.4,1.81l-2.52,-2.41l0.84,-2.11l-0.56,-1.81L492.85,201.21zM521.17,315.11l0.55,2.71l-1.96,3.01v2.71l-1.96,1.51H515l1.4,-5.42L521.17,315.11zM540.78,246.42l0.57,1.81l7.57,5.12l-0.56,1.51l-6.45,-1.2l-1.13,-5.73l-0.84,-0.3L540.78,246.42zM522.57,326.25l1.12,3.91l-0.28,3.92l-4.49,1.2l-0.84,-4.82l2.8,0.3l0.56,-3.92L522.57,326.25zM484.44,308.79l1.4,3.92l-1.96,0.9l-2.24,-3.01L484.44,308.79zM504.34,243.71l1.96,3.62l-3.37,0.9l-0.84,-2.11L504.34,243.71zM449.96,195.78l2.52,1.51l-0.28,2.11l-1.68,-0.3l-0.28,-1.51l-1.12,0.3l-0.56,-1.81L449.96,195.78zM539.39,255.16l0.84,1.81l-3.64,0.3l0.29,-1.51L539.39,255.16zM556.49,171.97l0.56,3.32h-1.13l-0.55,-3.02L556.49,171.97zM515.84,332.58l1.96,3.01l-2.25,-0.6L515.84,332.58zM539.95,320.83l1.4,3.01l-2.24,-1.81L539.95,320.83zM456.13,202.11v2.11l-1.96,0.3l-0.29,-0.91L456.13,202.11zM599.1,103.21l0.85,2.72l-2.25,-1.81v-0.9H599.1zM457.81,197.59l1.13,0.6V200l-1.96,-1.51L457.81,197.59zM456.69,215.08l-0.56,2.11l-1.12,-1.2L456.69,215.08z"
				},
				{
					"id":"HK-SO",
					"title":"Southern",
					"d":"M390.81,389.49l2.8,4.82l-0.56,3.31l-10.66,1.81l-2.24,-3.01v-12.94l3.03,-3.31l0.33,-2.41l-2.8,-4.21l-3.65,1.2l-2.24,4.82l-4.21,-0.3l-1.4,2.41l-3.37,0.3l-0.56,-2.41l0.85,-3.31l4.48,-1.81l-1.4,-4.21l-3.37,-0.3l-3.64,-2.71v-1.21l2.52,1.21l1.69,-0.9l-1.4,-4.82l1.68,-0.9v-4.21l-2.52,-4.22l-4.77,2.41l-2.53,-1.81l-1.96,-3.61l1.69,-2.71l-0.56,-1.81l-8.13,0.3l-0.56,2.41l-4.2,5.72l-1.4,6.93l-1.69,0.9l-5.32,-3.61l0.56,-3.01l-1.41,-0.6l-1.68,-6.02l-1.96,-0.6l-1.12,-4.52l-15.42,-0.9l-4.48,-1.21l-3.09,0.9l-2.24,-0.6l-1.69,-3.31l-2.24,-1.21l-0.56,-4.82l-2.52,-1.81l-6.45,-13.25l-4.2,-2.73l0,0l5.1,-0.08l3.4,-1.83h4.67l2.98,1.83l6.37,8.22l2.13,4.11l-0.42,1.37l2.97,2.74l-0.42,2.74l1.28,0.91l5.52,-3.19l1.7,-3.65l5.52,2.28l3.4,-0.46l1.72,-1.41l0,0l6.8,3.65l5.53,1.37l1.69,-1.83h1.7l1.7,1.83l5.1,0.91l12.36,-3.87l0,0l2.48,0.26l3.4,-1.37l2.13,0.91l3.82,-1.83l4.67,-0.46l1.7,2.28l4.25,1.37l8.07,0.45l2.55,2.74l7.22,-2.28l3.4,0.91l2.55,2.28l2.97,0.46l3.48,6.92l0,0l-0.89,1.24l-2.52,-0.6l-0.29,0.9l2.25,3.61l2.24,0.9l-0.29,2.71l3.09,3.31l-1.96,4.82l2.24,0.9l6.45,-0.3l-1.4,2.41l-2.8,-0.6l-0.29,1.2h-2.8l-1.96,-0.9l-1.12,1.51l4.77,7.53v10.83l3.92,-0.6l0.56,1.81l1.96,0.9l-0.56,5.12l-2.53,-0.9l1.41,-2.71l-2.81,0.3l-1.12,-0.9l-0.84,2.1h-1.69l-1.13,-1.5l-5.88,1.21l-4.49,-2.11l-0.84,-3.01l1.69,-2.41l-1.13,-4.82l-3.09,-0.3l-3.64,-4.82l1.4,-4.52l-1.12,-1.2v-4.82l-1.69,-3.31l0.84,-3.61l-3.64,-3.01l-4.77,0.9l-1.13,-5.42l-1.68,-0.9v5.72h1.68l3.93,3.31l0.84,8.43l-3.59,1.2l-2.86,-3.61l-1.96,3.31l-3.37,0.6l-0.28,3.31l-2.24,1.5l-0.85,2.41l0.29,3.01l7.85,4.81l-0.28,3.31l-1.4,-0.3l-0.85,2.41l-1.68,0.6L390.81,389.49zM326.32,343.42l3.93,6.02l-1.68,6.93l1.68,0.9l0.56,4.82l-2.8,-1.81l-1.12,-4.52l-4.77,-1.21l-1.12,-3.31l-2.8,0.9v-1.2h-1.96l-1.13,-3.92l-1.4,-0.9l1.96,-2.11l5.88,0.6L326.32,343.42zM356.04,353.06l2.24,2.71l-1.68,1.81l-4.21,0.9l-2.24,-2.71l0.29,-1.51L356.04,353.06zM353.52,373.84l2.8,1.5l0.29,2.71h-3.65l-1.12,-3.92L353.52,373.84zM428.37,364.2l-0.28,2.11L425,365.1l0.56,-0.9H428.37z"
				}
			]
		}
	}
};