/**
 * JavaScript for managing quiz categories
 */
$(function() {
    var rowCounter = $('.config-row').length;
    
    // Add new category row
    $('#add-category-row').click(function() {
        addCategoryRow();
    });
    
    // Remove category row
    $(document).on('click', '.remove-row', function() {
        var row = $(this).closest('tr');
        if ($('.config-row').length > 1) {
            row.remove();
            updateIndices();
        } else {
            alert('At least one category must be configured.');
        }
    });
    
    // Category selection change handler
    $(document).on('change', '.category-select', function() {
        var questionCount = $(this).find('option:selected').data('question-count') || 0;
        var row = $(this).closest('tr');
        
        // Update the question count badge
        row.find('.question-count').text(questionCount);
        
        // Update the max value of the number input
        row.find('.num-questions').attr('max', questionCount);
        
        // If the current value is greater than the max, reset it to the max
        var numQuestions = row.find('.num-questions');
        if (parseInt(numQuestions.val()) > questionCount) {
            numQuestions.val(questionCount);
        }
    });
    
    // Function to add a new category row
    function addCategoryRow() {
        var template = $('#category-config-rows tr:first').clone();
        
        // Reset the values
        template.find('select').val('');
        template.find('input[type="number"]').val(1);
        template.find('input[type="checkbox"]').prop('checked', true);
        template.find('.question-count').text('0');
        
        // Update the checkbox name
        template.find('input[type="checkbox"]').attr('name', 'random_selection[' + rowCounter + ']');
        
        // Append to the table
        $('#category-config-rows').append(template);
        rowCounter++;
    }
    
    // Update checkbox names when rows are removed
    function updateIndices() {
        $('.config-row').each(function(index) {
            $(this).find('input[type="checkbox"]').attr('name', 'random_selection[' + index + ']');
        });
        rowCounter = $('.config-row').length;
    }
});
