<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <?= $page_title; ?> <small></small>
        </h3>
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="<?= site_url($this->admin_path); ?>">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <?php
            foreach ($this->breadcrumbs->get() as $breadcrumb) {
                if (!isset($breadcrumb['active'])) { 
                    echo '<li>'
                    . '<a href="' . $breadcrumb["uri"] . '">' . $breadcrumb["name"] . '</a>'
                    . '<i class="fa fa-angle-right"></i>'
                    . '</li>';
                } else {
                    echo '<li class="active">'
                    . $breadcrumb["name"]
                    . '</li>';
                }
            }
            ?>
        </ul>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->
<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet box light-grey">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-globe"></i>Custom Quiz Assignments
                </div>
                <div class="tools">
                    <a href="javascript:;" class="collapse"></a>
                </div>
            </div>
            <div class="portlet-body">
                <?php if (!isset($dt_params['hide_add_button']) || !$dt_params['hide_add_button']) { ?>
                    <div class="clearfix">
                        <div class="btn-group">
                            <a id="sample_editable_1_new" class="btn green" href="<?= base_url() . $this->router->fetch_class() . '/add/' ?>">
                                Add New <i class="fa fa-plus"></i>
                            </a>
                        </div>
                    </div>
                <?php } ?>
                <table class="table table-striped table-bordered table-hover table-dt" id="sample_5">
                    <thead>
                        <tr>
                            <?php if (!$dt_params['hide']) { ?>
                                <?php foreach ($dt_params['dt_headings'] as $field_name => $val) { ?>
                                    <th><?= $val ?></th>
                                <?php } ?>
                                <?php if (isset($dt_params['action'])) { ?>
                                    <th style="<?= isset($dt_params['action']['width']) ? "width:" . $dt_params['action']['width'] . ";" : ""; ?> text-align:center;">Actions</th>
                                <?php } ?>
                            <?php } ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!$dt_params['hide'] && !empty($table_data)) { ?>
                            <?php foreach ($table_data as $key => $row) { ?>
                                <tr class="odd gradeX">
                                    <?php foreach ($dt_params['dt_headings'] as $field_name => $val) { ?>
                                        <td><?= $class->prepare_datatables_items($field_name, $row) ?></td>
                                    <?php } ?>
                                    <?php if (isset($dt_params['action'])) { ?>
                                        <td style="text-align:center;">
                                            <?php if (isset($dt_params['action']['extra']) && is_array($dt_params['action']['extra'])) { ?>
                                                <?php foreach ($dt_params['action']['extra'] as $text => $action) { ?>
                                                    <?= sprintf($action, $row[$class->model_obj->get_pk()]); ?>
                                                <?php } ?>
                                            <?php } ?>
                                            <?php if (!$dt_params['action']['hide']) { ?>
                                                <?php if (!$dt_params['action']['show_delete'] === false) { ?>
                                                    <a class="btn btn-icon-only red" href="javascript:;" onClick="doDelete('<?= base_url() . $this->router->fetch_class() . '/delete/' . $row[$class->model_obj->get_pk()] ?>')"><i class="fa fa-trash"></i></a>
                                                <?php } ?>
                                                <?php if (!$dt_params['action']['show_edit'] === false) { ?>
                                                    <a class="btn btn-icon-only green" href="<?= base_url() . $this->router->fetch_class() . '/update/' . $row[$class->model_obj->get_pk()] ?>"><i class="fa fa-edit"></i></a>
                                                <?php } ?>
                                                <?php if (isset($dt_params['action']['show_view']) && !$dt_params['action']['show_view'] === false) { ?>
                                                    <a class="btn btn-icon-only blue" href="<?= base_url() . $this->router->fetch_class() . '/view/' . $row[$class->model_obj->get_pk()] ?>"><i class="fa fa-search"></i></a>
                                                <?php } ?>
                                            <?php } ?>
                                        </td>
                                    <?php } ?>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
