<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            <?= $page_title; ?> <small></small>
        </h3>
        <ul class="page-breadcrumb breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="<?= site_url($this->admin_path); ?>">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <?php
            foreach ($this->breadcrumbs->get() as $breadcrumb) {
                if (!isset($breadcrumb['active'])) { 
                    echo '<li>'
                    . '<a href="' . $breadcrumb["uri"] . '">' . $breadcrumb["name"] . '</a>'
                    . '<i class="fa fa-angle-right"></i>'
                    . '</li>';
                } else {
                    echo '<li class="active">'
                    . $breadcrumb["name"]
                    . '</li>';
                }
            }
            ?>
        </ul>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>

<!-- BEGIN FORM-->
<div class="form-body">
    <div class="form-group">
        <label class="control-label col-md-3"><?= lang('forms.quiz_id') ?><?= mandatory() ?></label>
        <div class="col-md-4">
            <?= form_dropdown_dt('quiz_id', $form_fields['quiz_id']['list_data'], form_dt_value('quiz_id', $form_fields), 'class="form-control" id="quiz_dropdown"') ?>
            <span class="help-block"></span>
        </div>
    </div>
    
    <div class="form-group">
        <label class="control-label col-md-3"><?= lang('forms.user_id') ?><?= mandatory() ?></label>
        <div class="col-md-4">
            <?= form_dropdown_dt('user_id', $form_fields['user_id']['list_data'], form_dt_value('user_id', $form_fields), 'class="form-control" id="user_dropdown"') ?>
            <span class="help-block"></span>
        </div>
    </div>
    
    <div class="form-group">
        <label class="control-label col-md-3"><?= lang('forms.group_id') ?></label>
        <div class="col-md-4">
            <?= form_dropdown_dt('group_id', $form_fields['group_id']['list_data'] ?? [], form_dt_value('group_id', $form_fields), 'class="form-control" id="group_dropdown"') ?>
            <span class="help-block"></span>
        </div>
    </div>
    
    <div class="form-group">
        <label class="control-label col-md-3"><?= lang('forms.due_date') ?><?= mandatory() ?></label>
        <div class="col-md-4">
            <div class="input-group date date-picker" data-date-format="yyyy-mm-dd">
                <?= form_input_dt('due_date', form_dt_value('due_date', $form_fields), 'class="form-control" readonly') ?>
                <span class="input-group-btn">
                    <button class="btn default" type="button"><i class="fa fa-calendar"></i></button>
                </span>
            </div>
            <span class="help-block"></span>
        </div>
    </div>
    
    <div class="form-group">
        <label class="control-label col-md-3"><?= lang('forms.penalty_rate') ?></label>
        <div class="col-md-4">
            <?= form_input_dt('penalty_rate', form_dt_value('penalty_rate', $form_fields), 'class="form-control" type="number" min="0" max="100" step="0.1"') ?>
            <span class="help-block">Penalty percentage per day of late submission</span>
        </div>
    </div>
</div>

<script>
// Script to load quiz information when selected
$(document).ready(function() {
    $('#quiz_dropdown').change(function() {
        var quiz_id = $(this).val();
        if(quiz_id) {
            // Here additional information about the quiz could be loaded
            // For example, using AJAX to get default dates
            $.ajax({
                url: '<?= base_url("admin/quiz/get_quiz_details") ?>/' + quiz_id,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    if(data && data.quiz_enddate) {
                        $('input[name="due_date"]').val(data.quiz_enddate);
                    }
                    if(data && data.quiz_daily_penalty) {
                        $('input[name="penalty_rate"]').val(data.quiz_daily_penalty);
                    }
                }
            });
        }
    });
});
</script>
