<!-- MANAGE QUESTIONS IN CATEGORY VIEW -->
<div class="row">
    <div class="col-md-12">
        <div class="portlet">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-list"></i> Manage Questions for: <?= $category['qc_name'] ?>
                </div>
                <div class="actions">
                    <a href="<?= base_url('admin/quiz_categories') ?>" class="btn btn-default btn-sm" data-toggle="tooltip" title="Back to Categories">
                        <i class="fa fa-arrow-left"></i> Back
                    </a>
                    <button id="btn-add-questions" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Add Questions">
                        <i class="fa fa-plus"></i> Add Questions
                    </button>
                </div>
            </div>
            <div class="portlet-body">
        <div class="row">
            <div class="col-md-12">
                <div class="callout callout-info">
                    <h4><?= $category['qc_name'] ?></h4>
                    <p><?= $category['qc_description'] ?></p>
                    <p>
                        <strong>Course:</strong> <?= $category['course_title'] ?> | 
                        <strong>Subject:</strong> <?= $category['course_subject_name'] ?>
                    </p>
                </div>
            </div>
        </div>

        <table id="category-questions-table" class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th width="5%">ID</th>
                    <th width="40%">Question</th>
                    <th width="15%">Type</th>
                    <th width="15%">Course</th>
                    <th width="15%">Subject</th>
                    <th width="10%">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($category_questions)) : ?>
                    <?php foreach ($category_questions as $question) : ?>
                        <tr data-question-id="<?= $question['qb_id'] ?>">
                            <td><?= $question['qb_id'] ?></td>
                            <td><?= $question['qb_text'] ?></td>
                            <td><?= $question['type'] ?></td>
                            <td><?= $question['qb_course_id'] ?></td>
                            <td><?= $question['qb_subject_id'] ?></td>
                            <td>
                                <button type="button" class="btn btn-danger btn-xs remove-question" 
                                        data-question-id="<?= $question['qb_id'] ?>" data-category-id="<?= $category['qc_id'] ?>">
                                    <i class="fa fa-trash"></i> Remove
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="6" class="text-center">No questions in this category yet.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal for adding questions -->
<div class="modal fade" id="add-questions-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Add Questions to Category</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Course:</label>
                            <select id="filter-course" class="form-control">
                                <option value="">All Courses</option>
                                <?php foreach ($this->_list_data['qc_course_id'] as $key => $value) : ?>
                                    <option value="<?= $key ?>" <?= ($key == $course_id) ? 'selected' : '' ?>><?= $value ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Subject:</label>
                            <select id="filter-subject" class="form-control">
                                <option value="">All Subjects</option>
                                <?php foreach ($this->_list_data['qc_subject_id'] as $key => $value) : ?>
                                    <option value="<?= $key ?>" <?= ($key == $subject_id) ? 'selected' : '' ?>><?= $value ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <table id="available-questions-table" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">
                                        <input type="checkbox" id="select-all-questions">
                                    </th>
                                    <th width="5%">ID</th>
                                    <th width="50%">Question</th>
                                    <th width="15%">Type</th>
                                    <th width="15%">Course</th>
                                    <th width="15%">Subject</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Will be populated via AJAX -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" id="btn-confirm-add-questions" class="btn btn-primary">Add Selected Questions</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(function() {
        $('[data-toggle="tooltip"]').tooltip();

        var categoryId = <?= $category['qc_id'] ?>;
        var courseId = <?= $course_id ?>;
        var subjectId = <?= $subject_id ?>;
        var questionsTable;
        var availableQuestionsTable;

        // Initialize DataTable only if table has real question rows
        var hasDataRows = $('#category-questions-table tbody tr').filter(function() {
            return $(this).find('td').length > 1; // more than placeholder cell
        }).length > 0;

        if (hasDataRows) {
            questionsTable = $('#category-questions-table').DataTable({
                "paging": true,
                "lengthChange": true,
                "searching": true,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "columnDefs": [
                    { "orderable": false, "targets": 5 }
                ]
            });
        }

        // Add questions button click handler
        $('#btn-add-questions').click(function() {
            loadAvailableQuestions();
            $('#add-questions-modal').modal('show');
        });

        // --- DataTable para preguntas disponibles (modal) ---
        function loadAvailableQuestions() {
            if (availableQuestionsTable) {
                availableQuestionsTable.destroy();
            }
            availableQuestionsTable = $('#available-questions-table').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": "<?= base_url('admin/question_bank/get_available_questions_json') ?>",
                    "type": "POST",
                    "data": function(d) {
                        d.course_id = $('#filter-course').val();
                        d.subject_id = $('#filter-subject').val();
                        d.category_id = categoryId;
                    }
                },
                "columns": [
                    { "data": "qb_id", "orderable": false, "render": function(data) {
                        return '<input type="checkbox" class="question-checkbox" value="' + data + '">';
                    } },
                    { "data": "qb_id" },
                    { "data": "qb_text" },
                    { "data": "type" },
                    { "data": "course_title" },
                    { "data": "subject_name" }
                ],
                "drawCallback": function(settings) {
                    $('#select-all-questions').prop('checked', false);
                },
                "dom": "tipfl",
                "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
                "searching": false
            });
        }

        // Recarga la tabla cuando cambian los filtros
        $('#filter-course, #filter-subject').on('change', function() {
            if (availableQuestionsTable) {
                availableQuestionsTable.ajax.reload();
            }
        });
        // Select all questions checkbox
        $('#select-all-questions').on('change', function() {
            $('#available-questions-table tbody input[type="checkbox"]').prop('checked', this.checked);
        });

        // Confirm adding questions
        $('#btn-confirm-add-questions').click(function() {
            var selectedQuestions = [];
            $('#available-questions-table tbody input[type="checkbox"]:checked').each(function() {
                selectedQuestions.push($(this).val());
            });

            if (selectedQuestions.length === 0) {
                alert('Please select at least one question to add.');
                return;
            }

            // Add the selected questions to the category
            $.ajax({
                url: '<?= base_url('admin/quiz_categories/add_questions') ?>',
                type: 'POST',
                data: {
                    category_id: categoryId,
                    question_ids: selectedQuestions
                },
                dataType: 'json',
                success: function(response) {
                    if (response.status) {
                        $('#add-questions-modal').modal('hide');
                        alert(response.message);
                        location.reload(); // Reload to show updated list
                    } else {
                        alert('Error: ' + response.message);
                    }
                },
                error: function() {
                    alert('An error occurred while adding questions.');
                }
            });
        });

        // Remove question button click handler
        $(document).on('click', '.remove-question', function() {
            var questionId = $(this).data('question-id');
            var row = $(this).closest('tr');

            if (confirm('Are you sure you want to remove this question from the category?')) {
                $.ajax({
                    url: '<?= base_url('admin/quiz_categories/remove_question') ?>',
                    type: 'POST',
                    data: {
                        category_id: categoryId,
                        question_id: questionId
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.status) {
                            row.remove();
                            questionsTable.row(row).remove().draw();
                        } else {
                            alert('Error removing question');
                        }
                    },
                    error: function() {
                        alert('An error occurred while removing the question.');
                    }
                });
            }
        });
    });
</script>
