<!-- CATEGORY LIST VIEW -->

<?php if($this->session->flashdata("alert_msg")){?>
    <div class="alert alert-success">
        <?=$this->session->flashdata("alert_msg")?>
    </div>
<?php } ?>

<div class="box">
    <div class="box-header with-border">
        <h3 class="box-title">Quiz Categories</h3>
        <div class="box-tools pull-right">
            <a href="<?=base_url('admin/quiz_categories/add')?>" class="btn btn-primary btn-sm">
                <i class="fa fa-plus"></i> Add New Category
            </a>
        </div>
    </div>
    <div class="box-body">
        <table id="example2" class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Course</th>
                    <th>Subject</th>
                    <th>Questions</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($records as $record): ?>
                <tr>
                    <td><?=$record['qc_id']?></td>
                    <td><?=$record['qc_name']?></td>
                    <td><?=$record['course_title']?></td>
                    <td><?=$record['course_subject_name']?></td>
                    <td><?=$record['question_count']?></td>
                    <td>
                        <?php if($record['qc_status'] == 1): ?>
                        <span class="badge bg-green">Active</span>
                        <?php else: ?>
                        <span class="badge bg-red">Inactive</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?=base_url('admin/quiz_categories/add/' . $record['qc_id'])?>" 
                           class="btn btn-primary btn-xs" data-toggle="tooltip" title="Edit">
                            <i class="fa fa-pencil"></i>
                        </a>
                        <a href="<?=base_url('admin/quiz_categories/manage_questions/' . $record['qc_id'])?>" 
                           class="btn btn-info btn-xs" data-toggle="tooltip" title="Manage Questions">
                            <i class="fa fa-list"></i>
                        </a>
                        <a href="javascript:void(0)" onclick="delete_record('quiz_categories', '<?=$record['qc_id']?>')" 
                           class="btn btn-danger btn-xs" data-toggle="tooltip" title="Delete">
                            <i class="fa fa-trash"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
$(function(){
    $('#example2').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false
    });
    
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
