<!-- CATEGORY ADD/EDIT FORM VIEW -->

<?php
$form_action = $form_action ?? '';
$required = ' <span class="required">*</span>';
?>

<div class="box">
    <div class="box-header with-border">
        <h3 class="box-title"><?= $title ?? 'Quiz Category Form' ?></h3>
        <div class="box-tools pull-right">
            <a href="<?= base_url('admin/quiz_categories') ?>" class="btn btn-default btn-sm">
                <i class="fa fa-arrow-left"></i> Back to Categories
            </a>
        </div>
    </div>
    <form id="form-quiz-category" role="form" action="<?= $form_action ?>" method="post">
        <div class="box-body">
            <?php if ($this->session->flashdata('error')) { ?>
                <div class="alert alert-danger">
                    <?= $this->session->flashdata('error') ?>
                </div>
            <?php } ?>

            <?php if ($this->session->flashdata('success')) { ?>
                <div class="alert alert-success">
                    <?= $this->session->flashdata('success') ?>
                </div>
            <?php } ?>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Name <?= $required ?></label>
                        <input type="text" name="qc_name" class="form-control" placeholder="Category Name"
                               value="<?= set_value('qc_name', $form_data['qc_name'] ?? '') ?>" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Status</label>
                        <select name="qc_status" class="form-control">
                            <option value="1" <?= isset($form_data['qc_status']) && $form_data['qc_status'] == 1 ? 'selected' : '' ?>>
                                Active
                            </option>
                            <option value="0" <?= isset($form_data['qc_status']) && $form_data['qc_status'] == 0 ? 'selected' : '' ?>>
                                Inactive
                            </option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Course <?= $required ?></label>
                        <select id="qc_course_id" name="qc_course_id" class="form-control ajax-populate" 
                                data-target="qc_subject_id" required>
                            <option value="">Select Course</option>
                            <?php foreach ($this->_list_data['qc_course_id'] as $key => $value) { ?>
                                <option value="<?= $key ?>" <?= isset($form_data['qc_course_id']) && $form_data['qc_course_id'] == $key ? 'selected' : '' ?>>
                                    <?= $value ?>
                                </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Subject <?= $required ?></label>
                        <select id="qc_subject_id" name="qc_subject_id" class="form-control ajax-populate"
                                data-populate-uri="get_subjects"
                                data-uri="quiz_categories"
                                data-dd_key="course_subject_id"
                                data-dd_value="course_subject_name" required>
                            <option value="">Select Subject</option>
                            <?php foreach ($this->_list_data['qc_subject_id'] as $key => $value) { ?>
                                <option value="<?= $key ?>" <?= isset($form_data['qc_subject_id']) && $form_data['qc_subject_id'] == $key ? 'selected' : '' ?>>
                                    <?= $value ?>
                                </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Description</label>
                        <textarea name="qc_description" class="form-control" rows="4" placeholder="Category Description"><?= set_value('qc_description', $form_data['qc_description'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>

            <input type="hidden" name="qc_id" value="<?= $form_data['qc_id'] ?? '' ?>">
        </div>
        <div class="box-footer">
            <button type="submit" class="btn btn-primary pull-right">Save</button>
        </div>
    </form>
</div>

<script>
    $(function() {
        // Form validation
        $('#form-quiz-category').validate({
            rules: {
                qc_name: { required: true },
                qc_course_id: { required: true },
                qc_subject_id: { required: true }
            },
            messages: {
                qc_name: { required: "Please enter a category name" },
                qc_course_id: { required: "Please select a course" },
                qc_subject_id: { required: "Please select a subject" }
            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });

        // Course change handler to load subjects
        $('#qc_course_id').change(function() {
            var courseId = $(this).val();
            var subjectSelect = $('#qc_subject_id');
            
            // Clear the subjects dropdown
            subjectSelect.empty().append('<option value="">Select Subject</option>');
            
            if (!courseId) return;
            
            // Load subjects for this course
            $.ajax({
                url: '<?= base_url("admin/quiz_categories/get_subjects") ?>',
                type: 'POST',
                data: { search_val: courseId },
                dataType: 'json',
                success: function(data) {
                    $.each(data, function(index, item) {
                        subjectSelect.append('<option value="' + item.course_subject_id + '">' + item.course_subject_name + '</option>');
                    });
                }
            });
        });
    });
</script>
