<?global $config;
$model_heads = explode("," , $dt_params['dt_headings'] );

?>

<style type="text/css">
.fileupload-buttonbar .fade {display: none !important;}
.progress {
    position: static;
}

/* Action buttons styling */
.action-buttons {
    white-space: nowrap;
    width: 120px;
}

.action-buttons .btn-group {
    display: flex;
    justify-content: center;
}

.action-buttons .btn {
    padding: 3px 6px;
    margin: 0 3px;
}

.action-btn-container {
    display: flex;
    justify-content: space-around;
    width: 100%;
}

.action-btn-container .btn {
    margin: 0 5px;
    min-width: 28px;
}

/* Ensure table cells don't break content to multiple lines */
.dataTable td {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 200px;
}
</style>

<div class="row">
  <div class="col-md-12">
    <!-- BEGIN VALIDATION STATES-->
      <div class="tabbable tabbable-custom boxless tabbable-reversed">
        <ul class="nav nav-tabs">
              <li class="active">
                <a href="#tab_question_bank" data-toggle="tab">
                <i class="fa fa-bank"></i> Question Bank </a>
              </li>
              <li class="">
                <a href="#tab_create_question" data-toggle="tab">
                <i class="fa fa-plus-circle"></i> Create New Question </a>
              </li>
              <li class="">
                <a href="#tab_import" data-toggle="tab">
                <i class="fa fa-upload"></i> Import Questions </a>
              </li>
              <li class="">
                <a href="#tab_assigned" data-toggle="tab">
                <i class="fa fa-link"></i> Assigned Questions </a>
              </li>
              <li class="">
                <a href="#tab_0" data-toggle="tab">
                <i class="fa fa-cog"></i> Quiz Settings </a>
              </li>
            </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab_question_bank">
              <div class="portlet box blue">
                <div class="portlet-title">
                  <div class="caption">
                    <i class="fa fa-question-circle"></i>Question Bank
                        <small>Search, filter and manage all questions</small>
                  </div>
                  <div class="tools">
                    <a href="javascript:;" class="collapse"></a>
                    <a href="javascript:;" class="reload"></a>
                  </div>
                </div>
                <div class="portlet-body">
                  <!-- Filters for questions -->
                  <div class="row filter-row" style="margin-bottom: 15px;">
                    <div class="col-md-3">
                      <select id="filter_course" class="form-control" placeholder="Filter by Course">
                        <option value="">All Courses</option>
                        <?php if(isset($course_list) && is_array($course_list)): ?>
                          <?php foreach($course_list as $key => $val): ?>
                            <option value="<?=$key?>"><?=$val?></option>
                          <?php endforeach; ?>
                        <?php endif; ?>
                      </select>
                    </div>
                    <div class="col-md-3">
                      <select id="filter_subject" class="form-control" placeholder="Filter by Subject">
                        <option value="">All Subjects</option>
                        <!-- Will be populated via AJAX -->
                      </select>
                    </div>
                    <div class="col-md-3">
                      <select id="filter_type" class="form-control" placeholder="Filter by Type">
                        <option value="">All Types</option>
                        <?php 
                        $question_types = $this->model_course_quiz->question_type();
                        foreach($question_types as $key => $val): ?>
                          <option value="<?=$key?>"><?=$val?></option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                    <div class="col-md-3">
                      <div class="input-group">
                        <input type="text" id="search_questions" class="form-control" placeholder="Search questions">
                        <span class="input-group-btn">
                  </div>
                  
                  <!-- Batch actions -->
                  <div class="row" style="margin-top: 15px;">
                    <div class="col-md-12">
                      <button type="button" id="btn_assign_selected" class="btn btn-primary" disabled>
                        <i class="fa fa-link"></i> Assign Selected to Quiz
                      </button>
                      <button type="button" id="btn_copy_selected" class="btn btn-info" disabled>
                        <i class="fa fa-copy"></i> Copy Selected
                      </button>
                      <button type="button" id="btn_delete_selected" class="btn btn-danger" disabled>
                        <i class="fa fa-trash"></i> Delete Selected
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="tab-pane" id="tab_create_question">
              <div class="portlet box green">
                <div class="portlet-title">
                  <div class="caption">
                    <i class="fa fa-plus-circle"></i>Create New Question
                        <small>Add a new question to the bank</small>
                  </div>
                  <div class="tools">
                    <a href="javascript:;" class="collapse"></a>
                    <a href="javascript:;" class="reload"></a>
                  </div>
                </div>
                <div class="portlet-body">
                  <?php $this->load->view("admin/quiz_bank/_tab1"); ?>
                </div>
              </div>
            </div>
            
            <div class="tab-pane" id="tab_import">
              <div class="portlet box purple">
                <div class="portlet-title">
                  <div class="caption">
                    <i class="fa fa-upload"></i>Import Questions
                        <small>Import questions from Excel or CSV</small>
                  </div>
                  <div class="tools">
                    <a href="javascript:;" class="collapse"></a>
                    <a href="javascript:;" class="reload"></a>
                  </div>
                </div>
                <div class="portlet-body">
                  <?php $this->load->view("admin/quiz_bank/upload_excel"); ?>
                </div>
              </div>
            </div>
            
            <div class="tab-pane" id="tab_assigned">
              <div class="portlet box yellow">
                <div class="portlet-title">
                  <div class="caption">
                    <i class="fa fa-link"></i>Assigned Questions
                        <small>View and manage questions assigned to quizzes</small>
                  </div>
                  <div class="tools">
                    <a href="javascript:;" class="collapse"></a>
                    <a href="javascript:;" class="reload"></a>
                  </div>
                </div>
                <div class="portlet-body">
                  <div class="row filter-row" style="margin-bottom: 15px;">
                    <div class="col-md-6">
                      <select id="filter_quiz" class="form-control" placeholder="Select Quiz">
                        <option value="">Select a Quiz</option>
                        <?php if(isset($quiz_list) && is_array($quiz_list)): ?>
                          <?php foreach($quiz_list as $key => $val): ?>
                            <option value="<?=$key?>"><?=$val?></option>
                          <?php endforeach; ?>
                        <?php endif; ?>
                      </select>
                    </div>
                    <div class="col-md-6">
                      <button type="button" id="btn_load_quiz_questions" class="btn btn-primary">
                        <i class="fa fa-search"></i> Load Questions
                      </button>
                    </div>
                  </div>
                  
                  <div id="quiz_questions_container">
                    <!-- Will be populated via AJAX when a quiz is selected -->
                    <div class="alert alert-info">
                      <strong>Information:</strong> Please select a quiz from the dropdown above to view its questions.
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="tab-pane" id="tab_0">
              <div class="portlet box green">
                <div class="portlet-title">
                  <div class="caption">
                    <i class="fa fa-shopping-cart"></i><?=humanize($class_name)?>
                        <small>Add Details to <?=humanize($class_name)?></small>
                  </div>
                  <div class="tools">
                    <a href="javascript:;" class="collapse">
                    </a>
                    <a href="javascript:;" class="reload">
                    </a>
                  </div>
                </div>
                <div class="portlet-body form">
                  <!-- BEGIN FORM-->
                  <?$this->load->view("admin/widget/form_generator");?>
                  <!-- END FORM-->
                </div>
                <!-- END VALIDATION STATES-->
              </div>
            </div>
     

                   <?
            // Images only in edit mode.  
            if($form_data){?>
            <div class="tab-pane" id="tab_1">
              <div class="portlet box green">
                <div class="portlet-title">
                  <div class="caption">
                    <i class="fa fa-shopping-cart"></i>
                    <small>Add New Question</small>
                  </div>
                  <div style="float:right; margin:1%;">
                        <button type="button" class="btn btn-primary" data-toggle="modal" id="getData" data-target="#findQuestionModal" data-whatever="<?= $form_data ?>"><i class="fa fa-search"></i> Find Questions</button>

                  </div>
                </div>
                <div class="portlet-body form">
                  <!-- BEGIN FORM-->
                  <?php $this->load->view("admin/quiz/_tab1"); ?>
                  <!-- END FORM-->
                </div>
                <!-- END VALIDATION STATES-->
              </div>
            </div>


            <div class="tab-pane" id="tab_2">
              <div class="portlet box green">
                <div class="portlet-title">
                  <div class="caption">
                    <i class="fa fa-shopping-cart"></i>Quiz Listing
                  </div>
                </div>
                <div class="portlet-body form">
                  <!-- BEGIN FORM-->
                  <? $this->load->view("admin/quiz/_tab2");?>
                  <!-- END FORM-->
                </div>
                <!-- END VALIDATION STATES-->
              </div>
            </div>
            <?}?>
            

          </div>
      </div>
  </div>
</div>

<!--//mtech work -->
<div class="modal fade" id="findQuestionModal" tabindex="-1" role="dialog" aria-labelledby="findQuestionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="findQuestionModalLabel">Find Quiz Question</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-md-4">
              <div class="list-group" id="module-list">
                <!-- Modules will be dynamically loaded here -->
              </div>
            </div>
            <div class="col-md-8">
              <div id="question-list">
                <!-- Questions will be dynamically loaded here -->
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary" id="importSelectedQuestions">Import Selected</button>
        </div>
      </div>
    </div>
  </div>
<!--//mtech work -->


<div id="myModal-question" class="modal fade " role="dialog" style="">
  <div class="modal-dialog" style="width:1300px">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close tournament_close_quiz" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"><strong>Stored Question</strong></h4>
      </div>
      <div class="modal-body">
        <? $this->load->view('admin/quiz/_stored_question');?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default tournament_close_quiz">Close</button>
      </div>
    </div>

  </div>
</div>


<script>
  $(document).ready(function() {    
      ///MTech work
      $('#getData').on('click', function() {
    var url = "<?=la('quiz/paginate')?>";
    var data;

    $.ajax({
        url: url,
        method: 'GET', // Change to 'POST' if needed
        data: data,
        success: function(response) {
            console.log('AJAX request completed. Response:', response);

            try {
                const responseData = JSON.parse(response);
                console.log('Parsed response:', responseData);

                const s = responseData.data;
                console.log('Data array:', s);

                const modules = s.map(item => ({ id: item[1], name: item[5] }));
                console.log('Modules:', modules);

                const moduleList = $('#module-list');
                moduleList.empty();
                modules.forEach(module => {
                    moduleList.append(`<a href="#" class="list-group-item list-group-item-action" data-module-id="${module.id}">${module.name}</a>`);
                });

                moduleList.on('click', 'a', function() {
                    const moduleId = $(this).data('module-id');
                    const module = modules.find(m => m.id === moduleId);
                    fetchQuestions(moduleId);
                });
            } catch (error) {
                console.error('Error parsing response:', error);
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX request error:', error);
        }
    });

    console.log('were');
});
function stripTags(input) {
    var doc = new DOMParser().parseFromString(input, 'text/html');
    return doc.body.textContent || "";
}

function fetchQuestions(moduleId) {
    var url = "<?=la('quiz/get_questions')?>"; // Update this URL to the correct endpoint for fetching questions
    var data = { cq_quiz_id: moduleId };

    $.ajax({
        url: url,
        method: 'GET', 
        data: data,
        success: function(response) {
            console.log('Questions request completed. Response:', response);

            try {
                const questionData = JSON.parse(response);
                console.log('Parsed questions response:', questionData);

                const questionList = $('#question-list');
                questionList.empty();

                questionData.forEach(question => {
                    questionList.append(`
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="${question.cq_id}" id="question-${question.cq_id}" data-quiz_id='${moduleId}' data-table_name="course_quiz">
                            <label class="form-check-label" for="question-${question.cq_id}" >
                                ${stripTags(question.cq_question)}
                            </label>
                        </div>
                    `);
                });
                   $('.question-checkbox').on('change', function() {
                    collectSelectedQuestionIds();
                });
            } catch (error) {
                console.error('Error parsing questions response:', error);
            }
        },
        error: function(xhr, status, error) {
            console.error('Questions request error:', error);
        }
    });
}
function collectSelectedQuestionIds() {
    const selectedIds = [];
    $('.question-checkbox:checked').each(function() {
        const quiz_id = $(this).data('quiz_id');
        const question_id = $(this).val();
        const table_name = $(this).data('table_name');
        selectedQuestions.push({ quiz_id, question_id, table_name });
    });
    console.log('Selected question IDs:', selectedIds);
}

// Example function to use the selected question IDs array
function submitSelectedQuestions() {
    const selectedIds = [];
    $('.question-checkbox:checked').each(function() {
        const quiz_id = $(this).data('quiz_id');
        const question_id = $(this).val();
        const table_name = $(this).data('table_name');
        selectedQuestions.push({ quiz_id, question_id, table_name });
    });

    // Send selectedIds array to the server or handle it as needed
    console.log('Submitting selected question IDs:', selectedIds);

    var url = "<?=la('quiz/submit_selected_questions')?>"; // Change to your submission endpoint
    var data = { selectedQuestionIds: selectedIds };

    $.ajax({
        url: url,
        method: 'POST', // Change to 'GET' if needed
        data: data,
        success: function(response) {
            console.log('Submission completed. Response:', response);
        },
        error: function(xhr, status, error) {
            console.error('Submission request error:', error);
        }
    });
}

// Example button click to trigger submission
$('#submitQuestions').on('click', function() {
    submitSelectedQuestions();
});


      // Handle import selected questions button click
      $('#importSelectedQuestions').click(function() {
        const selectedQuestions = [];
        $('#question-list input:checked').each(function() {
          selectedQuestions.push($(this).val());
            const quiz_id = $(this).data('quiz_id');
            const question_id = $(this).val();
            const table_name = $(this).data('table_name');
        selectedQuestions.push({ quiz_id, question_id, table_name });
        });
        console.log(selectedQuestions); 
        // call ajax
        var url = "<?=la('course_quiz/ajax_add_quizes')?>";
            var quiz_id = $(this).data('quiz_id');
            var question_id = $(this).val();
            var table_name = $(this).attr('data-table_name');
        var data = {quiz_id:quiz_id,question_id:question_id,table_name:table_name};
        var s = AjaxRequest.fire(url,data);
    
        if(s.status) {
          AdminToastr.success("Questions successfully added to quiz");
          $(this).closest('.modal').modal('hide');
        }
        else {
          AdminToastr.error("Error found please try again");
        }
        
      });
    
    ///MTech work
      
      Metronic.init(); // init metronic core components
      QuickSidebar.init(); // init quick sidebar
      Demo.init(); // init demo features
      UIAlertDialogApi.init(); //UI Alert API
      FormFileUpload.init();
      //FormFileUpload2.init();

    if(!<?=$id?>) // when add product detail, disabled images and item set tab
    {
    $('.tabbable li a[href=\#tab_1]').css({"background-color": "#CFD1CF",
                        "color": "#fff"
                        });
    $('.tabbable li a[href=\#tab_2]').css({"background-color": "#CFD1CF",
    "color": "#fff"
    });
    $('.tabbable li a[href=\#tab_1]').click(false);
    $('.tabbable li a[href=\#tab_2]').click(false);
    } 
    if('<?=$_GET["msgtype"]?>' == 'success'){ // when add/edit product detail, switched to images tab
    $('.tabbable li a[href=\#tab_1]').click();
    }
    
      <?if($error)
          echo "AdminToastr.error('".str_replace("\n","",validation_errors('<div>', '</div></br>'))."');";
      ?>

      $("#product-product_brand_id").on('change',function(){
        //alert($(this).val());
        //get brand categories populate in selected categories
        var params = {} ;
        params.search_val = $(this).val();
        var res = AjaxRequest.fire($js_config.base_url + "admin/product/get_brand_categories" , params);
        var selCat = [];
        $(res).each(function(i,v){
          selCat.push(v.bc_category_id);
        })
       if($(selCat).length > 0)
       {
        $('#product_category-pc_category_id').multiSelect('select', selCat);
       }
       else
       {
        $('#product_category-pc_category_id').multiSelect('deselect_all');
       }
      });


      // Product Is Pack?
      pack_size(<?=$form_data['product']['product_is_pack_product']?>);

  });



  $("body").on('click','.btn_delete_size',function(){
    if(confirm('Are you sure you want to delete this question?'))
    {
      var id = $(this).attr('data-id');
      var url = '<?=la("course_quiz/ajax_delete_question")?>';
      var data = {id:id};
      var s = AjaxRequest.fire(url,data);
      if(s.status) {
        // Row Remove
        $("#row-"+id).remove();
      }
      else {
        AdminToastr.error("Error Found please try again");
      }
    }

  });


      
$("body").on('click','#view_question',function(){
    $("#myModal-question").modal();
});


$("body").on('click','.add_this_data',function(){
    var quiz_id = $(this).attr('data-quiz_id');
    var question_id = $(this).val();
    var table_name = $(this).attr('data-table_name');
    var url = "<?=la('course_quiz/ajax_add_quizes')?>";
    var data = {quiz_id:quiz_id,question_id:question_id,table_name:table_name};
    var s = AjaxRequest.fire(url,data);

    if(s.status) {
      AdminToastr.success("Quiz Added in this Quiz");
      $(this).hide();
    }
    else {
      AdminToastr.error("Error found please try again");
    }
});


$("body").on('click','.tournament_close_quiz',function(){
    //$("#myModal-question").modal("toggle");
    window.location.href = "<?=la('quiz/add/'.$form_data['quiz']['quiz_id'])?>";
  });
  
</script>
