<div class="container-fluid my-3">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?= $layout_title ?></h3>
                    <div class="card-tools">
                        <a href="<?= site_url('admin/quiz_group_assignment/assign_to_group/'.$quiz->id) ?>" class="btn btn-success btn-sm">
                            <i class="fas fa-plus"></i> Assign to Group
                        </a>
                        <a href="<?= site_url('admin/quiz') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Quizzes
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('success') ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('error') ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">Quiz Information</h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Title:</strong> <?= $quiz->title ?></p>
                                            <p><strong>Description:</strong> <?= $quiz->description ?: 'N/A' ?></p>
                                            <p><strong>Time Limit:</strong> <?= $quiz->time_limit ?> minutes</p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Status:</strong> 
                                                <?= $quiz->status == 1 ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>' ?>
                                            </p>
                                            <p><strong>Questions:</strong> 
                                                <?php 
                                                $this->load->model('model_quiz_question');
                                                $question_count = $this->db->where('quiz_id', $quiz->id)->count_all_results('quiz_question');
                                                echo $question_count;
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <ul class="nav nav-tabs" id="assignmentTabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="groups-tab" data-toggle="tab" href="#groups" role="tab" aria-controls="groups" aria-selected="true">
                                <i class="fas fa-users"></i> Group Assignments
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="individuals-tab" data-toggle="tab" href="#individuals" role="tab" aria-controls="individuals" aria-selected="false">
                                <i class="fas fa-user"></i> Individual Assignments
                            </a>
                        </li>
                    </ul>
                    
                    <div class="tab-content p-3 border border-top-0 rounded-bottom" id="assignmentTabsContent">
                        <!-- Group Assignments Tab -->
                        <div class="tab-pane fade show active" id="groups" role="tabpanel" aria-labelledby="groups-tab">
                            <div class="table-responsive">
                                <table class="table table-hover table-bordered">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Group Name</th>
                                            <th>Group Type</th>
                                            <th>Course</th>
                                            <th>Students</th>
                                            <th>Due Date</th>
                                            <th>Penalty Rate</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $group_assignments_found = false;
                                        if (!empty($assignments)): 
                                            foreach ($assignments as $assignment):
                                                if ($assignment->group_id > 0): // Group assignment
                                                    $group_assignments_found = true;
                                                    
                                                    // Get group details
                                                    $this->load->model('model_assignment_group');
                                                    $group = $this->model_assignment_group->find_by_pk($assignment->group_id);
                                                    
                                                    if ($group):
                                        ?>
                                        <tr>
                                            <td><?= $assignment->id ?></td>
                                            <td><?= $group->assignment_group_name ?></td>
                                            <td>
                                                <?php
                                                $group_types = [
                                                    'lab_section' => 'Laboratory Section',
                                                    'day_slot' => 'Day Slot',
                                                    'time_slot' => 'Time Slot',
                                                    'custom' => 'Custom Group',
                                                    'regular' => 'Regular Assignment Group'
                                                ];
                                                echo isset($group_types[$group->assignment_group_type]) ? $group_types[$group->assignment_group_type] : $group->assignment_group_type;
                                                ?>
                                            </td>
                                            <td>
                                                <?php
                                                $this->load->model('model_course');
                                                $course = $this->model_course->find_by_pk($group->assignment_group_course_id);
                                                echo $course ? $course->course_name : 'N/A';
                                                ?>
                                            </td>
                                            <td>
                                                <?php
                                                $this->load->model('model_assignment_group_member');
                                                $members_count = $this->db->where('agm_group_id', $group->assignment_group_id)->where('agm_status', 1)->count_all_results('assignment_group_members');
                                                echo $members_count;
                                                ?>
                                            </td>
                                            <td><?= date('Y-m-d H:i', strtotime($assignment->due_date)) ?></td>
                                            <td><?= $assignment->penalty_rate ?>%</td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="<?= site_url('admin/quiz_group_assignment/assign_to_group/'.$quiz->id.'?edit='.$assignment->id) ?>" class="btn btn-primary btn-sm" title="Edit Assignment">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="<?= site_url('admin/quiz_group_assignment/delete_assignment/'.$assignment->id.'/'.$quiz->id) ?>" class="btn btn-danger btn-sm" title="Delete Assignment" onclick="return confirm('Are you sure you want to delete this assignment?');">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php 
                                                    endif;
                                                endif;
                                            endforeach;
                                        endif;
                                        
                                        if (!$group_assignments_found):
                                        ?>
                                        <tr>
                                            <td colspan="8" class="text-center">No group assignments found</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <!-- Individual Assignments Tab -->
                        <div class="tab-pane fade" id="individuals" role="tabpanel" aria-labelledby="individuals-tab">
                            <div class="table-responsive">
                                <table class="table table-hover table-bordered">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Student Name</th>
                                            <th>Email</th>
                                            <th>Due Date</th>
                                            <th>Penalty Rate</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $individual_assignments_found = false;
                                        if (!empty($assignments)): 
                                            foreach ($assignments as $assignment):
                                                if ($assignment->user_id > 0): // Individual assignment
                                                    $individual_assignments_found = true;
                                                    
                                                    // Get user details
                                                    $this->load->model('model_user');
                                                    $user = $this->model_user->find_by_pk($assignment->user_id);
                                                    
                                                    if ($user):
                                        ?>
                                        <tr>
                                            <td><?= $assignment->id ?></td>
                                            <td><?= $user->user_firstname ?> <?= $user->user_lastname ?></td>
                                            <td><?= $user->user_email ?></td>
                                            <td><?= date('Y-m-d H:i', strtotime($assignment->due_date)) ?></td>
                                            <td><?= $assignment->penalty_rate ?>%</td>
                                            <td>
                                                <?php if ($assignment->status == 1): ?>
                                                    <span class="badge badge-success">Active</span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger">Inactive</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="<?= site_url('admin/quiz_assignment/edit_assignment/'.$assignment->id) ?>" class="btn btn-primary btn-sm" title="Edit Assignment">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="<?= site_url('admin/quiz_group_assignment/delete_assignment/'.$assignment->id.'/'.$quiz->id) ?>" class="btn btn-danger btn-sm" title="Delete Assignment" onclick="return confirm('Are you sure you want to delete this assignment?');">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php 
                                                    endif;
                                                endif;
                                            endforeach;
                                        endif;
                                        
                                        if (!$individual_assignments_found):
                                        ?>
                                        <tr>
                                            <td colspan="7" class="text-center">No individual assignments found</td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(function () {
    // Initialize DataTable
    $('.table').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
    });
});
</script>
