<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="portlet box light-grey">
    <div class="portlet-title">
        <div class="caption">
            <i class="fa fa-edit"></i> <?php echo isset($quiz) ? 'Editar Quiz' : 'Crear Nuevo Quiz'; ?>
        </div>
    </div>
    <div class="portlet-body form">
        <!-- BEGIN FORM-->
        <form action="<?php echo site_url('admin/quiz/save'); ?>" class="form-horizontal" method="post" enctype="multipart/form-data">
            <div class="form-body">
                <?php if(isset($quiz)): ?>
                <input type="hidden" name="quiz[quiz_id]" value="<?php echo $quiz->quiz_id; ?>">
                <?php endif; ?>
                
                <!-- Nombre del Quiz -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Nombre del Quiz <?php echo mandatory(); ?></label>
                    <div class="col-md-6">
                        <input type="text" name="quiz[quiz_name]" class="form-control" value="<?php echo isset($quiz) ? $quiz->quiz_name : ''; ?>" required>
                    </div>
                </div>
                
                <!-- Descripción -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Descripción</label>
                    <div class="col-md-6">
                        <textarea name="quiz[quiz_desc]" class="form-control" rows="3"><?php echo isset($quiz) ? html_entity_decode($quiz->quiz_desc) : ''; ?></textarea>
                    </div>
                </div>
                
                <!-- Curso -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Curso <?php echo mandatory(); ?></label>
                    <div class="col-md-4">
                        <select name="quiz[quiz_course_id]" class="form-control" id="course_dropdown" required>
                            <option value="">Selecciona un curso</option>
                            <?php foreach ($courses as $course): ?>
                                <option value="<?php echo $course->course_id; ?>" <?php echo (isset($quiz) && $quiz->quiz_course_id == $course->course_id) ? 'selected' : ''; ?>>
                                    <?php echo $course->course_title; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                
                <!-- Materia -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Materia <?php echo mandatory(); ?></label>
                    <div class="col-md-4">
                        <select name="quiz[quiz_subject_id]" class="form-control" id="subject_dropdown" required>
                            <option value="">Selecciona una materia</option>
                            <?php if(isset($subjects)): foreach ($subjects as $subject): ?>
                                <option value="<?php echo $subject->subject_id; ?>" <?php echo (isset($quiz) && $quiz->quiz_subject_id == $subject->subject_id) ? 'selected' : ''; ?>>
                                    <?php echo $subject->subject_name; ?>
                                </option>
                            <?php endforeach; endif; ?>
                        </select>
                    </div>
                </div>
                
                <!-- Puntos -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Puntos <?php echo mandatory(); ?></label>
                    <div class="col-md-2">
                        <input type="number" min="0" step="0.1" name="quiz[quiz_point]" class="form-control" value="<?php echo isset($quiz) ? $quiz->quiz_point : '10'; ?>" required>
                    </div>
                </div>
                
                <!-- Fecha Inicio -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Fecha Inicio <?php echo mandatory(); ?></label>
                    <div class="col-md-4">
                        <div class="input-group date date-picker" data-date-format="yyyy-mm-dd">
                            <input type="text" name="quiz[quiz_startdate]" class="form-control" value="<?php echo isset($quiz) ? $quiz->quiz_startdate : date('Y-m-d'); ?>" readonly required>
                            <span class="input-group-btn">
                                <button class="btn default" type="button"><i class="fa fa-calendar"></i></button>
                            </span>
                        </div>
                    </div>
                </div>
                
                <!-- Fecha Fin -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Fecha Fin <?php echo mandatory(); ?></label>
                    <div class="col-md-4">
                        <div class="input-group date date-picker" data-date-format="yyyy-mm-dd">
                            <input type="text" name="quiz[quiz_enddate]" class="form-control" value="<?php echo isset($quiz) ? $quiz->quiz_enddate : date('Y-m-d', strtotime('+7 days')); ?>" readonly required>
                            <span class="input-group-btn">
                                <button class="btn default" type="button"><i class="fa fa-calendar"></i></button>
                            </span>
                        </div>
                    </div>
                </div>
                
                <!-- Penalización Diaria -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Penalización Diaria (%)</label>
                    <div class="col-md-2">
                        <input type="number" min="0" max="100" step="0.1" name="quiz[quiz_daily_penalty]" class="form-control" value="<?php echo isset($quiz) && isset($quiz->quiz_daily_penalty) ? $quiz->quiz_daily_penalty : '10'; ?>">
                    </div>
                    <div class="col-md-4">
                        <span class="help-block">Porcentaje de penalización por cada día de retraso en la entrega</span>
                    </div>
                </div>
                
                <!-- Punto de Aprobación -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Punto de Aprobación (%)</label>
                    <div class="col-md-2">
                        <input type="number" min="0" max="100" step="1" name="quiz[quiz_passing_score]" class="form-control" value="<?php echo isset($quiz) && isset($quiz->quiz_passing_score) ? $quiz->quiz_passing_score : '60'; ?>">
                    </div>
                    <div class="col-md-4">
                        <span class="help-block">Porcentaje mínimo requerido para aprobar el quiz</span>
                    </div>
                </div>
                
                <!-- Estado -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Estado</label>
                    <div class="col-md-4">
                        <div class="switchery-demo">
                            <input type="hidden" name="quiz[quiz_status]" value="0">
                            <input type="checkbox" name="quiz[quiz_status]" class="js-switch" value="1" <?php echo (!isset($quiz) || (isset($quiz) && $quiz->quiz_status == 1)) ? 'checked' : ''; ?> data-toggle="toggle">
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="form-actions fluid">
                <div class="col-md-offset-3 col-md-9">
                    <button type="submit" class="btn green">Guardar</button>
                    <a href="<?php echo site_url('admin/quiz'); ?>" class="btn default">Cancelar</a>
                </div>
            </div>
        </form>
        <!-- END FORM-->
    </div>
</div>

<script>
$(document).ready(function() {
    // Inicializar Switchery para checkbox estilizado
    var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
    elems.forEach(function(html) {
        var switchery = new Switchery(html, { color: '#1AB394' });
    });
    
    // Cargar materias según el curso seleccionado
    $('#course_dropdown').change(function() {
        var course_id = $(this).val();
        if(course_id) {
            $.ajax({
                url: '<?php echo base_url("admin/subject/get_by_course"); ?>/' + course_id,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#subject_dropdown').empty();
                    $('#subject_dropdown').append('<option value="">Selecciona una materia</option>');
                    $.each(data, function(key, value) {
                        $('#subject_dropdown').append('<option value="' + value.subject_id + '">' + value.subject_name + '</option>');
                    });
                }
            });
        } else {
            $('#subject_dropdown').empty();
            $('#subject_dropdown').append('<option value="">Selecciona una materia</option>');
        }
    });
});
</script>

<!-- Incluir el JS de gestión de quiz -->
<script src="assets/admin/scripts/quiz.js"></script>
