<!-- CONFIGURE CATEGORIES FOR QUIZ -->

<div class="box">
    <div class="box-header with-border">
        <h3 class="box-title">Configure Categories for Quiz: <?= $quiz['quiz_name'] ?></h3>
        <div class="box-tools pull-right">
            <a href="<?= base_url('admin/quiz') ?>" class="btn btn-default btn-sm">
                <i class="fa fa-arrow-left"></i> Back to Quizzes
            </a>
        </div>
    </div>
    <div class="box-body">
        <?php if ($this->session->flashdata('error')) { ?>
            <div class="alert alert-danger">
                <?= $this->session->flashdata('error') ?>
            </div>
        <?php } ?>

        <?php if ($this->session->flashdata('success')) { ?>
            <div class="alert alert-success">
                <?= $this->session->flashdata('success') ?>
            </div>
        <?php } ?>

        <div class="row">
            <div class="col-md-12">
                <div class="callout callout-info">
                    <h4><?= $quiz['quiz_name'] ?></h4>
                    <p>
                        <strong>Course:</strong> 
                        <?php 
                            $course = $this->model_course->find_by_pk($quiz['quiz_course_id']);
                            echo isset($course['course_title']) ? $course['course_title'] : ''; 
                        ?>
                        | 
                        <strong>Subject:</strong> 
                        <?php 
                            $subject = $this->model_course_subject->find_by_pk($quiz['quiz_subject_id']);
                            echo isset($subject['course_subject_name']) ? $subject['course_subject_name'] : ''; 
                        ?>
                    </p>
                    <p>
                        <strong>Current Total Questions:</strong> <?= $total_questions ?>
                    </p>
                </div>
            </div>
        </div>

        <?php if (empty($categories)) { ?>
            <div class="alert alert-warning">
                <h4><i class="icon fa fa-warning"></i> No Categories Available</h4>
                <p>There are no question categories defined for this quiz's course and subject.</p>
                <p>Please <a href="<?= base_url('admin/quiz_categories/add') ?>">create categories</a> before configuring this quiz.</p>
            </div>
        <?php } else { ?>
            <form id="form-category-config" action="<?= base_url('admin/quiz/configure_categories/' . $quiz['quiz_id']) ?>" method="post">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th width="40%">Category</th>
                                <th width="20%">Number of Questions</th>
                                <th width="25%">Selection Method</th>
                                <th width="15%">Available Questions</th>
                                <th width="5%"></th>
                            </tr>
                        </thead>
                        <tbody id="category-config-rows">
                            <?php 
                            $row_counter = 0;
                            if (!empty($existing_configs)) { 
                                foreach ($existing_configs as $config) {
                                    $category_id = $config['qcc_category_id'];
                                    $num_questions = $config['qcc_num_questions'];
                                    $random = $config['qcc_random_selection'];
                                    $question_count = 0;
                                    
                                    // Find the category in the available categories
                                    foreach ($categories as $cat) {
                                        if ($cat['qc_id'] == $category_id) {
                                            $question_count = $cat['question_count'];
                                            break;
                                        }
                                    }
                            ?>
                                <tr class="config-row">
                                    <td>
                                        <select name="categories[]" class="form-control category-select" required>
                                            <option value="">Select Category</option>
                                            <?php foreach ($categories as $cat) { ?>
                                                <option value="<?= $cat['qc_id'] ?>" 
                                                    <?= ($cat['qc_id'] == $category_id) ? 'selected' : '' ?>
                                                    data-question-count="<?= $cat['question_count'] ?>">
                                                    <?= $cat['qc_name'] ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="number" name="num_questions[]" class="form-control num-questions" 
                                            min="1" max="<?= $question_count ?>" value="<?= $num_questions ?>" required>
                                    </td>
                                    <td>
                                        <div class="radio">
                                            <label>
                                                <input type="checkbox" name="random_selection[<?= $row_counter ?>]" value="1"
                                                    <?= $random ? 'checked' : '' ?>>
                                                Random Selection
                                            </label>
                                            <p class="help-block">If unchecked, questions will be selected in order.</p>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-blue question-count"><?= $question_count ?></span>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-danger btn-sm remove-row">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php 
                                    $row_counter++;
                                }
                            } 
                            ?>
                            
                            <!-- If no existing configurations, add an empty row -->
                            <?php if (empty($existing_configs)) { ?>
                                <tr class="config-row">
                                    <td>
                                        <select name="categories[]" class="form-control category-select" required>
                                            <option value="">Select Category</option>
                                            <?php foreach ($categories as $cat) { ?>
                                                <option value="<?= $cat['qc_id'] ?>" data-question-count="<?= $cat['question_count'] ?>">
                                                    <?= $cat['qc_name'] ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="number" name="num_questions[]" class="form-control num-questions" 
                                            min="1" value="1" required>
                                    </td>
                                    <td>
                                        <div class="radio">
                                            <label>
                                                <input type="checkbox" name="random_selection[0]" value="1" checked>
                                                Random Selection
                                            </label>
                                            <p class="help-block">If unchecked, questions will be selected in order.</p>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-blue question-count">0</span>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-danger btn-sm remove-row">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="5">
                                    <button type="button" id="add-category-row" class="btn btn-default">
                                        <i class="fa fa-plus"></i> Add Category
                                    </button>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                
                <div class="box-footer">
                    <button type="submit" name="submit_config" value="1" class="btn btn-primary pull-right">
                        Save Category Configuration
                    </button>
                </div>
            </form>
        <?php } ?>
    </div>
</div>

<script>
    $(function() {
        // Will be replaced by the external JS file
        var rowCounter = <?= $row_counter ?>;
        
        // Add new category row
        $('#add-category-row').click(function() {
            addCategoryRow();
        });
        
        // Remove category row
        $(document).on('click', '.remove-row', function() {
            var row = $(this).closest('tr');
            if ($('.config-row').length > 1) {
                row.remove();
                updateIndices();
            } else {
                alert('At least one category must be configured.');
            }
        });
        
        // Category selection change handler
        $(document).on('change', '.category-select', function() {
            var questionCount = $(this).find('option:selected').data('question-count') || 0;
            var row = $(this).closest('tr');
            
            // Update the question count badge
            row.find('.question-count').text(questionCount);
            
            // Update the max value of the number input
            row.find('.num-questions').attr('max', questionCount);
            
            // If the current value is greater than the max, reset it to the max
            var numQuestions = row.find('.num-questions');
            if (parseInt(numQuestions.val()) > questionCount) {
                numQuestions.val(questionCount);
            }
        });
        
        // Function to add a new category row
        function addCategoryRow() {
            var template = $('#category-config-rows tr:first').clone();
            
            // Reset the values
            template.find('select').val('');
            template.find('input[type="number"]').val(1);
            template.find('input[type="checkbox"]').prop('checked', true);
            template.find('.question-count').text('0');
            
            // Update the checkbox name
            template.find('input[type="checkbox"]').attr('name', 'random_selection[' + rowCounter + ']');
            
            // Append to the table
            $('#category-config-rows').append(template);
            rowCounter++;
        }
        
        // Update checkbox names when rows are removed
        function updateIndices() {
            $('.config-row').each(function(index) {
                $(this).find('input[type="checkbox"]').attr('name', 'random_selection[' + index + ']');
            });
            rowCounter = $('.config-row').length;
        }
        
        // Form validation
        $('#form-category-config').validate({
            rules: {
                'categories[]': { required: true },
                'num_questions[]': { required: true, min: 1 }
            },
            messages: {
                'categories[]': { required: "Please select a category" },
                'num_questions[]': { 
                    required: "Please enter the number of questions",
                    min: "Must be at least 1 question"
                }
            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
