<div class="container-fluid my-3">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?= $layout_title ?></h3>
                    <div class="card-tools">
                        <a href="<?= site_url('admin/quiz_group_assignment/view_assignments/'.$quiz->id) ?>" class="btn btn-info btn-sm">
                            <i class="fas fa-eye"></i> View Assignments
                        </a>
                        <a href="<?= site_url('admin/quiz') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Quizzes
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('success') ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('error') ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">Quiz Details</h3>
                                </div>
                                <div class="card-body">
                                    <p><strong>Title:</strong> <?= $quiz->title ?></p>
                                    <p><strong>Description:</strong> <?= $quiz->description ?: 'N/A' ?></p>
                                    <p><strong>Time Limit:</strong> <?= $quiz->time_limit ?> minutes</p>
                                    <p><strong>Status:</strong> 
                                        <?= $quiz->status == 1 ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>' ?>
                                    </p>
                                    <p><strong>Questions:</strong> 
                                        <?php 
                                        $this->load->model('model_quiz_question');
                                        $question_count = $this->db->where('quiz_id', $quiz->id)->count_all_results('quiz_question');
                                        echo $question_count;
                                        ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-success">
                                    <h3 class="card-title">Assign to Group</h3>
                                </div>
                                <div class="card-body">
                                    <form method="post" action="<?= site_url('admin/quiz_group_assignment/assign_to_group/'.$quiz->id) ?>">
                                        <div class="form-group">
                                            <label for="group_id">Select Student Group *</label>
                                            <select class="form-control select2" id="group_id" name="group_id" required>
                                                <option value="">-- Select Group --</option>
                                                <?php foreach ($groups as $group): ?>
                                                    <option value="<?= $group->assignment_group_id ?>"><?= $group->assignment_group_name ?> 
                                                        [<?php
                                                        // Get group type display name
                                                        $group_types = [
                                                            'lab_section' => 'Laboratory Section',
                                                            'day_slot' => 'Day Slot',
                                                            'time_slot' => 'Time Slot',
                                                            'custom' => 'Custom Group'
                                                        ];
                                                        echo isset($group_types[$group->assignment_group_type]) ? $group_types[$group->assignment_group_type] : $group->assignment_group_type;
                                                        
                                                        // Get course name
                                                        $this->load->model('model_course');
                                                        $course = $this->model_course->find_by_pk($group->assignment_group_course_id);
                                                        echo ' - ' . ($course ? $course->course_name : 'N/A');
                                                        ?>]
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="due_date">Due Date *</label>
                                            <input type="datetime-local" class="form-control" id="due_date" name="due_date" required>
                                            <small class="form-text text-muted">Set the deadline for quiz submission</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="penalty_rate">Late Submission Penalty Rate (%)</label>
                                            <input type="number" class="form-control" id="penalty_rate" name="penalty_rate" value="0" min="0" max="100" step="0.1">
                                            <small class="form-text text-muted">Percentage to deduct per day for late submissions (0 = no late submissions allowed)</small>
                                        </div>
                                        
                                        <div class="form-group text-right">
                                            <button type="submit" name="submit" value="1" class="btn btn-success">
                                                <i class="fas fa-save"></i> Assign Quiz to Group
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(function () {
    // Initialize Select2
    $('.select2').select2();
    
    // Set default due date (7 days from now)
    var now = new Date();
    now.setDate(now.getDate() + 7);
    
    // Format date for datetime-local input
    var year = now.getFullYear();
    var month = (now.getMonth() + 1).toString().padStart(2, '0');
    var day = now.getDate().toString().padStart(2, '0');
    var hours = now.getHours().toString().padStart(2, '0');
    var minutes = now.getMinutes().toString().padStart(2, '0');
    
    var defaultDueDate = `${year}-${month}-${day}T${hours}:${minutes}`;
    $('#due_date').val(defaultDueDate);
});
</script>
