<?php

// Unified tab: List of assigned questions + search/add from question bank
?>
<input type="hidden" id='quiz_id' value="<?=$id?>">

<!-- ================= Quiz Categories ================= -->
<div class="categories-section">
  <div class="portlet-title" style="margin-bottom: 10px;">
    <div class="caption">
      <i class="fa fa-tags"></i>
      <strong>Quiz Categories</strong>
    </div>
  </div>
  
  <?php 
  $has_categories = isset($categories) && is_array($categories) && !empty($categories);
  if ($has_categories): 
  ?>
    <form method="post" id="form-categories" action="<?= base_url('admin/quiz/edit/' . $id) ?>">
      <input type="hidden" name="submit_config" value="1">
      <table class="table table-bordered" id="tblCategories">
          <thead>
              <tr>
                  <th style="width:60px">Use</th>
                  <th>Category</th>
                  <th style="width:160px">Questions</th>
                  <th>Points</th>
              </tr>
          </thead>
          <tbody>
          <?php foreach ($categories as $cat): 
              // Check if it's an object or array
              if (is_object($cat)) {
                  $cat = (array)$cat;
              }
              
              // Get category ID (may have prefix or not)
              $cat_id = isset($cat['qc_id']) ? $cat['qc_id'] : 
                       (isset($cat['id']) ? $cat['id'] : 0);
                       
              // Check if it is selected
              $sel = isset($selected_categories[$cat_id]); 
          ?>
              <tr>
                  <td class="text-center">
                      <input type="checkbox" name="categories[]" value="<?= $cat_id; ?>" <?= $sel ? 'checked' : ''; ?> />
                  </td>
                  <td>
                      <?php 
                      // Try to get the name in different possible ways
                      if (isset($cat['qc_name'])) {
                          echo htmlspecialchars($cat['qc_name']);
                      } elseif (isset($cat['name'])) {
                          echo htmlspecialchars($cat['name']);
                      } else {
                          echo 'Category #' . $cat_id;
                      }
                      ?>
                  </td>
                  <td>
                      <input type="number" min="1" class="form-control" style="max-width:120px" 
                             name="num_questions[<?= $cat_id; ?>]" 
                             value="<?= $sel ? $selected_categories[$cat_id] : '5'; ?>" 
                             <?= $sel ? '' : 'disabled'; ?> />
                  </td>
                  <td>
                      <input type="number" min="0" class="form-control" style="max-width:120px" 
                             name="points_per_question[<?= $cat_id; ?>]"
                             value="<?php
                                 if ($sel && isset($selected_categories_points[$cat_id])) {
                                     // Si es 0 o null, mostrar vacío para que placeholder se vea
                                     echo ($selected_categories_points[$cat_id] == 0 ? '' : htmlspecialchars($selected_categories_points[$cat_id]));
                                 } else {
                                     echo '';
                                 }
                             ?>"
                             placeholder="auto"
                             <?= $sel ? '' : 'disabled'; ?> />
                  </td>
              </tr>
          <?php endforeach; ?>
          </tbody>
      </table>
      <div class="alert alert-info" style="font-size:15px;">
        <div style="display:flex; align-items:center; gap:8px; margin-bottom:4px;">
          <i class="fa fa-info-circle" style="font-size:18px;"></i>
          <span><strong>Select categories</strong> and specify how many questions should be randomly selected from each category when generating this quiz.</span>
        </div>
        <div style="margin-left:26px; margin-top:4px;">
          <strong>Points per question:</strong>
          <ul style="margin:6px 0 0 18px; padding:0; list-style:square; font-size:14px;">
            <li>
              <span>If the field is <strong>empty</strong> or shows <span style='color:#337ab7;font-weight:bold;'>auto</span>, the <u>base points</u> of each question from the Question Bank will be used.</span>
            </li>
            <li>
              <span>If you enter a value (e.g. <span style='color:#5cb85c;font-weight:bold;'>2.5</span>), <u>all questions</u> from that category will use that fixed score.</span>
            </li>
            <li>
              <span>If you enter <span style='color:#f0ad4e;font-weight:bold;'>0</span>, it will also be treated as <span style='color:#337ab7;font-weight:bold;'>auto</span> (base points).</span>
            </li>
          </ul>
        </div>
      </div>
      <div style="display: flex; justify-content: flex-end; margin-top: 10px;">
        <button type="submit" class="btn btn-primary">Save Categories</button>
      </div>
    </form>
  <?php else: ?>
    <div class="alert alert-warning">
      <strong>No categories available.</strong> Please create categories first in the <a href="<?= base_url('admin/quiz_categories'); ?>" target="_blank">Quiz Categories</a> section.
    </div>
  <?php endif; ?>
</div>
<hr>
<!-- ======================================================= -->

<!-- List of assigned questions -->
<div class="portlet-title" style="margin-bottom: 10px;">
  <div class="caption">
    <i class="fa fa-list"></i>
    <strong>Questions Assigned to this Quiz</strong>
  </div>
</div>
<style>
/* Ajuste de anchos para tabla de preguntas asignadas */
#assigned-questions-table th:nth-child(1),
#assigned-questions-table td:nth-child(1) { width: 5%; text-align: center; }
#assigned-questions-table th:nth-child(2),
#assigned-questions-table td:nth-child(2) { width: 50%; }
#assigned-questions-table .question-cell { width: 100%; white-space: normal; word-break: break-word; }
#assigned-questions-table .question-cell > div { width: 100%; white-space: normal; word-break: break-word; }
#assigned-questions-table th:nth-child(3),
#assigned-questions-table td:nth-child(3) { width: 15%; text-align: center; }
#assigned-questions-table th:nth-child(4),
#assigned-questions-table td:nth-child(4) { width: 15%; text-align: center; }
#assigned-questions-table th:nth-child(5),
#assigned-questions-table td:nth-child(5) { width: 15%; text-align: center; }
/* Ajuste para input de puntos */
#assigned-questions-table .points-input { width: 70px; display: inline-block; margin-right: 6px; }
#assigned-questions-table .btn-save-points { padding: 3px 7px; font-size: 13px; }
#assigned-questions-table .points-saved { background: #e6ffe6 !important; border-color: #5cb85c !important; transition: background 0.4s, border 0.4s; }
@media (max-width: 900px) {
  #assigned-questions-table th:nth-child(2),
  #assigned-questions-table td:nth-child(2) { width: 35%; }
  #assigned-questions-table th:nth-child(3),
  #assigned-questions-table td:nth-child(3),
  #assigned-questions-table th:nth-child(4),
  #assigned-questions-table td:nth-child(4),
  #assigned-questions-table th:nth-child(5),
  #assigned-questions-table td:nth-child(5) { width: 16%; }
}
</style>
<table class="table table-bordered table-striped" id="assigned-questions-table">
  <thead>
    <tr>
      <th style="width:5%;text-align:center;">#</th>
      <th style="width:50%;">Question</th>
      <th style="width:15%;text-align:center;">Type</th>
      <th style="width:15%;text-align:center;">Points</th>
      <th style="width:15%;text-align:center;">Actions</th>
    </tr>
  </thead>
  <tbody>
    <!-- Se llena vía JS -->
  </tbody>
</table>

<!-- Search/add from question bank -->
<h4>Add Questions from Question Bank</h4>
<div class="row" style="margin-bottom: 15px;">
  <div class="col-md-3">
    <select id="filter_course" class="form-control">
      <option value="">All Courses</option>
    </select>
  </div>
  <div class="col-md-3">
    <select id="filter_subject" class="form-control">
      <option value="">All Subjects</option>
    </select>
  </div>
  <div class="col-md-3">
    <select id="filter_type" class="form-control">
      <option value="">All Types</option>
    </select>
  </div>
  <div class="col-md-3">
    <input type="text" id="search_text" class="form-control" placeholder="Search...">
  </div>
</div>

<div class="table-responsive" style="margin-bottom: 0;">
  <table class="table table-striped table-bordered" id="bank-questions-table">
    <thead>
      <tr>
        <th><input type="checkbox" id="select_all_questions"></th>
        <th>ID</th>
        <th>Question</th>
        <th>Courses Assigned</th>
        <th>Quizzes Assigned</th>
        <th>Subject</th>
        <th>Type</th>
        <th>Base Points</th>
        <th>Bonus?</th>
        <th>Status</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <!-- Questions loaded via DataTables -->
    </tbody>
  </table>
</div>
<div style="display: flex; justify-content: flex-end; margin-bottom: 10px;">
  <button id="assign-questions" class="btn btn-primary">Add Selected to Quiz</button>
</div>

<script>
// --- SECURITY BLOCK: Remove any submit handler from #form-categories ---
$(document).off('submit', '#form-categories');
$('#form-categories').off('submit');

// Habilitar/deshabilitar inputs de cantidad y puntos por categoría
$(document).on('change', 'input[name="categories[]"]', function() {
  var catId = $(this).val();
  var checked = $(this).is(':checked');
  $('input[name="num_questions['+catId+']"]').prop('disabled', !checked);
  $('input[name="points_per_question['+catId+']"]').prop('disabled', !checked);
});

// Al cargar la página, asegurarse de que los campos estén bien habilitados
$('input[name="categories[]"]').each(function() {
  var catId = $(this).val();
  var checked = $(this).is(':checked');
  $('input[name="num_questions['+catId+']"]').prop('disabled', !checked);
  $('input[name="points_per_question['+catId+']"]').prop('disabled', !checked);
});

// --- END SECURITY BLOCK ---
$(document).ready(function() {
  var quiz_id = $('#quiz_id').val();

  // --- DataTable for the question bank ---
  var bankTable = $('#bank-questions-table').DataTable({
    "processing": true,
    "serverSide": true,
    "ajax": {
      "url": "<?=base_url('admin/question_bank/get_question_bank_data')?>",
      "type": "POST",
      "data": function(d) {
        d.course_id = $('#filter_course').val();
        d.subject_id = $('#filter_subject').val();
        d.question_type = $('#filter_type').val();
        d.search = { value: $('#search_text').val() };
        d.show_only_unassigned = 1;
      }
    },
    "columns": [
      { "orderable": false }, // Checkbox (HTML)
      null, // ID
      null, // Question
      null, // Courses assigned
      null, // Quizzes assigned
      null, // Subject
      null, // Type
      { "orderable": false }, // Base Points
      null, // Is bonus?
      null, // Status
      { "orderable": false } // Actions
    ],
    "drawCallback": function(settings) {
      // Re-associate the checkboxes
      $('#select_all_questions').prop('checked', false);
    },
    "dom": "tipfl", // table, info, pagination, lengthMenu (at the end)
    "lengthMenu": [ [10, 25, 50, 100], [10, 25, 50, 100] ],
    "searching": false // Removes the native search box
  });

  // Reload the table when filters change
  $('#filter_course, #filter_subject, #filter_type').on('change', function() {
    bankTable.ajax.reload();
  });
  $('#search_text').on('keyup', function(e) {
    if (e.keyCode === 13 || $(this).val() === '') {
      bankTable.ajax.reload();
    }
  });

  // Checkbox 'select all'
  $('#select_all_questions').on('change', function() {
    var checked = $(this).is(':checked');
    $('#bank-questions-table tbody input[type="checkbox"]').prop('checked', checked);
  });

  var quiz_id = $('#quiz_id').val();

  // --- List of assigned questions ---
  function loadAssignedQuestions() {
    console.log('[DEBUG] loadAssignedQuestions called with quiz_id:', quiz_id);
    console.log('[DEBUG] AJAX URL:', '<?=base_url('admin/quiz/get_quiz_questions')?>');
    
    $.post('<?=base_url('admin/quiz/get_quiz_questions')?>', {quiz_id: quiz_id}, function(resp) {
      console.log('[DEBUG] AJAX response received:', resp);
      var $tbody = $('#assigned-questions-table tbody');
      $tbody.empty();
      if (resp.status && resp.questions.length) {
        $.each(resp.questions, function(i, q) {
          // Determine points: qq_points -> qb_gain_point -> 1.0 (default)
          var currentPoints = '';
          if (q.qq_points && q.qq_points > 0) {
            currentPoints = q.qq_points;
          } else if (q.qb_gain_point && q.qb_gain_point > 0) {
            currentPoints = q.qb_gain_point;
          } else {
            currentPoints = '1.0';
          }
          
          $tbody.append('<tr>' +
            '<td>'+(i+1)+'</td>' +
            '<td class="question-cell"><div style="width:100%;white-space:normal;word-break:break-word;">'+q.question+'</div></td>' +
            '<td>'+(q.type ? q.type : '-')+'</td>' +
            '<td>' +
              '<input type="number" class="form-control input-sm points-input" ' +
                     'data-question-id="'+q.qb_id+'" ' +
                     'value="'+currentPoints+'" ' +
                     'min="0" step="0.1" style="width:80px; display:inline-block;" />' +
              '<button class="btn btn-xs btn-success btn-save-points" data-question-id="'+q.qb_id+'" title="Save Points" style="margin-left:5px;"><i class="fa fa-check"></i></button>' +
            '</td>' +
            '<td>' +
              '<a href="<?=base_url('admin/question_bank/edit/')?>'+q.qb_id+'" target="_blank" class="btn btn-xs btn-info" title="Edit in Question Bank"><i class="fa fa-edit"></i></a> ' +
              '<button class="btn btn-xs btn-danger btn-remove-question" data-question-id="'+q.qb_id+'" title="Remove from Quiz"><i class="fa fa-trash"></i></button>' +
            '</td>' +
          '</tr>');
        });
      } else {
        console.log('[DEBUG] No questions found or error:', resp);
        $tbody.append('<tr><td colspan="5" class="text-center">No questions assigned to this quiz.</td></tr>');
      }
    }, 'json').fail(function(xhr, status, error) {
      console.error('[ERROR] AJAX failed:', status, error);
      console.error('[ERROR] Response:', xhr.responseText);
    });
  }

  // Save points for a question
  $(document).on('click', '.btn-save-points', function() {
    var question_id = $(this).data('question-id');
    var points = $(this).siblings('.points-input').val();
    
    console.log('[DEBUG] Save points clicked:', question_id, points);
    
    if (!points || points <= 0) {
      alert('Please enter a valid points value greater than 0');
      return;
    }
    
    console.log('[DEBUG] Sending AJAX to update points');
    $.post('<?=base_url('admin/quiz/update_question_points')?>', {
      quiz_id: quiz_id,
      question_id: question_id,
      points: points
    }, function(resp) {
      console.log('[DEBUG] Update points response:', resp);
      if (resp.status) {
        // Feedback visual: resaltar input y mostrar icono
        var $input = $(this).siblings('.points-input');
        $input.addClass('points-saved');
        setTimeout(function(){ $input.removeClass('points-saved'); }, 1200);
        $(this).find('i').removeClass('fa-check').addClass('fa-check-circle');
        setTimeout(function() {
          $(this).find('i').removeClass('fa-check-circle').addClass('fa-check');
        }.bind(this), 1000);
      } else {
        console.error('[ERROR] Failed to update points:', resp);
        alert('Error: ' + (resp.message || 'Failed to update points'));
      }
    }.bind(this), 'json').fail(function(xhr, status, error) {
      console.error('[ERROR] AJAX update failed:', status, error);
      console.error('[ERROR] Response:', xhr.responseText);
      alert('Network error: ' + error);
    });
  });

  // Remove question from quiz
  $(document).on('click', '.btn-remove-question', function() {
    var question_id = $(this).data('question-id');
    if (confirm('Are you sure you want to remove this question from the quiz?')) {
      $.post('<?=base_url('admin/quiz/remove_question_from_quiz')?>', {quiz_id: quiz_id, question_id: question_id}, function(resp) {
        if (resp.status) {
          loadAssignedQuestions();
          bankTable.ajax.reload();
        } else {
          alert('Error: ' + (resp.message || 'Unknown error'));
        }
      }, 'json');
    }
  });

  // --- Search/add from question bank ---
// --- GLOBAL FUNCTIONS ---
function loadSubjectsByCourse(course_id, callback) {
  var $subject = $('#filter_subject');
  $subject.empty().append('<option value="">All Subjects</option>');
  if (!course_id) {
    if (typeof callback === 'function') callback();
    return;
  }
  $.post('<?=base_url('admin/course_quiz/get_subject_list')?>', {course_id: course_id}, function(data) {
    // data is an array of objects {ITEMID, ITEMDESC}
    if (Array.isArray(data)) {
      $.each(data, function(i, obj) {
        $subject.append('<option value="'+obj.ITEMID+'">'+obj.ITEMDESC+'</option>');
      });
    }
    if (typeof callback === 'function') callback();
  }, 'json');
}

function loadFilters() {
    $.get('<?=base_url('admin/question_bank/get_types')?>', function(data) {
      var $type = $('#filter_type');
      $type.empty().append('<option value="">All Types</option>');
      if (data.types && Array.isArray(data.types)) {
        $.each(data.types, function(i, obj) {
          $type.append('<option value="'+obj.id+'">'+obj.name+'</option>');
        });
      }
    }, 'json');
    $.get('<?=base_url('admin/question_bank/get_courses')?>', function(data) {
      var $course = $('#filter_course');
      $course.empty().append('<option value="">All Courses</option>');
      if (data.courses && Array.isArray(data.courses)) {
        $.each(data.courses, function(i, obj) {
          $course.append('<option value="'+obj.id+'">'+obj.name+'</option>');
        });
      }
      // If there is a course selected (by previous value or because there is only one), load the subjects and then reload the table
      var selectedCourse = $course.val();
      loadSubjectsByCourse(selectedCourse, function() {
        bankTable.ajax.reload();
      });
    }, 'json');
  }


  // Initialize
  console.log('[DEBUG] Initializing with quiz_id:', quiz_id);
  loadFilters();
  loadAssignedQuestions();

  // When the course changes, reload the subjects and the table
  $('#filter_course').on('change', function() {
    var course_id = $(this).val();
    loadSubjectsByCourse(course_id, function() {
      bankTable.ajax.reload();
    });
  });
  // When subject or type changes, only reload the table
  $('#filter_subject, #filter_type').on('change', function() {
    bankTable.ajax.reload();
  });
  $('#search_text').on('keyup', function(e) {
    if (e.keyCode === 13 || $(this).val() === '') {
      bankTable.ajax.reload();
    }
  });
  $('#select_all_questions').on('change', function() {
    $('.question-checkbox').prop('checked', this.checked);
  });

// Re-associate select all functionality after table draw
bankTable.on('draw', function() {
  // Re-bind select all functionality 
  $('#select_all_questions').prop('checked', false);
});

  // Assign selected questions to quiz
  $('#assign-questions').on('click', function() {
    var selected = $('.question-checkbox:checked').map(function(){ return $(this).val(); }).get();
    if (!selected.length) {
      alert('Select at least one question.');
      return;
    }
    $.post('<?=base_url('admin/question_bank/assign_questions')?>', {
      quiz_id: quiz_id,
      question_ids: selected
    }, function(resp) {
      if (resp.status) {
        alert('Questions assigned successfully! ' + resp.message);
        setTimeout(function() {
          loadAssignedQuestions();
          bankTable.ajax.reload();
        }, 100);
      } else {
        alert('Error: ' + (resp.message || 'Unknown error'));
      }
    }, 'json');
  });
});

// Activate/deactivate question limit inputs based on checkbox
$(document).ready(function() {
    // Initialize inputs based on checkbox state on load
    $('input[name="categories[]"]').each(function() {
        var catId = $(this).val();
        var input = $('input[name="num_questions['+catId+']"]');
        
        if ($(this).is(':checked')) {
            input.prop('disabled', false);
        } else {
            input.prop('disabled', true);
        }
    });
    
    // Handle changes in checkboxes
    $(document).on('change', 'input[name="categories[]"]', function() {
        var catId = $(this).val();
        var input = $('input[name="num_questions['+catId+']"]');
        
        if ($(this).is(':checked')) {
            input.prop('disabled', false);
            // If it's empty, set a default value
            if (input.val() === '') {
                input.val('5');
            }
        } else {
            input.prop('disabled', true);
        }
    });
    
    // Debug - Show available categories in console
    console.log('Categories loaded:', <?= json_encode(isset($categories) ? $categories : []); ?>);
    console.log('Selected categories:', <?= json_encode(isset($selected_categories) ? $selected_categories : []); ?>);
});
</script>