<?global $config;
$model_heads = explode("," , $dt_params['dt_headings'] );

?>

<style type="text/css">
.fileupload-buttonbar .fade {display: none !important;}
.progress {
    position: static;
    
}
</style>

<div class="row">
  <div class="col-md-12">
    <!-- BEGIN VALIDATION STATES-->
      <div class="tabbable tabbable-custom boxless tabbable-reversed">
        <ul class="nav nav-tabs">
              <li class="active">
                <a href="#tab_0" data-toggle="tab">
                Quiz </a>
              </li>
              <?php if($form_data){ ?>
                <li><a href="#tab_1" data-toggle="tab">Manage Questions</a></li>
              <?php } ?>
            </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab_0">
              <div class="portlet box green">
                <div class="portlet-title">
                  <div class="caption">
                    <i class="fa fa-shopping-cart"></i><?=humanize($class_name)?>
                        <small>Add Details to <?=humanize($class_name)?></small>
                  </div>
                  <div class="tools">
                    <a href="javascript:;" class="collapse">
                    </a>
                    <a href="javascript:;" class="reload">
                    </a>
                  </div>
                </div>
                <div class="portlet-body form">
                  <!-- BEGIN FORM-->
                  <?php $this->load->view("admin/widget/form_generator"); ?>


                  <!-- END FORM-->
                </div>
                <!-- END VALIDATION STATES-->
              </div>
            </div>
     

                   <?
            // Images only in edit mode.  
            if($form_data){?>
            <div class="tab-pane" id="tab_1">
              <div class="portlet box green">
                <div class="portlet-body form">
                  <!-- BEGIN FORM-->
                  <?php 
                  // Pasar las variables de categorías a la vista parcial
                  $tab1_data = array(
                    'categories' => isset($categories) ? $categories : array(),
                    'selected_categories' => isset($selected_categories) ? $selected_categories : array(),
                    'id' => $id
                  );
                  $this->load->view("admin/quiz/_tab1", $tab1_data); 
                  ?>
                  <!-- END FORM-->
                </div>
                <!-- END VALIDATION STATES-->
              </div>
            </div>


            
            <?}?>
            

          </div>
      </div>
  </div>
</div>

<!--//mtech work -->
<div class="modal fade" id="findQuestionModal" tabindex="-1" role="dialog" aria-labelledby="findQuestionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="findQuestionModalLabel">Find Quiz Question</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-md-4">
              <div class="list-group" id="module-list">
                <!-- Modules will be dynamically loaded here -->
              </div>
            </div>
            <div class="col-md-8">
              <div id="question-list">
                <!-- Questions will be dynamically loaded here -->
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary" id="importQuestions">Import</button>
        </div>
      </div>
    </div>
  </div>
<!--//mtech work -->


<div id="myModal-question" class="modal fade " role="dialog" style="">
  <div class="modal-dialog" style="width:1300px">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close tournament_close_quiz" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"><strong>Stored Question</strong></h4>
      </div>
      <div class="modal-body">
        <?php
          // Obtener el mapeo de tipos de pregunta desde el controlador de banco de preguntas
          $this->load->model('model_question_bank');
          $question_types = isset($this->model_question_bank->_list_data['qb_type']) ? $this->model_question_bank->_list_data['qb_type'] : array();
          $this->load->view('admin/quiz/_stored_question', ['question_types' => $question_types]);
        ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default tournament_close_quiz">Close</button>
      </div>
    </div>

  </div>
</div>


<script>
  $(document).ready(function() {    
      ///MTech work
      $('#quiz-assignment').prop('disabled', false);
      $('#time_limit_minutes').prop('disabled', false);
      $('#access_code').prop('disabled', false);
      $('#attempt_count').prop('disabled', false);
      
      if($('#quiz-quiz_type').val() == 1){
        $('#quiz-assignment').prop('disabled', true);
        $('#quiz-assignment').val('');
      }
      
      // Control Time Limit fields
      if($('#time_limit').val() == '0'){ // No = 0
          $('#time_limit_minutes').prop('disabled', true);
      }
      
      // Control Access Code fields
      if($('#require_access_code').val() == '0'){ // No = 0
          $('#access_code').prop('disabled', true);
      }
      
      // Control Multiple Attempts fields
      if($('#multiple_attempts').val() == '0'){ // No = 0
          $('#attempt_count').prop('disabled', true);
      }

      $('#quiz-quiz_type').on('change', function(){
        if($(this).val() == 1){
          $('#quiz-assignment').prop('disabled', true);
          $('#quiz-assignment').val('');
        }else{
          $('#quiz-assignment').prop('disabled', false);
        }
      });
    
        // Time Limit control
        $('#time_limit').on('change', function(){
          if($(this).val() == '0'){ // No
              $('#time_limit_minutes').prop('disabled', true);
              $('#time_limit_minutes').val('');
          }else{ // Yes
              $('#time_limit_minutes').prop('disabled', false);
          }
        });
        
        // Access Code control
        $('#require_access_code').on('change', function(){
          if($(this).val() == '0'){ // No
              $('#access_code').prop('disabled', true);
              $('#access_code').val('');
          }else{ // Yes
              $('#access_code').prop('disabled', false);
          }
        });
        
        // Multiple Attempts control
        $('#multiple_attempts').on('change', function(){
          if($(this).val() == '0'){ // No
              $('#attempt_count').prop('disabled', true);
              $('#attempt_count').val('');
          }else{ // Yes
              $('#attempt_count').prop('disabled', false);
          }
        });
      
      
    $('#getData').on('click', function() {
    var url = "<?=la('quiz/paginate')?>";
    var data;

    $.ajax({
        url: url,
        method: 'GET', 
        data: data,
        success: function(response) {
           
            try {
                const responseData = JSON.parse(response);
                
                const s = responseData.data;
               
                const modules = s.map(item => ({ id: item[1], name: item[5] }));
               
                const moduleList = $('#module-list');
                moduleList.empty();
                modules.forEach(module => {
                    moduleList.append(`<a href="#" class="list-group-item list-group-item-action" data-module-id="${module.id}">${module.name}</a>`);
                });

                moduleList.on('click', 'a', function() {
                    const moduleId = $(this).data('module-id');
                    const module = modules.find(m => m.id === moduleId);
                    fetchQuestions(moduleId);
                });
            } catch (error) {
                console.error('Error parsing response:', error);
            }
        },
        error: function(xhr, status, error) {
            console.error('AJAX request error:', error);
        }
    });


});

function stripTags(input) {
    var doc = new DOMParser().parseFromString(input, 'text/html');
    return doc.body.textContent || "";
}

function fetchQuestions(moduleId) {
    var url = "<?= la('quiz/get_questions') ?>"; 
    var data = { cq_quiz_id: moduleId };

    $.ajax({
        url: url,
        method: 'GET',
        data: data,
        success: function(response) {
            try {
                const questionData = JSON.parse(response);
                const questionList = $('#question-list');
                questionList.empty();

                if (questionData.length === 0) {
                    questionList.append(`
                        <p class="d-flex justify-content-center">No questions in this module</p>
                    `);
                } else {
                    questionData.forEach(question => {
                        questionList.append(`
                            <div class="form-check">
                                <input class="form-check-input question-checkbox" type="checkbox" value="${question.cq_id}" id="question-${question.cq_id}" data-quiz_id="${moduleId}" data-table_name="course_quiz">
                                <label class="form-check-label" for="question-${question.cq_id}">
                                    ${stripTags(question.cq_question)}
                                </label>
                            </div>
                        `);
                    });
                }

                // Attach event listener to the checkboxes
                $('.question-checkbox').on('change', function() {
                    collectSelectedQuestionIds();
                });
            } catch (error) {
                console.error('Error parsing questions response:', error);
            }
        },
        error: function(xhr, status, error) {
            console.error('Questions request error:', error);
        }
    });
}

function collectSelectedQuestionIds() {
    let selectedQuestions = [];
    $('.question-checkbox:checked').each(function() {
        const quiz_id = $('#quiz-quiz_id').val();
        const question_id = $(this).val();
        const table_name = $(this).data('table_name');
        selectedQuestions.push({ quiz_id: quiz_id, question_id: question_id, table_name: table_name });
    });
    console.log('Selected question IDs:', selectedQuestions);
}

function submitSelectedQuestions() {
    selectedQuestions = [];
    $('.question-checkbox:checked').each(function() {
        const quiz_id = $('#quiz-quiz_id').val();
        const question_id = $(this).val();
        const table_name = $(this).data('table_name');
        selectedQuestions.push({ quiz_id: quiz_id, question_id: question_id, table_name: table_name });
    });

    // Send the selectedQuestions array to the server
    console.log('Submitting selected question IDs:', selectedQuestions);

    var url = "<?= la('course_quiz/ajax_import_quizes') ?>"; 
    var data = { questions : selectedQuestions} ; 
    $.ajax({
        url: url,
        method: 'POST',
        contentType: 'application/json', 
        data: JSON.stringify(data),
        success: function(response) {
             AdminToastr.success("Questions Added in this Quiz");
             $('#findQuestionModal').hide();
            console.log('Submission completed. Response:', response);
        },
        error: function(xhr, status, error) {
             AdminToastr.success("Something went wrong!");
   
            console.error('Submission request error:', error);
        }
    });
}

// button click to trigger submission
$('#importQuestions').on('click', function() {
    submitSelectedQuestions();
});
    
    ///MTech work
      
      Metronic.init(); // init metronic core components
      QuickSidebar.init(); // init quick sidebar
      Demo.init(); // init demo features
      UIAlertDialogApi.init(); //UI Alert API
      FormFileUpload.init();
      //FormFileUpload2.init();

    if(!<?=$id?>) // when add product detail, disabled images and item set tab
    {
    $('.tabbable li a[href=\#tab_1]').css({"background-color": "#CFD1CF",
                        "color": "#fff"
                        });
    $('.tabbable li a[href=\#tab_2]').css({"background-color": "#CFD1CF",
    "color": "#fff"
    });
    $('.tabbable li a[href=\#tab_1]').click(false);
    $('.tabbable li a[href=\#tab_2]').click(false);
    } 
    if('<?=$_GET["msgtype"]?>' == 'success'){ // when add/edit product detail, switched to images tab
    $('.tabbable li a[href=\#tab_1]').click();
    }
    
      <?if($error)
          echo "AdminToastr.error('".str_replace("\n","",validation_errors('<div>', '</div></br>'))."');";
      ?>

      $("#product-product_brand_id").on('change',function(){
        //alert($(this).val());
        //get brand categories populate in selected categories
        var params = {} ;
        params.search_val = $(this).val();
        var res = AjaxRequest.fire($js_config.base_url + "admin/product/get_brand_categories" , params);
        var selCat = [];
        $(res).each(function(i,v){
          selCat.push(v.bc_category_id);
        })
       if($(selCat).length > 0)
       {
        $('#product_category-pc_category_id').multiSelect('select', selCat);
       }
       else
       {
        $('#product_category-pc_category_id').multiSelect('deselect_all');
       }
      });


      // Product Is Pack?
      pack_size(<?=$form_data['product']['product_is_pack_product']?>);

  });



  $("body").on('click','.btn_delete_size',function(){
    if(confirm('Are you sure you want to delete this question?'))
    {
      var id = $(this).attr('data-id');
      var url = '<?=la("course_quiz/ajax_delete_question")?>';
      var data = {id:id};
      var s = AjaxRequest.fire(url,data);
      if(s.status) {
        // Row Remove
        $("#row-"+id).remove();
      }
      else {
        AdminToastr.error("Error Found please try again");
      }
    }

  });


      
$("body").on('click','#view_question',function(){
    $("#myModal-question").modal();
});


$("body").on('click','.add_this_data',function(){
    var quiz_id = $(this).attr('data-quiz_id');
    var question_id = $(this).val();
    var table_name = $(this).attr('data-table_name');
    var url = "<?=la('course_quiz/ajax_add_quizes')?>";
    var data = {quiz_id:quiz_id,question_id:question_id,table_name:table_name};
    var s = AjaxRequest.fire(url,data);

    if(s.status) {
      AdminToastr.success("Quiz Added in this Quiz");
      $(this).hide();
    }
    else {
      AdminToastr.error("Error found please try again");
    }
});


$("body").on('click','.tournament_close_quiz',function(){
    //$("#myModal-question").modal("toggle");
    window.location.href = "<?=la('quiz/add/'.$form_data['quiz']['quiz_id'])?>";
  });
  
</script>

<script>
  $(document).ready(function() {
    $("body").on('click','.remove-from-quiz',function(){
        console.log('Botón eliminar clickeado', {
          quiz_id: $(this).data('quiz-id'),
          question_id: $(this).data('question-id')
        });
        if(confirm('Are you sure you want to remove this question from the quiz?')) {
            var quiz_id = $(this).data('quiz-id');
            var question_id = $(this).data('question-id');
            $.ajax({
                url: '<?=la("course_quiz/remove_question_from_quiz")?>',
                type: 'POST',
                data: {quiz_id: quiz_id, question_id: question_id},
                dataType: 'json',
                success: function(response) {
                    if(response.status) {
                        AdminToastr.success('Question removed from quiz successfully!');
                        // Recargar la página o la tabla de preguntas
                        location.reload();
                    } else {
                        AdminToastr.error('Error removing question: ' + (response.message || 'Unknown error'));
                    }
                },
                error: function(xhr, status, error) {
                    AdminToastr.error('Error removing question: ' + error);
                }
            });
        }
    });
  });
</script>
