<!-- Herramientas y filtros adicionales -->
<div class="row mb-15" style="margin-bottom: 15px;">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Filter Questions</h3>
                <div class="panel-options">
                    <a href="#" class="panel-minimize">
                        <i class="fa fa-chevron-up"></i>
                    </a>
                </div>
            </div>
            <div class="panel-body">
                <div class="row">
                    <!-- Filtro por curso -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="filter_course">Course:</label>
                            <select id="filter_course" class="form-control">
                                <option value="">All Courses</option>
                                <?php 
                                if (isset($courses) && !empty($courses)) {
                                    foreach ($courses as $course_id => $course_name) {
                                        echo '<option value="'.$course_id.'">'.$course_name.'</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Filtro por asignatura -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="filter_subject">Subject:</label>
                            <select id="filter_subject" class="form-control" disabled>
                                <option value="">Select Course First</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Filtro por tipo de pregunta -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="filter_type">Question Type:</label>
                            <select id="filter_type" class="form-control">
                                <option value="">All Types</option>
                                <?php 
                                if (isset($question_types) && !empty($question_types)) {
                                    foreach ($question_types as $type_id => $type_name) {
                                        echo '<option value="'.$type_id.'">'.$type_name.'</option>';
                                    }
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Bu00fasqueda por texto -->
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search_questions">Search:</label>
                            <input type="text" id="search_questions" class="form-control" placeholder="Search questions...">
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <!-- Opciones adicionales -->
                    <div class="col-md-4">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" id="show_only_unassigned">
                                Show only unassigned questions
                            </label>
                        </div>
                    </div>
                    
                    <!-- Botones de acciu00f3n para selecciu00f3n mu00faltiple -->
                    <div class="col-md-8 text-right">
                        <button type="button" id="btn_select_all" class="btn btn-default btn-sm">
                            <i class="fa fa-check-square-o"></i> Select All
                        </button>
                        <button type="button" id="btn_clear_selection" class="btn btn-default btn-sm">
                            <i class="fa fa-square-o"></i> Clear Selection
                        </button>
                        <button type="button" id="btn_assign_selected" class="btn btn-primary btn-sm" disabled>
                            <i class="fa fa-plus"></i> Assign Selected
                        </button>
                        <button type="button" id="btn_delete_selected" class="btn btn-danger btn-sm" disabled>
                            <i class="fa fa-trash"></i> Delete Selected
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
