<?php
// Mostrar mensajes de flashdata (éxito/error)
if ($this->session->flashdata('success')): ?>
    <div class="alert alert-success alert-dismissible" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <?= $this->session->flashdata('success'); ?>
    </div>
    <script>if (typeof toastr !== 'undefined') toastr.success('<?= addslashes($this->session->flashdata('success')); ?>');</script>
<?php endif; ?>
<?php if ($this->session->flashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <?= $this->session->flashdata('error'); ?>
    </div>
    <script>if (typeof toastr !== 'undefined') toastr.error('<?= addslashes($this->session->flashdata('error')); ?>');</script>
<?php endif; ?>
<?php
// Replicando la estructura de quiz_bank/datatable.php para question_bank
// Variables requeridas: $dt_params, $model_obj, $model_fields, $class_name, $model_name
$dt_params['dt_headings'] = isset($dt_params['dt_headings']) && $dt_params['dt_headings'] ? $dt_params['dt_headings'] : 'checkbox,qb_id,qb_text,qb_course_id,assigned_quizzes,qb_subject_id,qb_type,qb_gain_point,qb_is_bonus,qb_status,actions';
$model_heads = explode(",", $dt_params['dt_headings']);
$class_name = 'Question Bank';
$model_name = 'model_question_bank';

?>
<style type="text/css">
    table.dataTable thead>tr>th.sorting_asc, table.dataTable thead>tr>th.sorting_desc, table.dataTable thead>tr>th.sorting, table.dataTable thead>tr>td.sorting_asc, table.dataTable thead>tr>td.sorting_desc, table.dataTable thead>tr>td.sorting {
        padding-right: 0px;
    }
    .portlet-title button.btn.default.yellow-stripe {
        color: #ffff;
        border-left-color: #003488;
        padding: 7px 15px;
        font-size: 15px;
    }
</style>
<div class="row">
    <div class="col-md-12">
        <div class="portlet">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-list"></i><?=humanize($class_name)?>
                </div>
                <div class="actions">
                    <?php if(!$dt_params['action']['hide_add_button']){?>
                        <a href="<?php echo site_url('admin/question_bank/create'); ?>" class="btn default yellow-stripe">
                            <i class="fa fa-plus"></i>
                            <span class="hidden-480">New Question</span>
                        </a>
                    <?php } ?>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-container">
    <?php $this->load->view('admin/question_bank/partials/additional_tools', [
    'courses' => isset($this->_list_data['qb_course_id']) ? $this->_list_data['qb_course_id'] : [],
    'question_types' => isset($this->_list_data['qb_type']) ? $this->_list_data['qb_type'] : [],
]); ?>
                    <div class="table-actions-wrapper">
                        <span></span>
                        <select class="table-group-action-input form-control input-inline input-small input-sm" data-update-uri="update_status" data-model="<?=$model_name?>">
                            <option value="">Select...</option>
                            <option value="<?=STATUS_ACTIVE?>">Activate selected</option>
                            <option value="<?=STATUS_INACTIVE?>">Deactivate selected</option>
                            <?php if($dt_params['action']['show_delete']){?>
                                <option value="<?=STATUS_DELETE?>">Delete selected</option>
                            <?php } ?>
                        </select>
                        <button class="btn btn-sm yellow table-group-action-submit"><i class="fa fa-check"></i> Execute</button>
                    </div>
                    <table class="table table-striped table-bordered table-hover" id="question_bank_table" style="width:100%">
<!-- DataTables search box is hidden via CSS below -->
                        <thead>
                            <tr role="row" class="heading">
                                <th width="2%"><input type="checkbox" class="group-checkable"></th>
                                <?php
                                    echo '<th>ID</th>';
                                    echo '<th>Question</th>';
                                    echo '<th>Assigned courses</th>';
                                    echo '<th>Assigned quizzes</th>';
                                    echo '<th>Subject</th>';
                                    echo '<th>Type</th>';
                                    echo '<th>Base Points</th>';
                                    echo '<th>Is bonus?</th>';
                                    echo '<th>Status</th>';
                                    echo '<th width="15%">Actions</th>';
                                ?>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    // Global URLs configuration for question_bank.js
    window.QuestionBankConfig = {
        urls: {
            getQuestionBankData: '<?= base_url('admin/question_bank/get_question_bank_data') ?>',
            getSubjectList: '<?= base_url('admin/question_bank/get_subjects') ?>',
            getQuizzes: '<?= base_url('admin/quiz/get_quizzes') ?>',
            assignQuestions: '<?= base_url('admin/question_bank/assign_questions') ?>',
            deleteQuestion: '<?= base_url('admin/question_bank/delete_question') ?>',
            getQuizQuestions: '<?= base_url('admin/quiz/get_quiz_questions') ?>',
            editQuestion: '<?= base_url('admin/question_bank/edit/') ?>',
            removeQuestionFromQuiz: '<?= base_url('admin/quiz/remove_question_from_quiz') ?>',
            saveQuestionOrder: '<?= base_url('admin/quiz/save_question_order') ?>'
        }
    };
</script>
<script src="<?php echo base_url('assets/admin/scripts/layout.js'); ?>"></script>
<script>
    $(document).ready(function() {
        Metronic.init(); // init metronic core components
        Layout.init(); // <--- Asegura el funcionamiento del menú lateral
        QuickSidebar.init(); // init quick sidebar
        Demo.init(); // init demo features
        UIAlertDialogApi.init(); // UI Alert API
    });
</script>

<style>
    /* Styles for assignment tags */
    .quiz-tags {
        display: flex;
        flex-wrap: wrap;
        gap: 4px;
    }
    
    .quiz-tags .badge {
        margin: 2px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 100px;
    }
    
    /* Style for action buttons */
    .action-btn-container {
        display: flex;
        justify-content: center;
        gap: 5px;
    }
    
    /* Limit cell height for better visualization */
    #question_bank_table td {
        max-height: 100px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    /* Hide DataTables search box */
    .dataTables_filter { display: none !important; }
</style>

<!-- DataTables and dependencies -->
<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/global/plugins/datatables/media/css/jquery.dataTables.min.css'); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo base_url('assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.css'); ?>" />

<script src="<?php echo base_url('assets/admin/scripts/jquery.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/admin/scripts/jquery.blockui.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/global/plugins/datatables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/global/plugins/datatables/plugins/bootstrap/dataTables.bootstrap.js'); ?>"></script>
<!-- Scripts de Metronic y helpers -->
<script src="<?php echo base_url('assets/admin/scripts/metronic.js'); ?>"></script>

<script src="<?php echo base_url('assets/admin/scripts/quick-sidebar.js'); ?>"></script>
<script src="<?php echo base_url('assets/admin/scripts/demo.js'); ?>"></script>

<script src="<?php echo base_url('assets/admin/scripts/ui-alert-dialog-api.js'); ?>"></script>
