<!-- Vista para importar preguntas desde Excel -->
<div class="row">
    <div class="col-md-12">
        <?php echo form_open_multipart('admin/question_bank/process_import', array('class' => 'form-horizontal', 'id' => 'import_form')); ?>
        
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Import Questions</h3>
            </div>
            
            <div class="panel-body">
                <div class="alert alert-info">
                    <h4><i class="fa fa-info-circle"></i> Instructions</h4>
                    <p>Upload an Excel file (.xlsx) containing questions to import to the question bank. The file must follow the required format.</p>
                    <ul>
                        <li>Column A: Question Text (required)</li>
                        <li>Column B: Question Type (1=Multiple Choice, 2=True/False, 3=Essay, etc.) (required)</li>
                        <li>Column C: Options (for Multiple Choice/True/False questions, format: option1|option2|option3)</li>
                        <li>Column D: Correct Answers (for Multiple Choice, format: 1 for first option, 2 for second, etc.)</li>
                        <li>Column E: Explanation (optional)</li>
                        <li>Column F: Is Bonus (1=Yes, 0=No)</li>
                        <li>Column G: Bonus Points (if is bonus)</li>
                        <li>Column H: Difficulty (1-5)</li>
                        <li>Column I: Tags (comma separated)</li>
                    </ul>
                    <p><a href="<?php echo site_url('admin/question_bank/download_template'); ?>" class="btn btn-sm btn-default"><i class="fa fa-download"></i> Download Template</a></p>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">Excel File</label>
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" class="form-control" id="file_name" readonly placeholder="Select file...">
                            <span class="input-group-btn">
                                <span class="btn btn-primary btn-file">
                                    <i class="fa fa-folder-open"></i> Browse <input type="file" name="excel_file" id="excel_file" accept=".xlsx">
                                </span>
                            </span>
                        </div>
                        <span class="help-block">Select the Excel file (.xlsx) containing questions to import</span>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">Course (Optional)</label>
                    <div class="col-md-6">
                        <select name="course_id" id="course_id" class="form-control">
                            <option value="">No specific course</option>
                            <?php 
                            if (isset($courses) && !empty($courses)) {
                                foreach ($courses as $course_id => $course_name) {
                                    echo '<option value="'.$course_id.'">'.$course_name.'</option>';
                                }
                            }
                            ?>
                        </select>
                        <span class="help-block">Optionally associate all imported questions with this course</span>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">Subject (Optional)</label>
                    <div class="col-md-6">
                        <select name="subject_id" id="subject_id" class="form-control" disabled>
                            <option value="">Select Course First</option>
                        </select>
                        <span class="help-block">Optionally associate all imported questions with this subject</span>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">Options</label>
                    <div class="col-md-6">
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="skip_header" value="1" checked>
                                Skip first row (header)
                            </label>
                        </div>
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="validate_only" value="1">
                                Validate only (no import)
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-9 col-md-offset-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-upload"></i> Import Questions
                        </button>
                        <a href="<?php echo site_url('admin/question_bank'); ?>" class="btn btn-default">
                            <i class="fa fa-times"></i> Cancel
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <?php echo form_close(); ?>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        // Mostrar nombre del archivo seleccionado
        $('#excel_file').change(function() {
            var fileName = $(this).val().split('\\').pop();
            $('#file_name').val(fileName);
        });
        
        // Cargar asignaturas cuando se selecciona un curso
        $('#course_id').change(function() {
            var courseId = $(this).val();
            var subjectSelect = $('#subject_id');
            
            if (courseId) {
                // Habilitar el selector de asignaturas
                subjectSelect.prop('disabled', false);
                
                // Cargar asignaturas para este curso
                $.ajax({
                    url: '<?php echo site_url("admin/question_bank/get_subjects"); ?>',
                    type: 'POST',
                    data: { course_id: courseId },
                    dataType: 'json',
                    success: function(response) {
                        subjectSelect.empty();
                        subjectSelect.append('<option value="">No specific subject</option>');
                        
                        if (response.status && response.subjects.length > 0) {
                            $.each(response.subjects, function(i, subject) {
                                subjectSelect.append('<option value="' + subject.id + '">' + subject.name + '</option>');
                            });
                        }
                    },
                    error: function() {
                        console.error('Failed to load subjects');
                    }
                });
            } else {
                // Deshabilitar y reiniciar el selector de asignaturas
                subjectSelect.prop('disabled', true);
                subjectSelect.empty();
                subjectSelect.append('<option value="">No specific subject</option>');
            }
        });
        
        // Validación del formulario
        $('#import_form').submit(function(e) {
            if (!$('#excel_file').val()) {
                alert('Please select a file to import');
                e.preventDefault();
                return false;
            }
            
            return true;
        });
    });
</script>
