<!-- Formulario para crear/editar preguntas -->
<div class="row">
    <div class="col-md-12">
        <?php echo form_open('', array('class' => 'form-horizontal', 'id' => 'question_form')); ?>
        
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><?php echo isset($question) ? 'Edit Question' : 'Create New Question'; ?></h3>
            </div>
            
            <div class="panel-body">
                <!-- Campos ocultos si es ediciu00f3n -->
                <?php if(isset($question)): ?>
                    <input type="hidden" name="question[qb_id]" value="<?php echo $question['qb_id']; ?>">
                <?php endif; ?>
                
                <!-- Curso -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Course</label>
                    <div class="col-md-6">
                        <select name="question[qb_course_id]" id="course_id" class="form-control" required>
                            <option value="">Select Course</option>
                            <?php if (isset($layout_data['courses']) && is_array($layout_data['courses']) && count($layout_data['courses']) > 0): ?>
    <?php foreach($layout_data['courses'] as $course_id => $course_title): ?>
        <option value="<?php echo $course_id; ?>" <?php echo (isset($question) && isset($question['qb_course_id']) && $question['qb_course_id'] == $course_id) ? 'selected' : ''; ?>>
            <?php echo htmlspecialchars($course_title); ?>
        </option>
    <?php endforeach; ?>
<?php else: ?>
    <option value="">No courses available</option>
<?php endif; ?>
                        </select>
                        <span class="help-block">Select the course for this question</span>
                    </div>
                </div>
                <!-- Materia -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Subject</label>
                    <div class="col-md-6">
                        <select name="question[qb_subject_id]" id="subject_id" class="form-control" required>
                            <option value="">Select Subject</option>
                            <?php if (!empty($subjects) && is_array($subjects)): ?>
                                <?php foreach($subjects as $subject_id => $subject_title): ?>
                                    <option value="<?php echo $subject_id; ?>" <?php echo (isset($question) && $question['qb_subject_id'] == $subject_id) ? 'selected' : ''; ?>>
                                        <?php echo $subject_title; ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <option value="">No subjects available</option>
                            <?php endif; ?>
                        </select>
                        <span class="help-block">Select the subject for this question</span>
                    </div>
                </div>
                <!-- Tipo de pregunta -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Question Type</label>
                    <div class="col-md-6">
                        <select name="question[qb_type]" id="question_type" class="form-control" required>
                            <option value="">Select Type</option>
                            <?php foreach($layout_data['question_types'] as $type_id => $type_name): ?>
                                <option value="<?php echo $type_id; ?>" <?php echo (isset($question) && $question['qb_type'] == $type_id) ? 'selected' : ''; ?>>
                                    <?php echo $type_name; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <span class="help-block">Select the type of question</span>
                    </div>
                </div>
                
                <!-- Texto de la pregunta -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Question Text</label>
                    <div class="col-md-6">
                        <textarea name="question[qb_text]" id="question_text" class="form-control summernote" rows="5" required><?php echo isset($question) ? html_entity_decode($question['qb_text']) : ''; ?></textarea>
                        <span class="help-block">Enter the full text of the question</span>
                    </div>
                </div>
                
                <!-- Explicaciu00f3n (opcional) -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Explanation (Optional)</label>
                    <div class="col-md-6">
                        <textarea name="question[qb_explanation]" id="question_explanation" class="form-control summernote" rows="3"><?php echo isset($question) ? htmlspecialchars($question['qb_explanation']) : ''; ?></textarea>
                        <span class="help-block">Optional explanation or notes about this question</span>
                    </div>
                </div>
                
                <!-- Opciones de respuesta (para preguntas de opciu00f3n mu00faltiple y verdadero/falso) -->
                <div id="options_container" class="form-group" style="<?php echo (isset($question) && in_array($question['qb_type'], [1, 2])) ? '' : 'display:none;'; ?>">
                    <label class="col-md-3 control-label">Answer Options</label>
                    <div class="col-md-6">
                        <div id="options_list">
                            <?php if(isset($question) && isset($question['options']) && !empty($question['options'])): ?>
                                <?php foreach($question['options'] as $index => $option): ?>
                                    <div class="option-item panel panel-default mb-3 p-2" style="border-left: 4px solid #337ab7;">
                                        <div class="panel-body p-0">
                                            <div class="form-row row align-items-center">
                                                <div class="col-xs-12 col-sm-8 col-md-8 mb-2">
                                                    <label class="sr-only" for="option_text_<?php echo $index; ?>">Option Text</label>
                                                    <textarea id="option_text_<?php echo $index; ?>" name="options[<?php echo $index; ?>][text]" class="form-control input-sm" rows="2" placeholder="Option text..." required><?php echo htmlspecialchars($option['text']); ?></textarea>
                                                </div>
                                                <div class="col-xs-6 col-sm-2 col-md-2 mb-2">
                                                    <div class="checkbox mt-1">
                                                        <label>
                                                            <input type="checkbox" name="options[<?php echo $index; ?>][is_correct]" value="1" <?php echo isset($option['is_correct']) && $option['is_correct'] ? 'checked' : ''; ?>>
                                                            Correct
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="col-xs-6 col-sm-2 col-md-2 text-right mb-2">
                                                    <button type="button" class="btn btn-danger btn-sm remove-option" aria-label="Remove option">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="form-row row">
                                                <div class="col-xs-12 col-sm-12 col-md-12">
                                                    <label class="sr-only" for="option_feedback_<?php echo $index; ?>">Feedback (Optional)</label>
                                                    <input type="text" id="option_feedback_<?php echo $index; ?>" name="options[<?php echo $index; ?>][feedback]" class="form-control input-sm" value="<?php echo isset($option['feedback']) ? htmlspecialchars($option['feedback']) : ''; ?>" placeholder="Feedback (optional)">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        
                        <button type="button" id="add_option" class="btn btn-info btn-sm">
                            <i class="fa fa-plus"></i> Add Option
                        </button>
                        
                        <span class="help-block">Add answer options for multiple choice or true/false questions</span>
                    </div>
                </div>
                
                <!-- Configuraciu00f3n de bonus -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Bonus Question</label>
                    <div class="col-md-6">
                        <div class="checkbox">
                            <label>
                                <input type="hidden" name="question[qb_is_bonus]" value="0">
                                <input type="checkbox" name="question[qb_is_bonus]" value="1" <?php echo (isset($question) && $question['qb_is_bonus'] == 1) ? 'checked' : ''; ?>>
                                Mark as bonus question
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Puntos de bonus -->
                <div id="bonus_points_container" class="form-group" style="<?php echo (isset($question) && $question['qb_is_bonus'] == 1) ? '' : 'display:none;'; ?>">
                    <label class="col-md-3 control-label">Bonus Points</label>
                    <div class="col-md-6">
                        <input type="number" name="question[qb_bonus_points]" class="form-control" min="0" step="0.1" value="<?php echo isset($question) ? $question['qb_bonus_points'] : '0'; ?>">
                        <span class="help-block">Points awarded for this bonus question</span>
                    </div>
                </div>
                
                <!-- Dificultad -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Difficulty Level</label>
                    <div class="col-md-6">
                        <select name="question[qb_difficulty]" class="form-control">
                            <option value="1" <?php echo (isset($question) && $question['qb_difficulty'] == 1) ? 'selected' : ''; ?>>Very Easy</option>
                            <option value="2" <?php echo (isset($question) && $question['qb_difficulty'] == 2) ? 'selected' : ''; ?>>Easy</option>
                            <option value="3" <?php echo (isset($question) && $question['qb_difficulty'] == 3) ? 'selected' : ''; ?>>Medium</option>
                            <option value="4" <?php echo (isset($question) && $question['qb_difficulty'] == 4) ? 'selected' : ''; ?>>Hard</option>
                            <option value="5" <?php echo (isset($question) && $question['qb_difficulty'] == 5) ? 'selected' : ''; ?>>Very Hard</option>
                        </select>
                    </div>
                </div>
                
                <!-- Puntos Base -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Base Points</label>
                    <div class="col-md-6">
                        <input type="number" name="question[qb_gain_point]" class="form-control" min="0" step="0.1" value="<?php echo isset($question) && !empty($question['qb_gain_point']) ? $question['qb_gain_point'] : '1.0'; ?>" required>
                        <span class="help-block">Default points awarded for this question (can be overridden when assigning to specific quizzes)</span>
                    </div>
                </div>
                
                <!-- Etiquetas -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Tags (Optional)</label>
                    <div class="col-md-6">
                        <input type="text" name="question[qb_tags]" class="form-control" value="<?php echo isset($question) ? $question['qb_tags'] : ''; ?>" placeholder="tag1, tag2, tag3">
                        <span class="help-block">Optional: Add comma-separated tags to help categorize questions</span>
                    </div>
                </div>
                
                <!-- Estado -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Status</label>
                    <div class="col-md-6">
                        <select name="question[qb_status]" class="form-control">
                            <option value="1" <?php echo (!isset($question) || $question['qb_status'] == 1) ? 'selected' : ''; ?>>Active</option>
                            <option value="0" <?php echo (isset($question) && $question['qb_status'] == 0) ? 'selected' : ''; ?>>Inactive</option>
                        </select>
                    </div>
                </div>
                
                <?php if(isset($question) && isset($usage) && !empty($usage)): ?>
                <!-- Informaciu00f3n de uso -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Used In Quizzes</label>
                    <div class="col-md-6">
                        <div class="alert alert-info">
                            <p>This question is used in the following quizzes:</p>
                            <ul>
                                <?php foreach($usage as $quiz): ?>
                                    <li><?php echo $quiz['quiz_name']; ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-9 col-md-offset-3">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> <?php echo isset($question) ? 'Update Question' : 'Save Question'; ?>
                        </button>
                        <a href="<?php echo site_url('admin/question_bank'); ?>" class="btn btn-default">
                            <i class="fa fa-times"></i> Cancel
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <?php echo form_close(); ?>
    </div>
</div>
<!-- Mensajes de error si no hay cursos o materias -->
<?php if (empty($courses) || !is_array($courses)): ?>
    <div class="alert alert-warning">No courses available. Please create a course first.</div>
<?php endif; ?>
<?php if (empty($subjects)): ?>
    <div class="alert alert-warning">No subjects available. Please create a subject first.</div>
<?php endif; ?>
        
        <script type="text/javascript">

$(document).ready(function() {
    var optionCounter = $('#options_list .option-item').length;
    

    function addOption(text, isCorrect, feedback) {
        
        var html = '<div class="option-item panel panel-default mb-3 p-2" style="border-left: 4px solid #337ab7;">' +
            '<div class="panel-body p-0">' +
                '<div class="form-row row align-items-center">' +
                    '<div class="col-xs-12 col-sm-8 col-md-8 mb-2">' +
                        '<label class="sr-only" for="option_text_' + optionCounter + '">Option Text</label>' +
                        '<textarea id="option_text_' + optionCounter + '" name="options[' + optionCounter + '][text]" class="form-control input-sm" rows="2" placeholder="Option text..." required>' + (text || '') + '</textarea>' +
                    '</div>' +
                    '<div class="col-xs-6 col-sm-2 col-md-2 mb-2">' +
                        '<div class="checkbox mt-1">' +
                            '<label>' +
                                '<input type="checkbox" name="options[' + optionCounter + '][is_correct]" value="1"' + (isCorrect ? ' checked' : '') + '>Correct' +
                            '</label>' +
                        '</div>' +
                    '</div>' +
                    '<div class="col-xs-6 col-sm-2 col-md-2 text-right mb-2">' +
                        '<button type="button" class="btn btn-danger btn-sm remove-option" aria-label="Remove option">' +
                            '<i class="fa fa-trash"></i>' +
                        '</button>' +
                    '</div>' +
                '</div>' +
                '<div class="form-row row">' +
                    '<div class="col-xs-12 col-sm-12 col-md-12">' +
                        '<label class="sr-only" for="option_feedback_' + optionCounter + '">Feedback (Optional)</label>' +
                        '<input type="text" id="option_feedback_' + optionCounter + '" name="options[' + optionCounter + '][feedback]" class="form-control input-sm" placeholder="Feedback (optional)" value="' + (feedback || '') + '">' +
                    '</div>' +
                '</div>' +
            '</div>' +
        '</div>';
        $('#options_list').append(html);
        optionCounter++;
    }

    function clearOptions() {
        $('#options_list').empty();
        optionCounter = 0;
    }

    function showOptionsForType(type) {
        
        if (type == '1') { // Multiple Choice
            $('#options_container').show();
            if ($('#options_list .option-item').length == 0) {
                
                addOption('', false, '');
                addOption('', false, '');
            }
        } else if (type == '2') { // True/False
            $('#options_container').show();
            clearOptions();
            
            addOption('True', false, '');
            addOption('False', false, '');
        } else {
            $('#options_container').hide();
            clearOptions();
        }
    }

    // Inicializar al cargar la página
    var initialType = $('#question_type').val();
    
    showOptionsForType(initialType);

    // Al cambiar el tipo de pregunta
    $('#question_type').change(function() {
        var type = $(this).val();
        
        showOptionsForType(type);
    });

    // Botón para agregar opción
    $('#add_option').off('click').on('click', function() {
        addOption('', false, '');
    });

    // Eliminar opción
    $('#options_list').on('click', '.remove-option', function() {
        $(this).closest('.option-item').remove();
    });
    
    // Mostrar/ocultar puntos de bonus
    $('input[name="question[qb_is_bonus]"]').change(function() {
        if ($(this).is(':checked')) {
            $('#bonus_points_container').show();
        } else {
            $('#bonus_points_container').hide();
        }
    });
    
    // Cargar asignaturas cuando se selecciona un curso
    $('#course_id').change(function() {
        var courseId = $(this).val();
        var subjectSelect = $('#subject_id');
        
        if (courseId) {
            // Habilitar el selector de asignaturas
            subjectSelect.prop('disabled', false);
            
            // Cargar asignaturas para este curso
            $.ajax({
                url: '<?php echo site_url("admin/question_bank/get_subjects"); ?>',
                type: 'POST',
                data: { course_id: courseId },
                dataType: 'json',
                success: function(response) {
                    subjectSelect.empty();
                    subjectSelect.append('<option value="">No specific subject</option>');
                    
                    if (response.status && response.subjects.length > 0) {
                        $.each(response.subjects, function(i, subject) {
                            subjectSelect.append('<option value="' + subject.id + '">' + subject.name + '</option>');
                        });
                    }
                },
                error: function() {
                    console.error('Failed to load subjects');
                }
            });
        } else {
            // Deshabilitar y reiniciar el selector de asignaturas
            subjectSelect.prop('disabled', true);
            subjectSelect.empty();
            subjectSelect.append('<option value="">No specific subject</option>');
        }
    });
    
    // Inicializar editor WYSIWYG si está disponible
    if (typeof CKEDITOR !== 'undefined') {
        CKEDITOR.replace('question_text');
        CKEDITOR.replace('question_explanation');
    }
    
    // Validación del formulario
    $('#question_form').submit(function(e) {
        // Sincroniza Summernote con el textarea real
        $('.summernote').each(function() {
            var code = $(this).summernote('code');
            $(this).val(code);
        });
        var questionType = $('#question_type').val();
        // Validar que se haya seleccionado un tipo de pregunta
        if (!questionType) {
            alert('Please select a question type');
            e.preventDefault();
            return false;
        }
        // Validar opciones para preguntas de opción múltiple o verdadero/falso
        if (questionType == '1' || questionType == '2') {
            if ($('#options_list .option-item').length == 0) {
                alert('Please add at least one answer option');
                e.preventDefault();
                return false;
            }
            var hasCorrectAnswer = false;
            $('#options_list input[name$="[is_correct]"]').each(function() {
                if ($(this).is(':checked')) {
                    hasCorrectAnswer = true;
                    return false; // Break the loop
                }
            });
            if (!hasCorrectAnswer) {
                alert('Please mark at least one option as correct');
                e.preventDefault();
                return false;
            }
        }
        return true;
    });
});
</script>
<!-- Summernote CSS/JS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.18/summernote.min.js"></script>
<script>
$(document).ready(function() {
    $('.summernote').summernote({
        placeholder: 'Write your question here',
        tabsize: 2,
        height: 150,
        toolbar: [
            ['style', ['bold', 'italic', 'underline', 'clear']],
            ['font', ['strikethrough', 'superscript', 'subscript']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['insert', ['link', 'picture']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ]
    });
});
</script>
