<?global $config;
$dt_params['dt_headings'] = $dt_params['dt_headings'] ? $dt_params['dt_headings'] : $model_obj->pagination_params['fields'] ;
$model_heads = explode("," , $dt_params['dt_headings'] );
echo create_modal_html("view_product" , "Detail");
$id = $course_id;
?>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<link href="https://cdn.datatables.net/2.1.6/css/dataTables.dataTables.css" rel="stylesheet">

<style type="text/css">


    .dt-column-title{
         display:flex;
         flex-direction:column;
         text-align:center;
    }

  
 .gradebook-tooltip {
    position: relative;
    display: inline-block;
    cursor: pointer;
}
.dropdown-menu {
    text-transform: capitalize;
    left: 16px;
    padding:10px;
}
.dropdown-item {
    cursor: pointer; 
}

.dropdown-item:hover {
    background-color: #f0f0f0; 
}
.gradebook-tooltip:hover::after {
    content: attr(data-tooltip);
    position: absolute;
    background-color: #333;
    color: #fff;
    padding: 5px;
    border-radius: 3px;
    top: 100%; /* Position below the element */
    left: 50%;
    transform: translateX(-50%);
    white-space: nowrap;
    z-index: 10;
    font-size: 12px;
}
.badge{
    margin-left:3px;
    font-size: 14px !important;
    text-transform: capitalize;
    height: auto;
    padding: 5px 6px 5px 9px;
}
.close {
    margin-left:4px;
    margin-right:3px;
    margin-top:3px;
}
</style>



<div class="row">
  <div class="col-md-12">
    <!-- BEGIN VALIDATION STATES-->
    <div class="portlet">
      <div class="portlet-title">
        <div class="caption"><i class="fa fa-list"></i>Grade</div>
        
        <div class="actions">
                   <button type="button" class="btn btn-info btn-lg" data-toggle="modal" data-target="#myModal1" data-backdrop="static" data-keyboard="false"><i class="fa fa-gear"></i>
                    </button>
		</div>
        <div class="actions" style="margin-right:5px;">
                   <button type="button" class="btn btn-info btn-lg" data-toggle="modal" data-target="#myModalGrading" data-backdrop="static" data-keyboard="false"><i class="fa fa-graduation-cap"></i>
                    </button>
		</div>
      </div>

      <div class="portlet-body">
      <div class="table-container">
          	<div class="table-actions-wrapper">
						<span>
						</span>
						<select class="table-group-action-input form-control input-inline input-small input-sm" data-update-uri="update_status" data-model="<?=$model_name?>">
							<option value="">Select...</option>
							<option value="<?=STATUS_ACTIVE?>">Release Selected</option>
							<option value="<?=STATUS_INACTIVE?>">Hide Selected</option>
                            <?if($dt_params['action']['show_delete']){?>
							    <option value="<?=STATUS_DELETE?>">Delete Selected</option>
                            <?}?>
						</select>
						<button class="btn btn-sm yellow table-group-action-submit"><i class="fa fa-check"></i> Submit</button>
					</div>
            <div class="row">
                <div class="col-md-6">
                    <label for="studentSearch">Search Student:</label>
                    <input type="text" id="studentSearch" class="form-control" placeholder="Enter Student Name">
                    <ul class="dropdown-menu" id="studentDropdown" aria-labelledby="studentSearch" style="display: none;"></ul>
                </div>
                <div class="col-md-6">
                    <label for="assignmentSearch">Search Assignment:</label>
                    <input type="text" id="assignmentSearch" class="form-control" placeholder="Enter Assignment">
                    <ul id="assignmentDropdown" class="dropdown-menu dropdown" style="display:none;"></ul>
                </div>
            </div>
            <br>
            <table class="table table-striped table-bordered table-hover table-scrollable" id="gradeTable">
                    <thead>
                        <tr style="background-color: #003488 !important; color: #fff; font-size: 16px; font-weight: 300; padding: 13px; border: none; width:100%;">
                            <th>ID</th>
                            <th>Student ID</th>
                            <th>Student Name</th>
                            <?php foreach ($quizzes_assignments as $qa): ?>
                                <th><?= ucfirst($qa['title']); ?> <br> <small>Out of <?= round($qa['total_marks'],2); ?></small>  
                                </th>
                                
                            <?php endforeach; ?>
                            <th>Marks Obtained</th>
                            <th>Total Marks</th>
                            <?php foreach ($assignment_groups as $ag):
                                    if(isset($ag['assignment_group_name'])){
                            ?>
                                <th><?= ucfirst($ag['assignment_group_name']); ?> <br> <small><?= $ag['assignment_group_percentage']; ?>% of grade</small></th>
                            <?php } endforeach; ?>
                            <th>Final Grade (%)</th> <!-- Column for final percentage -->
                            <!--<th>Percentage</th>-->
                            <th>Grade</th>
                        </tr>
                        <tr>
                            <th></th>
                            <th></th>
                            <th></th>
                            <?php foreach ($quizzes_assignments as $qa): ?>
                            <th><a href="#" class="releasegrade" data-grade="<?= $qa['grade_related_id']; ?>" data-type="<?= $qa['grade_type']; ?>"><i class="fa <?= $qa['visible_status'] ? 'fa-eye' : 'fa-eye-slash'; ?>"></i></a></th>
                            <?php endforeach; ?>
                            <th></th>
                            <th></th>
                            <?php foreach ($assignment_groups as $ag):  
                            if (isset($ag['assignment_group_id'])){?>
                        <th></th>
                            <?php  } endforeach; ?>
                            <th></th>
                            <th></th>
                        </tr>
                    </thead>
                
              
                <tbody>
    <?php
    $student_grades = [];
    $i = 1;

    // Organize grades by user ID and assignment
    foreach ($grades as $grade) {
        $student_grades[$grade['user_id']]['username'] = $grade['username'];
        $student_grades[$grade['user_id']]['grades'][$grade['grade_related_id']] = [
            'marks' => $grade['grade_marks'],
            'total' => $grade['grade_total_marks'],
            'percentage' => $grade['grade_percentage']
        ];
    }

    // Loop through each student to display their grades and calculate totals
    foreach ($student_grades as $student_id => $student) {
        $total_marks = 0;
        $obtained_marks = 0;
        $grouped_marks = [];
        $final_grade_percentage = 0;

        // Initialize group marks array (don't reset inside the loop)
        foreach ($assignment_groups as $ag) {
            $grouped_marks[$ag['assignment_group_id']] = ['obtained' => 0, 'total' => 0];
        }
    ?>
    <tr>
        <td><?= $i++; ?></td>
        <td><?= $student_id; ?></td>
        <td><?= ucfirst($student['username']); ?></td>

        <!-- Display grades for each quiz/assignment -->
        <?php foreach ($quizzes_assignments as $qa): 
            
            $marks = isset($student['grades'][$qa['grade_related_id']]) ? $student['grades'][$qa['grade_related_id']]['marks'] : 0;
            $total = isset($student['grades'][$qa['grade_related_id']]) ? $student['grades'][$qa['grade_related_id']]['total'] : 0;
            $obtained_marks += $marks;
            
            $total_marks += $qa['total_marks'];
        ?>
            <td><?= $marks; ?></td>
            
            <?php
            // Accumulate marks for the assignment group
            $assignment_group_id = $qa['assignment_group_id'];
            if (isset($grouped_marks[$assignment_group_id])) {
                $grouped_marks[$assignment_group_id]['obtained'] += $marks;
                $grouped_marks[$assignment_group_id]['total'] += $total;
            }
            endforeach; 
        ?>

        <!-- Marks Obtained and Total Marks -->
        <td><?= $obtained_marks; ?></td>
        <td><?= round($total_marks, 2); ?></td>

        <!-- Display the marks obtained/total for each assignment group -->
        <?php foreach ($assignment_groups as $ag): 
            $group_obtained = $grouped_marks[$ag['assignment_group_id']]['obtained'];
            $group_total = $grouped_marks[$ag['assignment_group_id']]['total'];
            $group_percentage = $group_total > 0 ? round(($group_obtained / $group_total) * 100, 2) : 0;
            
            $group_grade = $group_percentage * ($ag['assignment_group_percentage'] / 100);
            
            
            $final_grade_percentage += $group_grade;
            
            
            $grade_letter = '';

    $grading_system = $grading_settings['grading_system'];

    switch ($grading_system) {
        case 'pass_fail':
            // For Pass/Fail system
            $grade_letter = ($final_grade_percentage >= $grading_settings['pass_percentage']) ? 'Pass' : 'Fail';
            break;

        case 'letter_grade':
            // For Letter Grade system
            if ($final_grade_percentage >= $grading_settings['grade_a_percentage']) {
                $grade_letter = 'A';
            } elseif ($final_grade_percentage >= $grading_settings['grade_b_percentage']) {
                $grade_letter = 'B';
            } elseif ($final_grade_percentage >= $grading_settings['grade_c_percentage']) {
                $grade_letter = 'C';
            } elseif ($final_grade_percentage >= $grading_settings['grade_d_percentage']) {
                $grade_letter = 'D';
            } else {
                $grade_letter = 'F';
            }
            break;

        case 'gpa':
            // For GPA system
            if ($final_grade_percentage >= $grading_settings['gpa_4_percentage']) {
                $grade_letter = '4.0';
            } elseif ($final_grade_percentage >= $grading_settings['gpa_3_percentage']) {
                $grade_letter = '3.0';
            } elseif ($final_grade_percentage >= $grading_settings['gpa_2_percentage']) {
                $grade_letter = '2.0';
            } elseif ($final_grade_percentage >= $grading_settings['gpa_1_percentage']) {
                $grade_letter = '1.0';
            } else {
                $grade_letter = '0.0'; // GPA 0
            }
            break;

        case 'custom':
            // For Custom grading system (assuming custom grades are provided in a JSON format)
            $custom_grades = json_decode($grading_settings['custom_grades'], true);
            foreach ($custom_grades as $grade => $threshold) {
                if ($final_grade_percentage >= $threshold) {
                    $grade_letter = $grade;
                    break;
                }
            }
            if (!$grade_letter) {
                $grade_letter = 'No Grade'; // If no custom grade matches
            }
            break;
    }
            
        ?>
        <td>
            <div class="gradebook-tooltip" data-tooltip="Marks: <?= $group_obtained . '/' . round($group_total, 2); ?>">
                <?= $group_percentage; ?>%
            </div>
        </td>          
        <?php endforeach; ?>

        <td>
            <?= number_format($final_grade_percentage, 2); ?>%
        </td>
        <td>
            <?= $grade_letter; ?>
        </td>
    </tr>
    <?php } ?>
</tbody>



            </table>
            
          </div>
        </div>
        </div>

      <!-- END VALIDATION STATES-->
    </div>
  </div>
<div class="clearfix">
</div>

<!-- Modal -->
<div id="myModal1" class="modal fade myModal1 abc" role="dialog">
  <div class="modal-dialog modal-lg">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Late Policies Setting</h4>
      </div>
      <form class="form_assignment_group">
        <div class="modal-body">
        
          <div class="row" style="margin-bottom:30px;">
            <div class="col-12 col-md-12 col-sm-12" style="margin-bottom:30px;">
                <input class="form-control" type="checkbox" id="missing_percentage_status" name="missing_percentage_status" <?= $gradesetting[0]['missing_percentage_status'] ? 'checked' : ''?>> 
                <strong> Automatically apply grade for missing submissions</strong>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-12 col-sm-12" style="display:flex;">
              <label for="missing_percentage">Grade for missing submissions</label>
              <input class="form-control" id="missing_percentage" name="missing_percentage" type="number" 
               value="<?= isset($gradesetting[0]['missing_percentage']) ? $gradesetting[0]['missing_percentage'] : '' ?>"> 
                <strong>%</strong>
              <input class="form-control" name="course_id" required type="hidden" value="<?= $id ?>"> 
              <input class="form-control" name="grade_setting_id" required type="hidden" value="<?= $gradesetting[0]['grade_setting_id'] ?>"> 
            </div>
          </div>
          <hr>
          <div class="row">
            <div class="col-12 col-md-12 col-sm-12" style="margin-bottom:30px;">
              <input class="form-control" type="checkbox" id="late_percentage_status" name="late_percentage_status" <?= $gradesetting[0]['late_percentage_status'] ? 'checked' : ''?>> 
              <strong> Automatically apply deduction to late submissions</strong>
            </div>
          </div>
          <div class="row">
            <div class="col-12 col-md-12 col-sm-12" style="display:flex;">
              <label for="late_percentage">Late submission deduction per day</label>
              <input class="form-control" id="late_percentage" name="late_percentage" type="number" 
               value="<?= isset($gradesetting[0]['late_percentage']) ? $gradesetting[0]['late_percentage'] : '' ?>">  
              <strong>%</strong>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary gradeSetting" id="submitBtn" disabled>Submit</button>
        </div>
      </form>
    </div>

  </div>
</div>

<!-- Modal -->
<div id="myModalGrading" class="modal fade myModal2 abc" role="dialog">
  <div class="modal-dialog modal-lg">
    <!-- Modal content-->
    <div class="modal-content p-5">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Grading Setting</h4>
      </div>
      <div class="modal-body">
        <form action="" method="POST">
          <label for="grading_system">Grading System</label>
          <div id="grading_system" style="display:flex; justify-content:space-evenly;margin-bottom:3%;">
            <div class="form-check">
              <input type="radio" class="form-check-input" id="pass_fail" name="grading_system" value="pass_fail" 
                     <?= isset($grading_settings['grading_system']) && $grading_settings['grading_system'] == 'pass_fail' ? 'checked' : ''; ?> checked
                     onchange="toggleGradingSections()">
              <label class="form-check-label" for="pass_fail">Pass/Fail</label>
            </div>
            <div class="form-check">
              <input type="radio" class="form-check-input" id="letter_grade" name="grading_system" value="letter_grade" 
                     <?= isset($grading_settings['grading_system']) && $grading_settings['grading_system'] == 'letter_grade' ? 'checked' : ''; ?> 
                     onchange="toggleGradingSections()">
              <label class="form-check-label" for="letter_grade">Letter Grade (A, B, C, etc.)</label>
            </div>
            <div class="form-check">
              <input type="radio" class="form-check-input" id="gpa" name="grading_system" value="gpa" 
                     <?= isset($grading_settings['grading_system']) && $grading_settings['grading_system'] == 'gpa' ? 'checked' : ''; ?> 
                     onchange="toggleGradingSections()">
              <label class="form-check-label" for="gpa">GPA (1-4)</label>
            </div>
            <div class="form-check">
              <input type="radio" class="form-check-input" id="custom" name="grading_system" value="custom" 
                     <?= isset($grading_settings['grading_system']) && $grading_settings['grading_system'] == 'custom' ? 'checked' : ''; ?> 
                     onchange="toggleGradingSections()">
              <label class="form-check-label" for="custom">Custom</label>
            </div>
          </div>
          
          <!-- Pass/Fail Grading -->
          <div id="grading_percentage" class="grading-tab" style="display:none;">
            <label for="pass_percentage">Pass Percentage</label>
            <input class="form-control" type="number" name="pass_percentage" value="<?= isset($grading_settings['pass_percentage']) ? $grading_settings['pass_percentage'] : ''; ?>">
          </div>

          <!-- Letter Grade Inputs -->
          <div id="letter_grades" class="grading-tab" style="display:none;">
            <label for="grade_a_percentage">Grade A Percentage</label>
            <input class="form-control" type="number" name="grade_a_percentage" value="<?= isset($grading_settings['grade_a_percentage']) ? $grading_settings['grade_a_percentage'] : ''; ?>">

            <label for="grade_b_percentage">Grade B Percentage</label>
            <input class="form-control" type="number" name="grade_b_percentage" value="<?= isset($grading_settings['grade_b_percentage']) ? $grading_settings['grade_b_percentage'] : ''; ?>">

            <label for="grade_c_percentage">Grade C Percentage</label>
            <input class="form-control" type="number" name="grade_c_percentage" value="<?= isset($grading_settings['grade_c_percentage']) ? $grading_settings['grade_c_percentage'] : ''; ?>">

            <label for="grade_d_percentage">Grade D Percentage</label>
            <input class="form-control" type="number" name="grade_d_percentage" value="<?= isset($grading_settings['grade_d_percentage']) ? $grading_settings['grade_d_percentage'] : ''; ?>">

            <label for="grade_f_percentage">Grade F Percentage</label>
            <input class="form-control" type="number" name="grade_f_percentage" value="<?= isset($grading_settings['grade_f_percentage']) ? $grading_settings['grade_f_percentage'] : ''; ?>">
          </div>

          <!-- GPA Inputs -->
          <div id="gpa_grades" class="grading-tab" style="display:none;">
            <label for="gpa_1_percentage">GPA 1 Percentage</label>
            <input class="form-control" type="number" name="gpa_1_percentage" value="<?= isset($grading_settings['gpa_1_percentage']) ? $grading_settings['gpa_1_percentage'] : ''; ?>">

            <label for="gpa_2_percentage">GPA 2 Percentage</label>
            <input class="form-control" type="number" name="gpa_2_percentage" value="<?= isset($grading_settings['gpa_2_percentage']) ? $grading_settings['gpa_2_percentage'] : ''; ?>">

            <label for="gpa_3_percentage">GPA 3 Percentage</label>
            <input class="form-control" type="number" name="gpa_3_percentage" value="<?= isset($grading_settings['gpa_3_percentage']) ? $grading_settings['gpa_3_percentage'] : ''; ?>">

            <label for="gpa_4_percentage">GPA 4 Percentage</label>
            <input class="form-control" type="number" name="gpa_4_percentage" value="<?= isset($grading_settings['gpa_4_percentage']) ? $grading_settings['gpa_4_percentage'] : ''; ?>">
          </div>

          <!-- Custom Grading -->
          <div id="custom_grades" class="grading-tab" style="display:none;">
            <label for="custom_grades">Custom Grades (JSON format)</label>
            <textarea class="form-control" name="custom_grades"><?= isset($grading_settings['custom_grades']) ?  json_encode($custom_grades, JSON_PRETTY_PRINT) : ''; ?></textarea>
          </div>

          <button class="btn btn-primary" style="margin-top:5%;" id="submitGrading" type="submit">Save</button>
        </form>
      </div>
    </div>
  </div>
</div>


<script src="https://cdn.datatables.net/2.1.6/js/dataTables.js"></script>
<script>
  // Function to toggle visibility of grading sections based on the selected radio button
  function toggleGradingSections() {
    // Hide all sections first
    const sections = document.querySelectorAll('.grading-tab');
    sections.forEach(section => {
      section.style.display = 'none';
    });

    // Show the section corresponding to the selected grading system
    const selectedGradingSystem = document.querySelector('input[name="grading_system"]:checked').value;

    if (selectedGradingSystem === 'pass_fail') {
      document.getElementById('grading_percentage').style.display = 'block';
    } else if (selectedGradingSystem === 'letter_grade') {
      document.getElementById('letter_grades').style.display = 'block';
    } else if (selectedGradingSystem === 'gpa') {
      document.getElementById('gpa_grades').style.display = 'block';
    } else if (selectedGradingSystem === 'custom') {
      document.getElementById('custom_grades').style.display = 'block';
    }
  }

  // Call the function once to show the correct section based on the initial state
  window.onload = function() {
    toggleGradingSections();
  };
</script>
<script>
  $(document).ready(function() {   
      
    var table = new DataTable('#gradeTable', {
        "scrollX": true,
    });
                        

    var quizzes_assignments = <?= json_encode($quizzes_assignments); ?>; 
    var quizzes_assignments_length = quizzes_assignments.length; 
    var selectedStudents = [];

    $('#studentSearch').on('keyup', function() {
       
        table.search(this.value).draw();  
    
        var searchTerm = this.value.toLowerCase();
        $('#studentDropdown').empty().show(); 
    
        table.rows().every(function() {
            var data = this.data(); 
            var studentName = data[2].toLowerCase(); 
 
            if (studentName.includes(searchTerm) && searchTerm) {
                $('#studentDropdown').append('<li class="dropdown-item" data-name="'+ studentName +'">'+ studentName +'</li>');
            }
        });
    
        if ($('#studentDropdown').children().length === 0) {
            $('#studentDropdown').hide();
        }
    });

    function updateRowVisibility() {
        var searchString = selectedStudents.length > 0 ? selectedStudents.join('|') : '';
    
        table.search(searchString, true, false).draw(); 
    }

    // Event handler for selecting a student from the dropdown
    $('#studentDropdown').on('click', '.dropdown-item', function() {
        var studentName = $(this).data('name'); // Get the selected student name
    
        // Check if the student is already selected
        if (!selectedStudents.includes(studentName)) {
            selectedStudents.push(studentName); 
    
            var pill = $('<span class="badge badge-success mr-1" data-name="' + studentName + '">' + studentName + ' <button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></span>');
            
            $('#studentSearch').before(pill); 
    
            updateRowVisibility();
        }
    
        $('#studentDropdown').hide(); 
        $('#studentSearch').val(''); 

        // Event handler to remove student pills and adjust row visibility
        $(document).on('click', '.badge-success .close', function() {
            var studentName = $(this).parent().data('name'); 
            selectedStudents = selectedStudents.filter(name => name !== studentName);
        
            updateRowVisibility();
        
            $(this).parent().remove();
        });


  });

        // Event handler for assignment search
        $('#assignmentSearch').on('keyup', function() {
            var searchTerm = this.value.toLowerCase(); 
            var dropdown = $('#assignmentDropdown'); 
            dropdown.empty(); 
            // Filter quizzes_assignments based on the search term
             quizzes_assignments.forEach(function(assignment, index) {
                if (assignment.title.toLowerCase().includes(searchTerm) && searchTerm) {
                    dropdown.append('<li class="dropdown-item" data-title="'+ assignment.title +'" data-index="'+ index +'">'+ assignment.title +'</li>');
                }
            });
        
            if (dropdown.children().length > 0) {
                dropdown.show();
            } else {
                dropdown.hide(); 
            }
        });

        var selectedColumns = [];

        var quizzes_assignments = <?= json_encode($quizzes_assignments); ?>; 
        
        // Event handler for assignment search
        $('#assignmentSearch').on('keyup', function() {
            var searchTerm = this.value.toLowerCase(); // Get the search term
            var dropdown = $('#assignmentDropdown'); // Reference to the dropdown
            dropdown.empty(); // Clear previous entries
        
            // Filter quizzes_assignments based on the search term
            quizzes_assignments.forEach(function(assignment, index) {
                if (assignment.title.toLowerCase().includes(searchTerm) && searchTerm) {
                    dropdown.append('<li class="dropdown-item" data-title="'+ assignment.title +'" data-index="'+ index +'">'+ assignment.title +'</li>');
                }
            });
        
            // Show dropdown if there are matching assignments
            if (dropdown.children().length > 0) {
                dropdown.show();
            } else {
                dropdown.hide(); // Hide if no matches
            }
        });

        $('#assignmentDropdown').on('click', '.dropdown-item', function() {
            var index = $(this).data('index'); 
        
            // Check if the column is already selected
            if (!selectedColumns.includes(index)) {
                selectedColumns.push(index); // Add to the selected columns array
        
                // Create a pill element
                var pill = $('<span class="badge badge-info mr-1 badge-md" data-index="' + index + '">' + $(this).data('title') + ' <button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button></span>');
                
                // Append the pill to the search box
                $('#assignmentSearch').before(pill); 
        
                for (var i = 0; i < quizzes_assignments.length; i++) {
                    var columnToHide = table.column(i + 3); 
                    columnToHide.visible(false); 
                }
        
                selectedColumns.forEach(function(colIndex) {
                    var selectedColumn = table.column(colIndex + 3); 
                    selectedColumn.visible(true); 
                });
            }
        
            $('#assignmentDropdown').hide(); 
            $('#assignmentSearch').val(''); 
        });

        $(document).on('click', '.badge .close', function() {
            var index = $(this).parent().data('index'); // Get the index of the column to remove
            selectedColumns = selectedColumns.filter(col => col !== index); // Remove the index from the array
        
            // Hide the column associated with the removed pill
            var columnToHide = table.column(index + 3);
            columnToHide.visible(false); // Hide the column
        
            // Remove the pill from the search box
            $(this).parent().remove();
        
            // If there are no pills left, show all columns
            if (selectedColumns.length === 0) {
                table.columns().visible(true); 
            } else {
                // Show all selected columns again after removing
                selectedColumns.forEach(function(colIndex) {
                    var selectedColumn = table.column(colIndex + 3);
                    selectedColumn.visible(true); 
                });
            }
        });


        $(document).on('click', function(e) {
            if (!$(e.target).closest('#assignmentDropdown').length && !$(e.target).is('#assignmentSearch')) {
                $('#assignmentDropdown').hide();
            }
        });
        
        Metronic.init(); // init metronic core components
		QuickSidebar.init(); // init quick sidebar
		Demo.init(); // init demo features
        UIAlertDialogApi.init(); //UI Alert API
        
        $("body").on('click','.releasegrade',function(){
            var obj = $(this).data('grade');
            var obj2 = $(this).data('type');
        
            var data = {
              grade_related_id : obj,
              grade_type : obj2,
            };
            
            $.ajax({
              url: '<?=la('grade/release')?>',
              type: "POST",
              data: data,
              async: false,  // Has to be false to be able to return response
              dataType: "json",
        
              success: function(response){
                if(response.status == true){
                    AdminToastr.success(response.message);
                    location.reload();
                }
                else{
                   AdminToastr.error( "Error" );
                }
              }
            }); 
            return false;
        });
        
    function validateForm() {
      var isMissingChecked = $('#missing_percentage_status').is(':checked');
      var missingValue = $('#missing_percentage').val();
      
      var isLateChecked = $('#late_percentage_status').is(':checked');
      var lateValue = $('#late_percentage').val();

      var isValid = false;

      if (isMissingChecked && missingValue === "") {
        isValid = false;
      } else if (isLateChecked && lateValue === "") {
        isValid = false;
      } else if (isMissingChecked || isLateChecked) {
        isValid = true;
      }

      $('#submitBtn').prop('disabled', !isValid);
    }

    //Initial validation on page load
    $('input[type="checkbox"], input[type="number"]').on('change keyup', function() {
      validateForm();
    });

    validateForm();

    $(".gradeSetting").on('click', function() {
        $(this).prop('disbale', true);
      var $form = $(this).closest('form');

      $form.submit(function(event) {
        event.preventDefault(); 
        var lateStatus = $form.find('input[name="late_percentage_status"]').is(':checked') ? 1 : 0;
        var missingStatus = $form.find('input[name="missing_percentage_status"]').is(':checked') ? 1 : 0;

        var formData = $form.serializeArray();
 
        formData.push(
        {
            name: 'late_percentage_status',
            value: lateStatus
        },
        {
            name: 'missing_percentage_status',
            value: missingStatus
        }
        );
           
        var url = "<?= la('grade/grade_setting') ?>"; 
        $.ajax({
          url: url,
          type: "POST",
          data: $.param(formData), // Convert data to query string
          dataType: "json",
          success: function(response) {
              console.log(response);
            if (response.status == 1) {
              AdminToastr.success(response.txt);
              $(".myModal1").modal("hide");
              location.reload();
            } else {
              AdminToastr.error("Error");
            }
          },
          error: function(xhr, status, error) {
            console.error('AJAX Error:', status, error);
            AdminToastr.error("An unexpected error occurred");
          }
        });

        return false;
      });
    });
    
    $("#submitGrading").on('click', function() {
        $(this).prop('disbale', true);
      var $form = $(this).closest('form');

      $form.submit(function(event) {
        event.preventDefault(); 
        
        var formData = $form.serializeArray();
 
        console.log(formData);
           
        var url = "<?= la('grading_settings/create/') . $id ?>";
        $.ajax({
          url: url,
          type: "POST",
          data: $.param(formData), // Convert data to query string
          dataType: "json",
          success: function(response) {
              console.log(response);
            if (response.status == 1) {
              AdminToastr.success(response.txt);
              $(".myModal2").modal("hide");
              location.reload();
            } else {
              AdminToastr.error("Error");
            }
          },
          error: function(xhr, status, error) {
            console.error('AJAX Error:', status, error);
            AdminToastr.error("An unexpected error occurred");
          }
        });

        return false;
      });
    });
    
  });
</script>


