<?php
    // Fetch all questions from the new question_bank and quiz_questions structure
    $this->load->model('model_quiz_questions');
    $this->load->model('model_question_bank');
    $this->load->model('model_quiz');
    
    // Example: get all quiz-question assignments (adapt as needed)
    $param = array();
    $param['where']['qq_status <'] = 2;
    $quiz_questions = $this->model_quiz_questions->find_all($param);
    
    $question_types = $this->model_question_bank->question_type();
?>
<table id="example2" class="table table-striped table-bordered example" style="width:100%">
        <thead>
            <tr>
                <th class="col-md-1">S#</th>
                <th class="col-md-1">Type</th>
                <th class="col-md-1">Quiz</th>
                <th class="col-md-3">Question</th>
                <th class="col-md-3">Options</th>
                <th class="col-md-1">Answer</th>
                <th class="col-md-1">Pts.</th>
                <th class="col-md-1">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            if(isset($quiz_questions) AND array_filled($quiz_questions)) { 
                $i=1;
                foreach($quiz_questions as $qq) {
                    $question = $this->model_question_bank->find_by_pk($qq['qq_question_id']);
                    $quiz = $this->model_quiz->find_by_pk($qq['qq_quiz_id']);
                    $options = json_decode($question['qb_options'], true);
                    $correct_answer = $question['qb_correct_answer'];
                    $answer = '';
                    if(is_array($options) && !empty($correct_answer)) {
                        if(is_array($correct_answer)) {
                            foreach($correct_answer as $ca) {
                                $answer .= isset($options[$ca]) ? $options[$ca] . "," : '';
                        }
                        } else {
                            $answer = isset($options[$correct_answer]) ? $options[$correct_answer] : '';
                        }
                        $answer = rtrim($answer,',');
                    }
            ?>
            <tr>
                <td><?=$i?></td>
                <td><?=isset($question_types[$question['qb_type']]) ? $question_types[$question['qb_type']] : '-'?></td>
                <td><?=$quiz['quiz_name']?></td>
                <td><?=html_entity_decode($question['qb_text'])?></td>
                <td>
                    <?php 
                    if(is_array($options)) {
                        $x = 1;
                        foreach($options as $opt) {
                            echo "Option $x :". $opt . "<br />";
                            $x++;
                        }
                    }
                    ?>
                </td>
                <td><?=$answer?></td>
                <td><?=isset($qq['qq_points']) ? $qq['qq_points'] : (isset($question['qb_gain_point']) ? $question['qb_gain_point'] : 1)?></td>
                <td>
                    <?php if($id == $qq['qq_quiz_id']):?>
                    <a href="javascript:void(0);" class="btn btn-info">Already added</a>
                    <?php else:?>
                    <a href="javascript:void(0);" class="btn btn-primary add_this_data" data-index='<?=$i?>' 
                    data-question_id="<?=$qq['qq_question_id']?>" data-quiz_id='<?=$id?>' data-table_name="quiz_questions">Add Quiz?</a>
                    <?php endif;?>
                    <a target="_blank" href="<?=la('question_bank/edit/'.$question['qb_id'])?>" title="Edit Question" class="btn btn-icon-only yellow">
                        <i class="fa fa-edit"></i>
                    </a>
                </td>
            </tr>
            <?php 
            $i++;
                }
            }
            ?>
        </tbody>
    </table>