<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="portlet box light-grey">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-list"></i> Preguntas del Quiz: <?php echo $quiz->quiz_name; ?>
                </div>
                <div class="actions">
                    <a href="<?php echo site_url('admin/course_quiz_question/add/'.$quiz->quiz_id); ?>" class="btn green">
                        <i class="fa fa-plus"></i> Au00f1adir Pregunta
                    </a>
                    <a href="<?php echo site_url('admin/quiz/edit/'.$quiz->quiz_id); ?>" class="btn blue">
                        <i class="fa fa-pencil"></i> Editar Quiz
                    </a>
                    <a href="<?php echo site_url('admin/quiz'); ?>" class="btn default">
                        <i class="fa fa-arrow-left"></i> Volver
                    </a>
                </div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-primary">
                            <div class="panel-heading">
                                <h3 class="panel-title">Informaciu00f3n del Quiz</h3>
                            </div>
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <strong>Nombre:</strong> <?php echo $quiz->quiz_name; ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Puntos Totales:</strong> <?php echo $quiz->quiz_point; ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Fecha Inicio:</strong> <?php echo $quiz->quiz_startdate; ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Fecha Fin:</strong> <?php echo $quiz->quiz_enddate; ?>
                                    </div>
                                </div>
                                <div class="row" style="margin-top: 15px;">
                                    <div class="col-md-3">
                                        <strong>Penalizaciu00f3n Diaria:</strong> <?php echo isset($quiz->quiz_daily_penalty) ? $quiz->quiz_daily_penalty.'%' : 'No definida'; ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Punto de Aprobaciu00f3n:</strong> <?php echo isset($quiz->quiz_passing_score) ? $quiz->quiz_passing_score : '60'; ?>%
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Estado:</strong> 
                                        <?php if($quiz->quiz_status == 1): ?>
                                            <span class="label label-success">Activo</span>
                                        <?php else: ?>
                                            <span class="label label-danger">Inactivo</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Contador de preguntas y puntos -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="dashboard-stat blue">
                            <div class="visual">
                                <i class="fa fa-question-circle"></i>
                            </div>
                            <div class="details">
                                <div class="number">
                                    <?php 
                                    $total_questions = count($questions);
                                    $bonus_questions = 0;
                                    $total_regular_points = 0;
                                    $total_bonus_points = 0;
                                    
                                    foreach($questions as $q) {
                                        if($q->cq_is_bonus == 1) {
                                            $bonus_questions++;
                                            $total_bonus_points += floatval($q->cq_bonus_points);
                                        }
                                        $total_regular_points += floatval($q->cq_gain_point);
                                    }
                                    echo $total_questions; 
                                    ?>
                                </div>
                                <div class="desc">Preguntas (<?php echo $bonus_questions; ?> bonus)</div>
                            </div>
                            <div class="more">
                                Puntos Regulares: <?php echo number_format($total_regular_points, 1); ?> | 
                                Puntos Bonus: <?php echo number_format($total_bonus_points, 1); ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Lista de preguntas -->
                <?php if($questions): ?>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th width="5%">#</th>
                                <th width="40%">Pregunta</th>
                                <th width="10%">Tipo</th>
                                <th width="10%">Puntos</th>
                                <th width="10%">Bonus</th>
                                <th width="10%">Estado</th>
                                <th width="15%">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($questions as $i => $question): ?>
                            <tr <?php echo $question->cq_is_bonus == 1 ? 'class="success"' : ''; ?>>
                                <td><?php echo $i + 1; ?></td>
                                <td>
                                    <?php echo html_entity_decode($question->cq_question); ?>
                                    <?php if($question->cq_is_bonus == 1): ?>
                                    <span class="label label-info">BONUS</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php 
                                    $types = array(
                                        'single' => 'Selecciu00f3n u00danica',
                                        'multiple' => 'Selecciu00f3n Mu00faltiple'
                                    );
                                    echo isset($types[$question->cq_type]) ? $types[$question->cq_type] : $question->cq_type; 
                                    ?>
                                </td>
                                <td><?php echo number_format($question->cq_gain_point, 1); ?></td>
                                <td>
                                    <?php if($question->cq_is_bonus == 1): ?>
                                    <span class="badge badge-success">+<?php echo number_format($question->cq_bonus_points, 1); ?></span>
                                    <?php else: ?>
                                    -
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($question->cq_status == 1): ?>
                                    <span class="label label-success">Activo</span>
                                    <?php else: ?>
                                    <span class="label label-danger">Inactivo</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo site_url('admin/course_quiz_question/edit/'.$question->cq_id); ?>" class="btn btn-xs blue">
                                        <i class="fa fa-edit"></i> Editar
                                    </a>
                                    <a href="javascript:;" onClick="doDelete('<?php echo site_url('admin/course_quiz_question/delete/'.$question->cq_id); ?>')" class="btn btn-xs red">
                                        <i class="fa fa-trash"></i> Eliminar
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <div class="alert alert-info">
                    <strong>Informaciu00f3n!</strong> No hay preguntas definidas para este quiz. Haga clic en "Au00f1adir Pregunta" para comenzar.
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
.dashboard-stat .more {
    clear: both;
    display: block;
    padding: 6px 10px;
    position: relative;
    text-transform: none;
    font-weight: 600;
    font-size: 14px;
    color: #FFFFFF;
    opacity: 0.7;
}
</style>

<script>
function doDelete(deleteUrl) {
    if (confirm('¿Está seguro de que desea eliminar este elemento?')) {
        window.location = deleteUrl;
    }
}
</script>
