<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="portlet box light-grey">
    <div class="portlet-title">
        <div class="caption">
            <i class="fa fa-question-circle"></i> Configurar Pregunta
        </div>
    </div>
    <div class="portlet-body form">
        <!-- BEGIN FORM-->
        <form action="<?php echo site_url('admin/course_quiz/save_question'); ?>" class="form-horizontal" method="post" enctype="multipart/form-data">
            <div class="form-body">
                <input type="hidden" name="question[cq_quiz_id]" value="<?php echo $quiz_id; ?>">
                <input type="hidden" name="question[cq_id]" value="<?php echo isset($question) ? $question->cq_id : ''; ?>">
                
                <!-- Tipo de pregunta -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Tipo de Pregunta <?php echo mandatory(); ?></label>
                    <div class="col-md-4">
                        <select name="question[cq_type]" class="form-control" required>
                            <option value="">Selecciona tipo</option>
                            <?php foreach ($question_types as $key => $value): ?>
                                <option value="<?php echo $key; ?>" <?php echo (isset($question) && $question->cq_type == $key) ? 'selected' : ''; ?>>
                                    <?php echo $value; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                
                <!-- Texto de la pregunta -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Pregunta <?php echo mandatory(); ?></label>
                    <div class="col-md-6">
                        <textarea name="question[cq_question]" class="form-control" rows="3" required><?php echo isset($question) ? html_entity_decode($question->cq_question) : ''; ?></textarea>
                    </div>
                </div>
                
                <!-- Puntos por respuesta correcta -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Puntos <?php echo mandatory(); ?></label>
                    <div class="col-md-2">
                        <input type="number" min="0" step="0.1" name="question[cq_gain_point]" class="form-control" value="<?php echo isset($question) ? $question->cq_gain_point : '1'; ?>" required>
                    </div>
                </div>
                
                <!-- Pregunta bonus -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Pregunta Bonus</label>
                    <div class="col-md-4">
                        <div class="switchery-demo">
                            <input type="hidden" name="question[cq_is_bonus]" value="0">
                            <input type="checkbox" name="question[cq_is_bonus]" class="js-switch" value="1" <?php echo (isset($question) && $question->cq_is_bonus == 1) ? 'checked' : ''; ?> data-toggle="toggle">
                        </div>
                        <span class="help-block">Marca esta opciu00f3n si es una pregunta bonus (opcional)</span>
                    </div>
                </div>
                
                <!-- Puntos bonus -->
                <div class="form-group" id="bonus-points-group" style="<?php echo (isset($question) && $question->cq_is_bonus == 1) ? '' : 'display:none;'; ?>">
                    <label class="col-md-3 control-label">Puntos Bonus</label>
                    <div class="col-md-2">
                        <input type="number" min="0" step="0.1" name="question[cq_bonus_points]" class="form-control" value="<?php echo isset($question) ? $question->cq_bonus_points : '0'; ?>">
                    </div>
                    <div class="col-md-4">
                        <span class="help-block">Puntos adicionales que se obtienen al responder correctamente</span>
                    </div>
                </div>
                
                <!-- Opciones de respuesta -->
                <div class="form-group">
                    <label class="col-md-3 control-label">Opciones <?php echo mandatory(); ?></label>
                    <div class="col-md-6">
                        <div id="options-container">
                            <?php for ($i = 1; $i <= 6; $i++): ?>
                                <div class="option-item">
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <input type="checkbox" name="question[cq_correct_answer][]" value="<?php echo $i; ?>" 
                                                <?php 
                                                if (isset($question) && isset($question->{'cq_correct_answer'})) {
                                                    $correct_answers = explode(',', $question->cq_correct_answer);
                                                    echo in_array($i, $correct_answers) ? 'checked' : '';
                                                }
                                                ?>
                                            >
                                        </span>
                                        <input type="text" name="question[cq_option][<?php echo $i; ?>]" class="form-control" 
                                            placeholder="Opciu00f3n <?php echo $i; ?>" 
                                            value="<?php echo isset($question) ? $question->{'cq_option_'.$i} : ''; ?>" 
                                            <?php echo $i <= 2 ? 'required' : ''; ?>
                                        >
                                    </div>
                                    <span class="help-block">Marque el checkbox si esta es una respuesta correcta</span>
                                </div>
                            <?php endfor; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-actions fluid">
                <div class="col-md-offset-3 col-md-9">
                    <button type="submit" class="btn green">Guardar</button>
                    <a href="<?php echo site_url('admin/course_quiz'); ?>" class="btn default">Cancelar</a>
                </div>
            </div>
        </form>
        <!-- END FORM-->
    </div>
</div>

<script>
$(document).ready(function() {
    // Mostrar/ocultar campo de puntos bonus segu00fan si es pregunta bonus
    $('input[name="question[cq_is_bonus]"]').on('change', function() {
        if($(this).is(':checked')) {
            $('#bonus-points-group').show();
        } else {
            $('#bonus-points-group').hide();
        }
    });
    
    // Inicializar Switchery para checkbox estilizado
    var elems = Array.prototype.slice.call(document.querySelectorAll('.js-switch'));
    elems.forEach(function(html) {
        var switchery = new Switchery(html, { color: '#1AB394' });
    });
});
</script>
