<?php
$type = isset($type) ? $type : 'admin';
// Remove old join/param logic
// $param = array();
// $param['joins'][] = array(
//     "table"=>"course_quiz" , 
//     "joint"=>"course_quiz.cq_id = result_quiz.rq_question_id",
// );
// $param['where']['rq_result_id'] = $id;
// $quz_data = $this->model_result_quiz->find_all($param);

// Use only the new structure for answers and questions
$this->load->model('model_result_quiz');
$this->load->model('model_quiz_questions');
$answers = $this->model_result_quiz->get_user_quiz_answers($id_user, $id_quiz); // Uses new structure
$questions_raw = $this->model_quiz_questions->get_quiz_questions($id_quiz);
$questions = array();
foreach ($questions_raw as $q) {
    $questions[$q['qb_id']] = $q;
}
?>

<table class="table table-striped table-bordered table-hover table-condensed">
    <thead>
      <tr>
        <th>#</th>
        <th>Question</th>
        <th>Student Answer</th>
        <th>Correct Answer</th>
        <th>Action</th>
        <th>Teacher Feedback</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($answers as $key2=>$ans): $q = $questions[$ans['qb_id']]; ?>
      <tr>
        <td><?=($key2+1)?></td>
        <td><?=htmlspecialchars($q['qb_text'])?></td>
        <td><?=htmlspecialchars($ans['user_answer'])?></td>
        <td><?=htmlspecialchars($ans['correct_answer'])?></td>
        <td>
            <input type="number" required class="form-control" min="0" max="<?=isset($q['qb_gain_point']) ? $q['qb_gain_point'] : 1?>" step=".01" name="result_quiz[<?=$ans['qb_id']?>]" value='<?=isset($ans['rq_points']) ? $ans['rq_points'] : ''?>'>
            <input type="hidden" name="total_marks[<?=$ans['qb_id']?>]" value='<?=isset($q['qb_gain_point']) ? $q['qb_gain_point'] : 1?>'>
            <sub style="color:green">Max marks <?=isset($q['qb_gain_point']) ? $q['qb_gain_point'] : 1?></sub>
        </td>
        <td>
            <textarea class="form-control" placeholder='Teacher feedback....' name="feedback[<?=$ans['qb_id']?>]"><?=isset($ans['rq_feedback']) ? $ans['rq_feedback'] : ''?></textarea>
        </td>
      </tr>
      <?php endforeach; ?> 
    </tbody>
  </table>

