<div class="container-fluid my-3">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?= $layout_title ?></h3>
                    <div class="card-tools">
                        <a href="<?= site_url('admin/assignment_group_management') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to Groups
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('success') ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('error') ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">Group Information</h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Group Name:</strong> <?= $group->assignment_group_name ?></p>
                                            <p><strong>Group Type:</strong> 
                                                <?php
                                                $group_types = [
                                                    'lab_section' => 'Laboratory Section',
                                                    'day_slot' => 'Day Slot',
                                                    'time_slot' => 'Time Slot',
                                                    'custom' => 'Custom Group'
                                                ];
                                                echo isset($group_types[$group->assignment_group_type]) ? $group_types[$group->assignment_group_type] : $group->assignment_group_type;
                                                ?>
                                            </p>
                                        </div>
                                        <div class="col-md-6">
                                            <?php
                                            $this->load->model('model_course');
                                            $course = $this->model_course->find_by_pk($group->assignment_group_course_id);
                                            ?>
                                            <p><strong>Course:</strong> <?= $course ? $course->course_name : 'N/A' ?></p>
                                            <p><strong>Status:</strong> <?= $group->assignment_group_status == 1 ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>' ?></p>
                                        </div>
                                    </div>
                                    <?php if ($group->assignment_group_description): ?>
                                        <div class="row mt-2">
                                            <div class="col-12">
                                                <p><strong>Description:</strong> <?= $group->assignment_group_description ?></p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header bg-success">
                                    <h3 class="card-title">Add Member</h3>
                                </div>
                                <div class="card-body">
                                    <form method="post" action="<?= site_url('admin/assignment_group_management/manage_members/'.$group->assignment_group_id) ?>" id="singleMemberForm">
                                        <div class="form-group">
                                            <label for="user_id">Select Student</label>
                                            <select class="form-control select2" id="user_id" name="user_id" required>
                                                <option value="">-- Select Student --</option>
                                                <?php foreach ($students as $student): ?>
                                                    <option value="<?= $student->user_id ?>">
                                                        <?= $student->user_firstname ?> <?= $student->user_lastname ?> (<?= $student->user_email ?>)
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group text-right">
                                            <button type="submit" name="add_member" value="1" class="btn btn-success">
                                                <i class="fas fa-plus"></i> Add to Group
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card mt-3">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">Bulk Add Members</h3>
                                </div>
                                <div class="card-body">
                                    <form id="bulkAddForm">
                                        <div class="form-group">
                                            <label for="bulk_user_ids">Select Multiple Students</label>
                                            <select class="form-control select2" id="bulk_user_ids" multiple required>
                                                <?php foreach ($students as $student): ?>
                                                    <option value="<?= $student->user_id ?>">
                                                        <?= $student->user_firstname ?> <?= $student->user_lastname ?> (<?= $student->user_email ?>)
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group text-right">
                                            <button type="button" id="bulkAddBtn" class="btn btn-info">
                                                <i class="fas fa-users"></i> Add Multiple Students
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">Current Members</h3>
                                </div>
                                <div class="card-body table-responsive">
                                    <table class="table table-hover table-bordered">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Student Name</th>
                                                <th>Email</th>
                                                <th>Added By</th>
                                                <th>Date Added</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($members)): ?>
                                                <?php foreach ($members as $member): ?>
                                                    <tr>
                                                        <td><?= $member->user_id ?></td>
                                                        <td><?= $member->user_firstname ?> <?= $member->user_lastname ?></td>
                                                        <td><?= $member->user_email ?></td>
                                                        <td>
                                                            <?php
                                                            $added_by_user = $this->model_user->find_by_pk($member->agm_added_by);
                                                            echo $added_by_user ? $added_by_user->user_firstname . ' ' . $added_by_user->user_lastname : 'N/A';
                                                            ?>
                                                        </td>
                                                        <td><?= date('Y-m-d H:i', strtotime($member->agm_created_at)) ?></td>
                                                        <td>
                                                            <form method="post" action="<?= site_url('admin/assignment_group_management/manage_members/'.$group->assignment_group_id) ?>" onsubmit="return confirm('Are you sure you want to remove this student from the group?');">
                                                                <input type="hidden" name="member_id" value="<?= $member->agm_id ?>">
                                                                <button type="submit" name="remove_member" value="1" class="btn btn-danger btn-sm">
                                                                    <i class="fas fa-user-minus"></i> Remove
                                                                </button>
                                                            </form>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <tr>
                                                    <td colspan="6" class="text-center">No members in this group</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(function () {
    // Initialize Select2
    $('.select2').select2();
    
    // Bulk add members
    $('#bulkAddBtn').on('click', function() {
        var selectedStudents = $('#bulk_user_ids').val();
        
        if (selectedStudents && selectedStudents.length > 0) {
            $.ajax({
                url: '<?= site_url('admin/assignment_group_management/bulk_add_members') ?>',
                type: 'POST',
                dataType: 'json',
                data: {
                    group_id: <?= $group->assignment_group_id ?>,
                    student_ids: selectedStudents
                },
                success: function(response) {
                    if (response.status) {
                        alert(response.msg);
                        location.reload();
                    } else {
                        alert(response.msg || 'Error adding members');
                    }
                },
                error: function() {
                    alert('An error occurred while processing your request');
                }
            });
        } else {
            alert('Please select at least one student');
        }
    });
});
</script>
