<div class="container-fluid my-3">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?= $layout_title ?></h3>
                    <div class="card-tools">
                        <a href="<?= site_url('admin/assignment_group_management/add') ?>" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Add New Group
                        </a>
                    </div>
                </div>
                <div class="card-body table-responsive">
                    <?php if ($this->session->flashdata('success')): ?>
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('success') ?>
                        </div>
                    <?php endif; ?>
                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('error') ?>
                        </div>
                    <?php endif; ?>
                    
                    <table class="table table-hover table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Group Name</th>
                                <th>Type</th>
                                <th>Course</th>
                                <th>Members</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($groups)): ?>
                                <?php foreach ($groups as $group): ?>
                                    <tr>
                                        <td><?= $group->assignment_group_id ?></td>
                                        <td><?= $group->assignment_group_name ?></td>
                                        <td>
                                            <?php
                                            $group_types = [
                                                'lab_section' => 'Laboratory Section',
                                                'day_slot' => 'Day Slot',
                                                'time_slot' => 'Time Slot',
                                                'custom' => 'Custom Group'
                                            ];
                                            echo isset($group_types[$group->assignment_group_type]) ? $group_types[$group->assignment_group_type] : $group->assignment_group_type;
                                            ?>
                                        </td>
                                        <td>
                                            <?php
                                            $this->load->model('model_course');
                                            $course = $this->model_course->find_by_pk($group->assignment_group_course_id);
                                            echo $course ? $course->course_name : 'N/A';
                                            ?>
                                        </td>
                                        <td>
                                            <?php
                                            $this->load->model('model_assignment_group_member');
                                            $members_count = $this->db->where('agm_group_id', $group->assignment_group_id)->where('agm_status', 1)->count_all_results('assignment_group_members');
                                            echo $members_count;
                                            ?>
                                        </td>
                                        <td>
                                            <?= $group->assignment_group_status == 1 ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">Inactive</span>' ?>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="<?= site_url('admin/assignment_group_management/manage_members/'.$group->assignment_group_id) ?>" class="btn btn-info btn-sm" title="Manage Members">
                                                    <i class="fas fa-users"></i>
                                                </a>
                                                <a href="<?= site_url('admin/assignment_group_management/edit/'.$group->assignment_group_id) ?>" class="btn btn-primary btn-sm" title="Edit Group">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="<?= site_url('admin/assignment_group_management/delete/'.$group->assignment_group_id) ?>" class="btn btn-danger btn-sm" title="Delete Group" onclick="return confirm('Are you sure you want to delete this group?');">
                                                    <i class="fas fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="text-center">No groups found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
