<div class="container-fluid my-3">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?= $layout_title ?></h3>
                    <div class="card-tools">
                        <a href="<?= site_url('admin/assignment_group_management') ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if ($this->session->flashdata('error')): ?>
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <?= $this->session->flashdata('error') ?>
                        </div>
                    <?php endif; ?>
                    
                    <form method="post" action="<?= site_url('admin/assignment_group_management/add') ?>">
                        <div class="form-group">
                            <label for="assignment_group_name">Group Name *</label>
                            <input type="text" class="form-control" id="assignment_group_name" name="form_data[assignment_group_name]" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="assignment_group_type">Group Type *</label>
                            <select class="form-control" id="assignment_group_type" name="form_data[assignment_group_type]" required>
                                <option value="">-- Select Type --</option>
                                <?php foreach ($group_types as $key => $value): ?>
                                    <option value="<?= $key ?>"><?= $value ?></option>
                                <?php endforeach; ?>
                            </select>
                            <small class="form-text text-muted">Select the type of group you want to create.</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="assignment_group_description">Description</label>
                            <textarea class="form-control" id="assignment_group_description" name="form_data[assignment_group_description]" rows="3"></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="assignment_group_course_id">Course *</label>
                            <select class="form-control" id="assignment_group_course_id" name="form_data[assignment_group_course_id]" required>
                                <option value="">-- Select Course --</option>
                                <?php foreach ($courses as $id => $name): ?>
                                    <option value="<?= $id ?>"><?= $name ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="assignment_group_percentage">Percentage *</label>
                            <input type="number" class="form-control" id="assignment_group_percentage" name="form_data[assignment_group_percentage]" value="0" min="0" max="100" step="0.1" required>
                            <small class="form-text text-muted">Enter 0 if this group is only for student organization and not for grading.</small>
                        </div>
                        
                        <div class="form-group">
                            <label for="assignment_group_status">Status</label>
                            <select class="form-control" id="assignment_group_status" name="form_data[assignment_group_status]">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        
                        <div class="form-group text-right">
                            <button type="submit" name="submit" value="1" class="btn btn-primary">Save Group</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
