
<div class="container">
    <div class="row my-3">
        <div class="col">
            <h4>Student Analytics</h4>
        </div>
    </div>
    <div class="row my-3">
        <div class="col-md-4 py-1">
            <div class="card">
                <div class="card-body">
                    <canvas id="chDonut1"></canvas>
                    <p id="noDataMessage1" style="display:none; text-align:center; color: #999; font-size: 16px;">No Data Available</p>
                </div>
            </div>
        </div>
        <div class="col-md-2 py-1"></div>
        <div class="col-md-6 py-1">
            <div class="card">
                <div class="card-body">
                    <h3>No. of Students Attempted Quiz</h3>
                    <table style="margin:5px;">
                    <?php foreach ($quizArray as $quiz): ?>
                    <tr>
                        <td style="padding:2%;"><p><?= $quiz['quiz_name'] ?> :
                        <span style="font-weight:bold;"><?= $quiz['students_attempted'] ?> </span>student(s)</p></td>
                        <td style="padding:2%;"><a style="margin-left:5%; padding:5px;" href="<?= la('course/quizAnalytics/'.$quiz['quiz_id']) ?>" class="button btn btn-primary">Quiz Analytics</a></td>
                    </tr>
                    <?php endforeach; ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="row my-3">
        <div class="col-md-4 py-1">
            <div class="card">
                <div class="card-body">
                    <canvas id="chDonut2"></canvas>
                    <p id="noDataMessage2" style="display:none; text-align:center; color: #999; font-size: 16px;">No Data Available</p>
                </div>
            </div>
        </div>
        <div class="col-md-2 py-1"></div>
        <div class="col-md-6 py-1">
            <div class="card">
                <div class="card-body">
                    <h3>No. of Students Attempted Assignment</h3>
                    <?php foreach ($assignmentArray as $assignment): ?>
                    <div style="display:flex; margin:5px;">
                        <p><?= $assignment['assignment_title'] ?> :
                        <span style="font-weight:bold;"><?= $assignment['students_attemptedAssignment'] ?> </span>student(s)</p>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <h3>Student Attempts and Time Analysis on each Quiz</h3>
        <div class="col-md-6">
            <select id="studentDropdown" class="form-control">
                <option value="">Select Student</option>
                <?php foreach ($students as $student): ?>
                    <option value="<?= $student['user_id'] ?>"><?= $student['user_firstname'] ?> <?= $student['user_lastname'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-6">
            <select id="quizDropdown" class="form-control">
                <option value="">Select Quiz</option>
                <?php foreach ($quizArray as $quiz): ?>
                    <option value="<?= $quiz['quiz_id'] ?>"><?= $quiz['quiz_name'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="row my-2">
        <div class="col-md-12 py-1">
            <div class="card">
                <div class="card-body">
                    <canvas id="chLine"></canvas>
                </div>
            </div>
        </div>
        <!--<div class="col-md-6 py-1">-->
        <!--    <div class="card">-->
        <!--        <div class="card-body">-->
        <!--            <canvas id="chBar"></canvas>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="row py-2">
        
    <!--    <div class="col-md-4 py-1">-->
    <!--        <div class="card">-->
    <!--            <div class="card-body">-->
    <!--                <canvas id="chDonut2"></canvas>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--    <div class="col-md-4 py-1">-->
    <!--        <div class="card">-->
    <!--            <div class="card-body">-->
    <!--                <canvas id="chDonut3"></canvas>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/3.3.0/js/bootstrap.min.js" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.3.0/chart.min.js" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    /* chart.js chart examples */

// chart colors
var colors = ['#007bff','#28a745','#333333','#c3e6cb','#dc3545','#6c757d'];

/* large line chart */
// var countUSer = <?= $studentCount; ?>;
// var chLine = document.getElementById("chLine");
// var chartData = {
//   labels: <?= json_encode($userIds); ?>,
//   datasets: [{
//     data:  <?= json_encode($timeSpent); ?>,
//     backgroundColor: 'transparent',
//     borderColor: colors[0],
//     borderWidth: 4,
//     pointBackgroundColor: colors[0]
//   }]
// };
// if (chLine) {
//   new Chart(chLine, {
//   type: 'line',
//   data: chartData,
//   options: {
//     scales: {
//       yAxes: [{
//         ticks: {
//           beginAtZero: false
//         }
//       }]
//     },
//     legend: {
//       display: false
//     },
//     responsive: true
//   }
//   });
// }

/* large pie/donut chart */
// var chPie = document.getElementById("chPie");
// if (chPie) {
//   new Chart(chPie, {
//     type: 'pie',
//     data: {
//       labels: ['Desktop', 'Phone', 'Tablet', 'Unknown'],
//       datasets: [
//         {
//           backgroundColor: [colors[1],colors[0],colors[2],colors[5]],
//           borderWidth: 0,
//           data: [50, 40, 15, 5]
//         }
//       ]
//     },
//     plugins: [{
//       beforeDraw: function(chart) {
//         var width = chart.chart.width,
//             height = chart.chart.height,
//             ctx = chart.chart.ctx;
//         ctx.restore();
//         var fontSize = (height / 70).toFixed(2);
//         ctx.font = fontSize + "em sans-serif";
//         ctx.textBaseline = "middle";
//         var text = chart.config.data.datasets[0].data[0] + "%",
//             textX = Math.round((width - ctx.measureText(text).width) / 2),
//             textY = height / 2;
//         ctx.fillText(text, textX, textY);
//         ctx.save();
//       }
//     }],
//     options: {layout:{padding:0}, legend:{display:false}, cutoutPercentage: 80}
//   });
// }

/* bar chart */
// var chBar = document.getElementById("chBar");
// if (chBar) {
//   new Chart(chBar, {
//   type: 'bar',
//   data: {
//     labels: <?= json_encode($userIds); ?>,
//   datasets: [{
//     data:  <?= json_encode($attempts); ?>,
//     backgroundColor: 'transparent',
//     borderColor: colors[0],
//     borderWidth: 4,
//     pointBackgroundColor: colors[0]
//   }]
//   },
//   options: {
//     legend: {
//       display: false
//     },
//     scales: {
//       xAxes: [{
//         barPercentage: 0.4,
//         categoryPercentage: 0.5
//       }]
//     }
//   }
//   });
// }

/* 3 donut charts */


// donut 2
// var chDonutData2 = {
//     labels: ['Wips', 'Pops', 'Dags'],
//     datasets: [
//       {
//         backgroundColor: colors.slice(0,3),
//         borderWidth: 0,
//         data: [40, 45, 30]
//       }
//     ]
// };
// var chDonut2 = document.getElementById("chDonut2");
// if (chDonut2) {
//   new Chart(chDonut2, {
//       type: 'pie',
//       data: chDonutData2,
//       options: donutOptions
//   });
// }

// donut 3
// var chDonutData3 = {
//     labels: ['Angular', 'React', 'Other'],
//     datasets: [
//       {
//         backgroundColor: colors.slice(0,3),
//         borderWidth: 0,
//         data: [21, 45, 55, 33]
//       }
//     ]
// };
// var chDonut3 = document.getElementById("chDonut3");
// if (chDonut3) {
//   new Chart(chDonut3, {
//       type: 'pie',
//       data: chDonutData3,
//       options: donutOptions
//   });
// }

/* 3 line charts */
// var lineOptions = {
//     legend:{display:false},
//     tooltips:{interest:false,bodyFontSize:11,titleFontSize:11},
//     scales:{
//         xAxes:[
//             {
//                 ticks:{
//                     display:false
//                 },
//                 gridLines: {
//                     display:false,
//                     drawBorder:false
//                 }
//             }
//         ],
//         yAxes:[{display:false}]
//     },
//     layout: {
//         padding: {
//             left: 6,
//             right: 6,
//             top: 4,
//             bottom: 6
//         }
//     }
// };

// var chLine1 = document.getElementById("chLine1");
// if (chLine1) {
//   new Chart(chLine1, {
//       type: 'line',
//       data: {
//           labels: ['Jan','Feb','Mar','Apr','May'],
//           datasets: [
//             {
//               backgroundColor:'#ffffff',
//               borderColor:'#ffffff',
//               data: [10, 11, 4, 11, 4],
//               fill: false
//             }
//           ]
//       },
//       options: lineOptions
//   });
// }
// var chLine2 = document.getElementById("chLine2");
// if (chLine2) {
//   new Chart(chLine2, {
//       type: 'line',
//       data: {
//           labels: ['A','B','C','D','E'],
//           datasets: [
//             {
//               backgroundColor:'#ffffff',
//               borderColor:'#ffffff',
//               data: [4, 5, 7, 13, 12],
//               fill: false
//             }
//           ]
//       },
//       options: lineOptions
//   });
// }

// var chLine3 = document.getElementById("chLine3");
// if (chLine3) {
//   new Chart(chLine3, {
//       type: 'line',
//       data: {
//           labels: ['Pos','Neg','Nue','Other','Unknown'],
//           datasets: [
//             {
//               backgroundColor:'#ffffff',
//               borderColor:'#ffffff',
//               data: [13, 15, 10, 9, 14],
//               fill: false
//             }
//           ]
//       },
//       options: lineOptions
//   });
// }
</script>
<script>
// Define chart colors for the charts
var colors = ['#007bff', '#28a745', '#333333', '#c3e6cb', '#dc3545', '#6c757d'];

// Initialize charts (empty data at the beginning)
var chLine = document.getElementById("chLine");
var noDataMessage = document.getElementById("noDataMessage");
var noDataMessage2 = document.getElementById("noDataMessage2");
// var chBar = document.getElementById("chBar");

var chartData = {
    labels: [],
    datasets: [{
        data: [],
        backgroundColor: 'transparent',
        borderColor: colors[0],
        borderWidth: 4,
        pointBackgroundColor: colors[0]
    }]
};

var barData = {
    labels: [],
    datasets: [{
        data: [],
        backgroundColor: 'transparent',
        borderColor: colors[0],
        borderWidth: 4,
        pointBackgroundColor: colors[0]
    }]
};
// Initialize charts once (only if lineChart is not already initialized)
var lineChart;
var chLine = document.getElementById("chLine");

if (!lineChart) {
    lineChart = new Chart(chLine, {
        type: 'line',
        data: chartData,
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: true // Hide legend if not needed
                }
            },
            scales: {
                x: {
                    title: {
                        display: true,
                        text: 'Quiz Attempts' // X-axis label
                    }
                },
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Number of Attempts / Time Spent (seconds)' // Y-axis label
                    },
                    ticks: {
                        stepSize: 10 // Adjust for attempts or time (you may want to change this depending on your data)
                    }
                }
            }
        }
    });
}


// var barChart = new Chart(chBar, {
//     type: 'bar',
//     data: barData,
//     options: {
//         legend: {
//             display: false
//         },
//         scales: {
//             xAxes: [{
//                 barPercentage: 0.4,
//                 categoryPercentage: 0.5
//             }]
//         }
//     }
// });
var donutOptions = {
    cutoutPercentage: 85,
    legend: {
        position: 'bottom',
        padding: 5,
        labels: { pointStyle: 'circle', usePointStyle: true }
    }
};

// Donut Chart 1 Data (Example)
var chDonutData1 = {
    labels: <?= json_encode($quizzes); ?>,
    datasets: [{
        backgroundColor: colors.slice(0, 3),
        borderWidth: 0,
        data: <?= json_encode($studentsAttempted); ?>
    }]
};

// Donut Chart 2 Data (Example)
var chDonutData2 = {
    labels: <?= json_encode($assignments); ?>,
    datasets: [{
        backgroundColor: colors.slice(0, 5),
        borderWidth: 0,
        data: <?= json_encode($studentsAttemptedAssignment); ?>
    }]
};

// Function to check if data is valid
function isDataValid(data) {
    return data && data.labels && data.labels.length > 0 && data.datasets[0].data && data.datasets[0].data.length > 0;
}
function isDataValidated(data) {
    return data && Array.isArray(data.labels) && data.labels.length > 0 && 
           Array.isArray(data.timeSpent) && data.timeSpent.length > 0;
}
// Donut Chart 1
var chDonut1 = document.getElementById("chDonut1");
var noDataMessage1 = document.getElementById("noDataMessage1");
if (chDonut1) {
    // Check if data for Donut Chart 1 is valid
    if (isDataValid(chDonutData1)) {
        new Chart(chDonut1, {
            type: 'pie',
            data: chDonutData1,
            options: donutOptions
        });
        noDataMessage1.style.display = "none"; // Hide the "No Data" message if data is valid
    } else {
        noDataMessage1.style.display = "block"; // Show the "No Data" message if data is invalid
        chDonut1.style.display = "none"; // Hide the canvas element if no data is available
    }
}

// Donut Chart 2
var chDonut2 = document.getElementById("chDonut2");
var noDataMessage2 = document.getElementById("noDataMessage2");
if (chDonut2) {
    // Check if data for Donut Chart 2 is valid
    if (isDataValid(chDonutData2)) {
        new Chart(chDonut2, {
            type: 'pie',
            data: chDonutData2,
            options: donutOptions
        });
        noDataMessage2.style.display = "none"; // Hide the "No Data" message if data is valid
    } else {
        noDataMessage2.style.display = "block"; // Show the "No Data" message if data is invalid
        chDonut2.style.display = "none"; // Hide the canvas element if no data is available
    }
}
// Function to fetch and update charts based on student selection
function updateCharts(studentId, quizId) {
    if (!studentId || !quizId) return; // Do nothing if no student or quiz is selected

    // AJAX call to fetch the data for the selected student
    $.ajax({
        url: '<?= la('course/getStudentData') ?>', // Replace with the actual URL to fetch student data
        type: 'GET',
        data: { user_id: studentId, quiz_id: quizId },
        success: function(response) {
            var studentData = JSON.parse(response);

            // Validate the data before using it
            //  if (isDataValidated(studentData)) {
                // If there's an existing chart, destroy it
                if (lineChart) {
                    lineChart.destroy();
                }

                // Recreate the chart with new data
                lineChart = new Chart(chLine, {
                    type: 'line',
                    data: {
                        labels: studentData.labels,  // New labels from the server
                        datasets: [{
                            label: 'Time Spent',
                            data: studentData.timeSpent,  // New data from the server
                            borderColor: '#007bff',
                            borderWidth: 4,
                            pointBackgroundColor: '#007bff',
                            fill: false
                        }]
                    },
                    options: {
                        responsive: true,
                        scales: {
                            x: {
                                title: {
                                    display: true,
                                    text: 'Quiz Attempts'
                                },
                                beginAtZero: true
                            },
                            y: {
                                beginAtZero: true,
                                title: {
                                    display: true,
                                    text: 'Time Spent (seconds)'
                                },
                                ticks: {
                                    stepSize: 10
                                }
                            }
                        }
                    }
                });
            // } else {
            //     console.error("Invalid data:", studentData);
            //     // alert("Error: Invalid data received.");
            // }
        },
        error: function() {
            alert("Error fetching student data.");
        }
    });
}

$('#studentDropdown, #quizDropdown').change(function() {
    var selectedStudentId = $('#studentDropdown').val(); // Get the selected student ID
    var selectedQuizId = $('#quizDropdown').val(); // Get the selected quiz ID
    
    // Only call updateCharts if both the student and quiz have been selected
    if (selectedStudentId && selectedQuizId) {
        updateCharts(selectedStudentId, selectedQuizId); // Call the function to update charts with both IDs
    }
});
</script>
