<style>
        .question {
            display: none;
        }
    </style>

<div class="container">
    <div class="row my-3">
        <div class="col">
            <h2>Quiz Analytics</h2>
        </div>
    </div>
    <div class="row question-container">
        <div class="col-md-8">
            <div id="quiz-container">
                <!-- The quiz questions will be inserted here -->
            </div>

            <!-- Navigation Buttons -->
            <div class="text-center">
                <button id="prev-btn" class="btn btn-primary" disabled>Previous</button>
                <button id="next-btn" class="btn btn-primary">Next</button>
            </div>
        </div>
    </div>
    <div class="row" style="margin-top:50px;">
        <div class="col-md-8 " id="chartDisplay">
            <canvas id="pollChart" width="400" height="200"></canvas>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/3.3.0/js/bootstrap.min.js" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.3.0/chart.min.js" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    var quizData = <?php echo json_encode($quiz); ?>;
    var currentQuestionIndex = 0;
    
    function stripTags(input) {
    var doc = new DOMParser().parseFromString(input, 'text/html');
    return doc.body.textContent || "";
}

    function loadQuestion(index) {
        var questionData = quizData[index];
        
        var options = [];
        if (questionData.cq_option_1) options.push('A) ' + stripTags(questionData.cq_option_1));
        if (questionData.cq_option_2) options.push('B) ' + stripTags(questionData.cq_option_2));
        if (questionData.cq_option_3) options.push('C) ' + stripTags(questionData.cq_option_3));
        if (questionData.cq_option_4) options.push('D) ' + stripTags(questionData.cq_option_4));
        if (questionData.cq_option_5) options.push('E) ' + stripTags(questionData.cq_option_5));
        if (questionData.cq_option_6) options.push('F) ' + stripTags(questionData.cq_option_6));
    
        // Construct HTML for the question and its options using an ordered list
        var questionHtml = `
            <div class="question" id="question-${index}">
                <h3>${stripTags(questionData.cq_question)}</h3>
                <ol style="list-style-type: none;">  <!-- Remove default numbering -->
                    ${options.map(option => `<li>${option}</li>`).join('')}
                </ol>
            </div>
        `;
            
        $('#quiz-container').html(questionHtml);
        
        $('.question').hide(); 
        $('#question-' + index).show();
        
        $('#prev-btn').prop('disabled', index === 0);
        $('#next-btn').prop('disabled', index === quizData.length - 1);
        
          updateChartData(questionData);
    }
    
    var chartInstance = null;  
    
    function updateChartData(questionData) {
        var ctx = document.getElementById('pollChart').getContext('2d');
        
        if (chartInstance) {
            chartInstance.destroy();
        }
    
        var correct_options = questionData.cq_correct_answer.split(',').map(function(num) {
            return parseInt(num.trim(), 10);  
        });
    
        var availableOptions = [];
        if (questionData.cq_option_1 !== null || questionData.cq_option_1 !== "") availableOptions.push({ label: questionData.cq_option_1, count: questionData.option_1_count });
        if (questionData.cq_option_2 !== null || questionData.cq_option_2 !== "") availableOptions.push({ label: questionData.cq_option_2, count: questionData.option_2_count });
        if (questionData.cq_option_3 !== null) availableOptions.push({ label: questionData.cq_option_3, count: questionData.option_3_count });
        if (questionData.cq_option_4 !== null) availableOptions.push({ label: questionData.cq_option_4, count: questionData.option_4_count });
        if (questionData.cq_option_5 !== null) availableOptions.push({ label: questionData.cq_option_5, count: questionData.option_5_count });
        if (questionData.cq_option_6 !== null) availableOptions.push({ label: questionData.cq_option_6, count: questionData.option_6_count });
    
    
        var backgroundColors = [];
        availableOptions.forEach(function(option, index) {
            backgroundColors.push('rgba(54, 162, 235, 0.2)');
        });
    
        availableOptions.forEach(function(option, index) {
    
            var optionNumber = index + 1; 
            if (correct_options.includes(optionNumber)) {
                backgroundColors[index] = 'rgba(22, 179, 96, 1)'; 
                availableOptions[index].label += ' (Correct)';
            }
        });
        
        var chartData = {
            labels: availableOptions.map(function(option) {
                return option.label;
            }),
            datasets: [{
                label: 'Students',
                data: availableOptions.map(function(option) {
                    return option.count;
                }),
                backgroundColor: backgroundColors,
                borderColor: [
                    'rgba(54, 162, 235, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(255, 99, 132, 1)',
                    'rgba(255, 205, 86, 1)'
                ],
                borderWidth: 1
            }]
        };
    
        chartInstance = new Chart(ctx, {
            type: 'bar',
            data: chartData,
            options: {
                indexAxis: 'y', 
                scales: {
                    x: {
                        beginAtZero: true, 
                    },
                    y: {
                        beginAtZero: true,  
                    }
                }
            }
        });
        if (!chartInstance){
            $('#chartDisplay').html('<p>No Data available</p>');
        }
    }
    
    $('#next-btn').click(function() {
        if (currentQuestionIndex < quizData.length - 1) {
            currentQuestionIndex++;
            loadQuestion(currentQuestionIndex);
        }
    });

    $('#prev-btn').click(function() {
        if (currentQuestionIndex > 0) {
            currentQuestionIndex--;
            loadQuestion(currentQuestionIndex);
        }
    });
    
    loadQuestion(currentQuestionIndex);
</script>
