<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="user-dashboard-wraper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12"> 
                <div class="card">
                    <div class="card-body">
                        <div class="quiz-result-header">
                            <h2>Quiz Result: <?php echo $quiz->quiz_name; ?></h2>
                            <p class="result-date">Date: <?php echo date('m/d/Y', strtotime($result->r_date)); ?></p>
                        </div>
                        
                        <div class="row result-summary">
                            <div class="col-md-4">
                                <div class="info-box bg-primary">
                                    <span class="info-box-icon"><i class="fa fa-question-circle"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Questions</span>
                                        <span class="info-box-number"><?php echo $result->r_total_question; ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-box bg-success">
                                    <span class="info-box-icon"><i class="fa fa-check-circle"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Correct Answers</span>
                                        <span class="info-box-number"><?php echo $result->r_correct_ans; ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="info-box bg-danger">
                                    <span class="info-box-icon"><i class="fa fa-times-circle"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Incorrect Answers</span>
                                        <span class="info-box-number"><?php echo $result->r_wrong_ans; ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row score-details">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header bg-info">
                                        <h3 class="card-title">Score Details</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <th width="30%">Original Score</th>
                                                        <td><?php echo $result->original_score; ?> points</td>
                                                    </tr>
                                                    
                                                    <?php if ($result->r_bonus_points > 0): ?>
                                                    <tr class="table-success">
                                                        <th>Bonus Points</th>
                                                        <td>+<?php echo $result->r_bonus_points; ?> points</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                    
                                                    <?php if ($result->is_late_submission): ?>
                                                    <tr class="table-warning">
                                                        <th>Days Late</th>
                                                        <td><?php echo $result->days_late; ?> <?php echo ($result->days_late > 1) ? 'days' : 'day'; ?></td>
                                                    </tr>
                                                    <tr class="table-danger">
                                                        <th>Late Penalty</th>
                                                        <td>-<?php echo $result->penalty_applied; ?>% (<?php echo number_format(($result->original_score * $result->penalty_applied / 100), 1); ?> points)</td>
                                                    </tr>
                                                    <?php endif; ?>
                                                    
                                                    <tr class="table-primary">
                                                        <th>Final Score</th>
                                                        <td><strong><?php echo $result->r_total_point; ?> points</strong></td>
                                                    </tr>
                                                    
                                                    <tr>
                                                        <th>Result</th>
                                                        <td>
                                                            <?php if ($result->r_result == 'pass'): ?>
                                                                <span class="badge badge-success">PASSED</span>
                                                            <?php else: ?>
                                                                <span class="badge badge-danger">FAILED</span>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php if ($result->is_late_submission): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-warning" role="alert">
                                    <h4 class="alert-heading"><i class="fa fa-exclamation-triangle"></i> Late Submission</h4>
                                    <p>This quiz was submitted <?php echo $result->days_late; ?> <?php echo ($result->days_late > 1) ? 'days' : 'day'; ?> after the due date.</p>
                                    <p>A penalty of <?php echo $result->penalty_applied; ?>% has been applied to the original score.</p>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <a href="<?php echo site_url('account/quiz'); ?>" class="btn btn-primary">
                                    <i class="fa fa-arrow-left"></i> Back to Quizzes
                                </a>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.result-summary {
    margin-bottom: 20px;
}
.info-box {
    display: flex;
    align-items: center;
    padding: 20px;
    border-radius: 5px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    color: white;
}
.info-box-icon {
    font-size: 50px;
    margin-right: 15px;
}
.info-box-content {
    display: flex;
    flex-direction: column;
}
.info-box-text {
    font-size: 18px;
    margin-bottom: 5px;
}
.info-box-number {
    font-size: 24px;
    font-weight: bold;
}
.score-details {
    margin-bottom: 20px;
}
.quiz-result-header {
    margin-bottom: 30px;
    border-bottom: 1px solid #eee;
    padding-bottom: 15px;
}
</style>
