<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="user-dashboard-wraper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12"> 
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title">Results Dashboard</h3>
                    </div>
                    <div class="card-body">
                        
                        <!-- Results Summary -->
                        <div class="row summary-widgets">
                            <div class="col-md-3">
                                <div class="info-box bg-primary">
                                    <span class="info-box-icon"><i class="fa fa-tasks"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Quizzes</span>
                                        <span class="info-box-number"><?php echo count($results); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box bg-success">
                                    <span class="info-box-icon"><i class="fa fa-check-circle"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Passed</span>
                                        <span class="info-box-number"><?php echo count(array_filter($results, function($r) { return $r->r_result == 'pass'; })); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box bg-danger">
                                    <span class="info-box-icon"><i class="fa fa-times-circle"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Failed</span>
                                        <span class="info-box-number"><?php echo count(array_filter($results, function($r) { return $r->r_result == 'fail'; })); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box bg-warning">
                                    <span class="info-box-icon"><i class="fa fa-clock-o"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Late Quizzes</span>
                                        <span class="info-box-number"><?php echo count(array_filter($results, function($r) { return $r->is_late_submission == 1; })); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Results Table -->
                        <div class="table-responsive mt-4">
                            <table class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Quiz</th>
                                        <th>Date</th>
                                        <th>Questions</th>
                                        <th>Correct</th>
                                        <th>Incorrect</th>
                                        <th>Points</th>
                                        <th>Bonus</th>
                                        <th>Penalty</th>
                                        <th>Result</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($results): ?>
                                        <?php foreach ($results as $i => $result): ?>
                                            <tr <?php echo $result->is_late_submission ? 'class="table-warning"' : ''; ?>>
                                                <td><?php echo $i + 1; ?></td>
                                                <td><?php echo $quizzes[$result->r_quiz_id]->quiz_name; ?></td>
                                                <td><?php echo date('d/m/Y', strtotime($result->r_date)); ?></td>
                                                <td><?php echo $result->r_total_question; ?></td>
                                                <td><?php echo $result->r_correct_ans; ?></td>
                                                <td><?php echo $result->r_wrong_ans; ?></td>
                                                <td>
                                                    <?php if ($result->is_late_submission || $result->r_bonus_points > 0): ?>
                                                        <span data-toggle="tooltip" title="Original score: <?php echo $result->original_score; ?>">
                                                            <?php echo $result->r_total_point; ?>
                                                        </span>
                                                    <?php else: ?>
                                                        <?php echo $result->r_total_point; ?>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if ($result->r_bonus_points > 0): ?>
                                                        <span class="badge badge-success">+<?php echo $result->r_bonus_points; ?></span>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if ($result->is_late_submission): ?>
                                                        <span class="badge badge-danger"><?php echo $result->penalty_applied; ?>%</span>
                                                        <small>(<?php echo $result->days_late; ?> days)</small>
                                                    <?php else: ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if ($result->r_result == 'pass'): ?>
                                                        <span class="badge badge-success">PASSED</span>
                                                    <?php else: ?>
                                                        <span class="badge badge-danger">FAILED</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <a href="<?php echo site_url('account/quiz_result/view/'.$result->r_id); ?>" class="btn btn-sm btn-info">
                                                        <i class="fa fa-eye"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="11" class="text-center">No results available</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.summary-widgets {
    margin-bottom: 30px;
}
.info-box {
    display: flex;
    align-items: center;
    padding: 20px;
    border-radius: 5px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    color: white;
}
.info-box-icon {
    font-size: 50px;
    margin-right: 15px;
}
.info-box-content {
    display: flex;
    flex-direction: column;
}
.info-box-text {
    font-size: 18px;
    margin-bottom: 5px;
}
.info-box-number {
    font-size: 24px;
    font-weight: bold;
}
.mt-4 {
    margin-top: 25px;
}
</style>

<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
