    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }

        th {
            background-color: #f2f2f2;
        }

        .status-late {
            color: red;
        }
    </style>


<div class="aboutForm">
  <div class="col-md-8 col-xs-6 col-sm-11 center">

  	<a href="<?=l('account-area/my-courses')?>" class="btn btn-primary pull-left"><< Back</a>
  	<h2><?=$title?></h2>




    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Due</th>
                <th>Submitted</th>
                <!--<th>Status</th>-->
                <th>Score</th>
            </tr>
        </thead>
        <tbody>
            <!-- Loop through quizzes and assignments -->
            <?php foreach ($quizzes_assignments as $item) : 
            $dateTime = new DateTime($item['due_date']);
            $due_date = $dateTime->format('M j \b\y g:ia');
            if($item['submitted_date'] != NULL){
                
            $timestamp = strtotime($item['submitted_date']); // Convert string to timestamp
            $submitDate = date('M j \a\t g:ia', $timestamp);
            }else{
                $submitDate = '-';
            }
            ?>
                <tr>
                    <td>
                        <?= $item['title'] ?><br>
                        <small><?= $item['assignment_group_name'] ?></small>
                    </td>
                    <td><?=  $due_date; ?></td> <!-- Placeholder for due date -->
                    <td><?= $submitDate; ?></td> <!-- Placeholder for submitted date -->
                    <!--<td class="<?= $item['grade_type'] == 'assignment' && $item['assignment_id'] == 5 ? 'status-late' : '' ?>">-->
                    <!--    <?= $item['grade_type'] == 'assignment' && $item['assignment_id'] == 5 ? 'late' : '' ?>-->
                    <!--</td>-->
                    <td>
                        <?php
                        // Find the grade for this assignment/quiz
                        $marks = 0 ;
                        $grade = array_filter($grades, function ($g) use ($item) {
                            return $g['grade_related_id'] == $item['assignment_id'];
                        });
                        $grade = reset($grade);
                        if ($grade && $grade['grade_status'] == 1) {
                            echo $grade['grade_marks'] . ' / ' . $grade['grade_total_marks'];
                        } else if($grade && $grade['grade_status'] == 0){
                            echo '<i class="fa fa-eye-slash" title="Professor has not posted this grade"></i> / ' . $item['total_marks'];
                        } else{
                            echo '- / ' . $item['total_marks'];
                        }
                        ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <h2>Grade Summary</h2>
<table>
    <thead>
        <tr>
            <th>Category</th>
          
            <th>Total Marks</th>
            <th>Percentage</th>
        </tr>
    </thead>
    <tbody>
        <?php
        // Array to store accumulated results for each assignment group
        $final_results = [];

        // Initialize group marks array
        foreach ($grades as $grade) {
                        $student_grades[$grade['user_id']]['username'] = $grade['username'];
                        $student_grades[$grade['user_id']]['grades'][$grade['grade_related_id']] = [
                            'marks' => $grade['grade_marks'],
                            'total' => $grade['grade_total_marks'],
                            'percentage' => $grade['grade_percentage'],
                            'grade_status' => $grade['grade_status'],
                            
                        ];
                    }
        foreach ($datagroups as $ag) {
            $final_results[$ag['assignment_group_id']] = [
                'name' => $ag['assignment_group_name'],
                'percentage' => $ag['assignment_group_percentage'],
                'obtained' => 0,
                'total' => 0,
            ];
        }

        // Loop through all data to accumulate marks
        foreach ($data as $qa) {
            foreach ($student_grades as $student_id => $student) {
              if($student['grades'][$qa['grade_related_id']]['grade_status'] == 1){
                  
                // Get marks for the quiz or assignment
                $marks = isset($student['grades'][$qa['grade_related_id']]) ? $student['grades'][$qa['grade_related_id']]['marks'] : 0;
                $total = isset($student['grades'][$qa['grade_related_id']]) ? $student['grades'][$qa['grade_related_id']]['total'] : 0;
              } else{
                  $marks = 0;
                  $total = 0;
              }

                // Accumulate marks for the assignment group
                $assignment_group_id = $qa['assignment_group_id'];
              
               
                if (isset($final_results[$assignment_group_id])) {
                    $final_results[$assignment_group_id]['obtained'] += $marks;
                    $final_results[$assignment_group_id]['total'] += $qa['total_marks'];
                }
                    
            }
        }

        // Now loop through final results to display in the table
        foreach ($final_results as $group_id => $result) {
            ?>
            <tr>
                <td><?= $result['name'] ?> <small><?= $result['percentage'] ?>% of grade</small></td>
                <td><?= $result['obtained'] . '/' . round($result['total'],2) ?></td>
                <?php 
                if($result['total'] > 0){
                    $percentage = ($result['obtained'] /  $result['total'])  * 100;  
                }else{
                $percentage = 0;
                }
                ?>
                <td><?= round($percentage,2); ?>%</td>
            </tr>
            <?php
            $finalPercentage +=  $percentage * $result['percentage']/100;
            $grading_system = $grading_settings['grading_system'];
            switch ($grading_system) {
                case 'pass_fail':
                    // For Pass/Fail system
                    $grade_letter = ($finalPercentage >= $grading_settings['pass_percentage']) ? 'Pass' : 'Fail';
                    break;
        
                case 'letter_grade':
                    // For Letter Grade system
                    if ($finalPercentage >= $grading_settings['grade_a_percentage']) {
                        $grade_letter = 'A';
                    } elseif ($finalPercentage >= $grading_settings['grade_b_percentage']) {
                        $grade_letter = 'B';
                    } elseif ($finalPercentage >= $grading_settings['grade_c_percentage']) {
                        $grade_letter = 'C';
                    } elseif ($finalPercentage >= $grading_settings['grade_d_percentage']) {
                        $grade_letter = 'D';
                    } else {
                        $grade_letter = 'F';
                    }
                    break;
        
                case 'gpa':
                    // For GPA system
                    if ($finalPercentage >= $grading_settings['gpa_4_percentage']) {
                        $grade_letter = '4.0';
                    } elseif ($finalPercentage >= $grading_settings['gpa_3_percentage']) {
                        $grade_letter = '3.0';
                    } elseif ($finalPercentage >= $grading_settings['gpa_2_percentage']) {
                        $grade_letter = '2.0';
                    } elseif ($finalPercentage >= $grading_settings['gpa_1_percentage']) {
                        $grade_letter = '1.0';
                    } else {
                        $grade_letter = '0.0'; // GPA 0
                    }
                    break;
        
                case 'custom':
                    // For Custom grading system (assuming custom grades are provided in a JSON format)
                    $custom_grades = json_decode($grading_settings['custom_grades'], true);
                    foreach ($custom_grades as $grade => $threshold) {
                        if ($finalPercentage >= $threshold) {
                            $grade_letter = $grade;
                            break;
                        }
                    }
                    if (!$grade_letter) {
                        $grade_letter = 'No Grade'; // If no custom grade matches
                    }
                    break;
            }
    
        }
        ?>
    </tbody>
</table>


    <p style="margin-top: 5px;">
        Final Grade Percentage: <?= round($finalPercentage, 2) ?>%
    </p>
    <p style="margin-top: 5px;">
        Final Grade: <?= $grade_letter ?>
    </p>


  
  </div>
</div>