-- Updates for 'result' table to support penalties and bonuses
-- Check if columns exist before adding them
-- is_late_submission column
SET @exist_is_late_submission = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'is_late_submission');
SET @sql_add_is_late_submission = IF(@exist_is_late_submission=0, 'ALTER TABLE `tn_result` ADD COLUMN `is_late_submission` TINYINT(1) NOT NULL DEFAULT 0 COMMENT \'Indicates if submission was late\' AFTER `r_status`', 'SELECT \'Column is_late_submission already exists in tn_result\'');
PREPARE stmt FROM @sql_add_is_late_submission;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- days_late column
SET @exist_days_late = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'days_late');
SET @sql_add_days_late = IF(@exist_days_late=0, 'ALTER TABLE `tn_result` ADD COLUMN `days_late` INT NOT NULL DEFAULT 0 COMMENT \'Days late for submission\' AFTER `is_late_submission`', 'SELECT \'Column days_late already exists in tn_result\'');
PREPARE stmt FROM @sql_add_days_late;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- penalty_applied column
SET @exist_penalty_applied = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'penalty_applied');
SET @sql_add_penalty_applied = IF(@exist_penalty_applied=0, 'ALTER TABLE `tn_result` ADD COLUMN `penalty_applied` FLOAT NOT NULL DEFAULT 0 COMMENT \'Penalty percentage applied\' AFTER `days_late`', 'SELECT \'Column penalty_applied already exists in tn_result\'');
PREPARE stmt FROM @sql_add_penalty_applied;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- original_score column
SET @exist_original_score = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'original_score');
SET @sql_add_original_score = IF(@exist_original_score=0, 'ALTER TABLE `tn_result` ADD COLUMN `original_score` FLOAT NOT NULL DEFAULT 0 COMMENT \'Original score before penalties/bonuses\' AFTER `penalty_applied`', 'SELECT \'Column original_score already exists in tn_result\'');
PREPARE stmt FROM @sql_add_original_score;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- r_bonus_points column
SET @exist_r_bonus_points = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_result' AND COLUMN_NAME = 'r_bonus_points');
SET @sql_add_r_bonus_points = IF(@exist_r_bonus_points=0, 'ALTER TABLE `tn_result` ADD COLUMN `r_bonus_points` FLOAT NOT NULL DEFAULT 0 COMMENT \'Bonus points earned\' AFTER `original_score`', 'SELECT \'Column r_bonus_points already exists in tn_result\'');
PREPARE stmt FROM @sql_add_r_bonus_points;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Updates for 'course_quiz' table to support bonus questions
-- cq_is_bonus column
SET @exist_cq_is_bonus = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_course_quiz' AND COLUMN_NAME = 'cq_is_bonus');
SET @sql_add_cq_is_bonus = IF(@exist_cq_is_bonus=0, 'ALTER TABLE `tn_course_quiz` ADD COLUMN `cq_is_bonus` TINYINT(1) NOT NULL DEFAULT 0 COMMENT \'Indicates if it is a bonus question\' AFTER `cq_status`', 'SELECT \'Column cq_is_bonus already exists in tn_course_quiz\'');
PREPARE stmt FROM @sql_add_cq_is_bonus;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- cq_bonus_points column
SET @exist_cq_bonus_points = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_course_quiz' AND COLUMN_NAME = 'cq_bonus_points');
SET @sql_add_cq_bonus_points = IF(@exist_cq_bonus_points=0, 'ALTER TABLE `tn_course_quiz` ADD COLUMN `cq_bonus_points` FLOAT NOT NULL DEFAULT 0 COMMENT \'Additional bonus points\' AFTER `cq_is_bonus`', 'SELECT \'Column cq_bonus_points already exists in tn_course_quiz\'');
PREPARE stmt FROM @sql_add_cq_bonus_points;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Updates for 'quiz' table to support daily penalties
-- quiz_daily_penalty column
SET @exist_quiz_daily_penalty = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_quiz' AND COLUMN_NAME = 'quiz_daily_penalty');
SET @sql_add_quiz_daily_penalty = IF(@exist_quiz_daily_penalty=0, 'ALTER TABLE `tn_quiz` ADD COLUMN `quiz_daily_penalty` FLOAT NOT NULL DEFAULT 0 COMMENT \'Daily penalty percentage for late submissions\' AFTER `quiz_enddate`', 'SELECT \'Column quiz_daily_penalty already exists in tn_quiz\'');
PREPARE stmt FROM @sql_add_quiz_daily_penalty;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- The script now verifies if columns exist before attempting to add them
-- This prevents errors when running the script multiple times

-- cq_order column for question ordering in quizzes
SET @exist_cq_order = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_course_quiz' AND COLUMN_NAME = 'cq_order');
SET @sql_add_cq_order = IF(@exist_cq_order=0, 'ALTER TABLE `tn_course_quiz` ADD COLUMN `cq_order` INT NOT NULL DEFAULT 0 COMMENT \'Order of questions in quiz\' AFTER `cq_gain_point`', 'SELECT \'Column cq_order already exists in tn_course_quiz\'');
PREPARE stmt FROM @sql_add_cq_order;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add index for ordering
SET @exist_idx_course_quiz_order = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tn_course_quiz' AND INDEX_NAME = 'idx_course_quiz_order');
SET @sql_add_idx_course_quiz_order = IF(@exist_idx_course_quiz_order=0, 'ALTER TABLE `tn_course_quiz` ADD INDEX `idx_course_quiz_order` (`cq_quiz_id`, `cq_order`)', 'SELECT \'Index idx_course_quiz_order already exists in tn_course_quiz\'');
PREPARE stmt FROM @sql_add_idx_course_quiz_order;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
