-- Quiz Categories Implementation
-- This file contains the SQL statements for adding quiz categories functionality
-- Created: July 1, 2025

-- Table for quiz categories
CREATE TABLE IF NOT EXISTS `tn_quiz_categories` (
  `qc_id` int(11) NOT NULL AUTO_INCREMENT,
  `qc_name` varchar(255) NOT NULL COMMENT 'Category name',
  `qc_description` text COMMENT 'Category description',
  `qc_course_id` int(11) DEFAULT NULL COMMENT 'Associated course ID',
  `qc_subject_id` int(11) DEFAULT NULL COMMENT 'Associated subject ID',
  `qc_status` tinyint(1) DEFAULT '1' COMMENT '1=Active, 0=Inactive',
  `qc_created_on` datetime DEFAULT NULL COMMENT 'Creation timestamp',
  `qc_modified_on` datetime DEFAULT NULL COMMENT 'Last modification timestamp',
  PRIMARY KEY (`qc_id`),
  KEY `qc_course_id` (`qc_course_id`),
  KEY `qc_subject_id` (`qc_subject_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Quiz categories for organizing questions';

-- Table for associating questions to categories
CREATE TABLE IF NOT EXISTS `tn_quiz_category_questions` (
  `qcq_id` int(11) NOT NULL AUTO_INCREMENT,
  `qcq_category_id` int(11) NOT NULL COMMENT 'Category ID',
  `qcq_question_id` int(11) NOT NULL COMMENT 'Question ID from question_bank',
  `qcq_created_on` datetime DEFAULT NULL COMMENT 'Creation timestamp',
  PRIMARY KEY (`qcq_id`),
  UNIQUE KEY `category_question_unique` (`qcq_category_id`, `qcq_question_id`),
  KEY `qcq_category_id` (`qcq_category_id`),
  KEY `qcq_question_id` (`qcq_question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps questions to categories';

-- Table for configuring categories in quizzes
CREATE TABLE IF NOT EXISTS `tn_quiz_category_config` (
  `qcc_id` int(11) NOT NULL AUTO_INCREMENT,
  `qcc_quiz_id` int(11) NOT NULL COMMENT 'Quiz ID',
  `qcc_category_id` int(11) NOT NULL COMMENT 'Category ID',
  `qcc_num_questions` int(11) NOT NULL DEFAULT '1' COMMENT 'Number of questions to include',
  `qcc_random_selection` tinyint(1) DEFAULT '1' COMMENT '1=Random selection, 0=Sequential',
  `qcc_created_on` datetime DEFAULT NULL COMMENT 'Creation timestamp',
  `qcc_modified_on` datetime DEFAULT NULL COMMENT 'Last modification timestamp',
  PRIMARY KEY (`qcc_id`),
  UNIQUE KEY `quiz_category_unique` (`qcc_quiz_id`, `qcc_category_id`),
  KEY `qcc_quiz_id` (`qcc_quiz_id`),
  KEY `qcc_category_id` (`qcc_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Quiz category configuration';

-- Add foreign key constraints
ALTER TABLE `tn_quiz_categories`
  ADD CONSTRAINT `fk_qc_course` FOREIGN KEY (`qc_course_id`) REFERENCES `tn_course` (`course_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_qc_subject` FOREIGN KEY (`qc_subject_id`) REFERENCES `tn_course_subject` (`course_subject_id`) ON DELETE SET NULL ON UPDATE CASCADE;

ALTER TABLE `tn_quiz_category_questions`
  ADD CONSTRAINT `fk_qcq_category` FOREIGN KEY (`qcq_category_id`) REFERENCES `tn_quiz_categories` (`qc_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_qcq_question` FOREIGN KEY (`qcq_question_id`) REFERENCES `tn_question_bank` (`qb_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `tn_quiz_category_config`
  ADD CONSTRAINT `fk_qcc_category` FOREIGN KEY (`qcc_category_id`) REFERENCES `tn_quiz_categories` (`qc_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_qcc_quiz` FOREIGN KEY (`qcc_quiz_id`) REFERENCES `tn_quiz` (`quiz_id`) ON DELETE CASCADE ON UPDATE CASCADE;
