-- ===================================================================
-- QUIZ SYSTEM COMPLETE MIGRATION - FIX POINTS DISPLAY ISSUE
-- Fixes: Unknown column 'qq_modified_on' error causing 500 errors
-- Version: 2.0 - Complete Fix
-- Created: July 24, 2025
-- ===================================================================

-- 1. FIX MISSING COLUMN FOR POINTS UPDATE
-- This is the CRITICAL fix for the 500 error
ALTER TABLE `tn_quiz_questions` 
ADD COLUMN `qq_modified_on` DATETIME NULL DEFAULT NULL 
AFTER `qq_points`;

-- 2. ENSURE qq_points column exists with proper type
ALTER TABLE `tn_quiz_questions` 
MODIFY COLUMN `qq_points` DECIMAL(5,2) DEFAULT '1.00' COMMENT 'Custom points for this question in quiz';

-- 3. ADD missing columns for proper tracking
ALTER TABLE `tn_quiz_questions` 
ADD COLUMN IF NOT EXISTS `qq_created_on` DATETIME DEFAULT CURRENT_TIMESTAMP COMMENT 'Assignment creation timestamp';

-- 4. UPDATE RESULT TABLES for better scoring (if missing)
ALTER TABLE `tn_result_quiz` 
ADD COLUMN IF NOT EXISTS `rq_points_possible` DECIMAL(5,2) DEFAULT NULL COMMENT 'Maximum points possible for this question',
ADD COLUMN IF NOT EXISTS `rq_points_earned` DECIMAL(5,2) DEFAULT NULL COMMENT 'Points earned for this question',
ADD COLUMN IF NOT EXISTS `rq_is_correct` TINYINT(1) DEFAULT 0 COMMENT '1 if answer is correct, 0 if wrong';

ALTER TABLE `tn_result` 
ADD COLUMN IF NOT EXISTS `r_max_points` DECIMAL(8,2) DEFAULT NULL COMMENT 'Maximum points possible for entire quiz',
ADD COLUMN IF NOT EXISTS `r_percentage` DECIMAL(5,2) DEFAULT NULL COMMENT 'Percentage score (0-100)';

-- 5. ENSURE DATA INTEGRITY - Fix existing null values
UPDATE `tn_quiz_questions` 
SET `qq_points` = '1.00' 
WHERE `qq_points` IS NULL OR `qq_points` = '';

-- 6. ADD PERFORMANCE INDEXES
CREATE INDEX IF NOT EXISTS `idx_qq_quiz_question` ON `tn_quiz_questions` (`qq_quiz_id`, `qq_question_id`);
CREATE INDEX IF NOT EXISTS `idx_qq_points` ON `tn_quiz_questions` (`qq_points`);

-- 7. VERIFY THE FIX - Test query to run after migration
-- SELECT qq_quiz_id, qq_question_id, qq_points, qq_modified_on 
-- FROM tn_quiz_questions 
-- WHERE qq_quiz_id = 33;

-- ===================================================================
-- VERIFICATION MESSAGE AFTER RUNNING THIS SCRIPT:
-- After executing this script, try editing quiz points again.
-- The 500 error should disappear and points should update correctly.
-- ===================================================================
