-- Fix question bank points field to support decimal values
-- This migration changes qb_gain_point from INT to DECIMAL(5,2)
-- Created: July 23, 2025

-- Modify the qb_gain_point field to support decimal values
ALTER TABLE `tn_question_bank` 
MODIFY COLUMN `qb_gain_point` DECIMAL(5,2) DEFAULT '1.00' COMMENT 'Base points for this question (supports decimals)';

-- Update existing records that have 0 points to default 1.00
UPDATE `tn_question_bank` 
SET `qb_gain_point` = 1.00 
WHERE `qb_gain_point` = 0 OR `qb_gain_point` IS NULL;
