-- Script SQL para extender la tabla assignment_group y crear la tabla de miembros
-- Creado: Mayo 14, 2025

-- 1. Extender la tabla assignment_group para incluir tipos de grupo
ALTER TABLE `assignment_group` 
ADD COLUMN `assignment_group_type` ENUM('regular', 'lab_section', 'day_slot', 'time_slot', 'custom') NOT NULL DEFAULT 'regular' 
AFTER `assignment_group_status`,
ADD COLUMN `assignment_group_description` TEXT NULL AFTER `assignment_group_type`;

-- 2. Crear la tabla para miembros de grupos
CREATE TABLE IF NOT EXISTS `assignment_group_members` (
  `agm_id` int(11) NOT NULL AUTO_INCREMENT,
  `agm_group_id` int(11) NOT NULL,
  `agm_user_id` int(11) NOT NULL,
  `agm_status` tinyint(1) DEFAULT '1',
  `agm_added_by` int(11) NOT NULL,
  `agm_created_date` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`agm_id`),
  UNIQUE KEY `group_user` (`agm_group_id`,`agm_user_id`),
  KEY `agm_user_id` (`agm_user_id`),
  KEY `agm_added_by` (`agm_added_by`),
  CONSTRAINT `fk_agm_group` FOREIGN KEY (`agm_group_id`) REFERENCES `assignment_group` (`assignment_group_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_agm_user` FOREIGN KEY (`agm_user_id`) REFERENCES `user` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `fk_agm_added_by` FOREIGN KEY (`agm_added_by`) REFERENCES `user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 3. Índice para mejorar el rendimiento de las consultas
ALTER TABLE `quiz_user_assignment`
ADD INDEX `idx_group_quiz` (`group_id`, `quiz_id`);

-- 4. Comentario para documentar los cambios
-- Tipos de grupo en assignment_group_type:
-- - regular: Para agrupación convencional de asignaciones (uso original)
-- - lab_section: Para grupos basados en secciones de laboratorio
-- - day_slot: Para grupos basados en días de la semana
-- - time_slot: Para grupos basados en franjas horarias
-- - custom: Para grupos personalizados definidos por el instructor
