<?
class Model_team_member extends MY_Model {
    /**
     *
     * @package     team_member Model
     * 
     * @version     1.0
     * @since       2017
     */

    protected $_table    = 'team_member';
    protected $_field_prefix    = 'team_member_';
    protected $_pk    = 'team_member_id';
    protected $_status_field    = 'team_member_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
      // Call the Model constructor
        $this->pagination_params['fields'] = "team_member_id,team_member_name,team_member_designation,CONCAT(team_member_image_path,team_member_image) as team_member_image,team_member_status";

      parent::__construct();
    }



    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules
    * 
    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields( $specific_field = "" )
    {

        
        $fields = array(
        
              'team_member_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'team_member_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              // 'team_member_website_id' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'team_member_website_id',
              //        'label'   => 'Website',
              //        'type'   => 'dropdown',
              //        'attributes'   => array(),
              //        'js_rules'   => 'required',
              //        'rules'   => 'required|trim|htmlentities'
              //     ),


              
              'team_member_name' => array(
                     'table'   => $this->_table,
                     'name'   => 'team_member_name',
                     'label'   => 'Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),

              'team_member_designation'  => array(
                'table'   => $this->_table,
                'name'   => 'team_member_designation',
                'label'   => 'Designation',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => array(),
                // 'rules'   => 'trim|htmlentities'
                'rules'   => 'required|htmlentities'
            ),

              'team_member_description' => array(
                     'table'   => $this->_table,
                     'name'   => 'team_member_description',
                     'label'   => 'Description',
                     //'type'   => 'editor',
                     'type'   => 'textarea',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),


              'team_member_image' => array(
                    'table' => $this->_table,
                    'name' => 'team_member_image',
                    'label' => 'Image',
                    'name_path' => 'team_member_image_path',
                    'upload_config' => 'site_upload_banner',
                    'type' => 'fileupload',
                    'type_dt' => 'image',
                    'randomize' => true,
                    'preview' => 'true',
                    // 'thumb'   => array(array('name'=>'team_member_image_thumb','max_width'=>200, 'max_height'=>200),),
                    'attributes'   => array(
                        'image_size_recommended'=>'800px × 800px',
                        'allow_ext'=>'png|jpeg|jpg',
                    ),
                    'dt_attributes' => array("width" => "10%"),
                    'rules' => 'trim|htmlentities',
                    'js_rules'=>""
                ),
              
           
            'team_member_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'team_member_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "team_member_status" ,
                     // 'list_data'    => array(
                     //                    "1"=>"Active",
                     //                    "0"=>"In-Active",
                     //                ) ,
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),

              
            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>