<?
class Model_store extends MY_Model {
  
    /**
     * model_store_details
     *
     * @package     model_store_details Model
     * 
     * @version     1.0
     * @since       2017 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'store';
    protected $_field_prefix    = 'store_';
    protected $_pk    = 'store_id';
    protected $_status_field    = 'store_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "store_id,store_country_id,store_name,store_address,store_phone,store_status";
        
        parent::__construct();
    }


    private function _pagination_filter($param = array())
    {

        if(isset($_GET['search']) AND (!empty($_GET['search']))){
            $search = trim($_GET['search']);
            $param['where_like'][] = array('column'=>'store_address','value'=>$search,'type'=>'both');
        }
        
        return $param;
    }

    public function get_pagination_total_count($paginate_param)
    {
        $param = array();
        $param = $this->_pagination_filter($paginate_param);
        $data = count($this->find_all($param));
        return $data;
    }

    public function get_pagination_data($limit = '', $offset = '',$paginate_param)
    {
        $param = array();

        //$param['order'] = 'product_id DESC';
        $param['limit'] = $limit;

        //  Filters Start
        $param = $this->_pagination_filter($paginate_param);
        
        $param['limit'] = $limit;
        $param['offset'] = $offset;
        return $this->find_all($param);
    }
    
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields( $specific_field = "" )
    {

        // Use when add new image
        // $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(
        
              'store_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'store_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),


              'store_country_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'store_country_id',
                   'label'   => 'Country',
                   'type'   => 'dropdown',
                   'list_data'    => array(
                        "1"=>"US",
                        "2"=>"UK",
                        "3"=>"Aus",
                        "4"=>"canada",
                        "5"=>"Chile",
                        "6"=>"Austria",
                        "7"=>"Denmark",
                        "8"=>"Belgium",
                        "9"=>"Argentina",
                        "10"=>"Netherlands",

                    ) ,
                   'attributes'   => array(),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim',
                ),

              'store_name' => array(
                     'table'   => $this->_table,
                     'name'   => 'store_name',
                     'label'   => 'Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'default'   => '',
                     'rules'   => 'trim|htmlentities|required',
                     'js_rules'   => 'required'
                  ),

              'store_address' => array(
                     'table'   => $this->_table,
                     'name'   => 'store_address',
                     'label'   => 'Address',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'default'   => '',
                     'rules'   => 'trim|htmlentities|required',
                     'js_rules'   => 'required'
                  ),
              'store_post_code' => array(
                     'table'   => $this->_table,
                     'name'   => 'store_post_code',
                     'label'   => 'Post code',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'default'   => '',
                     'rules'   => 'trim|htmlentities|required',
                     'js_rules'   => 'required'
                  ),
              'store_phone' => array(
                     'table'   => $this->_table,
                     'name'   => 'store_phone',
                     'label'   => 'Phone',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'default'   => '',
                     'rules'   => 'trim|htmlentities',
                     'js_rules'   => ''
                  ),
              'store_location' => array(
                     'table'   => $this->_table,
                     'name'   => 'store_location',
                     'label'   => 'Location',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'default'   => '',
                     'rules'   => 'trim|htmlentities',
                     'js_rules'   => ''
                  ),


              'store_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'store_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt'   => 'dropdown',
                     'list_data' => array( ) ,
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),
              
            );

        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;

    }

}
?>